/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define CV_CPP
#include "../common.h"
//  CsvFCSVt@C

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	BOOL flgUpdate;
	WCHAR path[MAX_PATH];
	
	INT32 tabStopIdx;
	HWND tabStops[TBSP_CSV];
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;} cn;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			UINT32 percent;
			st_Image tmp;} pc;
	
	HWND hWnd;
	HWND hPd[3];
	HWND hEdit[1];
	HWND hBtn[3];
	HWND hCn;
	HWND hPc;
	
	LRESULT (CALLBACK *pCallEdit[1]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn [3]) (HWND,UINT,WPARAM,LPARAM);
} cv[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void CvInitClass(void);
void CvInit(LONG);
void CvInst(LONG);
void CvDialog(LONG);
void CvRead(st_Image *, WCHAR *, BOOL *);
void CvLoad(LONG);
void CvStore(LONG);
LRESULT CALLBACK CvWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CvWndProcPd    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CvWndProcEditP (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CvWndProcBtnBrs(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CvWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CvWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CvWndProcPc    (HWND, UINT, WPARAM, LPARAM);
void CvSetFocus     (LONG, WPARAM, LPARAM);
void CvSize         (LONG, WPARAM, LPARAM);
void CvMinMaxInfo   (LONG, WPARAM, LPARAM);
void CvKeyDown      (LONG, WPARAM, LPARAM, HWND);
void CvKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void CvKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void CvKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void CvKeyDownF5    (LONG, WPARAM, LPARAM, HWND);
void CvClose        (LONG, WPARAM, LPARAM);
void CvDestroy      (LONG, WPARAM, LPARAM);
void CvPdCommand    (LONG, WPARAM, LPARAM);
void CvPdPaint      (LONG, WPARAM, LPARAM);
void CvBtSetFocus   (LONG, WPARAM, LPARAM, HWND);
void CvPcPaint      (LONG, WPARAM, LPARAM);
void  CvEnterBrs(LONG);
void  CvEnterOk(LONG);
void  CvEnterCan(LONG);
void  CvTmpCreate(LONG, INT32, INT32);
void  CvTmpDelete(LONG);
void  CvView(LONG);
void  CvSetPane(LONG);

/*------------------------------------------------------------------------------
    Fvoid CvInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void CvInitClass(void)
{
	WNDCLASS wcCsv;
	WNDCLASS wcCsvPd;
	WNDCLASS wcCsvCn;
	WNDCLASS wcCsvPc;
	
	InitWC(CS_OWNDC, DefWindowProc, hIcon,hCurArrow,hBrBrGray,NM_CSV,  &wcCsv);
	InitWC(CS_OWNDC, DefWindowProc, NULL, hCurArrow,hBrWhite, NM_CSVPD,&wcCsvPd);
	InitWC(CS_OWNDC, DefWindowProc, NULL, hCurArrow,hBrWhite, NM_CSVCN,&wcCsvCn);
	InitWC(CS_OWNDC, DefWindowProc, NULL, hCurArrow,hBrNull,  NM_CSVPC,&wcCsvPc);
	
	RegisterClass(&wcCsv);
	RegisterClass(&wcCsvPd);
	RegisterClass(&wcCsvCn);
	RegisterClass(&wcCsvPc);
}

/*------------------------------------------------------------------------------
    Fvoid CvInit(LONG)
    FLONG    FORM ID
    @\F
------------------------------------------------------------------------------*/
void CvInit(LONG id)
{
	INT32 i;
	
	cv[id].flgUpdate = FALSE;
	wmemset(cv[id].path, 0x0000, MAX_PATH);
	
	cv[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_CSV; i++) {cv[id].tabStops[i] = NULL;}
	
	cv[id].cn.x = 0;
	cv[id].cn.y = 0;
	cv[id].cn.w = 0;
	cv[id].cn.h = 0;
	
	cv[id].pc.x = 0;
	cv[id].pc.y = 0;
	cv[id].pc.w = 0;
	cv[id].pc.h = 0;
	ImageInit(&cv[id].pc.tmp);
	
	cv[id].hWnd = NULL;
	for (i = 0; i < 3; i++) {cv[id].hPd  [i] = NULL;}
	for (i = 0; i < 1; i++) {cv[id].hEdit[i] = NULL;}
	for (i = 0; i < 3; i++) {cv[id].hBtn [i] = NULL;}
	cv[id].hCn = NULL;
	cv[id].hPc = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid CvInst(LONG)
    FLONG    FORM ID
    @\F̉
------------------------------------------------------------------------------*/
void CvInst(LONG id)
{
	DWORD styleCv  = WS_OVERLAPPED|WS_CAPTION|WS_MAXIMIZEBOX|WS_THICKFRAME|WS_SYSMENU;
	DWORD stylePd1 = WS_CHILD|WS_VISIBLE;
	DWORD stylePd2 = WS_CHILD|WS_VISIBLE;
	DWORD stylePd3 = WS_CHILD;
	DWORD styleEd1 = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_LEFT|  ES_AUTOHSCROLL;
	DWORD styleEd2 = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleCk  = WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD styleCn  = WS_CHILD|WS_CLIPCHILDREN;
	DWORD stylePc  = WS_CHILD;
	INT32 wPd1;
	INT32 hPd1;
	INT32 yPd2;
	INT32 wPd2;
	
	wPd1 = SZ_WCSV1;
	hPd1 = SZ_HCSV1;
	yPd2 = SZ_HCSV1+PADD8*2;
	wPd2 = SZ_WEDIT2-PADD8*2;
	cv[id].hWnd     = a_CreateWindow(NM_CSV,   TxTl(E_TTLCSV),styleCv, 0,   0,   0,   0,   fm[id].hWnd);
	cv[id].hPd[0]   = a_CreateWindow(NM_CSVPD, NULL,          stylePd1,8,   8,   wPd1,hPd1,cv[id].hWnd);
	cv[id].hPd[1]   = a_CreateWindow(NM_CSVPD, NULL,          stylePd2,8,   yPd2,wPd2,43,  cv[id].hWnd);
	cv[id].hPd[2]   = a_CreateWindow(NM_CSVPD, NULL,          stylePd3,0,   0,   0,   0,   cv[id].hWnd);
	cv[id].hEdit[0] = a_CreateWindow(L"Edit",  cv[id].path,   styleEd1,7,   8,   300, 20,  cv[id].hPd[0]);
	cv[id].hBtn[0]  = a_CreateWindow(L"Button",L"browse",     styleBt, 314, 5,   70,  25,  cv[id].hPd[0]);
	cv[id].hBtn[1]  = a_CreateWindow(L"Button",TxEd(E_OK),    styleBt, 10,  10,  70,  25,  cv[id].hPd[1]);
	cv[id].hBtn[2]  = a_CreateWindow(L"Button",TxEd(E_CANCEL),styleBt, 90,  10,  70,  25,  cv[id].hPd[1]);
	cv[id].hCn      = a_CreateWindow(NM_CSVCN, NULL,          styleCn, 0,   0,   0,   0,   cv[id].hPd[2]);
	cv[id].hPc      = a_CreateWindow(NM_CSVPC, NULL,          stylePc, 0,   0,   0,   0,   cv[id].hCn);
	
	SetWindowLong(cv[id].hWnd,    GWL_USERDATA, id);
	SetWindowLong(cv[id].hPd[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(cv[id].hPd[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(cv[id].hPd[2],  GWL_USERDATA, 2*100+id);
	SetWindowLong(cv[id].hEdit[0],GWL_USERDATA, 0*100+id);
	SetWindowLong(cv[id].hBtn[0] ,GWL_USERDATA, 0*100+id);
	SetWindowLong(cv[id].hBtn[1] ,GWL_USERDATA, 1*100+id);
	SetWindowLong(cv[id].hBtn[2] ,GWL_USERDATA, 2*100+id);
	SetWindowLong(cv[id].hPc,     GWL_USERDATA, id);
	
	SetWindowLong(cv[id].hWnd,  GWL_WNDPROC, (LONG)CvWndProc);
	SetWindowLong(cv[id].hPd[0],GWL_WNDPROC, (LONG)CvWndProcPd);
	SetWindowLong(cv[id].hPd[1],GWL_WNDPROC, (LONG)CvWndProcPd);
	SetWindowLong(cv[id].hPd[2],GWL_WNDPROC, (LONG)CvWndProcPd);
	SetWindowLong(cv[id].hPc,   GWL_WNDPROC, (LONG)CvWndProcPc);
	
	E_SETFONT(cv[id].hEdit[0], hFtArial14);
	B_SETFONT(cv[id].hBtn [0], hFtArial14);
	B_SETFONT(cv[id].hBtn [1], hFtArial14);
	B_SETFONT(cv[id].hBtn [2], hFtArial14);
	
	EnableWindow(cv[id].hEdit[0], FALSE);
	
	cv[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(cv[id].hEdit[0], GWL_WNDPROC);
	cv[id].pCallBtn [0] = (CALLFUNC)GetWindowLong(cv[id].hBtn [0], GWL_WNDPROC);
	cv[id].pCallBtn [1] = (CALLFUNC)GetWindowLong(cv[id].hBtn [1], GWL_WNDPROC);
	cv[id].pCallBtn [2] = (CALLFUNC)GetWindowLong(cv[id].hBtn [2], GWL_WNDPROC);
	SetWindowLong(cv[id].hEdit[0], GWL_WNDPROC, (LONG)CvWndProcEditP);
	SetWindowLong(cv[id].hBtn [0], GWL_WNDPROC, (LONG)CvWndProcBtnBrs);
	SetWindowLong(cv[id].hBtn [1], GWL_WNDPROC, (LONG)CvWndProcBtnOk);
	SetWindowLong(cv[id].hBtn [2], GWL_WNDPROC, (LONG)CvWndProcBtnCan);
	
	cv[id].tabStopIdx = 0;
	cv[id].tabStops[0] = cv[id].hBtn[0];
	cv[id].tabStops[1] = cv[id].hBtn[1];
	cv[id].tabStops[2] = cv[id].hBtn[2];
	
	SetFocus(cv[id].hEdit[0]);
}

/*------------------------------------------------------------------------------
    Fvoid CvDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void CvDialog(LONG id)
{
	CvInit(id);
	CvLoad(id);
	
	CvTmpCreate(id, fm[id].pc[0].img.w, fm[id].pc[0].img.h);
	CvInst(id);
	
	CvRead(&cv[id].pc.tmp, cv[id].path, &cv[id].flgUpdate);
	PpPlacement(id, cv[id].hWnd);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = cv[id].hWnd;
	
	ShowWindow(cv[id].hPd[2], 0x1);
	ShowWindow(cv[id].hCn,    0x1);
	ShowWindow(cv[id].hPc,    0x1);
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid CvRead(st_Image *, WCHAR *, BOOL *, INT32 *)
    Fst_Image *  -
          WCHAR *     -
          BOOL *      -
          INT32 *     -
    @\FCSVt@Cǂݍ݁AG[o͂
------------------------------------------------------------------------------*/
void CvRead(st_Image *pImg, WCHAR *path, BOOL *pUpdate)
{
	WCHAR str[100];
	
	if (wcslen(path) == 0) {return;}
	
	if (!CsvReadFile(pImg, path, pUpdate)) {
		CsvGetErrMsg(str);
		MessageBox(NULL, str, L"error", MB_OK);
	}
}

/*------------------------------------------------------------------------------
    Fvoid CvLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void CvLoad(LONG id)
{
	wcscpy(cv[id].path, g_cvPath);
}

/*------------------------------------------------------------------------------
    Fvoid CvStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void CvStore(LONG id)
{
	wcscpy(g_cvPath, cv[id].path);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CvWndProc(,,,)
    F-
    ߒlF-
    @\FCSVCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CvWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:       CvSetFocus  (id, wp, lp);  break;
	case WM_SIZE:           CvSize      (id, wp, lp);  break;
	case WM_GETMINMAXINFO:  CvMinMaxInfo(id, wp, lp);  break;
	case WM_CLOSE:          CvClose     (id, wp, lp);  break;
	case WM_DESTROY:        CvDestroy   (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CvWndProcPd(,,,)
    F-
    ߒlF-
    @\FPDCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CvWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idP;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:
		if ((idP == 0) || (idP == 1)) {
			CvPdCommand(id, wp, lp);
		}
		break;
	case WM_PAINT:
		if (idP == 1) {
			CvPdPaint(id, wp, lp);
		}
		break;
	default:  break;
	}
	
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CvWndProcEditP(,,,)
    F-
    ߒlF-
    @\FEDIT PCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CvWndProcEditP(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	default: break;
	}
	return cv[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CvWndProcBtnBrs(,,,)
    F-
    ߒlF-
    @\FBTN BRSCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CvWndProcBtnBrs(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  CvBtSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   CvKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return cv[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CvWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FBTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CvWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  CvBtSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   CvKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return cv[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CvWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FBTN CANCELCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CvWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  CvBtSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   CvKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return cv[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK CvWndProcPc(,,,)
    F-
    ߒlF-
    @\FPCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK CvWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:  CvPcPaint(id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid CvSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FCSV WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void CvSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(cv[id].tabStops[cv[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid CvSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FCSV WM_SIZECxg
------------------------------------------------------------------------------*/
void CvSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	if (fm[id].cntSkipEdit != 0) {fm[id].cntSkipEdit--;  return;}
	
	GetClientRect(cv[id].hWnd, &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	
	a_SetWindowPos(cv[id].hPd[2], SZ_WEDIT2,
								  SZ_HCSV1+PADD8*2,
								  w-SZ_WEDIT2-PADD8,
								  h-SZ_HCSV1-PADD8*3);
	
	CvSetPane(id);
	CvView(id);
	
	a_SetWindowPos(cv[id].hPc, cv[id].pc.x, cv[id].pc.y,
							   cv[id].pc.w, cv[id].pc.h);
	
	InvalidateRect(cv[id].hWnd,   NULL, TRUE);
	InvalidateRect(cv[id].hPd[2], NULL, TRUE);
	InvalidateRect(cv[id].hCn,    NULL, TRUE);
	InvalidateRect(cv[id].hPc,    NULL, FALSE);
	UpdateWindow(cv[id].hWnd);
	UpdateWindow(cv[id].hPd[2]);
	UpdateWindow(cv[id].hCn);
	UpdateWindow(cv[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid CvMinMaxInfo(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FCSV WM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void CvMinMaxInfo(LONG id, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	INT32 w;
	INT32 h;
	
	w = SZ_WCSV1+   PADD8*2+GetSystemMetrics(SM_CYSIZEFRAME)*2;
	h = 43+SZ_HCSV1+PADD8*3+GetSystemMetrics(SM_CYSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = w;
	mmi->ptMinTrackSize.y = h;
}

/*------------------------------------------------------------------------------
    Fvoid CvKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FCSV WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void CvKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  CvKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    CvKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    CvKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_F5:     CvKeyDownF5   (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid CvKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FCSV [enter]L[Cxg
------------------------------------------------------------------------------*/
void CvKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if      (hWnd == cv[id].hBtn[0]) {CvEnterBrs(id);}
	else if (hWnd == cv[id].hBtn[2]) {CvEnterCan(id);}
	else                             {CvEnterOk (id);}
}

/*------------------------------------------------------------------------------
    Fvoid CvKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FCSV [esc]L[Cxg
------------------------------------------------------------------------------*/
void CvKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(cv[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid CvKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FCSV [tab]L[Cxg
------------------------------------------------------------------------------*/
void CvKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (cv[id].tabStopIdx == 0) {cv[id].tabStopIdx = TBSP_CSV-1;}
		else                        {cv[id].tabStopIdx--;}
	}
	else {
		cv[id].tabStopIdx = (cv[id].tabStopIdx + 1) % TBSP_CSV;
	}
	SetFocus(cv[id].tabStops[cv[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid CvKeyDownF5(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FCSV [F5]L[Cxg
------------------------------------------------------------------------------*/
void CvKeyDownF5(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	memcpy(cv[id].pc.tmp.pB, fm[id].pc[0].img.pB, fm[id].pc[0].img.w * fm[id].pc[0].img.h * 4);
	CvRead(&cv[id].pc.tmp, cv[id].path, &cv[id].flgUpdate);
	InvalidateRect(cv[id].hPc, NULL, FALSE);
	UpdateWindow  (cv[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid CvClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FCSV WM_CLOSECxg
------------------------------------------------------------------------------*/
void CvClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid CvDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FCSV WM_DESTROYCxg
------------------------------------------------------------------------------*/
void CvDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	CvTmpDelete(id);
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid CvPdCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPD WM_COMMANDCxg
------------------------------------------------------------------------------*/
void CvPdCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if      ((HWND)lp == cv[id].hBtn[0]) {CvEnterBrs(id);}
	else if ((HWND)lp == cv[id].hBtn[1]) {CvEnterOk (id);}
	else if ((HWND)lp == cv[id].hBtn[2]) {CvEnterCan(id);}
}

/*------------------------------------------------------------------------------
    Fvoid CvPdPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPD WM_PAINTCxg
------------------------------------------------------------------------------*/
void CvPdPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	
	hdc = BeginPaint(cv[id].hPd[1], &ps);
	GetClientRect(cv[id].hPd[1], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(cv[id].hPd[1], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid CvBtSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FBUTTON WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void CvBtSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_CSV; i++) {
		if (hWnd == cv[id].tabStops[i]) {
			cv[id].tabStopIdx = i;
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid CvPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_PAINTCxg
------------------------------------------------------------------------------*/
void CvPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1, w1, h1;
	INT32 x2, y2, w2, h2;
	INT32 mode;
	
	hdc = BeginPaint(cv[id].hPc, &ps);
	GetClientRect(cv[id].hPc, &rc);
	SetClipRgn(hdc, &rc);
	
	x2 = 0;
	y2 = 0;
	w2 = cv[id].pc.w;
	h2 = cv[id].pc.h;
	x1 = 0;
	y1 = 0;
	w1 = fm[id].pc[0].img.w;
	h1 = fm[id].pc[0].img.h;
	
	if (cv[id].pc.percent < 10000) {mode = HALFTONE;}
	else                           {mode = COLORONCOLOR;}
	
	SetStretchBltMode(hdc, mode);
	StretchBlt(hdc,               x2, y2, w2, h2,
			   cv[id].pc.tmp.hdc, x1, y1, w1, h1, SRCCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w2;
	rc.bottom = h2;
	FrameRect(hdc, &rc, hBrGray);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(cv[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid CvEnterBrs(LONG id)
    FLONG    FORM ID
    @\F[browse]{^s
------------------------------------------------------------------------------*/
void CvEnterBrs(LONG id)
{
	OPENFILENAME ofn;
	WCHAR path     [MAX_PATH+1];
	WCHAR pathD    [MAX_PATH];
	WCHAR pathDInit[MAX_PATH];
	WCHAR flt[60] = L"CSV\0*.CSV\0ALL\0*.*\0";
	// ͌ł͕\ĂȂt@C܂ŏoĂB
	
	wmemset(path, 0x0000, MAX_PATH+1);
	if (wcslen(cv[id].path) != 0) {
		wcscpy(pathD, cv[id].path);
		PathRemoveFileSpec(pathD);
	}
	else {
		GetModuleFileName(NULL, pathD, MAX_PATH);
		PathRemoveFileSpec(pathD);
	}
	
	memset(&ofn, 0x00, sizeof(OPENFILENAME));
	ofn.lStructSize     = sizeof(OPENFILENAME);
	ofn.hwndOwner       = cv[id].hWnd;
	ofn.hInstance       = NULL;
	ofn.lpstrInitialDir = pathD;
	ofn.lpstrFile       = path;
	ofn.nMaxFile        = MAX_PATH;
	ofn.lpstrFilter     = flt;
	ofn.lpstrDefExt     = L"";
	ofn.lpstrTitle      = TxDl(E_DLGCSV);
	ofn.Flags           = OFN_FILEMUSTEXIST;
	ofn.nFilterIndex    = 1;
	
	if (GetOpenFileName(&ofn) == TRUE) {
		wcscpy(cv[id].path, path);
		
		SetWindowText(cv[id].hEdit[0], cv[id].path);
		
		GetModuleFileName(NULL, pathDInit, MAX_PATH);
		PathRemoveFileSpec(pathDInit);
		SetCurrentDirectory(pathDInit);
		
		memcpy(cv[id].pc.tmp.pB, fm[id].pc[0].img.pB, fm[id].pc[0].img.w * fm[id].pc[0].img.h * 4);
		CvRead(&cv[id].pc.tmp, cv[id].path, &cv[id].flgUpdate);
		
		InvalidateRect(cv[id].hPc, NULL, FALSE);
		UpdateWindow  (cv[id].hPc);
	}
}

/*------------------------------------------------------------------------------
    Fvoid CvEnterOk(LONG id)
    FLONG    FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void CvEnterOk(LONG id)
{
	if (cv[id].flgUpdate == FALSE) {CLOSE(cv[id].hWnd);  return;}
	
	memcpy(fm[id].pc[0].img.pB, cv[id].pc.tmp.pB, fm[id].pc[0].img.w * fm[id].pc[0].img.h * 4);
	LiViewDelete(id, 0);
	
	InvalidateRect(fm[id].hPict[0],  NULL, TRUE);
	UpdateWindow(fm[id].hPict[0]);
	
	fm[id].flgCsv = TRUE;
	SetFormText(id);
	MnFlushFile(id);
	
	CvStore(id);
	CLOSE(cv[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid CvEnterCan(LONG id)
    FLONG    FORM ID
    @\F[LZ]{^s
------------------------------------------------------------------------------*/
void CvEnterCan(LONG id)
{
	CLOSE(cv[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid CvTmpCreate(LONG, INT32, INT32)
    FLONG     FORM ID
          INT32    
          INT32    
    @\FꎞC[W쐬
------------------------------------------------------------------------------*/
void CvTmpCreate(LONG id, INT32 w, INT32 h)
{
	RECT rc;
	
	ImageCreate(&cv[id].pc.tmp, w, h);
	memcpy(cv[id].pc.tmp.pB, fm[id].pc[0].img.pB, fm[id].pc[0].img.w * fm[id].pc[0].img.h * 4);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w;
	rc.bottom = h;
	SetClipRgn(cv[id].pc.tmp.hdc, &rc);
}

/*------------------------------------------------------------------------------
    Fvoid CvTmpDelete(LONG)
    FLONG     FORM ID
    @\FꎞC[W폜
------------------------------------------------------------------------------*/
void CvTmpDelete(LONG id)
{
	SelectClipRgn(cv[id].pc.tmp.hdc, NULL);
	DeleteDC    (cv[id].pc.tmp.hdc);
	DeleteObject(cv[id].pc.tmp.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid CvView(LONG)
    FLONG    FORM ID
    @\FCSV\p
------------------------------------------------------------------------------*/
void CvView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	gainW = (double)cv[id].cn.w / fm[id].pc[0].img.w;
	gainH = (double)cv[id].cn.h / fm[id].pc[0].img.h;
	
	if ((1 < gainW) && (1 < gainH)) {
		gainW = gainH = (double)1;
	}
	else {
		if (CmpGain(gainW, gainH) == TRUE) {
			limW = TRUE;
			limH = TRUE;
		}
		else {
			if (gainW < gainH) {
				gainH = gainW;
				limW = TRUE;
			}
			else {
				gainW = gainH;
				limH = TRUE;
			}
		}
	}
	
	x = (double)cv[id].cn.w / 2 - (double)fm[id].pc[0].img.w * gainW / 2;
	y = (double)cv[id].cn.h / 2 - (double)fm[id].pc[0].img.h * gainH / 2;
	w = (double)fm[id].pc[0].img.w * gainW;
	h = (double)fm[id].pc[0].img.h * gainH;
	
	if (limW == TRUE) {x = 0;  w = cv[id].cn.w;}
	if (limH == TRUE) {y = 0;  h = cv[id].cn.h;}
	
	if (limW == TRUE) {TryZeroDivision(fm[id].pc[0].img.w);  cv[id].pc.percent = ((double)w / fm[id].pc[0].img.w) * 10000;}
	else              {TryZeroDivision(fm[id].pc[0].img.h);  cv[id].pc.percent = ((double)h / fm[id].pc[0].img.h) * 10000;}
	
	cv[id].pc.x = x;
	cv[id].pc.y = y;
	if (w <= 0) {cv[id].pc.w = 1;}
	else        {cv[id].pc.w = w;}
	if (h <= 0) {cv[id].pc.h = 1;}
	else        {cv[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    Fvoid CvSetPane(LONG)
    FLONG    FORM ID
    @\FCSV̕\̘g\
------------------------------------------------------------------------------*/
void CvSetPane(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(cv[id].hPd[2], &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	a_SetWindowPos(cv[id].hCn, PADD8, PADD8, w-PADD8*2, h-PADD8*2);
	
	GetClientRect(cv[id].hCn, &rc);
	cv[id].cn.x = rc.left;
	cv[id].cn.y = rc.top;
	cv[id].cn.w = rc.right - rc.left;
	cv[id].cn.h = rc.bottom - rc.top;
}
