/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define FL_CPP
#include "../common.h"
//  FillFhԂ

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 rgb;
	BOOL flgClick;
	BOOL flgUpdate;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_FILL];
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;} cn;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			UINT32 percent;
			st_Image tmp;} pc;
	
	HWND hWnd;
	HWND hPd[2];
	HWND hEdit;
	HWND hRgb;
	HWND hBtn[2];
	HWND hCn;
	HWND hPc;
	
	LRESULT (CALLBACK *pCallEdit)  (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn[2])(HWND,UINT,WPARAM,LPARAM);
} fl[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void FlInitClass(void);
void FlInit(LONG);
void FlInst(LONG);
void FlDialog(LONG);
void FlLoad(LONG);
void FlStore(LONG);
LRESULT CALLBACK FlWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK FlWndProcPd    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK FlWndProcEdit  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK FlWndProcRgb   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK FlWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK FlWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK FlWndProcPc    (HWND, UINT, WPARAM, LPARAM);
void FlSize         (LONG, WPARAM, LPARAM);
void FlGetMinMaxInfo(LONG, WPARAM, LPARAM);
void FlSetFocus     (LONG, WPARAM, LPARAM);
void FlKeyDown      (LONG, WPARAM, LPARAM, HWND);
void FlKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void FlKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void FlKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void FlKeyDownSpace (LONG, WPARAM, LPARAM, HWND);
void FlClose        (LONG, WPARAM, LPARAM);
void FlDestroy      (LONG, WPARAM, LPARAM);
void FlPdCommand    (LONG, WPARAM, LPARAM);
void FlPdPaint      (LONG, WPARAM, LPARAM);
void FlEdSetFocus   (LONG, WPARAM, LPARAM, HWND);
BOOL FlEdChar       (LONG, WPARAM, LPARAM, HWND);
void FlRbPaint      (LONG, WPARAM, LPARAM, HWND);
void FlRbSetFocus   (LONG, WPARAM, LPARAM, HWND);
void FlRbKillFocus  (LONG, WPARAM, LPARAM, HWND);
void FlRbLButtonDown(LONG, WPARAM, LPARAM, HWND);
void FlRbLButtonUp  (LONG, WPARAM, LPARAM, HWND);
void FlPcPaint      (LONG, WPARAM, LPARAM);
void FlPcLButtonDown(LONG, WPARAM, LPARAM);
void FlEnterOk(LONG);
void FlEnterCan(LONG);
void FlTmpCreate(LONG);
void FlTmpDelete(LONG);
void FlView(LONG);
void FlSetPane(LONG);

/*------------------------------------------------------------------------------
    Fvoid FlInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void FlInitClass(void)
{
	WNDCLASS wcFill;
	WNDCLASS wcFillPd;
	WNDCLASS wcFillCn;
	WNDCLASS wcFillPc;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_FILL,  &wcFill);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_FILLPD,&wcFillPd);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_FILLCN,&wcFillCn);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurFill, hBrNull,  NM_FILLPC,&wcFillPc);
	
	RegisterClass(&wcFill);
	RegisterClass(&wcFillPd);
	RegisterClass(&wcFillCn);
	RegisterClass(&wcFillPc);
}

/*------------------------------------------------------------------------------
    Fvoid FlInit(LONG)
    FLONG    FORM ID
    @\FhԂ
------------------------------------------------------------------------------*/
void FlInit(LONG id)
{
	INT32 i;
	
	fl[id].rgb        = 0x000000;
	fl[id].flgUpdate  = FALSE;
	fl[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_FILL; i++) {fl[id].tabStops[i] = NULL;}
	
	fl[id].cn.x = 0;
	fl[id].cn.y = 0;
	fl[id].cn.w = 0;
	fl[id].cn.h = 0;
	
	fl[id].pc.x       = 0;
	fl[id].pc.y       = 0;
	fl[id].pc.w       = 0;
	fl[id].pc.h       = 0;
	fl[id].pc.percent = 0;
	ImageInit(&fl[id].pc.tmp);
	
	fl[id].hWnd  = NULL;
	for (i = 0; i < 2; i++) {fl[id].hPd[i] = NULL;}
	fl[id].hEdit = NULL;
	fl[id].hRgb  = NULL;
	for (i = 0; i < 2; i++) {fl[id].hBtn[i] = NULL;}
	fl[id].hCn = NULL;
	fl[id].hPc = NULL;
	
	fl[id].pCallEdit = NULL;
	for (i = 0; i < 2; i++) {fl[id].pCallBtn[i] = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid FlInst(LONG)
    FLONG      FORM ID
    @\FFILL̉
------------------------------------------------------------------------------*/
void FlInst(LONG id)
{
	DWORD styleFl  = WS_OVERLAPPED|WS_CAPTION|WS_MAXIMIZEBOX|WS_THICKFRAME|WS_SYSMENU;
	DWORD stylePd1 = WS_CHILD|WS_VISIBLE;
	DWORD stylePd2 = WS_CHILD;
	DWORD styleEd  = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleRb  = WS_CHILD|WS_VISIBLE|WS_BORDER;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD styleCn  = WS_CHILD|WS_CLIPCHILDREN;
	DWORD stylePc  = WS_CHILD;
	INT32 w;
	WCHAR str[6+1];
	
	_htow(fl[id].rgb, str, 6);
	
	w = SZ_WEDIT2-PADD8*2;
	fl[id].hWnd    = a_CreateWindow(NM_FILL,  TxTl(E_TTLFIL), styleFl, 0,  0, 0, 0, fm[id].hWnd);
	fl[id].hPd[0]  = a_CreateWindow(NM_FILLPD,NULL,           stylePd1,8,  8, w, 74,fl[id].hWnd);
	fl[id].hPd[1]  = a_CreateWindow(NM_FILLPD,NULL,           stylePd2,0,  0, 0, 0, fl[id].hWnd);
	fl[id].hEdit   = a_CreateWindow(L"Edit",  str,            styleEd, 54, 12,65,17,fl[id].hPd[0]);
	fl[id].hRgb    = a_CreateWindow(NM_RGBBOX,NULL,           styleRb, 125,13,16,16,fl[id].hPd[0]);
	fl[id].hBtn[0] = a_CreateWindow(L"Button",TxEd(E_OK),     styleBt, 10, 41,70,25,fl[id].hPd[0]);
	fl[id].hBtn[1] = a_CreateWindow(L"Button",TxEd(E_CANCEL), styleBt, 90, 41,70,25,fl[id].hPd[0]);
	fl[id].hCn     = a_CreateWindow(NM_FILLCN,NULL,           styleCn, 0,  0, 0, 0, fl[id].hPd[1]);
	fl[id].hPc     = a_CreateWindow(NM_FILLPC,NULL,           stylePc, 0,  0, 0, 0, fl[id].hCn);
	
	SetWindowLong(fl[id].hWnd,    GWL_USERDATA, id);
	SetWindowLong(fl[id].hPd[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(fl[id].hPd[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(fl[id].hEdit,   GWL_USERDATA, id);
	SetWindowLong(fl[id].hRgb,    GWL_USERDATA, id);
	SetWindowLong(fl[id].hBtn[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(fl[id].hBtn[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(fl[id].hPc,     GWL_USERDATA, id);
	
	SetWindowLong(fl[id].hWnd,   GWL_WNDPROC, (LONG)FlWndProc);
	SetWindowLong(fl[id].hPd[0], GWL_WNDPROC, (LONG)FlWndProcPd);
	SetWindowLong(fl[id].hPd[1], GWL_WNDPROC, (LONG)FlWndProcPd);
	SetWindowLong(fl[id].hRgb,   GWL_WNDPROC, (LONG)FlWndProcRgb);
	SetWindowLong(fl[id].hPc,    GWL_WNDPROC, (LONG)FlWndProcPc);
	
	E_SETLIMITTEXT(fl[id].hEdit, 6);
	
	E_SETFONT(fl[id].hEdit,   hFtCourier);
	B_SETFONT(fl[id].hBtn[0], hFtArial14);
	B_SETFONT(fl[id].hBtn[1], hFtArial14);
	
	fl[id].pCallEdit   = (CALLFUNC)GetWindowLong(fl[id].hEdit,   GWL_WNDPROC);
	fl[id].pCallBtn[0] = (CALLFUNC)GetWindowLong(fl[id].hBtn[0], GWL_WNDPROC);
	fl[id].pCallBtn[1] = (CALLFUNC)GetWindowLong(fl[id].hBtn[1], GWL_WNDPROC);
	SetWindowLong(fl[id].hEdit,   GWL_WNDPROC, (LONG)FlWndProcEdit);
	SetWindowLong(fl[id].hBtn[0], GWL_WNDPROC, (LONG)FlWndProcBtnOk);
	SetWindowLong(fl[id].hBtn[1], GWL_WNDPROC, (LONG)FlWndProcBtnCan);
	
	fl[id].tabStopIdx = 0;
	fl[id].tabStops[0] = fl[id].hEdit;
	fl[id].tabStops[1] = fl[id].hRgb;
	fl[id].tabStops[2] = fl[id].hBtn[0];
	fl[id].tabStops[3] = fl[id].hBtn[1];
	
	SetFocus  (fl[id].hEdit);
	EditSelAll(fl[id].hEdit);
}

/*------------------------------------------------------------------------------
    Fvoid FlDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void FlDialog(LONG id)
{
	FlInit(id);
	FlLoad(id);
	
	FlTmpCreate(id);
	FlInst(id);
	
	PpPlacement(id, fl[id].hWnd);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = fl[id].hWnd;
	
	ShowWindow(fl[id].hPd[1], 0x1);
	ShowWindow(fl[id].hCn,    0x1);
	ShowWindow(fl[id].hPc,    0x1);
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid FlLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void FlLoad(LONG id)
{
	fl[id].rgb = g_flRgb;
}

/*------------------------------------------------------------------------------
    Fvoid FlStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void FlStore(LONG id)
{
	g_flRgb = fl[id].rgb;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK FlWndProc(,,,)
    F-
    ߒlF-
    @\FFILLCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK FlWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SIZE:           FlSize         (id, wp, lp);  break;
	case WM_GETMINMAXINFO:  FlGetMinMaxInfo(id, wp, lp);  break;
	case WM_SETFOCUS:       FlSetFocus     (id, wp, lp);  break;
	case WM_CLOSE:          FlClose        (id, wp, lp);  break;
	case WM_DESTROY:        FlDestroy      (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK FlWndProcPd(,,,)
    F-
    ߒlF-
    @\FFILL PDCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK FlWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idP;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:
		if (idP == 0) {
			FlPdCommand(id, wp, lp);
		}
		break;
	case WM_PAINT:
		if (idP == 0) {
			FlPdPaint(id, wp, lp);
		}
		break;
	default:  break;
	}
	
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK FlWndProcEdit(,,,)
    F-
    ߒlF-
    @\FFILL EDITCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK FlWndProcEdit(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:   FlEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    FlKeyDown    (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (FlEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:  break;
	}
	
	return fl[id].pCallEdit(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK FlWndProcRgb(,,,)
    F-
    ߒlF-
    @\FFILL RGB F  Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK FlWndProcRgb(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        FlRbPaint      (id, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     FlRbSetFocus   (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    FlRbKillFocus  (id, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  FlRbLButtonDown(id, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    FlRbLButtonUp  (id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      FlKeyDown      (id, wp, lp, hWnd);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK FlWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FFILL BTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK FlWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  FlEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   FlKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return fl[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK FlWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FFILL BTN CANCELCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK FlWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  FlEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   FlKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return fl[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK FlWndProcPc(,,,)
    F-
    ߒlF-
    @\FFILL PCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK FlWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        FlPcPaint      (id, wp, lp);  break;
	case WM_LBUTTONDOWN:  FlPcLButtonDown(id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid FlSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFILL WM_SIZECxg
------------------------------------------------------------------------------*/
void FlSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	
	if (fm[id].cntSkipEdit != 0) {fm[id].cntSkipEdit--;  return;}
	
	GetClientRect(fl[id].hWnd, &rc);
	a_SetWindowPos(fl[id].hPd[1], SZ_WEDIT2, PADD8, rc.right-SZ_WEDIT2-PADD8, rc.bottom-PADD8*2);
	
	FlSetPane(id);
	FlView(id);
	
	a_SetWindowPos(fl[id].hPc, fl[id].pc.x, fl[id].pc.y,
							   fl[id].pc.w, fl[id].pc.h);
	
	InvalidateRect(fl[id].hWnd,   NULL, TRUE);
	InvalidateRect(fl[id].hPd[1], NULL, TRUE);
	InvalidateRect(fl[id].hCn,    NULL, TRUE);
	InvalidateRect(fl[id].hPc,    NULL, FALSE);
	UpdateWindow(fl[id].hWnd);
	UpdateWindow(fl[id].hPd[1]);
	UpdateWindow(fl[id].hCn);
	UpdateWindow(fl[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid FlGetMinMaxInfo(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFILL WM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void FlGetMinMaxInfo(LONG id, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	INT32 w;
	INT32 h;
	
	w = SZ_WEDIT2+PADD8*3+GetSystemMetrics(SM_CYSIZEFRAME)*2;
	h = 74       +PADD8*2+GetSystemMetrics(SM_CYSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = w;
	mmi->ptMinTrackSize.y = h;
}

/*------------------------------------------------------------------------------
    Fvoid FlSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFILL WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void FlSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(fl[id].tabStops[fl[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid FlKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFILL WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void FlKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  FlKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    FlKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    FlKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_SP:     FlKeyDownSpace(id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid FlKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFILL [enter]L[Cxg
------------------------------------------------------------------------------*/
void FlKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == fl[id].hBtn[1]) {FlEnterCan(id);}
	else                        {FlEnterOk(id);}
}

/*------------------------------------------------------------------------------
    Fvoid FlKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFILL [esc]L[Cxg
------------------------------------------------------------------------------*/
void FlKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(fl[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid FlKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFILL [tab]L[Cxg
------------------------------------------------------------------------------*/
void FlKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (fl[id].tabStopIdx == 0) {fl[id].tabStopIdx = TBSP_FILL-1;}
		else                        {fl[id].tabStopIdx--;}
	}
	else {
		fl[id].tabStopIdx = (fl[id].tabStopIdx + 1) % TBSP_FILL;
	}
	SetFocus(fl[id].tabStops[fl[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid FlKeyDownSpace(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFILL [space]L[Cxg
------------------------------------------------------------------------------*/
void FlKeyDownSpace(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (hWnd != fl[id].hRgb) {return;}
	
	GetWindowText(fl[id].hEdit, buffRgb, 6+1);
	RbDialog(id, fl[id].hWnd, fl[id].hEdit, fl[id].hRgb, buffRgb);
}

/*------------------------------------------------------------------------------
    Fvoid FlClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFILL WM_CLOSECxg
------------------------------------------------------------------------------*/
void FlClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid FlDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFILL WM_DESTROYCxg
------------------------------------------------------------------------------*/
void FlDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	FlTmpDelete(id);
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid FlPdCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFILL WM_COMMANDCxg
------------------------------------------------------------------------------*/
void FlPdCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if      ((HWND)lp == fl[id].hBtn[0]) {FlEnterOk(id);}
	else if ((HWND)lp == fl[id].hBtn[1]) {FlEnterCan(id);}
}

/*------------------------------------------------------------------------------
    Fvoid FlPdPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFILL PD WM_PAINTCxg
------------------------------------------------------------------------------*/
void FlPdPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1;
	
	hdc = BeginPaint(fl[id].hPd[0], &ps);
	GetClientRect(fl[id].hPd[0], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	switch (g_idxLang) {
	case 0:  x1 = 26;  break;
	case 1:  x1 = 20;  break;
	default: break;
	}
	y1 = 13;
	a_TextOut(hdc, x1, y1, TxEd(E_FLCOLOR));
	
	SelectClipRgn(hdc, NULL);
	EndPaint(fl[id].hPd[0], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid FlEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFILL WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void FlEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_FILL; i++) {
		if (hWnd == fl[id].tabStops[i]) {
			fl[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    FBOOL FlEdChar(LONG, WPARAM, LPARAM, HWND )
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    ߒlFBOOL    -
    @\FFILL EDIT WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL FlEdChar(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == fl[id].hEdit) {
		if (((0x30 <= wp) && (wp <= 0x39)) ||  // 0-9
			((0x41 <= wp) && (wp <= 0x46)) ||  // a-f
			((0x61 <= wp) && (wp <= 0x66)))    // A-F
		{
			return TRUE;
		}
	}
	
	switch (wp) {
	case 0x03:  // ctrl+C
	case 0x08:  // back space
	case 0x16:  // ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid FlRbPaint(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFILL RGBBOX WM_PAINTCxg
------------------------------------------------------------------------------*/
void FlRbPaint(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	RbBoxPaint(id, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid FlRbSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFILL RGBBOX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void FlRbSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_FILL; i++) {
		if ((HWND)wp == fl[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
	
	FlEdSetFocus(id, wp, lp, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid FlRbKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFILL RGBBOX WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void FlRbKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_FILL; i++) {
		if ((HWND)wp == fl[id].tabStops[i]) {
			res = TRUE;
		}
	}
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid FlRbLButtonDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFILL RGBBOX WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void FlRbLButtonDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	fl[id].flgClick = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid FlRbLButtonUp(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFILL RGBBOX WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void FlRbLButtonUp(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (fl[id].flgClick == FALSE) {return;}
	fl[id].flgClick = FALSE;
	SetFocus(hWnd);
	
	GetWindowText(fl[id].hEdit, buffRgb, 6+1);
	RbDialog(id, fl[id].hWnd, fl[id].hEdit, fl[id].hRgb, buffRgb);
}

/*------------------------------------------------------------------------------
    Fvoid FlPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFILL PC WM_PAINTCxg
------------------------------------------------------------------------------*/
void FlPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1, w1, h1;
	INT32 x2, y2, w2, h2;
	INT32 mode;
	
	hdc = BeginPaint(fl[id].hPc, &ps);
	GetClientRect(fl[id].hPc, &rc);
	SetClipRgn(hdc, &rc);
	
	x2 = 0;
	y2 = 0;
	w2 = fl[id].pc.w;
	h2 = fl[id].pc.h;
	x1 = 0;
	y1 = 0;
	w1 = fm[id].pc[0].img.w;
	h1 = fm[id].pc[0].img.h;
	
	if (fl[id].pc.percent < 10000) {mode = HALFTONE;}
	else                           {mode = COLORONCOLOR;}
	
	SetStretchBltMode(hdc, mode);
	StretchBlt(hdc,               x2, y2, w2, h2,
			   fl[id].pc.tmp.hdc, x1, y1, w1, h1, SRCCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w2;
	rc.bottom = h2;
	FrameRect(hdc, &rc, hBrGray);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(fl[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid FlPcLButtonDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFILL PC WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void FlPcLButtonDown(LONG id, WPARAM wp, LPARAM lp)
{
	INT16 x16, y16;
	INT32 x, y;
	WCHAR buffRgb[6+1];
	INT32 rgb;
	INT32 target;
	HDC hdc;
	HBRUSH hBr;
	HBRUSH old;
	
	x16 = LOWORD(lp);
	y16 = HIWORD(lp);
	TryZeroDivision(fl[id].pc.w);
	TryZeroDivision(fl[id].pc.h);
	x = (double)(x16 * fm[id].pc[0].img.w) / fl[id].pc.w;
	y = (double)(y16 * fm[id].pc[0].img.h) / fl[id].pc.h;
	
	GetWindowText(fl[id].hEdit, buffRgb, 6+1);
	rgb = _wtoh(buffRgb, 6);
	
	hdc = fl[id].pc.tmp.hdc;
	
	hBr = CreateSolidBrush(_htor(rgb));
	old = (HBRUSH)SelectObject(hdc, hBr);
	
	target = GetPixel(hdc, x, y);
//	FloodFill(hdc, x, y, target);
	ExtFloodFill(hdc, x, y, target, FLOODFILLSURFACE);
	
	SelectObject(hdc, old);
	DeleteObject(hBr);
	
	InvalidateRect(fl[id].hPc, NULL, FALSE);
	UpdateWindow  (fl[id].hPc);
	fl[id].flgUpdate = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid FlEnterOk(LONG id)
    FLONG    FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void FlEnterOk(LONG id)
{
	WCHAR buffRgb[6+1];
	
	if (fl[id].flgUpdate == FALSE) {return;}
	
	memcpy(fm[id].pc[0].img.pB, fl[id].pc.tmp.pB, fm[id].pc[0].img.w*fm[id].pc[0].img.h*4);
	LiViewDelete(id, 0);
	
	InvalidateRect(fm[id].hPict[0],  NULL, TRUE);
	UpdateWindow(fm[id].hPict[0]);
	
	fm[id].flgFill = TRUE;
	SetFormText(id);
	MnFlushFile(id);
	
	GetWindowText(fl[id].hEdit, buffRgb, 6+1);
	fl[id].rgb = _wtoh(buffRgb, 6);
	
	FlStore(id);
	CLOSE(fl[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid FlEnterCan(LONG id)
    FLONG    FORM ID
    @\F[CANCEL]{^s
------------------------------------------------------------------------------*/
void FlEnterCan(LONG id)
{
	CLOSE(fl[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid FlTmpCreate(LONG)
    FLONG     FORM ID
    @\FhԂ ꎞC[W쐬
------------------------------------------------------------------------------*/
void FlTmpCreate(LONG id)
{
	INT32 w;
	INT32 h;
	
	w = fm[id].pc[0].img.w;
	h = fm[id].pc[0].img.h;
	ImageCreate(&fl[id].pc.tmp, w, h);
	
	memcpy(fl[id].pc.tmp.pB, fm[id].pc[0].img.pB, w * h * 4);
}

/*------------------------------------------------------------------------------
    Fvoid FlTmpDelete(LONG)
    FLONG     FORM ID
    @\FhԂ ꎞC[W폜
------------------------------------------------------------------------------*/
void FlTmpDelete(LONG id)
{
	DeleteDC    (fl[id].pc.tmp.hdc);
	DeleteObject(fl[id].pc.tmp.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid FlView(LONG)
    FLONG    FORM ID
    @\FhԂ̕ҏW\p
------------------------------------------------------------------------------*/
void FlView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	
	if (IsBit(fm[id].pc[0].img.stat, BIT_NONE|BIT_FAILURE)) {return;}
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	gainW = (double)fl[id].cn.w / fm[id].pc[0].img.w;
	gainH = (double)fl[id].cn.h / fm[id].pc[0].img.h;
	
	if (CmpGain(gainW, gainH) == TRUE) {
		limW = TRUE;
		limH = TRUE;
	}
	else {
		if (gainW < gainH) {
			gainH = gainW;
			limW = TRUE;
		}
		else {
			gainW = gainH;
			limH = TRUE;
		}
	}
	
	x = (double)fl[id].cn.w / 2 - (double)fm[id].pc[0].img.w * gainW / 2;
	y = (double)fl[id].cn.h / 2 - (double)fm[id].pc[0].img.h * gainH / 2;
	w = (double)fm[id].pc[0].img.w * gainW;
	h = (double)fm[id].pc[0].img.h * gainH;
	
	if (limW == TRUE) {x = 0;  w = fl[id].cn.w;}
	if (limH == TRUE) {y = 0;  h = fl[id].cn.h;}
	
	if (limW == TRUE) {TryZeroDivision(fm[id].pc[0].img.w);  fl[id].pc.percent = ((double)w / fm[id].pc[0].img.w) * 10000;}
	else              {TryZeroDivision(fm[id].pc[0].img.h);  fl[id].pc.percent = ((double)h / fm[id].pc[0].img.h) * 10000;}
	
	fl[id].pc.x = x;
	fl[id].pc.y = y;
	if (w <= 0) {fl[id].pc.w = 1;}
	else        {fl[id].pc.w = w;}
	if (h <= 0) {fl[id].pc.h = 1;}
	else        {fl[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    Fvoid FlSetPane(LONG)
    FLONG    FORM ID
    @\FhԂ̕\̘g\
------------------------------------------------------------------------------*/
void FlSetPane(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(fl[id].hPd[1], &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	a_SetWindowPos(fl[id].hCn, PADD8, PADD8, w-PADD8*2, h-PADD8*2);
	
	GetClientRect(fl[id].hCn, &rc);
	fl[id].cn.x = rc.left;
	fl[id].cn.y = rc.top;
	fl[id].cn.w = rc.right - rc.left;
	fl[id].cn.h = rc.bottom - rc.top;
}
