/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define FR_CPP
#include "../common.h"
//  FreeFRF

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 rgb;
	BOOL flgClick;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_FREE];
	
	HWND hWnd;
	HWND hEdit;
	HWND hRgb;
	HWND hBtn;
	
	LRESULT (CALLBACK *pCallEdit) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn)  (HWND,UINT,WPARAM,LPARAM);
} fr[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void FrInitClass(void);
void FrInit(LONG);
void FrInst(LONG);
void FrDialog(LONG);
void FrLoad(LONG);
void FrStore(LONG);
LRESULT CALLBACK FrWndProc    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK FrWndProcEdit(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK FrWndProcRgb (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK FrWndProcBtn (HWND, UINT, WPARAM, LPARAM);
void FrPaint        (LONG, WPARAM, LPARAM);
void FrCommand      (LONG, WPARAM, LPARAM);
void FrSetFocus     (LONG, WPARAM, LPARAM);
void FrKeyDown      (LONG, WPARAM, LPARAM, HWND);
void FrKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void FrKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void FrKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void FrKeyDownSpace (LONG, WPARAM, LPARAM, HWND);
void FrClose        (LONG, WPARAM, LPARAM);
void FrDestroy      (LONG, WPARAM, LPARAM);
void FrEdSetFocus   (LONG, WPARAM, LPARAM, HWND);
BOOL FrEdChar       (LONG, WPARAM, LPARAM, HWND);
void FrRbPaint      (LONG, WPARAM, LPARAM, HWND);
void FrRbSetFocus   (LONG, WPARAM, LPARAM, HWND);
void FrRbKillFocus  (LONG, WPARAM, LPARAM, HWND);
void FrRbLButtonDown(LONG, WPARAM, LPARAM, HWND);
void FrRbLButtonUp  (LONG, WPARAM, LPARAM, HWND);
void FrEnterOk(LONG);

/*------------------------------------------------------------------------------
    Fvoid FrInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void FrInitClass(void)
{
	WNDCLASS wcFree;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_FREE,&wcFree);
	
	RegisterClass(&wcFree);
}

/*------------------------------------------------------------------------------
    Fvoid FrInit(LONG)
    FLONG    FORM ID
    @\FRF 
------------------------------------------------------------------------------*/
void FrInit(LONG id)
{
	INT32 i;
	
	fr[id].rgb      = 0x000000;
	fr[id].flgClick = FALSE;
	
	fr[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_FREE; i++) {fr[id].tabStops[i] = NULL;}
	
	fr[id].hWnd  = NULL;
	fr[id].hEdit = NULL;
	fr[id].hRgb  = NULL;
	fr[id].hBtn  = NULL;
	
	fr[id].pCallEdit = NULL;
	fr[id].pCallBtn  = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid FrInst(LONG)
    FLONG      FORM ID
    @\FFREẺ
------------------------------------------------------------------------------*/
void FrInst(LONG id)
{
	DWORD styleFr = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_CLIPCHILDREN;
	DWORD styleEd = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleRb = WS_CHILD|WS_VISIBLE|WS_BORDER;
	DWORD styleBt = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	WCHAR str[6+1];
	
	_htow(fr[id].rgb, str, 6);
	
	fr[id].hWnd  = a_CreateWindow(NM_FREE,  TxTl(E_TTLFREE),styleFr,0,  0, 0, 0, fm[id].hWnd);
	fr[id].hEdit = a_CreateWindow(L"Edit",  str,            styleEd,35, 22,73,17,fr[id].hWnd);
	fr[id].hRgb  = a_CreateWindow(NM_RGBBOX,NULL,           styleRb,116,23,16,16,fr[id].hWnd);
	fr[id].hBtn  = a_CreateWindow(L"Button",L"OK",          styleBt,37, 54,70,25,fr[id].hWnd);
	SetWindowLong(fr[id].hWnd, GWL_USERDATA, id);
	SetWindowLong(fr[id].hEdit,GWL_USERDATA, id);
	SetWindowLong(fr[id].hRgb, GWL_USERDATA, id);
	SetWindowLong(fr[id].hBtn, GWL_USERDATA, id);
	SetWindowLong(fr[id].hWnd, GWL_WNDPROC, (LONG)FrWndProc);
	SetWindowLong(fr[id].hRgb, GWL_WNDPROC, (LONG)FrWndProcRgb);
	
	E_SETLIMITTEXT(fr[id].hEdit, 6);
	
	E_SETFONT(fr[id].hEdit, hFtCourier);
	B_SETFONT(fr[id].hBtn,  hFtArial14);
	
	fr[id].pCallEdit = (CALLFUNC)GetWindowLong(fr[id].hEdit, GWL_WNDPROC);
	fr[id].pCallBtn  = (CALLFUNC)GetWindowLong(fr[id].hBtn,  GWL_WNDPROC);
	SetWindowLong(fr[id].hEdit, GWL_WNDPROC, (LONG)FrWndProcEdit);
	SetWindowLong(fr[id].hBtn,  GWL_WNDPROC, (LONG)FrWndProcBtn);
	
	fr[id].tabStopIdx = 0;
	fr[id].tabStops[0] = fr[id].hEdit;
	fr[id].tabStops[1] = fr[id].hRgb;
	fr[id].tabStops[2] = fr[id].hBtn;
	
	SetFocus  (fr[id].hEdit);
	EditSelAll(fr[id].hEdit);
}

/*------------------------------------------------------------------------------
    Fvoid FrDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void FrDialog(LONG id)
{
	WINDOWPLACEMENT plcm;
	
	FrInit(id);
	FrLoad(id);
	FrInst(id);
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5 + 4;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + 157;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + 130;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(fr[id].hWnd, &plcm);
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = fr[id].hWnd;
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid FrLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void FrLoad(LONG id)
{
	fr[id].rgb = fm[id].rgbFree;
}

/*------------------------------------------------------------------------------
    Fvoid FrStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void FrStore(LONG id)
{
	fm[id].rgbFree = fr[id].rgb;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK FrWndProc(,,,)
    F-
    ߒlF-
    @\FFREECxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK FrWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:     FrPaint   (id, wp, lp);  break;
	case WM_COMMAND:   FrCommand (id, wp, lp);  break;
	case WM_SETFOCUS:  FrSetFocus(id, wp, lp);  break;
	case WM_CLOSE:     FrClose   (id, wp, lp);  break;
	case WM_DESTROY:   FrDestroy (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK FrWndProcEdit(,,,)
    F-
    ߒlF-
    @\FFREE EDITCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK FrWndProcEdit(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:  FrEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   FrKeyDown   (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (FrEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default: break;
	}
	return fr[id].pCallEdit(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK FrWndProcRgb(,,,)
    F-
    ߒlF-
    @\FFREE RGBBOXCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK FrWndProcRgb(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        FrRbPaint      (id, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     FrRbSetFocus   (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    FrRbKillFocus  (id, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  FrRbLButtonDown(id, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    FrRbLButtonUp  (id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      FrKeyDown      (id, wp, lp, hWnd);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK FrWndProcBtn(,,,)
    F-
    ߒlF-
    @\FFREE BTNCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK FrWndProcBtn(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:  FrEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   FrKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return fr[id].pCallBtn(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid FrPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFREE WM_PAINTCxg
------------------------------------------------------------------------------*/
void FrPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	
	hdc = BeginPaint(fr[id].hWnd, &ps);
	GetClientRect(fr[id].hWnd, &rc);
	SetClipRgn(hdc, &rc);
	SelectObject(hdc, hBrWhite);
	
	PatBlt(hdc, rc.left+PADD8,
				rc.top +PADD8,
				rc.right-rc.left-PADD8*2,
				rc.bottom-rc.top-PADD8*2, PATCOPY);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(fr[id].hWnd, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid FrCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFREE WM_COMMANDCxg
------------------------------------------------------------------------------*/
void FrCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if ((HWND)lp == fr[id].hBtn) {FrEnterOk(id);}
}

/*------------------------------------------------------------------------------
    Fvoid FrSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFREE WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void FrSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(fr[id].tabStops[fr[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid FrKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFREE WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void FrKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  FrKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    FrKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    FrKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_SP:     FrKeyDownSpace(id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid FrKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFREE [enter]L[Cxg
------------------------------------------------------------------------------*/
void FrKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	FrEnterOk(id);
}

/*------------------------------------------------------------------------------
    Fvoid FrKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFREE [esc]L[Cxg
------------------------------------------------------------------------------*/
void FrKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(fr[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid FrKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFREE [tab]L[Cxg
------------------------------------------------------------------------------*/
void FrKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (fr[id].tabStopIdx == 0) {fr[id].tabStopIdx = TBSP_FREE-1;}
		else                        {fr[id].tabStopIdx--;}
	}
	else {
		fr[id].tabStopIdx = (fr[id].tabStopIdx + 1) % TBSP_FREE;
	}
	SetFocus(fr[id].tabStops[fr[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid FrKeyDownSpace(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFREE [space]L[Cxg
------------------------------------------------------------------------------*/
void FrKeyDownSpace(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (hWnd != fr[id].hRgb) {return;}
	
	GetWindowText(fr[id].hEdit, buffRgb, 6+1);
	RbDialog(id, fr[id].hWnd, fr[id].hEdit, fr[id].hRgb, buffRgb);
}

/*------------------------------------------------------------------------------
    Fvoid FrClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFREE WM_CLOSECxg
------------------------------------------------------------------------------*/
void FrClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid FrDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FFREE WM_DESTROYCxg
------------------------------------------------------------------------------*/
void FrDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid FrEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFREE EDIT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void FrEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_FREE; i++) {
		if (hWnd == fr[id].tabStops[i]) {
			fr[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    FBOOL FrEdChar(LONG, WPARAM, LPARAM, HWND )
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    ߒlFBOOL    -
    @\FFREE WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL FrEdChar(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == fr[id].hEdit) {
		if (((0x30 <= wp) && (wp <= 0x39)) ||  // 0-9
			((0x41 <= wp) && (wp <= 0x46)) ||  // a-f
			((0x61 <= wp) && (wp <= 0x66)))    // A-F
		{
			return TRUE;
		}
	}
	
	switch (wp) {
	case 0x03:  // ctrl+C
	case 0x08:  // back space
	case 0x16:  // ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid FrRbPaint(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFREE RGBBOX WM_PAINTCxg
------------------------------------------------------------------------------*/
void FrRbPaint(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	RbBoxPaint(id, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid FrRbSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFREE RGBBOX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void FrRbSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_FREE; i++) {
		if ((HWND)wp == fr[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
	
	FrEdSetFocus(id, wp, lp, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid FrRbKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFREE RGBBOX WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void FrRbKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_FREE; i++) {
		if ((HWND)wp == fr[id].tabStops[i]) {
			res = TRUE;
		}
	}
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid FrRbLButtonDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFREE RGBBOX WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void FrRbLButtonDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	fr[id].flgClick = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid FrRbLButtonUp(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FFREE RGBBOX WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void FrRbLButtonUp(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (fr[id].flgClick == FALSE) {return;}
	fr[id].flgClick = FALSE;
	SetFocus(hWnd);
	
	GetWindowText(fr[id].hEdit, buffRgb, 6+1);
	RbDialog(id, fr[id].hWnd, fr[id].hEdit, fr[id].hRgb, buffRgb);
}

/*------------------------------------------------------------------------------
    Fvoid FrEnterOk(LONG)
    FLONG    FORM ID
    @\FRF wis
------------------------------------------------------------------------------*/
void FrEnterOk(LONG id)
{
	WCHAR str[6+1];
	
	fm[id].bkColor = FREE;
	
	GetWindowText(fr[id].hEdit, str, 6+1);
	fr[id].rgb = _wtoh(str, 6);
	
	FrStore(id);
	CLOSE(fr[id].hWnd);
	
	CmdBkColorChange(id, TRUE);
}
