/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define IG_CPP
#include "../common.h"
//  IgnoreF

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 ignore;
	
	HWND hWnd;
	HWND hEdit;
	
	LRESULT (CALLBACK *pCallEdit) (HWND,UINT,WPARAM,LPARAM);
} ig[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void IgInitClass(void);
void IgInit(LONG);
void IgInst(LONG, LONG);
void IgDialog(LONG, INT32);
void IgLoad(LONG, LONG);
void IgStore(LONG, LONG);
LRESULT CALLBACK IgWndProc    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK IgWndProcEdit(HWND, UINT, WPARAM, LPARAM);
void IgPaint    (LONG, LONG, WPARAM, LPARAM);
void IgSetFocus (LONG, LONG, WPARAM, LPARAM);
void IgClose    (LONG, LONG, WPARAM, LPARAM);
void IgDestroy  (LONG, LONG, WPARAM, LPARAM);
BOOL IgEdChar   (LONG, LONG, WPARAM, LPARAM);
void IgEdKeyDown(LONG, LONG, WPARAM, LPARAM);
void EnterOk(LONG, LONG);

/*------------------------------------------------------------------------------
    Fvoid IgInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void IgInitClass(void)
{
	WNDCLASS wcIgnore;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_IGNORE,&wcIgnore);
	
	RegisterClass(&wcIgnore);
}

/*------------------------------------------------------------------------------
    Fvoid IgInit(LONG)
    FLONG    FORM ID
    @\F 
------------------------------------------------------------------------------*/
void IgInit(LONG id)
{
	ig[id].ignore = 0x000;
	
	ig[id].hWnd  = NULL;
	ig[id].hEdit = NULL;
	
	ig[id].pCallEdit = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid IgInst(LONG, LONG)
    FLONG    FORM ID
          LONG    IGNORE ID
    @\FIGNORẺ
------------------------------------------------------------------------------*/
void IgInst(LONG id, LONG idI)
{
	DWORD styleIn = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_CLIPCHILDREN;
	DWORD styleEd = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	WCHAR str[3+1];
	
	_htow(ig[id].ignore, str, 3);
	
	ig[id].hWnd  = a_CreateWindow(NM_IGNORE,TxTl(E_TTLIGN),styleIn,0, 0, 0, 0, fm[id].hWnd);
	ig[id].hEdit = a_CreateWindow(L"Edit",   str,          styleEd,35,22,73,17,ig[id].hWnd);
	SetWindowLong(ig[id].hWnd,  GWL_USERDATA, idI * 100 + id);
	SetWindowLong(ig[id].hEdit, GWL_USERDATA, idI * 100 + id);
	SetWindowLong(ig[id].hWnd, GWL_WNDPROC, (LONG)IgWndProc);
	
	E_SETLIMITTEXT(ig[id].hEdit, 3);
	E_SETFONT     (ig[id].hEdit, hFtCourier);
	
	ig[id].pCallEdit = (CALLFUNC)GetWindowLong(ig[id].hEdit, GWL_WNDPROC);
	SetWindowLong(ig[id].hEdit, GWL_WNDPROC, (LONG)IgWndProcEdit);
	
	SetFocus  (ig[id].hEdit);
	EditSelAll(ig[id].hEdit);
}

/*------------------------------------------------------------------------------
    Fvoid IgDialog(LONG, INT32)
    FLONG    FORM ID
          INT32   -
    @\F_CAO
------------------------------------------------------------------------------*/
void IgDialog(LONG id, INT32 idx)
{
	WINDOWPLACEMENT plcm;
	
	IgLoad(id, idx);
	IgInst(id, idx);
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5 + 4;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + 150;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  +  87;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(ig[id].hWnd, &plcm);
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = ig[id].hWnd;
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid IgLoad(LONG, LONG)
    FLONG    FORM ID
          LONG    IGNORE ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void IgLoad(LONG id, LONG idI)
{
	ig[id].ignore = g_ignore[idI];
}

/*------------------------------------------------------------------------------
    Fvoid IgStore(LONG, LONG)
    FLONG    FORM ID
          LONG    IGNORE ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void IgStore(LONG id, LONG idI)
{
	g_ignore[idI] = ig[id].ignore;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK IgWndProc(,,,)
    F-
    ߒlF-
    @\FIGNORECxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK IgWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idI;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idI = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:     IgPaint   (id, idI, wp, lp);  break;
	case WM_SETFOCUS:  IgSetFocus(id, idI, wp, lp);  break;
	case WM_CLOSE:     IgClose   (id, idI, wp, lp);  break;
	case WM_DESTROY:   IgDestroy (id, idI, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK IgWndProcEdit(,,,)
    F-
    ߒlF-
    @\FIGNORE EDITCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK IgWndProcEdit(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idI;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idI = tmp / 100;
	
	switch (msg) {
	case WM_CHAR:
		if (IgEdChar(id, idI, wp, lp) == FALSE) {return 0;}
		break;
	case WM_KEYDOWN:  IgEdKeyDown(id, idI, wp, lp);  break;
	default: break;
	}
	return ig[id].pCallEdit(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid IgPaint(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM    ID
          LONG    IGNORE ID
          WPARAM  -
          LPARAM  -
    @\FIGNORE WM_PAINTCxg
------------------------------------------------------------------------------*/
void IgPaint(LONG id, LONG idI, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	
	hdc = BeginPaint(ig[id].hWnd, &ps);
	GetClientRect(ig[id].hWnd, &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hBrWhite);
	
	PatBlt(hdc, rc.left+PADD8,
				rc.top +PADD8,
				rc.right-rc.left-PADD8*2,
				rc.bottom-rc.top-PADD8*2, PATCOPY);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(ig[id].hWnd, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid IgSetFocus(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM    ID
          LONG    IGNORE ID
          WPARAM  -
          LPARAM  -
    @\FIGNORE WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void IgSetFocus(LONG id, LONG idI, WPARAM wp, LPARAM lp)
{
	SetFocus(ig[id].hEdit);
}

/*------------------------------------------------------------------------------
    Fvoid IgClose(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM    ID
          LONG    IGNORE ID
          WPARAM  -
          LPARAM  -
    @\FIGNORE WM_CLOSECxg
------------------------------------------------------------------------------*/
void IgClose(LONG id, LONG idI, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid IgDestroy(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM    ID
          LONG    IGNORE ID
          WPARAM  -
          LPARAM  -
    @\FIGNORE WM_DESTROYCxg
------------------------------------------------------------------------------*/
void IgDestroy(LONG id, LONG idI, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    FBOOL IgEdChar(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM    ID
          LONG    IGNORE ID
          WPARAM  -
          LPARAM  -
    ߒlFBOOL    -
    @\FIGNORE EDIT WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL IgEdChar(LONG id, LONG idI, WPARAM wp, LPARAM lp)
{
	if (wp == KEY_ENTER) {return FALSE;}
	else                 {return TRUE;}
}

/*------------------------------------------------------------------------------
    Fvoid IgEdKeyDown(LONG, LONG, WPARAM, LPARAM)
    FLONG    FORM    ID
          LONG    IGNORE ID
          WPARAM  -
          LPARAM  -
    @\FIGNORE EDIT WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void IgEdKeyDown(LONG id, LONG idI, WPARAM wp, LPARAM lp)
{
	switch (wp) {
	case KEY_ENTER:
		EnterOk(id, idI);
		break;
	case KEY_ESC:
		CLOSE(ig[id].hWnd);
		break;
	default:
		break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid EnterOk(LONG, LONG)
    FLONG    FORM    ID
          LONG    IGNORE ID
    @\Fs
------------------------------------------------------------------------------*/
void EnterOk(LONG id, LONG idI)
{
	WCHAR str[3+1];
	
	GetWindowText(ig[id].hEdit, str, 3+1);
	
	ig[id].ignore = _wtoh(str, 3);
	
	IgStore(id, idI);
	CLOSE(ig[id].hWnd);
	
	DebugReset();
}
