/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define MB_CPP
#include "../common.h"
//  MessageBoxFbZ[W{bNX

/*------------------------------------------------------------------------------
    ft@C
------------------------------------------------------------------------------*/
#define LEN_STR   10000
#define LEN_LINE  500

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 tabStopIdx;
	HWND tabStops[TBSP_MSGBX];
	INT32 cntTbsp;
	
	INT32 res;
	UINT type;
	WCHAR str[LEN_STR];
	
	HWND hPar;
	HWND hWnd;
	HWND hPd;
	HWND hBtn[3];
	
	LRESULT (CALLBACK *pCallBtn[3]) (HWND,UINT,WPARAM,LPARAM);
} mb[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void MbInitClass(void);
void MbInit(LONG);
void MbInst(LONG,const WCHAR *);
BOOL MbDialog(LONG,HWND,const WCHAR *,UINT);
INT32 MbGetStrW(LONG);
INT32 MbGetStrH(LONG);
LRESULT CALLBACK MbWndProc(HWND,UINT,WPARAM,LPARAM);
LRESULT CALLBACK MbWndProcBtn1(HWND,UINT,WPARAM,LPARAM);
LRESULT CALLBACK MbWndProcBtn2(HWND,UINT,WPARAM,LPARAM);
LRESULT CALLBACK MbWndProcBtn3(HWND,UINT,WPARAM,LPARAM);
void MbCommand(LONG,WPARAM,LPARAM);
void MbSetFocus(LONG,WPARAM,LPARAM);
void MbPaint(LONG,WPARAM,LPARAM);
void MbClose(LONG,WPARAM,LPARAM);
void MbDestroy(LONG,WPARAM,LPARAM);
void MbBtKeyDown(LONG,WPARAM,LPARAM,HWND);
void MbKeyDownEnter(LONG,WPARAM,LPARAM,HWND);
void MbKeyDownEsc(LONG,WPARAM,LPARAM,HWND);
void MbKeyDownTab(LONG,WPARAM,LPARAM,HWND);
void MbKeyDownRtLf(LONG,WPARAM,LPARAM,HWND);
void MbEnter(LONG,HWND);

/*------------------------------------------------------------------------------
    Fvoid MbInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void MbInitClass(void)
{
	WNDCLASS wcMsgbx;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_MSGBX,&wcMsgbx);
	
	RegisterClass(&wcMsgbx);
}

/*------------------------------------------------------------------------------
    Fvoid MbInit(LONG)
    FLONG    FORM ID
    @\FbZ[W{bNX 
------------------------------------------------------------------------------*/
void MbInit(LONG id)
{
	INT32 i;
	
	mb[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_MSGBX; i++) {mb[id].tabStops[i] = NULL;}
	mb[id].cntTbsp = 0;
	
	mb[id].res = FALSE;
	mb[id].type = 0;
	wmemset(mb[id].str, 0x0000, LEN_STR);
	
	mb[id].hPar = NULL;
	mb[id].hWnd = NULL;
	mb[id].hPd  = NULL;
	for (i = 0; i < 3; i++) {mb[id].hBtn[i] = NULL;}
	
	for (i = 0; i < 3; i++) {mb[id].pCallBtn[i] = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid MbInst(LONG, const WCHAR *)
    FLONG           FORM ID
          const WCHAR *  -
    @\FMESSAGEBOX̉
------------------------------------------------------------------------------*/
void MbInst(LONG id, const WCHAR *title)
{
	DWORD styleMb = WS_CAPTION|WS_SYSMENU;
	DWORD styleBt1 = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD styleBt2 = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD styleBt3 = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	INT32 x, y, w, h;
	INT32 wMin[3] = {103, 202, 286};
	INT32 wMax;
	INT32 x1, x2, x3;
	INT32 y1;
	const WCHAR *str1, *str2, *str3;
	INT32 idx;
	RECT rc;
	
	str1 = NULL;
	str2 = NULL;
	str3 = NULL;
	
	switch (mb[id].type) {
	case MB_OK:          str1=TxEd(E_OK);    styleBt2&=~WS_VISIBLE;  styleBt3&=~WS_VISIBLE;  idx=0;  break;
	case MB_OKCANCEL:    str1=TxEd(E_OK);    str2=TxEd(E_CANCEL);    styleBt3&=~WS_VISIBLE;  idx=1;  break;
	case MB_YESNOCANCEL: str1=TxEd(E_YES);   str2=TxEd(E_NO);        str3=TxEd(E_CANCEL);    idx=2;  break;
	case MB_RETRYCANCEL: str1=TxEd(E_RETRY); str2=TxEd(E_CANCEL);    styleBt3&=~WS_VISIBLE;  idx=1;  break;
	default: break;
	}
	
	w = wMin[idx];
	mb[id].cntTbsp = idx+1;
	
	wMax = MbGetStrW(id);
	if (w < (wMax + 38)) {w = wMax + 38;}
	
	h = 85;
	h += MbGetStrH(id);
	y1 = h - 23;
	
	w += GetSystemMetrics(SM_CXSIZEFRAME)*2;
	h += GetSystemMetrics(SM_CYSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	x = (GetSystemMetrics(SM_CXSCREEN) - w) / 2;
	y = (GetSystemMetrics(SM_CYSCREEN) - h) / 2;
	
	mb[id].hWnd = a_CreateWindow(NM_MSGBX,title,styleMb,x,y,w,h,mb[id].hPar);
	SetWindowLong(mb[id].hWnd, GWL_USERDATA, id);
	SetWindowLong(mb[id].hWnd, GWL_WNDPROC, (LONG)MbWndProc);
	
	GetClientRect(mb[id].hWnd, &rc);
	w = rc.right - rc.left;
	
	switch (idx) {
	case 0:  x1 = w -93;  break;
	case 1:  x1 = w -176;  x2 = w -93;  break;
	case 2:  x1 = w -260;  x2 = w -177;  x3 = w -92;  break;
	default: break;
	}
	
	mb[id].hBtn[0] = a_CreateWindow(L"Button",str1,styleBt1,x1,y1,74,25,mb[id].hWnd);
	mb[id].hBtn[1] = a_CreateWindow(L"Button",str2,styleBt2,x2,y1,74,25,mb[id].hWnd);
	mb[id].hBtn[2] = a_CreateWindow(L"Button",str3,styleBt3,x3,y1,74,25,mb[id].hWnd);
	SetWindowLong(mb[id].hBtn[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(mb[id].hBtn[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(mb[id].hBtn[2], GWL_USERDATA, 2*100+id);
	B_SETFONT(mb[id].hBtn[0], hFtArial14);
	B_SETFONT(mb[id].hBtn[1], hFtArial14);
	B_SETFONT(mb[id].hBtn[2], hFtArial14);
	mb[id].pCallBtn[0] = (CALLFUNC)GetWindowLong(mb[id].hBtn[0], GWL_WNDPROC);
	mb[id].pCallBtn[1] = (CALLFUNC)GetWindowLong(mb[id].hBtn[1], GWL_WNDPROC);
	mb[id].pCallBtn[2] = (CALLFUNC)GetWindowLong(mb[id].hBtn[2], GWL_WNDPROC);
	SetWindowLong(mb[id].hBtn[0], GWL_WNDPROC, (LONG)MbWndProcBtn1);
	SetWindowLong(mb[id].hBtn[1], GWL_WNDPROC, (LONG)MbWndProcBtn2);
	SetWindowLong(mb[id].hBtn[2], GWL_WNDPROC, (LONG)MbWndProcBtn3);
	
	mb[id].tabStopIdx = 0;
	mb[id].tabStops[0] = mb[id].hBtn[0];
	mb[id].tabStops[1] = mb[id].hBtn[1];
	mb[id].tabStops[2] = mb[id].hBtn[2];
	
	SetFocus(mb[id].hBtn[0]);
}

/*------------------------------------------------------------------------------
    FBOOL MbDialog(LONG, HWND, const WCHAR *, const WCHAR *, UINT)
    FLONG           FORM ID
          HWND           -
          const WCHAR *  -
          const WCHAR *  -
          UINT           -
    ߒlFBOOL           -
    @\F_CAO
------------------------------------------------------------------------------*/
BOOL MbDialog(LONG id, HWND hWnd, const WCHAR *str, const WCHAR *title, UINT type)
{
	MbInit(id);
	
	mb[id].hPar = hWnd;
	mb[id].type = type;
	wcsncpy(mb[id].str, str, LEN_STR-1);
	
	MbInst(id, title);
	
	EnableWindow(mb[id].hPar, FALSE);
	fm[id].hModal = mb[id].hWnd;
	
	ShowWindow(mb[id].hWnd, 0x1);
	
	return MessageLoop();
}

/*------------------------------------------------------------------------------
    FINT32 MbGetStrW(LONG)
    FLONG   FORM ID
    ߒlFINT32  -
    @\F̕擾
------------------------------------------------------------------------------*/
INT32 MbGetStrW(LONG id)
{
	HDC hdc;
	PAINTSTRUCT ps;
	SIZE sz;
	WCHAR *p;
	WCHAR buff[LEN_STR];
	INT32 w;
	INT32 wMax = 0;
	
	wcscpy(buff, mb[id].str);
	p = wcstok(buff, L"\r\n");
	
	while (p != NULL) {
		hdc = BeginPaint(mb[id].hPar, &ps);
		SelectObject(hdc, hFtArial14);
		GetTextExtentPoint32(hdc, p, wcslen(p), &sz);
		EndPaint(mb[id].hPar, &ps);
		
		w = sz.cx;
		if (w > wMax) {wMax = w;}
		
		p = wcstok(NULL, L"\r\n");
	}
	return wMax;
}

/*------------------------------------------------------------------------------
    FINT32 MbGetStrH(LONG)
    FLONG   -
    ߒlFINT32  -
    @\F̍擾
------------------------------------------------------------------------------*/
INT32 MbGetStrH(LONG id)
{
	INT32 i;
	INT32 row;
	BOOL cr;
	
	if (wcslen(mb[id].str) == 0) {return 0;}
	
	row = 1;
	cr = FALSE;
	for (i = 0; mb[id].str[i] != '\0'; i++) {
		if (!cr) {
			if (mb[id].str[i] == '\r') {cr = TRUE;}
		}
		else {
			if (mb[id].str[i] == '\n') {cr = FALSE;  row++;}
		}
	}
	
	return row*13;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK ArWndProc(,,,)
    F-
    ߒlF-
    @\FMSGBX Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MbWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_COMMAND:   MbCommand(id, wp, lp);   break;
	case WM_SETFOCUS:  MbSetFocus(id, wp, lp);  break;
	case WM_PAINT:     MbPaint(id, wp, lp);     break;
	case WM_CLOSE:     MbClose(id, wp, lp);     break;
	case WM_DESTROY:   MbDestroy(id, wp, lp);   break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MbWndProcBtn1(,,,)
    F-
    ߒlF-
    @\FBTN1 Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MbWndProcBtn1(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_KEYDOWN:  MbBtKeyDown(id, wp, lp, hWnd);  break;
	default: break;
	}
	return mb[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MbWndProcBtn2(,,,)
    F-
    ߒlF-
    @\FBTN2 Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MbWndProcBtn2(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_KEYDOWN:  MbBtKeyDown(id, wp, lp, hWnd);  break;
	default: break;
	}
	return mb[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MbWndProcBtn3(,,,)
    F-
    ߒlF-
    @\FBTN3 Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MbWndProcBtn3(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_KEYDOWN:  MbBtKeyDown(id, wp, lp, hWnd);  break;
	default: break;
	}
	return mb[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid MbCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_COMMANDCxg
------------------------------------------------------------------------------*/
void MbCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	MbEnter(id, (HWND)lp);
}

/*------------------------------------------------------------------------------
    Fvoid MbSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void MbSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(mb[id].tabStops[mb[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid MbPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_PAINTCxg
------------------------------------------------------------------------------*/
void MbPaint(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 i;
	INT32 idx;
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 row;
	BOOL cr;
	WCHAR buff[LEN_LINE];
	
	hdc = BeginPaint(mb[id].hWnd, &ps);
	GetClientRect(mb[id].hWnd, &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hBrWhite);
	PatBlt(hdc, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top-40, PATCOPY);
	
	SelectObject(hdc, hFtArial14);
	SetTextColor(hdc, RGB_BLACK);
	SetBkColor(hdc, RGB_WHITE);
	
	//  wcstok ͋󕶎ĂȂBB
	
	i = 0;
	idx = 0;
	row = 0;
	cr = FALSE;
	while (1) {
		if (mb[id].str[i] == '\0') {
			wmemset(buff, 0x0000, LEN_LINE);
			wcsncpy(buff, &(mb[id].str[idx]), i-idx+1);
			a_TextOut(hdc, 19, 28+row*13, buff);
			break;
		}
		
		if (!cr) {
			if (mb[id].str[i] == '\r') {
				cr = TRUE;
			}
		}
		else {
			if (mb[id].str[i] == '\n') {
				cr = FALSE;
				
				wmemset(buff, 0x0000, LEN_LINE);
				wcsncpy(buff, &(mb[id].str[idx]), i-idx+1);
				a_TextOut(hdc, 19, 28+row*13, buff);
				idx = i+1;
				
				row++;
			}
		}
		i++;
	}
	
	SelectClipRgn(hdc, NULL);
	EndPaint(mb[id].hWnd, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid MbClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_CLOSECxg
------------------------------------------------------------------------------*/
void MbClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = mb[id].hPar;
	EnableWindow(mb[id].hPar, TRUE);
	SetForegroundWindow(mb[id].hPar);
}

/*------------------------------------------------------------------------------
    Fvoid MbDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_DESTROYCxg
------------------------------------------------------------------------------*/
void MbDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(mb[id].res);
}

/*------------------------------------------------------------------------------
    Fvoid MbBtKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FWM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void MbBtKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  MbKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    MbKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    MbKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_RT:
	case KEY_LF:     MbKeyDownRtLf (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid MbKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[enter]L[Cxg
------------------------------------------------------------------------------*/
void MbKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	MbEnter(id, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid MbKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[esc]L[Cxg
------------------------------------------------------------------------------*/
void MbKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(mb[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid MbKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[tab]L[Cxg
------------------------------------------------------------------------------*/
void MbKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (mb[id].tabStopIdx == 0) {mb[id].tabStopIdx = mb[id].cntTbsp-1;}
		else                        {mb[id].tabStopIdx--;}
	}
	else {
		mb[id].tabStopIdx = (mb[id].tabStopIdx + 1) % mb[id].cntTbsp;
	}
	SetFocus(mb[id].tabStops[mb[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid MbKeyDownRtLf(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[][]L[Cxg
------------------------------------------------------------------------------*/
void MbKeyDownRtLf(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == mb[id].hBtn[0]) {
		if (wp == KEY_RT) {mb[id].tabStopIdx++;}
	}
	else if (hWnd == mb[id].hBtn[1]) {
		if (wp == KEY_LF) {mb[id].tabStopIdx--;}
		if (wp == KEY_RT) {mb[id].tabStopIdx++;}
	}
	else {
		if (wp == KEY_LF) {mb[id].tabStopIdx--;}
	}
	
	if (mb[id].cntTbsp <= mb[id].tabStopIdx) {mb[id].tabStopIdx--;}
	
	SetFocus(mb[id].tabStops[mb[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid MbEnter(LONG, HWND)
    FLONG    FORM ID
          HWND    -
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void MbEnter(LONG id, HWND hWnd)
{
	INT32 idx;
	
	if      (hWnd == mb[id].hBtn[0]) {idx = 0;}
	else if (hWnd == mb[id].hBtn[1]) {idx = 1;}
	else if (hWnd == mb[id].hBtn[2]) {idx = 2;}
	else                             {return;}
	
	mb[id].res = NULL;
	
	switch (mb[id].type) {
	case MB_OK:
		switch (idx) {
		case 0:  mb[id].res = IDOK;  break;
		default: break;
		}
		break;
	case MB_OKCANCEL:
		switch (idx) {
		case 0:  mb[id].res = IDOK;      break;
		case 1:  mb[id].res = IDCANCEL;  break;
		default: break;
		}
		break;
	case MB_YESNOCANCEL:
		switch (idx) {
		case 0:  mb[id].res = IDYES;     break;
		case 1:  mb[id].res = IDNO;      break;
		case 2:  mb[id].res = IDCANCEL;  break;
		default: break;
		}
		break;
	case MB_RETRYCANCEL:
		switch (idx) {
		case 0:  mb[id].res = IDRETRY;   break;
		case 1:  mb[id].res = IDCANCEL;  break;
		default: break;
		}
		break;
	default:
		break;
	}
	
	CLOSE(mb[id].hWnd);
}
