/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define MARGIN_CPP
#include "../common.h"

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 tabStopIdx;
	HWND tabStops[TBSP_MARGIN];
	
	HWND hWnd;
	HWND hEdit[4];
	HWND hBtn[2];
	
	LRESULT (CALLBACK *pCallEdit[4])(HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn[2]) (HWND,UINT,WPARAM,LPARAM);
} mr[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void MrInitClass(void);
void MrInit(LONG);
void MrInst(LONG);
void MrDialog(LONG);
LRESULT CALLBACK MrWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MrWndProcEdit  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MrWndProcEditTp(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MrWndProcEditBm(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MrWndProcEditLf(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MrWndProcEditRt(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MrWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MrWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
void MrCommand     (LONG, WPARAM, LPARAM);
void MrPaint       (LONG, WPARAM, LPARAM);
void MrSetFocus    (LONG, WPARAM, LPARAM);
void MrKeyDown     (LONG, WPARAM, LPARAM, HWND);
void MrKeyDownEnter(LONG, WPARAM, LPARAM, HWND);
void MrKeyDownEsc  (LONG, WPARAM, LPARAM, HWND);
void MrKeyDownTab  (LONG, WPARAM, LPARAM, HWND);
void MrKeyDownUpDw (LONG, WPARAM, LPARAM, HWND);
void MrClose       (LONG, WPARAM, LPARAM);
void MrDestroy     (LONG, WPARAM, LPARAM);
void MrEdSetFocus  (LONG, WPARAM, LPARAM, HWND);
BOOL MrEdChar      (LONG, WPARAM, LPARAM);
void MrEnterOk(LONG);
void MrEnterCan(LONG);

/*------------------------------------------------------------------------------
    Fvoid MrInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void MrInitClass(void)
{
	WNDCLASS wcMargin;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_MARGIN,&wcMargin);
	
	RegisterClass(&wcMargin);
}

/*------------------------------------------------------------------------------
    Fvoid MrInit(LONG)
    FLONG    FORM ID
    @\F]
------------------------------------------------------------------------------*/
void MrInit(LONG id)
{
	INT32 i;
	
	mr[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_DEFORM; i++) {mr[id].tabStops[i] = NULL;}
	
	mr[id].hWnd  = NULL;
	for (i = 0; i < 4; i++) {mr[id].hEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {mr[id].hBtn[i]  = NULL;}
	
	for (i = 0; i < 4; i++) {mr[id].pCallEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {mr[id].pCallBtn[i]  = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid MrInst(LONG)
    FLONG      FORM ID
    @\FMARGIN̉
------------------------------------------------------------------------------*/
void MrInst(LONG id)
{
	DWORD styleMr = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU;
	DWORD styleEd = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleBt = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	
	mr[id].hWnd     = a_CreateWindow(NM_MARGIN,TxTl(E_TTLMAR),  styleMr,0,  0,  0, 0, fm[id].hWnd);
	mr[id].hEdit[0] = a_CreateWindow(L"Edit",  L"0",            styleEd,80, 22, 65,17,mr[id].hWnd);
	mr[id].hEdit[1] = a_CreateWindow(L"Edit",  L"0",            styleEd,80, 52, 65,17,mr[id].hWnd);
	mr[id].hEdit[2] = a_CreateWindow(L"Edit",  L"0",            styleEd,80, 82, 65,17,mr[id].hWnd);
	mr[id].hEdit[3] = a_CreateWindow(L"Edit",  L"0",            styleEd,80, 112,65,17,mr[id].hWnd);
	mr[id].hBtn[0]  = a_CreateWindow(L"Button",TxEd(E_OK),      styleBt,18, 144,70,25,mr[id].hWnd);
	mr[id].hBtn[1]  = a_CreateWindow(L"Button",TxEd(E_CANCEL),  styleBt,98, 144,70,25,mr[id].hWnd);
	
	SetWindowLong(mr[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(mr[id].hEdit[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(mr[id].hEdit[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(mr[id].hEdit[2], GWL_USERDATA, 2*100+id);
	SetWindowLong(mr[id].hEdit[3], GWL_USERDATA, 3*100+id);
	SetWindowLong(mr[id].hBtn[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(mr[id].hBtn[1],  GWL_USERDATA, 1*100+id);
	
	SetWindowLong(mr[id].hWnd, GWL_WNDPROC, (LONG)MrWndProc);
	
	E_SETLIMITTEXT(mr[id].hEdit[0], 3);
	E_SETLIMITTEXT(mr[id].hEdit[1], 3);
	E_SETLIMITTEXT(mr[id].hEdit[2], 3);
	E_SETLIMITTEXT(mr[id].hEdit[3], 3);
	
	E_SETFONT(mr[id].hEdit[0], hFtCourier);
	E_SETFONT(mr[id].hEdit[1], hFtCourier);
	E_SETFONT(mr[id].hEdit[2], hFtCourier);
	E_SETFONT(mr[id].hEdit[3], hFtCourier);
	B_SETFONT(mr[id].hBtn[0],  hFtArial14);
	B_SETFONT(mr[id].hBtn[1],  hFtArial14);
	
	mr[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(mr[id].hEdit[0], GWL_WNDPROC);
	mr[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(mr[id].hEdit[1], GWL_WNDPROC);
	mr[id].pCallEdit[2] = (CALLFUNC)GetWindowLong(mr[id].hEdit[2], GWL_WNDPROC);
	mr[id].pCallEdit[3] = (CALLFUNC)GetWindowLong(mr[id].hEdit[3], GWL_WNDPROC);
	mr[id].pCallBtn[0]  = (CALLFUNC)GetWindowLong(mr[id].hBtn[0],  GWL_WNDPROC);
	mr[id].pCallBtn[1]  = (CALLFUNC)GetWindowLong(mr[id].hBtn[1],  GWL_WNDPROC);
	SetWindowLong(mr[id].hEdit[0], GWL_WNDPROC, (LONG)MrWndProcEditTp);
	SetWindowLong(mr[id].hEdit[1], GWL_WNDPROC, (LONG)MrWndProcEditBm);
	SetWindowLong(mr[id].hEdit[2], GWL_WNDPROC, (LONG)MrWndProcEditLf);
	SetWindowLong(mr[id].hEdit[3], GWL_WNDPROC, (LONG)MrWndProcEditRt);
	SetWindowLong(mr[id].hBtn[0],  GWL_WNDPROC, (LONG)MrWndProcBtnOk);
	SetWindowLong(mr[id].hBtn[1],  GWL_WNDPROC, (LONG)MrWndProcBtnCan);
	
	mr[id].tabStopIdx = 0;
	mr[id].tabStops[0] = mr[id].hEdit[0];
	mr[id].tabStops[1] = mr[id].hEdit[1];
	mr[id].tabStops[2] = mr[id].hEdit[2];
	mr[id].tabStops[3] = mr[id].hEdit[3];
	mr[id].tabStops[4] = mr[id].hBtn[0];
	mr[id].tabStops[5] = mr[id].hBtn[1];
	
	SetFocus  (mr[id].hEdit[0]);
	EditSelAll(mr[id].hEdit[0]);
}

/*------------------------------------------------------------------------------
    Fvoid MrDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void MrDialog(LONG id)
{
	WINDOWPLACEMENT plcm;
	
	MrInit(id);
	MrInst(id);
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5 + 4;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + 190;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + 215;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(mr[id].hWnd, &plcm);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = mr[id].hWnd;
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MrWndProc(,,,)
    F-
    ߒlF-
    @\FMARGINCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MrWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_COMMAND:   MrCommand (id, wp, lp);  break;
	case WM_PAINT:     MrPaint   (id, wp, lp);  break;
	case WM_SETFOCUS:  MrSetFocus(id, wp, lp);  break;
	case WM_CLOSE:     MrClose   (id, wp, lp);  break;
	case WM_DESTROY:   MrDestroy (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MrWndProcEditTp(,,,)
    F-
    ߒlF-
    @\FMARGIN EDIT TOPCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MrWndProcEditTp(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  MrEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		MrKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (MrEdChar(id, wp, lp) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return mr[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MrWndProcEditBm(,,,)
    F-
    ߒlF-
    @\FMARGIN EDIT BOTTOMCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MrWndProcEditBm(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  MrEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		MrKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (MrEdChar(id, wp, lp) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return mr[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MrWndProcEditLf(,,,)
    F-
    ߒlF-
    @\FMARGIN EDIT LEFTCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MrWndProcEditLf(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  MrEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		MrKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (MrEdChar(id, wp, lp) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return mr[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MrWndProcEditRt(,,,)
    F-
    ߒlF-
    @\FMARGIN EDIT RIGHTCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MrWndProcEditRt(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  MrEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		MrKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (MrEdChar(id, wp, lp) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return mr[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MrWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FMARGIN BUTTON OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MrWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  MrEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   MrKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	
	return mr[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MrWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FMARGIN BUTTON CANCELCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MrWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  MrEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   MrKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	
	return mr[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid MrCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMARGIN WM_COMMANDCxg
------------------------------------------------------------------------------*/
void MrCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if      ((HWND)lp == mr[id].hBtn[0]) {MrEnterOk(id);}
	else if ((HWND)lp == mr[id].hBtn[1]) {MrEnterCan(id);}
}

/*------------------------------------------------------------------------------
    Fvoid MrPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMARGIN WM_PAINTCxg
------------------------------------------------------------------------------*/
void MrPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x;
	
	hdc = BeginPaint(mr[id].hWnd, &ps);
	GetClientRect(mr[id].hWnd, &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hBrWhite);
	SelectObject(hdc, hFtArial14);
	
	PatBlt(hdc, rc.left+PADD8,
				rc.top+PADD8,
				rc.right-rc.left-PADD8*2,
				rc.bottom-rc.top-PADD8*2, PATCOPY);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	switch (g_idxLang) {
	case 0:  x = 43;  break;
	case 1:  x = 34;  break;
	default: break;
	}
	
	a_TextOut(hdc, x, 23,  TxEd(E_MRTOP));
	a_TextOut(hdc, x, 53,  TxEd(E_MRBOTTOM));
	a_TextOut(hdc, x, 83,  TxEd(E_MRLEFT));
	a_TextOut(hdc, x, 113, TxEd(E_MRRIGHT));
	
	SelectClipRgn(hdc, NULL);
	EndPaint(mr[id].hWnd, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid MrSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMARGIN WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void MrSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(mr[id].tabStops[mr[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid MrClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMARGIN WM_CLOSECxg
------------------------------------------------------------------------------*/
void MrClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid MrDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMARGIN WM_DESTROYCxg
------------------------------------------------------------------------------*/
void MrDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid MrEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FMARGIN EDIT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void MrEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_MARGIN; i++) {
		if (hWnd == mr[id].tabStops[i]) {
			mr[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid MrKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FMARGIN WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void MrKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  MrKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    MrKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    MrKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_UP:
	case KEY_DW:     MrKeyDownUpDw (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid MrKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FMARGIN [enter]L[Cxg
------------------------------------------------------------------------------*/
void MrKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == mr[id].hBtn[1]) {MrEnterCan(id);}
	else                        {MrEnterOk(id);}
}

/*------------------------------------------------------------------------------
    Fvoid MrKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FMARGIN [esc]L[Cxg
------------------------------------------------------------------------------*/
void MrKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(mr[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid MrKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FMARGIN [tab]L[Cxg
------------------------------------------------------------------------------*/
void MrKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (mr[id].tabStopIdx == 0) {mr[id].tabStopIdx = TBSP_MARGIN-1;}
		else                        {mr[id].tabStopIdx--;}
	}
	else {
		mr[id].tabStopIdx = (mr[id].tabStopIdx + 1) % TBSP_MARGIN;
	}
	SetFocus(mr[id].tabStops[mr[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid MrKeyDownUpDw(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FMARGIN [][]L[Cxg
------------------------------------------------------------------------------*/
void MrKeyDownUpDw(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT16 tmp;
	UINT16 comb;
	BOOL shift;
	WCHAR text[3+1];
	INT32 val;
	INT32 valTmp;
	INT32 limL;
	INT32 limH;
	INT32 step;
	
	comb  = 0x000;
	shift = FALSE;
	tmp = GetKeyState(KEY_CTRL);   if((tmp & 0x80)!=0){comb |= 0x100;}
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){comb |= 0x010;  shift = TRUE;}
	
	if      (comb == 0x000) {step = 1;}
	else if (comb == 0x100) {step = 10;}
	else if (comb == 0x010) {step = 100;}
	else                    {return;}
	
	if ((hWnd == mr[id].hEdit[0]) ||
		(hWnd == mr[id].hEdit[1]) ||
		(hWnd == mr[id].hEdit[2]) ||
		(hWnd == mr[id].hEdit[3]))
	{
		GetWindowText(hWnd, text, 3+1);
		val = _wtoi(text);
		valTmp = val;
		
		limL = 0;
		limH = 999;
		
		if (wp == KEY_UP) {val += step;}
		else              {val -= step;}
		
		if (val < limL) {val = limL;}
		if (limH < val) {val = limH;}
		
		if (valTmp == val) {return;}
		
		_itow(val, text, 10);
		SetWindowText(hWnd, text);
		EditSelAll(hWnd);
	}
}

/*------------------------------------------------------------------------------
    FBOOL MrEdChar(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    ߒlFBOOL    -
    @\FMARGIN EDIT WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL MrEdChar(LONG id, WPARAM wp, LPARAM lp)
{
	if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	
	switch (wp) {
	case 0x03:		// ctrl+C
	case 0x08:		// back space
	case 0x16:		// ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid MrEnterOk(LONG id)
    FLONG    FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void MrEnterOk(LONG id)
{
	INT32 i, j;
	WCHAR text[4][3+1];
	INT32 val[4];
	INT32 srcX, srcY;
	INT32 dstX, dstY;
	INT32 srcW, srcH;
	INT32 dstW, dstH;
	BYTE *pB;
	st_Image img;
	
	GetWindowText(mr[id].hEdit[0], text[0], 3+1);
	GetWindowText(mr[id].hEdit[1], text[1], 3+1);
	GetWindowText(mr[id].hEdit[2], text[2], 3+1);
	GetWindowText(mr[id].hEdit[3], text[3], 3+1);
	val[0] = _wtoi(text[0]);
	val[1] = _wtoi(text[1]);
	val[2] = _wtoi(text[2]);
	val[3] = _wtoi(text[3]);
	for (i = 0; i < 4; i++) {
		if (val[i] < 0)   {val[i] = 0;}
		if (999 < val[i]) {val[i] = 999;}
	}
	
	srcW = fm[id].pc[0].img.w;
	srcH = fm[id].pc[0].img.h;
	dstW = val[2] + srcW + val[3];
	dstH = val[0] + srcH + val[1];
	
	srcX = 0;
	srcY = 0;
	dstX = srcX + val[2];
	dstY = srcY + val[0];
	
	ImageCreate(&img, dstW, dstH);
	
	pB = img.pB;
	for (i = 0; i < dstH; i++) {
		for (j = 0; j < dstW; j++) {
			*(pB + 2) = 0xFF;
			*(pB + 1) = 0xFF;
			*(pB + 0) = 0xFF;
			pB += 4;
		}
	}
	BitBlt(img.hdc, dstX, dstY, dstW, dstH, fm[id].pc[0].img.hdc, srcX, srcY, SRCCOPY);
	
	DeleteObject(fm[id].pc[0].img.hBmp);
	DeleteDC    (fm[id].pc[0].img.hdc);
	fm[id].pc[0].img.hBmp = img.hBmp;
	fm[id].pc[0].img.hdc  = img.hdc;
	fm[id].pc[0].img.pB   = img.pB;
	fm[id].pc[0].img.w    = img.w;
	fm[id].pc[0].img.h    = img.h;
	fm[id].flgMargin      = TRUE;
	LiViewDelete(id, 0);
	
	SetAverageColor(id, 0);
	FmSizeNeutral(id, NULL, NULL);
	
	SbFlush(id);
	SetFormText(id);
	MnFlushFile(id);
	
	CLOSE(mr[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid MrEnterCan(LONG id)
    FLONG    FORM ID
    @\F[CANCEL]{^s
------------------------------------------------------------------------------*/
void MrEnterCan(LONG id)
{
	CLOSE(mr[id].hWnd);
}
