/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define PN_CPP
#include "../common.h"
//  PenFy

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 rgb;
	INT32 t;
	BOOL flgClick;
	BOOL flgUpdate;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_PEN];
	HPEN hPn;
	HPEN hOld;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;} cn;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			UINT32 percent;
			BOOL flgClick;
			st_Image tmp;} pc;
	
	HWND hWnd;
	HWND hPd[2];
	HWND hEdit[2];
	HWND hRgb;
	HWND hBtn[2];
	HWND hCn;
	HWND hPc;
	
	LRESULT (CALLBACK *pCallEdit[2]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn[2])  (HWND,UINT,WPARAM,LPARAM);
} pn[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void PnInitClass(void);
void PnInit(LONG);
void PnInst(LONG);
void PnDialog(LONG);
void PnLoad(LONG);
void PnStore(LONG);
LRESULT CALLBACK PnWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PnWndProcPd    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PnWndProcEditC (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PnWndProcEditT (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PnWndProcRgb   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PnWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PnWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PnWndProcPc    (HWND, UINT, WPARAM, LPARAM);
void PnSize         (LONG, WPARAM, LPARAM);
void PnGetMinMaxInfo(LONG, WPARAM, LPARAM);
void PnSetFocus     (LONG, WPARAM, LPARAM);
void PnKeyDown      (LONG, WPARAM, LPARAM, HWND);
void PnKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void PnKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void PnKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void PnKeyDownSpace (LONG, WPARAM, LPARAM, HWND);
void PnKeyDownUpDw  (LONG, WPARAM, LPARAM, HWND);
void PnClose        (LONG, WPARAM, LPARAM);
void PnDestroy      (LONG, WPARAM, LPARAM);
void PnPdCommand    (LONG, WPARAM, LPARAM);
void PnPdPaint      (LONG, WPARAM, LPARAM);
void PnEdSetFocus   (LONG, WPARAM, LPARAM, HWND);
void PnEdKillFocus  (LONG, WPARAM, LPARAM, HWND);
BOOL PnEdChar       (LONG, WPARAM, LPARAM, HWND);
void PnRbPaint      (LONG, WPARAM, LPARAM, HWND);
void PnRbSetFocus   (LONG, WPARAM, LPARAM, HWND);
void PnRbKillFocus  (LONG, WPARAM, LPARAM, HWND);
void PnRbLButtonDown(LONG, WPARAM, LPARAM, HWND);
void PnRbLButtonUp  (LONG, WPARAM, LPARAM, HWND);
void PnPcPaint      (LONG, WPARAM, LPARAM);
void PnPcMouseMove  (LONG, WPARAM, LPARAM);
void PnPcLButtonDown(LONG, WPARAM, LPARAM);
void PnPcLButtonUp  (LONG, WPARAM, LPARAM);
void PnEnterOk(LONG);
void PnEnterCan(LONG);
void PnTmpCreate(LONG);
void PnTmpDelete(LONG);
void PnView(LONG);
void PnSetPane(LONG);

/*------------------------------------------------------------------------------
    Fvoid PnInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void PnInitClass(void)
{
	WNDCLASS wcPen;
	WNDCLASS wcPenPd;
	WNDCLASS wcPenCn;
	WNDCLASS wcPenPc;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_PEN,  &wcPen);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_PENPD,&wcPenPd);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_PENCN,&wcPenCn);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurPen,  hBrNull,  NM_PENPC,&wcPenPc);
	
	RegisterClass(&wcPen);
	RegisterClass(&wcPenPd);
	RegisterClass(&wcPenCn);
	RegisterClass(&wcPenPc);
}

/*------------------------------------------------------------------------------
    Fvoid PnInit(LONG)
    FLONG    FORM ID
    @\Fy
------------------------------------------------------------------------------*/
void PnInit(LONG id)
{
	INT32 i;
	
	pn[id].rgb        = 0x000000;
	pn[id].t          = 0;
	pn[id].flgUpdate  = FALSE;
	pn[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_PEN; i++) {pn[id].tabStops[i] = NULL;}
	
	pn[id].cn.x = 0;
	pn[id].cn.y = 0;
	pn[id].cn.w = 0;
	pn[id].cn.h = 0;
	
	pn[id].pc.x       = 0;
	pn[id].pc.y       = 0;
	pn[id].pc.w       = 0;
	pn[id].pc.h       = 0;
	pn[id].pc.percent = 0;
	ImageInit(&pn[id].pc.tmp);
	
	pn[id].hWnd = NULL;
	for (i = 0; i < 2; i++) {pn[id].hPd[i]   = NULL;}
	for (i = 0; i < 2; i++) {pn[id].hEdit[i] = NULL;}
	pn[id].hRgb = NULL;
	for (i = 0; i < 2; i++) {pn[id].hBtn[i] = NULL;}
	pn[id].hCn  = NULL;
	pn[id].hPc  = NULL;
	
	for (i = 0; i < 2; i++) {pn[id].pCallEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {pn[id].pCallBtn[i]  = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid PnInst(LONG)
    FLONG      FORM ID
    @\FPEN̉
------------------------------------------------------------------------------*/
void PnInst(LONG id)
{
	DWORD stylePn  = WS_OVERLAPPED|WS_CAPTION|WS_MAXIMIZEBOX|WS_THICKFRAME|WS_SYSMENU;
	DWORD stylePd1 = WS_CHILD|WS_VISIBLE;
	DWORD stylePd2 = WS_CHILD;
	DWORD styleEd  = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleRb  = WS_CHILD|WS_VISIBLE|WS_BORDER;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD styleCn  = WS_CHILD|WS_CLIPCHILDREN;
	DWORD stylePc  = WS_CHILD;
	INT32 y[2] = {12,42,};
	INT32 w;
	WCHAR strRgb  [6+1];
	WCHAR strThick[2+1];
	
	_htow(pn[id].rgb, strRgb,   6);
	_itow(pn[id].t,   strThick, 10);
	
	w = SZ_WEDIT2-PADD8*2;
	pn[id].hWnd    = a_CreateWindow(NM_PEN,   TxTl(E_TTLPEN),stylePn, 0,   0,   0, 0,  fm[id].hWnd);
	pn[id].hPd[0]  = a_CreateWindow(NM_PENPD, NULL,          stylePd1,8,   8,   w, 104,pn[id].hWnd);
	pn[id].hPd[1]  = a_CreateWindow(NM_PENPD, NULL,          stylePd2,0,   0,   0, 0,  pn[id].hWnd);
	pn[id].hEdit[0]= a_CreateWindow(L"Edit",  strRgb,        styleEd, 60,  y[0],65,17, pn[id].hPd[0]);
	pn[id].hEdit[1]= a_CreateWindow(L"Edit",  strThick,      styleEd, 60,  y[1],65,17, pn[id].hPd[0]);
	pn[id].hRgb    = a_CreateWindow(NM_RGBBOX,NULL,          styleRb, 131, 13,  16,16, pn[id].hPd[0]);
	pn[id].hBtn[0] = a_CreateWindow(L"Button",TxEd(E_OK),    styleBt, 10,  71,  70,25, pn[id].hPd[0]);
	pn[id].hBtn[1] = a_CreateWindow(L"Button",TxEd(E_CANCEL),styleBt, 90,  71,  70,25, pn[id].hPd[0]);
	pn[id].hCn     = a_CreateWindow(NM_PENCN, NULL,          styleCn, 0,   0,   0, 0,  pn[id].hPd[1]);
	pn[id].hPc     = a_CreateWindow(NM_PENPC, NULL,          stylePc, 0,   0,   0, 0,  pn[id].hCn);
	
	SetWindowLong(pn[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(pn[id].hPd[0],   GWL_USERDATA, 0*100+id);
	SetWindowLong(pn[id].hPd[1],   GWL_USERDATA, 1*100+id);
	SetWindowLong(pn[id].hEdit[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(pn[id].hEdit[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(pn[id].hRgb,     GWL_USERDATA, id);
	SetWindowLong(pn[id].hBtn[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(pn[id].hBtn[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(pn[id].hPc,      GWL_USERDATA, id);
	
	SetWindowLong(pn[id].hWnd,   GWL_WNDPROC, (LONG)PnWndProc);
	SetWindowLong(pn[id].hPd[0], GWL_WNDPROC, (LONG)PnWndProcPd);
	SetWindowLong(pn[id].hPd[1], GWL_WNDPROC, (LONG)PnWndProcPd);
	SetWindowLong(pn[id].hRgb,   GWL_WNDPROC, (LONG)PnWndProcRgb);
	SetWindowLong(pn[id].hPc,    GWL_WNDPROC, (LONG)PnWndProcPc);
	
	E_SETFONT(pn[id].hEdit[0], hFtCourier);
	E_SETFONT(pn[id].hEdit[1], hFtCourier);
	B_SETFONT(pn[id].hBtn[0],  hFtArial14);
	B_SETFONT(pn[id].hBtn[1],  hFtArial14);
	
	E_SETLIMITTEXT(pn[id].hEdit[0], 6);
	E_SETLIMITTEXT(pn[id].hEdit[1], 2);
	
	pn[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(pn[id].hEdit[0], GWL_WNDPROC);
	pn[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(pn[id].hEdit[1], GWL_WNDPROC);
	pn[id].pCallBtn[0]  = (CALLFUNC)GetWindowLong(pn[id].hBtn[0],  GWL_WNDPROC);
	pn[id].pCallBtn[1]  = (CALLFUNC)GetWindowLong(pn[id].hBtn[1],  GWL_WNDPROC);
	SetWindowLong(pn[id].hEdit[0], GWL_WNDPROC, (LONG)PnWndProcEditC);
	SetWindowLong(pn[id].hEdit[1], GWL_WNDPROC, (LONG)PnWndProcEditT);
	SetWindowLong(pn[id].hBtn[0],  GWL_WNDPROC, (LONG)PnWndProcBtnOk);
	SetWindowLong(pn[id].hBtn[1],  GWL_WNDPROC, (LONG)PnWndProcBtnCan);
	
	pn[id].tabStopIdx = 0;
	pn[id].tabStops[0] = pn[id].hEdit[0];
	pn[id].tabStops[1] = pn[id].hRgb;
	pn[id].tabStops[2] = pn[id].hEdit[1];
	pn[id].tabStops[3] = pn[id].hBtn[0];
	pn[id].tabStops[4] = pn[id].hBtn[1];
	
	SetFocus  (pn[id].hEdit[0]);
	EditSelAll(pn[id].hEdit[0]);
}

/*------------------------------------------------------------------------------
    Fvoid PnDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void PnDialog(LONG id)
{
	PnInit(id);
	PnLoad(id);
	PnTmpCreate(id);
	PnInst(id);
	PpPlacement(id, pn[id].hWnd);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = pn[id].hWnd;
	
	ShowWindow(pn[id].hPd[1], 0x1);
	ShowWindow(pn[id].hCn,    0x1);
	ShowWindow(pn[id].hPc,    0x1);
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid PnLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void PnLoad(LONG id)
{
	pn[id].rgb = g_pnRgb;
	pn[id].t   = g_pnThick;
}

/*------------------------------------------------------------------------------
    Fvoid PnStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void PnStore(LONG id)
{
	g_pnRgb   = pn[id].rgb;
	g_pnThick = pn[id].t;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PnWndProc(,,,)
    F-
    ߒlF-
    @\FPENCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PnWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SIZE:           PnSize         (id, wp, lp);  break;
	case WM_GETMINMAXINFO:  PnGetMinMaxInfo(id, wp, lp);  break;
	case WM_SETFOCUS:       PnSetFocus     (id, wp, lp);  break;
	case WM_CLOSE:          PnClose        (id, wp, lp);  break;
	case WM_DESTROY:        PnDestroy      (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PnWndProcPd(,,,)
    F-
    ߒlF-
    @\FPEN PDCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PnWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idP;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:
		if (idP == 0) {
			PnPdCommand(id, wp, lp);
		}
		break;
	case WM_PAINT:
		if (idP == 0) {
			PnPdPaint(id, wp, lp);
		}
		break;
	default:  break;
	}
	
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PnWndProcEditC(,,,)
    F-
    ߒlF-
    @\FPEN EDIT COLORCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PnWndProcEditC(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   PnEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    PnKeyDown    (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (PnEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:  break;
	}
	
	return pn[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PnWndProcEditT(,,,)
    F-
    ߒlF-
    @\FPEN EDIT THICKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PnWndProcEditT(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   PnEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		PnKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (PnEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:  break;
	}
	
	return pn[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PnWndProcRgb(,,,)
    F-
    ߒlF-
    @\FPEN RGB F  Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PnWndProcRgb(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        PnRbPaint      (id, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     PnRbSetFocus   (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    PnRbKillFocus  (id, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  PnRbLButtonDown(id, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    PnRbLButtonUp  (id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      PnKeyDown      (id, wp, lp, hWnd);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PnWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FPEN BTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PnWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  PnEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   PnKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return pn[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PnWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FPEN BTN CANCELCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PnWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  PnEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   PnKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return pn[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PnWndProcPc(,,,)
    F-
    ߒlF-
    @\FPEN PCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PnWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        PnPcPaint      (id, wp, lp);  break;
	case WM_MOUSEMOVE:    PnPcMouseMove  (id, wp, lp);  break;
	case WM_LBUTTONDOWN:  PnPcLButtonDown(id, wp, lp);  break;
	case WM_LBUTTONUP:    PnPcLButtonUp  (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid PnSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPEN WM_SIZECxg
------------------------------------------------------------------------------*/
void PnSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	
	if (fm[id].cntSkipEdit != 0) {fm[id].cntSkipEdit--;  return;}
	
	GetClientRect(pn[id].hWnd, &rc);
	a_SetWindowPos(pn[id].hPd[1], SZ_WEDIT2, PADD8, rc.right-SZ_WEDIT2-PADD8, rc.bottom-PADD8*2);
	
	PnSetPane(id);
	PnView(id);
	
	a_SetWindowPos(pn[id].hPc, pn[id].pc.x, pn[id].pc.y,
							   pn[id].pc.w, pn[id].pc.h);
	
	InvalidateRect(pn[id].hWnd,   NULL, TRUE);
	InvalidateRect(pn[id].hPd[1], NULL, TRUE);
	InvalidateRect(pn[id].hCn,    NULL, TRUE);
	InvalidateRect(pn[id].hPc,    NULL, FALSE);
	UpdateWindow(pn[id].hWnd);
	UpdateWindow(pn[id].hPd[1]);
	UpdateWindow(pn[id].hCn);
	UpdateWindow(pn[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid PnGetMinMaxInfo(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPEN WM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void PnGetMinMaxInfo(LONG id, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	INT32 w;
	INT32 h;
	
	w = SZ_WEDIT2+PADD8*3+GetSystemMetrics(SM_CYSIZEFRAME)*2;
	h = 104      +PADD8*2+GetSystemMetrics(SM_CYSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = w;
	mmi->ptMinTrackSize.y = h;
}

/*------------------------------------------------------------------------------
    Fvoid PnSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPEN WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void PnSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(pn[id].tabStops[pn[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid PnKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPEN WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void PnKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  PnKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    PnKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    PnKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_SP:     PnKeyDownSpace(id, wp, lp, hWnd);  break;
	case KEY_UP:
	case KEY_DW:     PnKeyDownUpDw (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid PnKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPEN [enter]L[Cxg
------------------------------------------------------------------------------*/
void PnKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == pn[id].hBtn[1]) {PnEnterCan(id);}
	else                        {PnEnterOk(id);}
}

/*------------------------------------------------------------------------------
    Fvoid PnKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPEN [esc]L[Cxg
------------------------------------------------------------------------------*/
void PnKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(pn[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PnKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPEN [tab]L[Cxg
------------------------------------------------------------------------------*/
void PnKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (pn[id].tabStopIdx == 0) {pn[id].tabStopIdx = TBSP_PEN-1;}
		else                        {pn[id].tabStopIdx--;}
	}
	else {
		pn[id].tabStopIdx = (pn[id].tabStopIdx + 1) % TBSP_PEN;
	}
	SetFocus(pn[id].tabStops[pn[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid PnKeyDownSpace(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPEN [space]L[Cxg
------------------------------------------------------------------------------*/
void PnKeyDownSpace(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (hWnd == pn[id].hRgb) {return;}
	
	GetWindowText(pn[id].hEdit[0], buffRgb, 6+1);
	RbDialog(id, pn[id].hWnd, pn[id].hEdit[0], pn[id].hRgb, buffRgb);
}

/*------------------------------------------------------------------------------
    Fvoid PnKeyDownUpDw(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPEN [][]L[Cxg
------------------------------------------------------------------------------*/
void PnKeyDownUpDw(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT16 tmp;
	UINT16 comb;
	BOOL shift;
	INT32 step;
	WCHAR text[2+1];
	INT32 val;
	INT32 limL;
	INT32 limH;
	
	comb  = 0x000;
	shift = FALSE;
	tmp = GetKeyState(KEY_CTRL);   if((tmp & 0x80)!=0){comb |= 0x100;}
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){comb |= 0x010;  shift = TRUE;}
	
	if (hWnd != pn[id].hEdit[1]) {return;}
	
	if      (comb == 0x000) {step = 1;}
	else if (comb == 0x100) {step = 10;}
	else if (comb == 0x010) {step = 100;}
	else                    {return;}
	
	GetWindowText(hWnd, text, 2+1);
	val = _wtoi(text);
	
	limL = 0;
	limH = 99;
	
	if (wp == KEY_UP) {val += step;}
	else              {val -= step;}
	
	if (val < limL) {val = limL;}
	if (limH < val) {val = limH;}
	
	_itow(val, text, 10);
	SetWindowText(hWnd, text);
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PnClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPEN WM_CLOSECxg
------------------------------------------------------------------------------*/
void PnClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PnDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPEN WM_DESTROYCxg
------------------------------------------------------------------------------*/
void PnDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	PnTmpDelete(id);
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid PnPdCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPEN WM_COMMANDCxg
------------------------------------------------------------------------------*/
void PnPdCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if      ((HWND)lp == pn[id].hBtn[0]) {PnEnterOk(id);}
	else if ((HWND)lp == pn[id].hBtn[1]) {PnEnterCan(id);}
}

/*------------------------------------------------------------------------------
    Fvoid PnPdPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPEN PD WM_PAINTCxg
------------------------------------------------------------------------------*/
void PnPdPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1;
	INT32 x2, y2;
	
	hdc = BeginPaint(pn[id].hPd[0], &ps);
	GetClientRect(pn[id].hPd[0], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	switch (g_idxLang) {
	case 0:
		x1 = 32;
		x2 = 32;
		break;
	case 1:
		x1 = 26;
		x2 = 26;
		break;
	default: break;
	}
	y1 = 13;
	y2 = 43;
	a_TextOut(hdc, x1, y1, TxEd(E_PNCOLOR));
	a_TextOut(hdc, x2, y2, TxEd(E_PNTHICK));
	
	SelectClipRgn(hdc, NULL);
	EndPaint(pn[id].hPd[0], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid PnEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPEN WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void PnEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_PEN; i++) {
		if (hWnd == pn[id].tabStops[i]) {
			pn[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    FBOOL PnEdChar(LONG, WPARAM, LPARAM, HWND )
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    ߒlFBOOL    -
    @\FPEN WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL PnEdChar(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == pn[id].hEdit[0]) {
		if (((0x30 <= wp) && (wp <= 0x39)) ||  // 0-9
			((0x41 <= wp) && (wp <= 0x46)) ||  // a-f
			((0x61 <= wp) && (wp <= 0x66)))    // A-F
		{
			return TRUE;
		}
	}
	else if (hWnd == pn[id].hEdit[1]) {
		if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	}
	
	switch (wp) {
	case 0x03:  // ctrl+C
	case 0x08:  // back space
	case 0x16:  // ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid PnRbPaint(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPEN RGBBOX WM_PAINTCxg
------------------------------------------------------------------------------*/
void PnRbPaint(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	RbBoxPaint(id, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PnRbSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPEN RGBBOX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void PnRbSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_PEN; i++) {
		if ((HWND)wp == pn[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
	
	PnEdSetFocus(id, wp, lp, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PnRbKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPEN RGBBOX WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void PnRbKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_PEN; i++) {
		if ((HWND)wp == pn[id].tabStops[i]) {
			res = TRUE;
		}
	}
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid PnRbLButtonDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPEN RGBBOX WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void PnRbLButtonDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	pn[id].flgClick = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid PnRbLButtonUp(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPEN RGBBOX WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void PnRbLButtonUp(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (pn[id].flgClick == FALSE) {return;}
	pn[id].flgClick = FALSE;
	SetFocus(hWnd);
	
	GetWindowText(pn[id].hEdit[0], buffRgb, 6+1);
	RbDialog(id, pn[id].hWnd, pn[id].hEdit[0], pn[id].hRgb, buffRgb);
}

/*------------------------------------------------------------------------------
    Fvoid PnPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPEN PC WM_PAINTCxg
------------------------------------------------------------------------------*/
void PnPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1, w1, h1;
	INT32 x2, y2, w2, h2;
	INT32 mode;
	
	hdc = BeginPaint(pn[id].hPc, &ps);
	GetClientRect(pn[id].hPc, &rc);
	SetClipRgn(hdc, &rc);
	
	x2 = 0;
	y2 = 0;
	w2 = pn[id].pc.w;
	h2 = pn[id].pc.h;
	x1 = 0;
	y1 = 0;
	w1 = fm[id].pc[0].img.w;
	h1 = fm[id].pc[0].img.h;
	
	if (pn[id].pc.percent < 10000) {mode = HALFTONE;}
	else                              {mode = COLORONCOLOR;}
	
	SetStretchBltMode(hdc, mode);
	StretchBlt(hdc,                  x2, y2, w2, h2,
			   pn[id].pc.tmp.hdc, x1, y1, w1, h1, SRCCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w2;
	rc.bottom = h2;
	FrameRect(hdc, &rc, hBrGray);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(pn[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid PnPcMouseMove(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPEN PC WM_MOUSEMOVECxg
------------------------------------------------------------------------------*/
void PnPcMouseMove(LONG id, WPARAM wp, LPARAM lp)
{
	INT16 x16, y16;
	INT32 x, y;
	
	if ((wp & MK_LBUTTON) == 0) {return;}
	if (pn[id].pc.flgClick == FALSE) {return;}
	
	x16 = LOWORD(lp);
	y16 = HIWORD(lp);
	TryZeroDivision(pn[id].pc.w);
	TryZeroDivision(pn[id].pc.h);
	x = (double)(x16 * fm[id].pc[0].img.w) / pn[id].pc.w;
	y = (double)(y16 * fm[id].pc[0].img.h) / pn[id].pc.h;
	
	LineTo(pn[id].pc.tmp.hdc, x, y);
	InvalidateRect(pn[id].hPc, NULL, FALSE);
	UpdateWindow  (pn[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid PnPcLButtonDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPEN PC WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void PnPcLButtonDown(LONG id, WPARAM wp, LPARAM lp)
{
	INT16 x16, y16;
	INT32 x, y;
	HDC hdc;
	WCHAR buffRgb[6+1];
	WCHAR buffT  [2+1];
	INT32 rgb;
	INT32 t;
	RECT rc;
	
	pn[id].pc.flgClick = TRUE;
	SetCapture(pn[id].hPc);
	
	x16 = LOWORD(lp);
	y16 = HIWORD(lp);
	TryZeroDivision(pn[id].pc.w);
	TryZeroDivision(pn[id].pc.h);
	x = (double)(x16 * fm[id].pc[0].img.w) / pn[id].pc.w;
	y = (double)(y16 * fm[id].pc[0].img.h) / pn[id].pc.h;
	hdc = pn[id].pc.tmp.hdc;
	
	GetWindowText(pn[id].hEdit[0], buffRgb, 6+1);
	GetWindowText(pn[id].hEdit[1], buffT,   2+1);
	rgb = _wtoh(buffRgb, 6);
	rgb = _htor(rgb);
	t = _wtoi(buffT);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = fm[id].pc[0].img.w;
	rc.bottom = fm[id].pc[0].img.h;
	SetClipRgn(hdc, &rc);
	
	pn[id].hPn  = CreatePen(PS_SOLID, t, rgb);
	pn[id].hOld = (HPEN)SelectObject(hdc, pn[id].hPn);
	
	if ((t == 0) || (t == 1)) {SetPixel(hdc, x, y, rgb);}
	MoveToEx(hdc, x, y, NULL);
	LineTo  (hdc, x, y);
	InvalidateRect(pn[id].hPc, NULL, FALSE);
	UpdateWindow  (pn[id].hPc);
	
	pn[id].flgUpdate = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid PnPcLButtonUp(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPEN PC WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void PnPcLButtonUp(LONG id, WPARAM wp, LPARAM lp)
{
	SelectObject(pn[id].pc.tmp.hdc, pn[id].hOld);
	DeleteObject(pn[id].hPn);
	
	SelectClipRgn(pn[id].pc.tmp.hdc, NULL);
	ReleaseCapture();
	pn[id].pc.flgClick = FALSE;
}

/*------------------------------------------------------------------------------
    Fvoid PnEnterOk(LONG id)
    FLONG    FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void PnEnterOk(LONG id)
{
	WCHAR buffRgb[6+1];
	WCHAR buffT  [2+1];
	
	if (pn[id].flgUpdate == FALSE) {return;}
	
	memcpy(fm[id].pc[0].img.pB, pn[id].pc.tmp.pB, fm[id].pc[0].img.w*fm[id].pc[0].img.h*4);
	LiViewDelete(id, 0);
	
	InvalidateRect(fm[id].hPict[0],  NULL, TRUE);
	UpdateWindow(fm[id].hPict[0]);
	
	fm[id].flgPen = TRUE;
	SetFormText(id);
	MnFlushFile(id);
	
	GetWindowText(pn[id].hEdit[0], buffRgb, 6+1);
	GetWindowText(pn[id].hEdit[1], buffT,   2+1);
	
	pn[id].rgb = _wtoh(buffRgb, 6);
	pn[id].t   = _wtoi(buffT);
	
	PnStore(id);
	CLOSE(pn[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PnEnterCan(LONG id)
    FLONG    FORM ID
    @\F[CANCEL]{^s
------------------------------------------------------------------------------*/
void PnEnterCan(LONG id)
{
	CLOSE(pn[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PnTmpCreate(LONG)
    FLONG     FORM ID
    @\Fy ꎞC[W쐬
------------------------------------------------------------------------------*/
void PnTmpCreate(LONG id)
{
	INT32 w;
	INT32 h;
	
	w = fm[id].pc[0].img.w;
	h = fm[id].pc[0].img.h;
	ImageCreate(&pn[id].pc.tmp, w, h);
	
	memcpy(pn[id].pc.tmp.pB, fm[id].pc[0].img.pB, w * h * 4);
}

/*------------------------------------------------------------------------------
    Fvoid PnTmpDelete(LONG)
    FLONG     FORM ID
    @\Fy ꎞC[W폜
------------------------------------------------------------------------------*/
void PnTmpDelete(LONG id)
{
	DeleteDC    (pn[id].pc.tmp.hdc);
	DeleteObject(pn[id].pc.tmp.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid PnView(LONG)
    FLONG    FORM ID
    @\Fy̕ҏW\p
------------------------------------------------------------------------------*/
void PnView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	
	if (IsBit(fm[id].pc[0].img.stat, BIT_NONE|BIT_FAILURE)) {return;}
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	gainW = (double)pn[id].cn.w / fm[id].pc[0].img.w;
	gainH = (double)pn[id].cn.h / fm[id].pc[0].img.h;
	
	if (CmpGain(gainW, gainH) == TRUE) {
		limW = TRUE;
		limH = TRUE;
	}
	else {
		if (gainW < gainH) {
			gainH = gainW;
			limW = TRUE;
		}
		else {
			gainW = gainH;
			limH = TRUE;
		}
	}
	
	x = (double)pn[id].cn.w / 2 - (double)fm[id].pc[0].img.w * gainW / 2;
	y = (double)pn[id].cn.h / 2 - (double)fm[id].pc[0].img.h * gainH / 2;
	w = (double)fm[id].pc[0].img.w * gainW;
	h = (double)fm[id].pc[0].img.h * gainH;
	
	if (limW == TRUE) {x = 0;  w = pn[id].cn.w;}
	if (limH == TRUE) {y = 0;  h = pn[id].cn.h;}
	
	if (limW == TRUE) {TryZeroDivision(fm[id].pc[0].img.w);  pn[id].pc.percent = ((double)w / fm[id].pc[0].img.w) * 10000;}
	else              {TryZeroDivision(fm[id].pc[0].img.h);  pn[id].pc.percent = ((double)h / fm[id].pc[0].img.h) * 10000;}
	
	pn[id].pc.x = x;
	pn[id].pc.y = y;
	if (w <= 0) {pn[id].pc.w = 1;}
	else        {pn[id].pc.w = w;}
	if (h <= 0) {pn[id].pc.h = 1;}
	else        {pn[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    Fvoid PnSetPane(LONG)
    FLONG    FORM ID
    @\Fy̕\̘g\
------------------------------------------------------------------------------*/
void PnSetPane(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(pn[id].hPd[1], &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	a_SetWindowPos(pn[id].hCn, PADD8, PADD8, w-PADD8*2, h-PADD8*2);
	
	GetClientRect(pn[id].hCn, &rc);
	pn[id].cn.x = rc.left;
	pn[id].cn.y = rc.top;
	pn[id].cn.w = rc.right - rc.left;
	pn[id].cn.h = rc.bottom - rc.top;
}
