/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define PP_CPP
#include "../common.h"
//  PasteWithParamFp[^[œ\t

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 x;
	INT32 y;
	BOOL alpha;
	INT32 chroma;
	INT32 percent;
	BOOL keep;
	INT32 back;
	BOOL flgClick;
	BOOL flgUpdate;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_PAPARA];
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;} cn;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			UINT32 percent;
			st_Image tmp;
			st_Image clp;} pc;
	
	HWND hWnd;
	HWND hPd[2];
	HWND hEdit[5];
	HWND hChk[2];
	HWND hRgb[2];
	HWND hBtn[2];
	HWND hCn;
	HWND hPc;
	
	LRESULT (CALLBACK *pCallEdit[5]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallChk[2])  (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn[2])  (HWND,UINT,WPARAM,LPARAM);
} pp[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void PpInitClass(void);
void PpInit(LONG);
void PpInst(LONG);
void PpDialog(LONG);
void PpLoad(LONG);
void PpStore(LONG);
LRESULT CALLBACK PpWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcEditX (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcEditY (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcEditC (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcEditP (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcEditB (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcChkA  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcChkK  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcRgbC  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcRgbB  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcPd    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK PpWndProcPc    (HWND, UINT, WPARAM, LPARAM);
void PpSize         (LONG, WPARAM, LPARAM);
void PpGetMinMaxInfo(LONG, WPARAM, LPARAM);
void PpSetFocus     (LONG, WPARAM, LPARAM);
void PpKeyDown      (LONG, WPARAM, LPARAM, HWND);
void PpKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void PpKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void PpKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void PpKeyDownSpace (LONG, WPARAM, LPARAM, HWND);
void PpKeyDownF5    (LONG, WPARAM, LPARAM, HWND);
void PpKeyDownUpDw  (LONG, WPARAM, LPARAM, HWND);
void PpClose        (LONG, WPARAM, LPARAM);
void PpDestroy      (LONG, WPARAM, LPARAM);
void PpEdSetFocus   (LONG, WPARAM, LPARAM, HWND);
void PpEdKillFocus  (LONG, WPARAM, LPARAM, HWND);
BOOL PpEdChar       (LONG, WPARAM, LPARAM, HWND);
void PpChSetCheck   (LONG, WPARAM, LPARAM);
void PpRbPaint      (LONG, LONG, WPARAM, LPARAM, HWND);
void PpRbSetFocus   (LONG, LONG, WPARAM, LPARAM, HWND);
void PpRbKillFocus  (LONG, LONG, WPARAM, LPARAM, HWND);
void PpRbLButtonDown(LONG, LONG, WPARAM, LPARAM, HWND);
void PpRbLButtonUp  (LONG, LONG, WPARAM, LPARAM, HWND);
void PpPdCommand    (LONG, WPARAM, LPARAM);
void PpPdPaint      (LONG, WPARAM, LPARAM);
void PpPcPaint      (LONG, WPARAM, LPARAM);
void PpPcLButtonDown(LONG, WPARAM, LPARAM);
void PpEnterOk(LONG);
void PpEnterCan(LONG);
void PpUpdate(LONG);
void PpTmpWh(LONG, INT32 *, INT32 *, INT32, INT32, INT32);
void PpTmpCreate(LONG, INT32, INT32, INT32);
void PpTmpDraw(LONG);
void PpTmpDelete(LONG);
void PpClpCreate(LONG);
void PpClpDelete(LONG);
void PpView(LONG);
void PpSetPane(LONG);

/*------------------------------------------------------------------------------
    Fvoid PpInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void PpInitClass(void)
{
	WNDCLASS wcPapara;
	WNDCLASS wcPaparaPd;
	WNDCLASS wcPaparaCn;
	WNDCLASS wcPaparaPc;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_PAPARA,  &wcPapara);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_PAPARAPD,&wcPaparaPd);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_PAPARACN,&wcPaparaCn);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrNull,  NM_PAPARAPC,&wcPaparaPc);
	
	RegisterClass(&wcPapara);
	RegisterClass(&wcPaparaPd);
	RegisterClass(&wcPaparaCn);
	RegisterClass(&wcPaparaPc);
}

/*------------------------------------------------------------------------------
    Fvoid PpInit(LONG)
    FLONG    FORM ID
    @\Fw\t
------------------------------------------------------------------------------*/
void PpInit(LONG id)
{
	INT32 i;
	
	pp[id].x       = 0;
	pp[id].y       = 0;
	pp[id].alpha   = FALSE;
	pp[id].chroma  = 0x000000;
	pp[id].percent = 0;
	pp[id].keep    = FALSE;
	pp[id].back    = 0x000000;
	
	pp[id].flgClick   = FALSE;
	pp[id].flgUpdate  = FALSE;
	pp[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_PAPARA; i++) {pp[id].tabStops[i] = NULL;}
	
	pp[id].cn.x = 0;
	pp[id].cn.y = 0;
	pp[id].cn.w = 0;
	pp[id].cn.h = 0;
	
	pp[id].pc.x       = 0;
	pp[id].pc.y       = 0;
	pp[id].pc.w       = 0;
	pp[id].pc.h       = 0;
	pp[id].pc.percent = 0;
	ImageInit(&pp[id].pc.tmp);
	ImageInit(&pp[id].pc.clp);
	
	pp[id].hWnd = NULL;
	for (i = 0; i < 5; i++) {pp[id].hEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {pp[id].hChk[i]  = NULL;}
	for (i = 0; i < 2; i++) {pp[id].hRgb[i]  = NULL;}
	for (i = 0; i < 2; i++) {pp[id].hBtn[i]  = NULL;}
	for (i = 0; i < 2; i++) {pp[id].hPd[i]   = NULL;}
	pp[id].hCn  = NULL;
	pp[id].hPc  = NULL;
	
	for (i = 0; i < 5; i++) {pp[id].pCallEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {pp[id].pCallChk[i]  = NULL;}
	for (i = 0; i < 2; i++) {pp[id].pCallBtn[i]  = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid PpInst(LONG)
    FLONG      FORM ID
    @\FPAPARẢ
------------------------------------------------------------------------------*/
void PpInst(LONG id)
{
	DWORD stylePp  = WS_OVERLAPPED|WS_CAPTION|WS_MAXIMIZEBOX|WS_THICKFRAME|WS_SYSMENU;
	DWORD styleEd  = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleRb  = WS_CHILD|WS_VISIBLE|WS_BORDER;
	DWORD styleCk  = WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD stylePd1 = WS_CHILD|WS_VISIBLE;
	DWORD stylePd2 = WS_CHILD;
	DWORD styleCn  = WS_CHILD|WS_CLIPCHILDREN;
	DWORD stylePc  = WS_CHILD;
	INT32 w;
	INT32 x1, x2;
	INT32 w1, w2;
	WCHAR strChroma [6+1];
	WCHAR strPercent[6+1];
	WCHAR strBack   [6+1];
	WPARAM wp[2];
	
	pp[id].flgUpdate = TRUE;
	pp[id].percent   = 1000;
	
	_htow(pp[id].chroma,  strChroma,  6);
	_htow(pp[id].back,    strBack,    6);
	_itow(pp[id].percent, strPercent, 10);
	
	switch (g_idxLang) {
	case 0:  x1 = 70;  w1 = 70;   x2 = 60;  w2 = 70;   break;
	case 1:  x1 = 33;  w1 = 100;  x2 = 33;  w2 = 100;  break;
	default: break;
	}
	
	w = SZ_WEDIT2-PADD8*2;
	pp[id].hWnd     = a_CreateWindow(NM_PAPARA,  TxTl(E_TTLPPR), stylePp, 0,  0,  0, 0,  fm[id].hWnd);
	pp[id].hPd[0]   = a_CreateWindow(NM_PAPARAPD,NULL,           stylePd1,8,  8,  w, 254,pp[id].hWnd);
	pp[id].hPd[1]   = a_CreateWindow(NM_PAPARAPD,NULL,           stylePd2,0,  0,  0, 0,  pp[id].hWnd);
	pp[id].hEdit[0] = a_CreateWindow(L"Edit",    L"0",           styleEd, 61, 12, 65,17, pp[id].hPd[0]);
	pp[id].hEdit[1] = a_CreateWindow(L"Edit",    L"0",           styleEd, 61, 42, 65,17, pp[id].hPd[0]);
	pp[id].hEdit[2] = a_CreateWindow(L"Edit",    strChroma,      styleEd, 61, 102,65,17, pp[id].hPd[0]);
	pp[id].hEdit[3] = a_CreateWindow(L"Edit",    strPercent,     styleEd, 61, 132,65,17, pp[id].hPd[0]);
	pp[id].hEdit[4] = a_CreateWindow(L"Edit",    strBack,        styleEd, 61, 192,65,17, pp[id].hPd[0]);
	pp[id].hChk[0]  = a_CreateWindow(L"Button",  TxEd(E_PPTRANS),styleCk, x1, 68, w1,25, pp[id].hPd[0]);
	pp[id].hChk[1]  = a_CreateWindow(L"Button",  TxEd(E_PPKEEP), styleCk, x2, 158,w2,25, pp[id].hPd[0]);
	pp[id].hRgb[0]  = a_CreateWindow(NM_RGBBOX,  NULL,           styleRb, 132,103,16,16, pp[id].hPd[0]);
	pp[id].hRgb[1]  = a_CreateWindow(NM_RGBBOX,  NULL,           styleRb, 132,193,16,16, pp[id].hPd[0]);
	pp[id].hBtn[0]  = a_CreateWindow(L"Button",  TxEd(E_OK),     styleBt, 10, 221,70,25, pp[id].hPd[0]);
	pp[id].hBtn[1]  = a_CreateWindow(L"Button",  TxEd(E_CANCEL), styleBt, 90, 221,70,25, pp[id].hPd[0]);
	pp[id].hCn      = a_CreateWindow(NM_PAPARACN,NULL,           styleCn, 0,  0,  0, 0,  pp[id].hPd[1]);
	pp[id].hPc      = a_CreateWindow(NM_PAPARAPC,NULL,           stylePc, 0,  0,  0, 0,  pp[id].hCn);
	
	SetWindowLong(pp[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(pp[id].hPd[0],   GWL_USERDATA, 0*100+id);
	SetWindowLong(pp[id].hPd[1],   GWL_USERDATA, 1*100+id);
	SetWindowLong(pp[id].hEdit[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(pp[id].hEdit[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(pp[id].hEdit[2], GWL_USERDATA, 2*100+id);
	SetWindowLong(pp[id].hEdit[3], GWL_USERDATA, 3*100+id);
	SetWindowLong(pp[id].hEdit[4], GWL_USERDATA, 4*100+id);
	SetWindowLong(pp[id].hRgb[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(pp[id].hRgb[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(pp[id].hChk[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(pp[id].hChk[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(pp[id].hBtn[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(pp[id].hBtn[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(pp[id].hPc,      GWL_USERDATA, id);
	
	SetWindowLong(pp[id].hPd[0],  GWL_WNDPROC, (LONG)PpWndProcPd);
	SetWindowLong(pp[id].hPd[1],  GWL_WNDPROC, (LONG)PpWndProcPd);
	SetWindowLong(pp[id].hWnd,    GWL_WNDPROC, (LONG)PpWndProc);
	SetWindowLong(pp[id].hRgb[0], GWL_WNDPROC, (LONG)PpWndProcRgbC);
	SetWindowLong(pp[id].hRgb[1], GWL_WNDPROC, (LONG)PpWndProcRgbB);
	SetWindowLong(pp[id].hPc,     GWL_WNDPROC, (LONG)PpWndProcPc);
	
	E_SETLIMITTEXT(pp[id].hEdit[0], 4);
	E_SETLIMITTEXT(pp[id].hEdit[1], 4);
	E_SETLIMITTEXT(pp[id].hEdit[2], 6);
	E_SETLIMITTEXT(pp[id].hEdit[3], 4);
	E_SETLIMITTEXT(pp[id].hEdit[4], 6);
	
	E_SETFONT(pp[id].hEdit[0], hFtCourier);
	E_SETFONT(pp[id].hEdit[1], hFtCourier);
	E_SETFONT(pp[id].hEdit[2], hFtCourier);
	E_SETFONT(pp[id].hEdit[3], hFtCourier);
	E_SETFONT(pp[id].hEdit[4], hFtCourier);
	B_SETFONT(pp[id].hChk[0],  hFtArial14);
	B_SETFONT(pp[id].hChk[1],  hFtArial14);
	B_SETFONT(pp[id].hBtn[0],  hFtArial14);
	B_SETFONT(pp[id].hBtn[1],  hFtArial14);
	
	if (pp[id].alpha) {wp[0] = BST_CHECKED;} else {wp[0] = BST_UNCHECKED;}
	if (pp[id].keep)  {wp[1] = BST_CHECKED;} else {wp[1] = BST_UNCHECKED;}
	B_SETCHECK(pp[id].hChk[0], wp[0]);
	B_SETCHECK(pp[id].hChk[1], wp[1]);
	
	pp[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(pp[id].hEdit[0], GWL_WNDPROC);
	pp[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(pp[id].hEdit[1], GWL_WNDPROC);
	pp[id].pCallEdit[2] = (CALLFUNC)GetWindowLong(pp[id].hEdit[2], GWL_WNDPROC);
	pp[id].pCallEdit[3] = (CALLFUNC)GetWindowLong(pp[id].hEdit[3], GWL_WNDPROC);
	pp[id].pCallEdit[4] = (CALLFUNC)GetWindowLong(pp[id].hEdit[4], GWL_WNDPROC);
	pp[id].pCallChk[0]  = (CALLFUNC)GetWindowLong(pp[id].hChk[0],  GWL_WNDPROC);
	pp[id].pCallChk[1]  = (CALLFUNC)GetWindowLong(pp[id].hChk[1],  GWL_WNDPROC);
	pp[id].pCallBtn[0]  = (CALLFUNC)GetWindowLong(pp[id].hBtn[0],  GWL_WNDPROC);
	pp[id].pCallBtn[1]  = (CALLFUNC)GetWindowLong(pp[id].hBtn[1],  GWL_WNDPROC);
	SetWindowLong(pp[id].hEdit[0], GWL_WNDPROC, (LONG)PpWndProcEditX);
	SetWindowLong(pp[id].hEdit[1], GWL_WNDPROC, (LONG)PpWndProcEditY);
	SetWindowLong(pp[id].hEdit[2], GWL_WNDPROC, (LONG)PpWndProcEditC);
	SetWindowLong(pp[id].hEdit[3], GWL_WNDPROC, (LONG)PpWndProcEditP);
	SetWindowLong(pp[id].hEdit[4], GWL_WNDPROC, (LONG)PpWndProcEditB);
	SetWindowLong(pp[id].hChk[0],  GWL_WNDPROC, (LONG)PpWndProcChkA);
	SetWindowLong(pp[id].hChk[1],  GWL_WNDPROC, (LONG)PpWndProcChkK);
	SetWindowLong(pp[id].hBtn[0],  GWL_WNDPROC, (LONG)PpWndProcBtnOk);
	SetWindowLong(pp[id].hBtn[1],  GWL_WNDPROC, (LONG)PpWndProcBtnCan);
	
	pp[id].tabStopIdx = 0;
	pp[id].tabStops[0]  = pp[id].hEdit[0];
	pp[id].tabStops[1]  = pp[id].hEdit[1];
	pp[id].tabStops[2]  = pp[id].hChk[0];
	pp[id].tabStops[3]  = pp[id].hEdit[2];
	pp[id].tabStops[4]  = pp[id].hRgb[0];
	pp[id].tabStops[5]  = pp[id].hEdit[3];
	pp[id].tabStops[6]  = pp[id].hChk[1];
	pp[id].tabStops[7]  = pp[id].hEdit[4];
	pp[id].tabStops[8]  = pp[id].hRgb[1];
	pp[id].tabStops[9]  = pp[id].hBtn[0];
	pp[id].tabStops[10] = pp[id].hBtn[1];
	
	SetFocus  (pp[id].hEdit[0]);
	EditSelAll(pp[id].hEdit[0]);
}

/*------------------------------------------------------------------------------
    Fvoid PpDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void PpDialog(LONG id)
{
	INT32 w, h;
	
	PpInit(id);
	PpLoad(id);
	
	PpClpCreate(id);
	w = fm[id].pc[0].img.w;
	h = fm[id].pc[0].img.h;
	if (!pp[id].keep) {PpTmpWh(id, &w, &h, 0, 0, 1000);}
	PpTmpCreate(id, w, h, pp[id].back);
	
	PpInst(id);
	PpPlacement(id, pp[id].hWnd);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = pp[id].hWnd;
	
	ShowWindow(pp[id].hPd[1], 0x1);
	ShowWindow(pp[id].hCn,    0x1);
	ShowWindow(pp[id].hPc,    0x1);
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid PpLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void PpLoad(LONG id)
{
	pp[id].alpha  = g_ppAlpha;
	pp[id].chroma = g_ppChroma;
	pp[id].keep   = g_ppKeep;
	pp[id].back   = g_ppBack;
}

/*------------------------------------------------------------------------------
    Fvoid PpStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void PpStore(LONG id)
{
	g_ppAlpha  = pp[id].alpha;
	g_ppChroma = pp[id].chroma;
	g_ppKeep   = pp[id].keep;
	g_ppBack   = pp[id].back;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProc(,,,)
    F-
    ߒlF-
    @\FPAPARACxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_USER:  PpUpdate(id);  break;  // WMU_RGBEND
	case WM_SIZE:           PpSize         (id, wp, lp);  break;
	case WM_GETMINMAXINFO:  PpGetMinMaxInfo(id, wp, lp);  break;
	case WM_SETFOCUS:       PpSetFocus     (id, wp, lp);  break;
	case WM_CLOSE:          PpClose        (id, wp, lp);  break;
	case WM_DESTROY:        PpDestroy      (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcEditX(,,,)
    F-
    ߒlF-
    @\FPAPARA EDIT XCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcEditX(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   PpEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  PpEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		PpKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (PpEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return pp[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcEditY(,,,)
    F-
    ߒlF-
    @\FPAPARA EDIT YCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcEditY(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   PpEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  PpEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		PpKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (PpEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return pp[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcEditC(,,,)
    F-
    ߒlF-
    @\FPAPARA EDIT N}L[Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcEditC(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   PpEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  PpEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    PpKeyDown    (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (PpEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return pp[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcEditP(,,,)
    F-
    ߒlF-
    @\FPAPARA EDIT {Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcEditP(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   PpEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  PpEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    PpKeyDown    (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (PpEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return pp[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcEditB(,,,)
    F-
    ߒlF-
    @\FPAPARA EDIT wiCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcEditB(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   PpEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  PpEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		PpKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (PpEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return pp[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcChkA(,,,)
    F-
    ߒlF-
    @\FPAPARA CHK ߃Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcChkA(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  PpEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   PpKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	
	res = pp[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  PpChSetCheck(id, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcChkK(,,,)
    F-
    ߒlF-
    @\FPAPARA CHK TCYێCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcChkK(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  PpEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   PpKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	
	res = pp[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  PpChSetCheck(id, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcRgbC(,,,)
    F-
    ߒlF-
    @\FPAPARA RGB N}Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcRgbC(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idR;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idR = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:        PpRbPaint      (id, idR, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     PpRbSetFocus   (id, idR, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    PpRbKillFocus  (id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  PpRbLButtonDown(id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    PpRbLButtonUp  (id, idR, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      PpKeyDown      (id, wp, lp, hWnd);       break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcRgbB(,,,)
    F-
    ߒlF-
    @\FPAPARA RGB wiCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcRgbB(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idR;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idR = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:        PpRbPaint      (id, idR, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     PpRbSetFocus   (id, idR, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    PpRbKillFocus  (id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  PpRbLButtonDown(id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    PpRbLButtonUp  (id, idR, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      PpKeyDown      (id, wp, lp, hWnd);       break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FPAPARA BTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  PpEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   PpKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return pp[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FPAPARA BTN CANCELCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  PpEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   PpKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return pp[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcPd(,,,)
    F-
    ߒlF-
    @\FPAPARA PDCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idP;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:
		if (idP == 0) {
			PpPdCommand(id, wp, lp);
		}
		break;
	case WM_PAINT:
		if (idP == 0) {
			PpPdPaint(id, wp, lp);
		}
		break;
	case WM_CTLCOLORSTATIC:
		if ((HWND)lp == pp[id].hChk[0]) {return (LRESULT)hBrWhite;}
		if ((HWND)lp == pp[id].hChk[1]) {return (LRESULT)hBrWhite;}
		break;
	default:  break;
	}
	
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK PpWndProcPc(,,,)
    F-
    ߒlF-
    @\FPAPARA PCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK PpWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        PpPcPaint      (id, wp, lp);  break;
	case WM_LBUTTONDOWN:  PpPcLButtonDown(id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid PpSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPAPARA WM_SIZECxg
------------------------------------------------------------------------------*/
void PpSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	
	if (fm[id].cntSkipEdit != 0) {fm[id].cntSkipEdit--;  return;}
	
	GetClientRect(pp[id].hWnd, &rc);
	a_SetWindowPos(pp[id].hPd[1], SZ_WEDIT2, PADD8, rc.right-SZ_WEDIT2-PADD8, rc.bottom-PADD8*2);
	
	PpSetPane(id);
	PpView(id);
	
	a_SetWindowPos(pp[id].hPc, pp[id].pc.x, pp[id].pc.y,
									 pp[id].pc.w, pp[id].pc.h);
	
	InvalidateRect(pp[id].hWnd,      NULL, TRUE);
	InvalidateRect(pp[id].hPd[1], NULL, TRUE);
	InvalidateRect(pp[id].hCn,    NULL, TRUE);
	InvalidateRect(pp[id].hPc,    NULL, FALSE);
	UpdateWindow(pp[id].hWnd);
	UpdateWindow(pp[id].hPd[1]);
	UpdateWindow(pp[id].hCn);
	UpdateWindow(pp[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid PpGetMinMaxInfo(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPAPARA WM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void PpGetMinMaxInfo(LONG id, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	INT32 w;
	INT32 h;
	
	w = SZ_WEDIT2+PADD8*3+GetSystemMetrics(SM_CYSIZEFRAME)*2;
	h = 254      +PADD8*2+GetSystemMetrics(SM_CYSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = w;
	mmi->ptMinTrackSize.y = h;
}

/*------------------------------------------------------------------------------
    Fvoid PpSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPAPARA WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void PpSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(pp[id].tabStops[pp[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid PpKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void PpKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  PpKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    PpKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    PpKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_SP:     PpKeyDownSpace(id, wp, lp, hWnd);  break;
	case KEY_F5:     PpKeyDownF5   (id, wp, lp, hWnd);  break;
	case KEY_UP:
	case KEY_DW:     PpKeyDownUpDw (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid PpKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA [enter]L[Cxg
------------------------------------------------------------------------------*/
void PpKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == pp[id].hBtn[1]) {PpEnterCan(id);}
	else                        {PpEnterOk(id);}
}

/*------------------------------------------------------------------------------
    Fvoid PpKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA [esc]L[Cxg
------------------------------------------------------------------------------*/
void PpKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(pp[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PpKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA [tab]L[Cxg
------------------------------------------------------------------------------*/
void PpKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (pp[id].tabStopIdx == 0) {pp[id].tabStopIdx = TBSP_PAPARA-1;}
		else                        {pp[id].tabStopIdx--;}
	}
	else {
		pp[id].tabStopIdx = (pp[id].tabStopIdx + 1) % TBSP_PAPARA;
	}
	SetFocus(pp[id].tabStops[pp[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid PpKeyDownSpace(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA [space]L[Cxg
------------------------------------------------------------------------------*/
void PpKeyDownSpace(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffChroma[6+1];
	WCHAR buffRgb   [6+1];
	
	if (hWnd == pp[id].hRgb[0]) {
		GetWindowText(pp[id].hEdit[2], buffChroma, 6+1);
		RbDialog(id, pp[id].hWnd, pp[id].hEdit[2], pp[id].hRgb[0], buffRgb);
	}
	else if (hWnd == pp[id].hRgb[1]) {
		GetWindowText(pp[id].hEdit[4], buffRgb, 6+1);
		RbDialog(id, pp[id].hWnd, pp[id].hEdit[4], pp[id].hRgb[1], buffRgb);
	}
}

/*------------------------------------------------------------------------------
    Fvoid PpKeyDownF5(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA [F5]L[Cxg
------------------------------------------------------------------------------*/
void PpKeyDownF5(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	PpUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid PpKeyDownUpDw(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA [tab]L[Cxg
------------------------------------------------------------------------------*/
void PpKeyDownUpDw(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT16 tmp;
	UINT16 comb;
	BOOL shift;
	INT32 step;
	WCHAR text[4+1];
	INT32 val;
	INT32 limL;
	INT32 limH;
	
	comb  = 0x000;
	shift = FALSE;
	tmp = GetKeyState(KEY_CTRL);   if((tmp & 0x80)!=0){comb |= 0x100;}
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){comb |= 0x010;  shift = TRUE;}
	
	if ((hWnd != pp[id].hEdit[0]) &&
		(hWnd != pp[id].hEdit[1]) &&
		(hWnd != pp[id].hEdit[3]))
	{
		return;
	}
	
	if      (comb == 0x000) {step = 1;}
	else if (comb == 0x100) {step = 10;}
	else if (comb == 0x010) {step = 100;}
	else                    {return;}
	
	GetWindowText(hWnd, text, 4+1);
	val = _wtoi(text);
	
	if (hWnd == pp[id].hEdit[3]) {
		limL = 0;
		limH = 9999;
	}
	else {
		limL = -999;
		limH = 9999;
	}
	
	if (wp == KEY_UP) {val += step;}
	else              {val -= step;}
	
	if (val < limL) {val = limL;}
	if (limH < val) {val = limH;}
	
	_itow(val, text, 10);
	SetWindowText(hWnd, text);
	EditSelAll(hWnd);
	
	PpUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid PpClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPAPARA WM_CLOSECxg
------------------------------------------------------------------------------*/
void PpClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PpDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPAPARA WM_DESTROYCxg
------------------------------------------------------------------------------*/
void PpDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	PpTmpDelete(id);
	PpClpDelete(id);
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid PpPdCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPAPARA WM_COMMANDCxg
------------------------------------------------------------------------------*/
void PpPdCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if      ((HWND)lp == pp[id].hBtn[0]) {PpEnterOk(id);}
	else if ((HWND)lp == pp[id].hBtn[1]) {PpEnterCan(id);}
}

/*------------------------------------------------------------------------------
    Fvoid PpPdPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPAPARA PD WM_PAINTCxg
------------------------------------------------------------------------------*/
void PpPdPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1;
	INT32 x2, y2;
	INT32 x3, y3;
	
	hdc = BeginPaint(pp[id].hPd[0], &ps);
	GetClientRect(pp[id].hPd[0], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	a_TextOut(hdc, 34, 13,  L"X");
	a_TextOut(hdc, 34, 43,  L"Y");
	
	switch (g_idxLang) {
	case 0:
		x1 = 22;
		x2 = 22;
		x3 = 22;
		break;
	case 1:
		x1 = 16;
		x2 = 16;
		x3 = 21;
		break;
	default: break;
	}
	y1 = 103;
	y2 = 133;
	y3 = 193;
	a_TextOut(hdc, x1, y1, TxEd(E_PPCHROMA));
	a_TextOut(hdc, x2, y2, TxEd(E_PPPERCENT));
	a_TextOut(hdc, x3, y3, TxEd(E_PPBACK));
	
	SelectClipRgn(hdc, NULL);
	EndPaint(pp[id].hPd[0], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid PpEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void PpEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_PAPARA; i++) {
		if (hWnd == pp[id].tabStops[i]) {
			pp[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PpEdKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void PpEdKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_PAPARA; i++) {
		if ((HWND)wp == pp[id].tabStops[i]) {
			PpUpdate(id);
			break;
		}
	}
}

/*------------------------------------------------------------------------------
    FBOOL PpEdChar(LONG, WPARAM, LPARAM, HWND )
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    ߒlFBOOL    -
    @\FPAPARA WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL PpEdChar(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if ((hWnd == pp[id].hEdit[0]) ||
		(hWnd == pp[id].hEdit[1]))
	{
		if (wp == 0x2D) {return TRUE;}	// -
		
		if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	}
	else if ((hWnd == pp[id].hEdit[2]) ||
			 (hWnd == pp[id].hEdit[4]))
	{
		if (((0x30 <= wp) && (wp <= 0x39)) ||  // 0-9
			((0x41 <= wp) && (wp <= 0x46)) ||  // a-f
			((0x61 <= wp) && (wp <= 0x66)))    // A-F
		{
			return TRUE;
		}
	}
	else if (hWnd == pp[id].hEdit[3]) {
		if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	}
	
	switch (wp) {
	case 0x03:  // ctrl+C
	case 0x08:  // back space
	case 0x16:  // ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid PpChSetCheck(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPAPARA CHECK BM_SETCHECKCxg
------------------------------------------------------------------------------*/
void PpChSetCheck(LONG id, WPARAM wp, LPARAM lp)
{
	PpUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid PpRbPaint(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA RGBBOX WM_PAINTCxg
------------------------------------------------------------------------------*/
void PpRbPaint(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	RbBoxPaint(id, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PpRbSetFocus(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA RGBBOX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void PpRbSetFocus(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_PAPARA; i++) {
		if ((HWND)wp == pp[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
	
	PpEdSetFocus(id, wp, lp, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PpRbKillFocus(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA RGBBOX WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void PpRbKillFocus(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_PAPARA; i++) {
		if ((HWND)wp == pp[id].tabStops[i]) {
			res = TRUE;
		}
	}
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid PpRbLButtonDown(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA RGBBOX WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void PpRbLButtonDown(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	pp[id].flgClick = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid PpRbLButtonUp(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FPAPARA RGBBOX WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void PpRbLButtonUp(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	HWND  hEdit = NULL;
	
	if (pp[id].flgClick == FALSE) {return;}
	pp[id].flgClick = FALSE;
	SetFocus(hWnd);
	
	switch (idR) {
	case 0:  hEdit = pp[id].hEdit[2];  break;
	case 1:  hEdit = pp[id].hEdit[4];  break;
	default: break;
	}
	
	GetWindowText(hEdit, buffRgb, 6+1);
	RbDialog(id, pp[id].hWnd, hEdit, pp[id].hRgb[idR], buffRgb);
}

/*------------------------------------------------------------------------------
    Fvoid PpPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPAPARA PC WM_PAINTCxg
------------------------------------------------------------------------------*/
void PpPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1, w1, h1;
	INT32 x2, y2, w2, h2;
	INT32 mode;
	
	hdc = BeginPaint(pp[id].hPc, &ps);
	GetClientRect(pp[id].hPc, &rc);
	SetClipRgn(hdc, &rc);
	
	x2 = 0;
	y2 = 0;
	w2 = pp[id].pc.w;
	h2 = pp[id].pc.h;
	x1 = 0;
	y1 = 0;
	w1 = pp[id].pc.tmp.w;
	h1 = pp[id].pc.tmp.h;
	
	if (pp[id].pc.percent < 10000) {mode = HALFTONE;}
	else                              {mode = COLORONCOLOR;}
	
	PpTmpDraw(id);
	
	SetStretchBltMode(hdc, mode);
	StretchBlt(hdc,                  x2, y2, w2, h2,
			   pp[id].pc.tmp.hdc, x1, y1, w1, h1, SRCCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w2;
	rc.bottom = h2;
	FrameRect(hdc, &rc, hBrGray);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(pp[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid PpPcLButtonDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPAPARA PC WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void PpPcLButtonDown(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 x;
	INT32 y;
	INT32 xStr;
	INT32 yStr;
	WCHAR buff[2][10+1];
	
	x = LOWORD(lp);
	y = HIWORD(lp);
	
	xStr = (double)(x * fm[id].pc[0].img.w) / pp[id].pc.w;
	yStr = (double)(y * fm[id].pc[0].img.h) / pp[id].pc.h;
	
	_itow(xStr, buff[0], 10);
	_itow(yStr, buff[1], 10);
	SetWindowText(pp[id].hEdit[0], buff[0]);
	SetWindowText(pp[id].hEdit[1], buff[1]);
	UpdateWindow (pp[id].hEdit[0]);
	UpdateWindow (pp[id].hEdit[1]);
	
	PpUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid PpEnterOk(LONG id)
    FLONG    FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void PpEnterOk(LONG id)
{
	WCHAR buffChroma[6+1];
	WCHAR buffBack  [6+1];
	INT32 checked[2];
	INT32 chroma;
	INT32 back;
	st_Image img;
	INT32 w, h;
	
	PpUpdate(id);
	if (pp[id].flgUpdate == FALSE) {return;  CLOSE(pp[id].hWnd);}
	
	w = pp[id].pc.tmp.w;
	h = pp[id].pc.tmp.h;
	ImageCreate(&img, w, h);
	memcpy(img.pB, pp[id].pc.tmp.pB, w * h * 4);
	DeleteObject(fm[id].pc[0].img.hBmp);
	DeleteDC    (fm[id].pc[0].img.hdc);
	fm[id].pc[0].img.hBmp = img.hBmp;
	fm[id].pc[0].img.hdc  = img.hdc;
	fm[id].pc[0].img.pB   = img.pB;
	fm[id].pc[0].img.w    = img.w;
	fm[id].pc[0].img.h    = img.h;
	fm[id].flgArea        = TRUE;
	LiViewDelete(id, 0);
	
	SetAverageColor(id, 0);
	FmSize(id, NULL, NULL);
	
	GetWindowText(pp[id].hEdit[2], buffChroma, 6+1);
	GetWindowText(pp[id].hEdit[4], buffBack,   6+1);
	
	chroma = _wtoh(buffChroma, 6);
	back   = _wtoh(buffBack,   6);
	pp[id].chroma = chroma;
	pp[id].back   = back;
	
	checked[0] = B_GETCHECK(pp[id].hChk[0]);
	checked[1] = B_GETCHECK(pp[id].hChk[1]);
	if (checked[0] == BST_CHECKED) {pp[id].alpha = TRUE;}
	else                           {pp[id].alpha = FALSE;}
	if (checked[1] == BST_CHECKED) {pp[id].keep  = TRUE;}
	else                           {pp[id].keep  = FALSE;}
	
	fm[id].flgPapara = TRUE;
	SetFormText(id);
	MnFlushFile(id);
	
	PpStore(id);
	CLOSE(pp[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PpEnterCan(LONG id)
    FLONG    FORM ID
    @\F[CANCEL]{^s
------------------------------------------------------------------------------*/
void PpEnterCan(LONG id)
{
	CLOSE(pp[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid PpUpdate(LONG id)
    FLONG    FORM ID
    @\Fw\t̕\XV
------------------------------------------------------------------------------*/
void PpUpdate(LONG id)
{
	WCHAR strEditX[4+1];
	WCHAR strEditY[4+1];
	WCHAR strEditC[6+1];
	WCHAR strEditP[4+1];
	WCHAR strEditB[6+1];
	INT32 x;
	INT32 y;
	BOOL  alpha;
	BOOL  keep;
	INT32 chroma;
	INT32 back;
	INT32 percent;
	INT32 checked[2];
	INT32 w;
	INT32 h;
	
	GetWindowText(pp[id].hEdit[0], strEditX, 4+1);
	GetWindowText(pp[id].hEdit[1], strEditY, 4+1);
	GetWindowText(pp[id].hEdit[2], strEditC, 6+1);
	GetWindowText(pp[id].hEdit[3], strEditP, 4+1);
	GetWindowText(pp[id].hEdit[4], strEditB, 6+1);
	
	x = _wtoi(strEditX);
	y = _wtoi(strEditY);
	checked[0] = B_GETCHECK(pp[id].hChk[0]);
	checked[1] = B_GETCHECK(pp[id].hChk[1]);
	if (checked[0] == BST_CHECKED) {alpha = TRUE;} else {alpha = FALSE;}
	if (checked[1] == BST_CHECKED) {keep  = TRUE;} else {keep  = FALSE;}
	chroma  = _wtoh(strEditC, 6);
	back    = _wtoh(strEditB, 6);
	percent = _wtoi(strEditP);
	
	if ((x       != pp[id].x)       ||
		(y       != pp[id].y)       ||
		(alpha   != pp[id].alpha)   ||
		(chroma  != pp[id].chroma)  ||
		(percent != pp[id].percent) ||
		(keep    != pp[id].keep)    ||
		(back    != pp[id].back))
	{
		w = fm[id].pc[0].img.w;
		h = fm[id].pc[0].img.h;
		if (keep == FALSE) {PpTmpWh(id, &w, &h, x, y, percent);}
		PpTmpDelete(id);
		PpTmpCreate(id, w, h, back);
		
		PpView(id);
		a_SetWindowPos(pp[id].hPc, pp[id].pc.x, pp[id].pc.y,
								   pp[id].pc.w, pp[id].pc.h);
		InvalidateRect(pp[id].hCn, NULL, TRUE);
		InvalidateRect(pp[id].hPc, NULL, FALSE);
		UpdateWindow  (pp[id].hCn);
		UpdateWindow  (pp[id].hPc);
		
		pp[id].flgUpdate = TRUE;
	}
	
	pp[id].x       = x;
	pp[id].y       = y;
	pp[id].alpha   = alpha;
	pp[id].chroma  = chroma;
	pp[id].percent = percent;
	pp[id].keep    = keep;
	pp[id].back    = back;
}

/*------------------------------------------------------------------------------
    Fvoid PpTmpWh(LONG, INT32 *, INT32 *, INT32, INT32, INT32)
    FLONG     FORM ID
          INT32       Q
          INT32     Q
          INT32    XW
          INT32    YW
          INT32    {
    @\Fw\t EvZ
------------------------------------------------------------------------------*/
void PpTmpWh(LONG id, INT32 *pW, INT32 *pH, INT32 x, INT32 y, INT32 percent)
{
	INT32 w,    h;
	INT32 xAbs, yAbs;
	INT32 wImg, hImg;
	INT32 wClp, hClp;
	
	if (percent < 0)    {percent = 0;}
	if (9999 < percent) {percent = 9999;}
	
	wImg = fm[id].pc[0].img.w;
	hImg = fm[id].pc[0].img.h;
	wClp = ((double)pp[id].pc.clp.w * percent) / 1000;
	hClp = ((double)pp[id].pc.clp.h * percent) / 1000;
	xAbs = abs(x);
	yAbs = abs(y);
	
	if (0 < x) {
		if ((xAbs + wClp) < wImg) {w = wImg;}
		else                      {w = xAbs + wClp;}
	}
	else {
		if (wImg < wClp) {
			if (wClp < (xAbs + wImg)) {w = xAbs + wImg;}
			else                      {w = wClp;}
		}
		else {
			w = xAbs + wImg;
		}
	}
	
	if (0 < y) {
		if ((yAbs + hClp) < hImg) {h = hImg;}
		else                      {h = yAbs + hClp;}
	}
	else {
		if (hImg < hClp) {
			if (hClp < (yAbs + hImg)) {h = yAbs + hImg;}
			else                      {h = hClp;}
		}
		else {
			h = yAbs + hImg;
		}
	}
	
	*pW = w;
	*pH = h;
}

/*------------------------------------------------------------------------------
    Fvoid PpTmpCreate(LONG, INT32, INT32, INT32)
    FLONG     FORM ID
          INT32    
          INT32    
          INT32    wiF
    @\Fw\t ꎞC[W쐬
------------------------------------------------------------------------------*/
void PpTmpCreate(LONG id, INT32 w, INT32 h, INT32 rgb)
{
	INT32 i;
	INT32 *pB32;
	
	ImageCreate(&pp[id].pc.tmp, w, h);
	
	pB32 = (INT32 *)pp[id].pc.tmp.pB;
	for (i = 0; i < w*h; i++) {
		*pB32 = rgb;
		pB32++;
	}
}

/*------------------------------------------------------------------------------
    Fvoid PpTmpDraw(LONG)
    FLONG     FORM ID
    @\Fw\t ꎞC[W`
------------------------------------------------------------------------------*/
void PpTmpDraw(LONG id)
{
	HDC hdc0;
	HDC hdc1;
	HDC hdc2;
	WCHAR buffX     [4+1];
	WCHAR buffY     [4+1];
	WCHAR buffChroma[6+1];
	WCHAR buffPer   [4+1];
	WCHAR buffRgb   [6+1];
	INT32 x,    y;
	INT32 w0,   h0;
	INT32 w1,   h1;
	INT32 xImg, yImg;
	INT32 xClp, yClp;
	INT32 wDst, hDst;
	INT32 chroma;
	INT32 percent;
	INT32 rgb;
	BOOL  alpha;
	BOOL  keep;
	INT32 checked[2];
	RECT  rc;
	INT32 mode;
	INT32 i;
	INT32 *pB32;
	
	GetWindowText(pp[id].hEdit[0], buffX,      4+1);
	GetWindowText(pp[id].hEdit[1], buffY,      4+1);
	GetWindowText(pp[id].hEdit[2], buffChroma, 6+1);
	GetWindowText(pp[id].hEdit[3], buffPer,    4+1);
	GetWindowText(pp[id].hEdit[4], buffRgb,    6+1);
	x = _wtoi(buffX);
	y = _wtoi(buffY);
	
	chroma = _wtoh(buffChroma, 6);
	rgb    = _wtoh(buffRgb,    6);
	chroma = _htor(chroma);
//	rgb    = _htor(rgb);
	percent = _wtoi(buffPer);
	if (percent < 0)    {percent = 0;}
	if (9999 < percent) {percent = 9999;}
	
	hdc0 = fm[id].pc[0].img.hdc;
	hdc1 = pp[id].pc.clp.hdc;
	hdc2 = pp[id].pc.tmp.hdc;
	w0   = fm[id].pc[0].img.w;
	h0   = fm[id].pc[0].img.h;
	w1   = pp[id].pc.clp.w;
	h1   = pp[id].pc.clp.h;
	
	checked[0] = B_GETCHECK(pp[id].hChk[0]);
	checked[1] = B_GETCHECK(pp[id].hChk[1]);
	if (checked[0] == BST_CHECKED) {alpha = TRUE;} else {alpha = FALSE;}
	if (checked[1] == BST_CHECKED) {keep  = TRUE;} else {keep  = FALSE;}
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = pp[id].pc.tmp.w;
	rc.bottom = pp[id].pc.tmp.h;
	SetClipRgn(hdc2, &rc);
	
	if (percent < 1000) {mode = HALFTONE;}
	else                {mode = COLORONCOLOR;}
	SetStretchBltMode(hdc2, mode);
	
	wDst = ((double)w1 * percent) / 1000;
	hDst = ((double)h1 * percent) / 1000;
	
	xImg = 0;  xClp = x;
	yImg = 0;  yClp = y;
	if (keep == FALSE) {
		if (x < 0) {xImg = abs(x);  xClp = 0;}
		if (y < 0) {yImg = abs(y);  yClp = 0;}
	}
	
	pB32 = (INT32 *)pp[id].pc.tmp.pB;
	for (i = 0; i < pp[id].pc.tmp.w*pp[id].pc.tmp.h; i++) {
		*pB32 = rgb;
		pB32++;
	}
	
	BitBlt(hdc2, xImg, yImg, w0, h0, hdc0, 0, 0, SRCCOPY);
	
	if (alpha == TRUE) {
		TransparentBlt(hdc2, xClp, yClp, wDst, hDst, hdc1, 0, 0, w1, h1, chroma);
	}
	else {
		if (percent == 1000) {
			BitBlt(hdc2, xClp, yClp, w1, h1, hdc1, 0, 0, SRCCOPY);
		}
		else {
			StretchBlt(hdc2, xClp, yClp, wDst, hDst, hdc1, 0, 0, w1, h1, SRCCOPY);
		}
	}
	
	SelectClipRgn(hdc2, NULL);
}

/*------------------------------------------------------------------------------
    Fvoid PpTmpDelete(LONG)
    FLONG     FORM ID
    @\Fw\t ꎞC[W폜
------------------------------------------------------------------------------*/
void PpTmpDelete(LONG id)
{
	DeleteDC    (pp[id].pc.tmp.hdc);
	DeleteObject(pp[id].pc.tmp.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid PpClpCreate(LONG)
    FLONG     FORM ID
    @\Fw\t Nbv摜 쐬
------------------------------------------------------------------------------*/
void PpClpCreate(LONG id)
{
	HBITMAP hBmp;
	BITMAP bmp;
	INT32 w, h;
	HDC hdc;
	
	OpenClipboard(NULL);
	hBmp = (HBITMAP)GetClipboardData(CF_BITMAP);
	
	GetObject(hBmp, sizeof(bmp), &bmp);
	w = bmp.bmWidth;
	h = bmp.bmHeight;
	
	hdc = CreateCompatibleDC(NULL);
	SelectObject(hdc, hBmp);
	
	ImageCreate(&pp[id].pc.clp, w, h);
	
	BitBlt(pp[id].pc.clp.hdc, 0, 0, w, h, hdc, 0, 0, SRCCOPY);
	
	DeleteObject(hBmp);
	DeleteDC    (hdc);
	CloseClipboard();
}

/*------------------------------------------------------------------------------
    Fvoid PpClpDelete(LONG)
    FLONG     FORM ID
    @\Fw\t Nbv摜 폜
------------------------------------------------------------------------------*/
void PpClpDelete(LONG id)
{
	DeleteDC    (pp[id].pc.clp.hdc);
	DeleteObject(pp[id].pc.clp.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid PpView(LONG)
    FLONG    FORM ID
    @\Fw\t\p
------------------------------------------------------------------------------*/
void PpView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	
	if (IsBit(fm[id].pc[0].img.stat, BIT_NONE|BIT_FAILURE)) {return;}
	
	TryZeroDivision(pp[id].pc.tmp.w);
	TryZeroDivision(pp[id].pc.tmp.h);
	gainW = (double)pp[id].cn.w / pp[id].pc.tmp.w;
	gainH = (double)pp[id].cn.h / pp[id].pc.tmp.h;
	
	if ((1 < gainW) && (1 < gainH)) {
		gainW = gainH = (double)1;
	}
	else {
		if (CmpGain(gainW, gainH) == TRUE) {
			limW = TRUE;
			limH = TRUE;
		}
		else {
			if (gainW < gainH) {
				gainH = gainW;
				limW = TRUE;
			}
			else {
				gainW = gainH;
				limH = TRUE;
			}
		}
	}
	
	x = (double)pp[id].cn.w / 2 - (double)pp[id].pc.tmp.w * gainW / 2;
	y = (double)pp[id].cn.h / 2 - (double)pp[id].pc.tmp.h * gainH / 2;
	w = (double)pp[id].pc.tmp.w * gainW;
	h = (double)pp[id].pc.tmp.h * gainH;
	
	if (limW == TRUE) {x = 0;  w = pp[id].cn.w;}
	if (limH == TRUE) {y = 0;  h = pp[id].cn.h;}
	
	if (limW == TRUE) {TryZeroDivision(pp[id].pc.tmp.w);  pp[id].pc.percent = ((double)w / pp[id].pc.tmp.w) * 10000;}
	else              {TryZeroDivision(pp[id].pc.tmp.h);  pp[id].pc.percent = ((double)h / pp[id].pc.tmp.h) * 10000;}
	
	pp[id].pc.x = x;
	pp[id].pc.y = y;
	if (w <= 0) {pp[id].pc.w = 1;}
	else        {pp[id].pc.w = w;}
	if (h <= 0) {pp[id].pc.h = 1;}
	else        {pp[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    Fvoid PpSetPane(LONG)
    FLONG    FORM ID
    @\Fw\t̕\̘g\
------------------------------------------------------------------------------*/
void PpSetPane(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(pp[id].hPd[1], &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	a_SetWindowPos(pp[id].hCn, PADD8, PADD8, w-PADD8*2, h-PADD8*2);
	
	GetClientRect(pp[id].hCn, &rc);
	pp[id].cn.x = rc.left;
	pp[id].cn.y = rc.top;
	pp[id].cn.w = rc.right - rc.left;
	pp[id].cn.h = rc.bottom - rc.top;
}
