/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define RT_CPP
#include "../common.h"
//  RectF`

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	INT32 fore;
	INT32 back;
	INT32 t;
	INT32 c;
	BOOL fill;
	BOOL only;
	BOOL elip;
	BOOL l;
	BOOL flgClick[2];
	BOOL flgUpdate;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_RECT];
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;} cn;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			INT32 x1;
			INT32 y1;
			INT32 x2;
			INT32 y2;
			UINT32 percent;
			BOOL flgClick;
			INT32 flgsBorder;
			st_Image tmp;} pc;
	
	HWND hWnd;
	HWND hPd[2];
	HWND hEdit[8];
	HWND hRgb[2];
	HWND hChk[4];
	HWND hBtn[3];
	HWND hCn;
	HWND hPc;
	
	LRESULT (CALLBACK *pCallEdit[8]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallChk[4])  (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn[3])  (HWND,UINT,WPARAM,LPARAM);
} rt[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void RtInitClass(void);
void RtInit(LONG);
void RtInst(LONG);
void RtDialog(LONG);
void RtLoad(LONG);
void RtStore(LONG);
LRESULT CALLBACK RtWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcPd    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcEditX (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcEditY (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcEditW (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcEditH (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcEditF (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcEditB (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcEditT (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcEditC (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcRgbF  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcRgbB  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcChkF  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcChkO  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcChkE  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcChkL  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcBtnApl(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK RtWndProcPc    (HWND, UINT, WPARAM, LPARAM);
void RtSize         (LONG, WPARAM, LPARAM);
void RtGetMinMaxInfo(LONG, WPARAM, LPARAM);
void RtSetFocus     (LONG, WPARAM, LPARAM);
void RtKeyDown      (LONG, WPARAM, LPARAM, HWND);
void RtKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void RtKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void RtKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void RtKeyDownSpace (LONG, WPARAM, LPARAM, HWND);
void RtKeyDownF5    (LONG, WPARAM, LPARAM, HWND);
void RtKeyDownUpDw  (LONG, WPARAM, LPARAM, HWND);
void RtClose        (LONG, WPARAM, LPARAM);
void RtDestroy      (LONG, WPARAM, LPARAM);
void RtPdCommand    (LONG, WPARAM, LPARAM);
void RtPdPaint      (LONG, WPARAM, LPARAM);
void RtEdSetFocus   (LONG, WPARAM, LPARAM, HWND);
void RtEdKillFocus  (LONG, WPARAM, LPARAM, HWND);
BOOL RtEdChar       (LONG, WPARAM, LPARAM, HWND);
void RtRbPaint      (LONG, LONG, WPARAM, LPARAM, HWND);
void RtRbSetFocus   (LONG, LONG, WPARAM, LPARAM, HWND);
void RtRbKillFocus  (LONG, LONG, WPARAM, LPARAM, HWND);
void RtRbLButtonDown(LONG, LONG, WPARAM, LPARAM, HWND);
void RtRbLButtonUp  (LONG, LONG, WPARAM, LPARAM, HWND);
void RtChSetCheck   (LONG, WPARAM, LPARAM);
void RtPcPaint      (LONG, WPARAM, LPARAM);
void RtPcMouseMove  (LONG, WPARAM, LPARAM);
void RtPcLButtonDown(LONG, WPARAM, LPARAM);
void RtPcLButtonUp  (LONG, WPARAM, LPARAM);
void RtEnterOk(LONG);
void RtEnterCan(LONG);
void RtEnterApl(LONG);
void RtUpdate(LONG);
void RtTmpCreate(LONG, INT32, INT32);
void RtTmpDraw(LONG);
void RtTmpDelete(LONG);
void RtSetCursor(LONG, INT32, INT32);
void RtMouse(LONG, INT32, INT32);
void RtView(LONG);
void RtSetPane(LONG);

/*------------------------------------------------------------------------------
    Fvoid RtInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void RtInitClass(void)
{
	WNDCLASS wcRect;
	WNDCLASS wcRectPd;
	WNDCLASS wcRectCn;
	WNDCLASS wcRectPc;
	
	InitWC(CS_OWNDC, DefWindowProc, hIcon,hCurArrow,hBrBrGray,   NM_RECT,       &wcRect);
	InitWC(CS_OWNDC, DefWindowProc, NULL, hCurArrow,hBrWhite,    NM_RECTPD,     &wcRectPd);
	InitWC(CS_OWNDC, DefWindowProc, NULL, hCurArrow,hBrWhite,    NM_RECTCN,     &wcRectCn);
	InitWC(CS_OWNDC, DefWindowProc, NULL, hCurArrow,hBrNull,     NM_RECTPC,     &wcRectPc);
	
	RegisterClass(&wcRect);
	RegisterClass(&wcRectPd);
	RegisterClass(&wcRectCn);
	RegisterClass(&wcRectPc);
}

/*------------------------------------------------------------------------------
    Fvoid RtInit(LONG)
    FLONG    FORM ID
    @\F`
------------------------------------------------------------------------------*/
void RtInit(LONG id)
{
	INT32 i;
	
	rt[id].x    = 0;
	rt[id].y    = 0;
	rt[id].w    = 0;
	rt[id].h    = 0;
	rt[id].fore = 0x000000;
	rt[id].back = 0x000000;
	rt[id].t    = 0;
	rt[id].c    = 0;
	rt[id].fill = FALSE;
	rt[id].only = FALSE;
	rt[id].elip = FALSE;
	rt[id].l    = FALSE;
	
	rt[id].flgUpdate  = FALSE;
	rt[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_RECT; i++) {rt[id].tabStops[i] = NULL;}
	
	rt[id].cn.x = 0;
	rt[id].cn.y = 0;
	rt[id].cn.w = 0;
	rt[id].cn.h = 0;
	
	rt[id].pc.x          = 0;
	rt[id].pc.y          = 0;
	rt[id].pc.w          = 0;
	rt[id].pc.h          = 0;
	rt[id].pc.x1         = 0;
	rt[id].pc.y1         = 0;
	rt[id].pc.x2         = 0;
	rt[id].pc.y2         = 0;
	rt[id].pc.percent    = 0;
	rt[id].pc.flgClick   = 0;
	rt[id].pc.flgsBorder = 0;
	ImageInit(&rt[id].pc.tmp);
	
	rt[id].hWnd = NULL;
	for (i = 0; i < 2; i++) {rt[id].hPd  [i] = NULL;}
	for (i = 0; i < 8; i++) {rt[id].hEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {rt[id].hRgb [i] = NULL;}
	for (i = 0; i < 4; i++) {rt[id].hChk [i] = NULL;}
	for (i = 0; i < 3; i++) {rt[id].hBtn [i] = NULL;}
	rt[id].hCn  = NULL;
	rt[id].hPc  = NULL;
	
	for (i = 0; i < 8; i++) {rt[id].pCallEdit[i] = NULL;}
	for (i = 0; i < 4; i++) {rt[id].pCallChk[i]  = NULL;}
	for (i = 0; i < 3; i++) {rt[id].pCallBtn[i]  = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid RtInst(LONG)
    FLONG      FORM ID
    @\F̉
------------------------------------------------------------------------------*/
void RtInst(LONG id)
{
	DWORD styleRc  = WS_OVERLAPPED|WS_CAPTION|WS_MAXIMIZEBOX|WS_THICKFRAME|WS_SYSMENU;
	DWORD stylePd1 = WS_CHILD|WS_VISIBLE;
	DWORD stylePd2 = WS_CHILD;
	DWORD styleEd  = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleRb  = WS_CHILD|WS_VISIBLE|WS_BORDER;
	DWORD styleCk  = WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD styleCn  = WS_CHILD|WS_CLIPCHILDREN;
	DWORD stylePc  = WS_CHILD;
	INT32 y[8] = {12,42,72,102,132,162,192,222,};
	INT32 w;
	WCHAR strFore[6+1];
	WCHAR strBack[6+1];
	WCHAR strT   [2+1];
	WCHAR strC   [3+1];
	WPARAM wp[4];
	
	_htow(rt[id].fore, strFore, 6);
	_htow(rt[id].back, strBack, 6);
	_itow(rt[id].t   , strT,    10);
	_itow(rt[id].c   , strC,    10);
	
	if (rt[id].fill) {wp[0] = BST_CHECKED;} else {wp[0] = BST_UNCHECKED;}
	if (rt[id].only) {wp[1] = BST_CHECKED;} else {wp[1] = BST_UNCHECKED;}
	if (rt[id].elip) {wp[2] = BST_CHECKED;} else {wp[2] = BST_UNCHECKED;}
	if (rt[id].l)    {wp[3] = BST_CHECKED;} else {wp[3] = BST_UNCHECKED;}
	
	w = SZ_WEDIT3-PADD8*2;
	rt[id].hWnd    = a_CreateWindow(NM_RECT,  TxTl(E_TTLRCT),   styleRc, 0,   0,  0, 0,  fm[id].hWnd);
	rt[id].hPd[0]  = a_CreateWindow(NM_RECTPD,NULL,             stylePd1,8,   8,  w, 404,rt[id].hWnd);
	rt[id].hPd[1]  = a_CreateWindow(NM_RECTPD,NULL,             stylePd2,0,   0,  0, 0,  rt[id].hWnd);
	rt[id].hEdit[0]= a_CreateWindow(L"Edit",  L"0",             styleEd, 91, y[0],65,17, rt[id].hPd[0]);
	rt[id].hEdit[1]= a_CreateWindow(L"Edit",  L"0",             styleEd, 91, y[1],65,17, rt[id].hPd[0]);
	rt[id].hEdit[2]= a_CreateWindow(L"Edit",  L"0",             styleEd, 91, y[2],65,17, rt[id].hPd[0]);
	rt[id].hEdit[3]= a_CreateWindow(L"Edit",  L"0",             styleEd, 91, y[3],65,17, rt[id].hPd[0]);
	rt[id].hEdit[4]= a_CreateWindow(L"Edit",  strFore,          styleEd, 91, y[4],65,17, rt[id].hPd[0]);
	rt[id].hEdit[5]= a_CreateWindow(L"Edit",  strBack,          styleEd, 91, y[5],65,17, rt[id].hPd[0]);
	rt[id].hEdit[6]= a_CreateWindow(L"Edit",  strT,             styleEd, 91, y[6],65,17, rt[id].hPd[0]);
	rt[id].hEdit[7]= a_CreateWindow(L"Edit",  strC,             styleEd, 91, y[7],65,17, rt[id].hPd[0]);
	rt[id].hRgb[0] = a_CreateWindow(NM_RGBBOX,NULL,             styleRb, 162,133, 16,16, rt[id].hPd[0]);
	rt[id].hRgb[1] = a_CreateWindow(NM_RGBBOX,NULL,             styleRb, 162,163, 16,16, rt[id].hPd[0]);
	rt[id].hChk[0] = a_CreateWindow(L"Button",TxEd(E_RTFILL),   styleCk, 91, 247, 70,25, rt[id].hPd[0]);
	rt[id].hChk[1] = a_CreateWindow(L"Button",TxEd(E_RTONLY),   styleCk, 91, 277, 85,25, rt[id].hPd[0]);
	rt[id].hChk[2] = a_CreateWindow(L"Button",TxEd(E_RTELIPSE), styleCk, 91, 307, 70,25, rt[id].hPd[0]);
	rt[id].hChk[3] = a_CreateWindow(L"Button",TxEd(E_RTLSHAPED),styleCk, 91, 337, 70,25, rt[id].hPd[0]);
	rt[id].hBtn[0] = a_CreateWindow(L"Button",TxEd(E_OK),       styleBt, 10, 371, 70,25, rt[id].hPd[0]);
	rt[id].hBtn[1] = a_CreateWindow(L"Button",TxEd(E_CANCEL),   styleBt, 90, 371, 70,25, rt[id].hPd[0]);
	rt[id].hBtn[2] = a_CreateWindow(L"Button",TxEd(E_APPLY),    styleBt, 170,371, 70,25, rt[id].hPd[0]);
	rt[id].hCn     = a_CreateWindow(NM_RECTCN,NULL,             styleCn, 0,  0,   0, 0,  rt[id].hPd[1]);
	rt[id].hPc     = a_CreateWindow(NM_RECTPC,NULL,             stylePc, 0,  0,   0, 0,  rt[id].hCn);
	
	SetWindowLong(rt[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(rt[id].hPd[0],   GWL_USERDATA, 0*100+id);
	SetWindowLong(rt[id].hPd[1],   GWL_USERDATA, 1*100+id);
	SetWindowLong(rt[id].hEdit[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(rt[id].hEdit[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(rt[id].hEdit[2], GWL_USERDATA, 2*100+id);
	SetWindowLong(rt[id].hEdit[3], GWL_USERDATA, 3*100+id);
	SetWindowLong(rt[id].hEdit[4], GWL_USERDATA, 4*100+id);
	SetWindowLong(rt[id].hEdit[5], GWL_USERDATA, 5*100+id);
	SetWindowLong(rt[id].hEdit[6], GWL_USERDATA, 6*100+id);
	SetWindowLong(rt[id].hEdit[7], GWL_USERDATA, 7*100+id);
	SetWindowLong(rt[id].hRgb[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(rt[id].hRgb[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(rt[id].hChk[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(rt[id].hChk[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(rt[id].hChk[2],  GWL_USERDATA, 2*100+id);
	SetWindowLong(rt[id].hChk[3],  GWL_USERDATA, 3*100+id);
	SetWindowLong(rt[id].hBtn[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(rt[id].hBtn[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(rt[id].hBtn[2],  GWL_USERDATA, 2*100+id);
	SetWindowLong(rt[id].hPc,      GWL_USERDATA, id);
	
	SetWindowLong(rt[id].hWnd,    GWL_WNDPROC, (LONG)RtWndProc);
	SetWindowLong(rt[id].hPd[0],  GWL_WNDPROC, (LONG)RtWndProcPd);
	SetWindowLong(rt[id].hPd[1],  GWL_WNDPROC, (LONG)RtWndProcPd);
	SetWindowLong(rt[id].hRgb[0], GWL_WNDPROC, (LONG)RtWndProcRgbF);
	SetWindowLong(rt[id].hRgb[1], GWL_WNDPROC, (LONG)RtWndProcRgbB);
	SetWindowLong(rt[id].hPc,     GWL_WNDPROC, (LONG)RtWndProcPc);
	
	E_SETFONT(rt[id].hEdit[0], hFtCourier);
	E_SETFONT(rt[id].hEdit[1], hFtCourier);
	E_SETFONT(rt[id].hEdit[2], hFtCourier);
	E_SETFONT(rt[id].hEdit[3], hFtCourier);
	E_SETFONT(rt[id].hEdit[4], hFtCourier);
	E_SETFONT(rt[id].hEdit[5], hFtCourier);
	E_SETFONT(rt[id].hEdit[6], hFtCourier);
	E_SETFONT(rt[id].hEdit[7], hFtCourier);
	
	E_SETLIMITTEXT(rt[id].hEdit[0], 5);
	E_SETLIMITTEXT(rt[id].hEdit[1], 5);
	E_SETLIMITTEXT(rt[id].hEdit[2], 5);
	E_SETLIMITTEXT(rt[id].hEdit[3], 5);
	E_SETLIMITTEXT(rt[id].hEdit[4], 6);
	E_SETLIMITTEXT(rt[id].hEdit[5], 6);
	E_SETLIMITTEXT(rt[id].hEdit[6], 2);
	E_SETLIMITTEXT(rt[id].hEdit[7], 3);
	
	B_SETCHECK(rt[id].hChk[0], wp[0]);
	B_SETCHECK(rt[id].hChk[1], wp[1]);
	B_SETCHECK(rt[id].hChk[2], wp[2]);
	B_SETCHECK(rt[id].hChk[3], wp[3]);
	
	B_SETFONT(rt[id].hChk[0], hFtArial14);
	B_SETFONT(rt[id].hChk[1], hFtArial14);
	B_SETFONT(rt[id].hChk[2], hFtArial14);
	B_SETFONT(rt[id].hChk[3], hFtArial14);
	B_SETFONT(rt[id].hBtn[0], hFtArial14);
	B_SETFONT(rt[id].hBtn[1], hFtArial14);
	B_SETFONT(rt[id].hBtn[2], hFtArial14);
	
	rt[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(rt[id].hEdit[0], GWL_WNDPROC);
	rt[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(rt[id].hEdit[1], GWL_WNDPROC);
	rt[id].pCallEdit[2] = (CALLFUNC)GetWindowLong(rt[id].hEdit[2], GWL_WNDPROC);
	rt[id].pCallEdit[3] = (CALLFUNC)GetWindowLong(rt[id].hEdit[3], GWL_WNDPROC);
	rt[id].pCallEdit[4] = (CALLFUNC)GetWindowLong(rt[id].hEdit[4], GWL_WNDPROC);
	rt[id].pCallEdit[5] = (CALLFUNC)GetWindowLong(rt[id].hEdit[5], GWL_WNDPROC);
	rt[id].pCallEdit[6] = (CALLFUNC)GetWindowLong(rt[id].hEdit[6], GWL_WNDPROC);
	rt[id].pCallEdit[7] = (CALLFUNC)GetWindowLong(rt[id].hEdit[7], GWL_WNDPROC);
	rt[id].pCallChk[0]  = (CALLFUNC)GetWindowLong(rt[id].hChk[0],  GWL_WNDPROC);
	rt[id].pCallChk[1]  = (CALLFUNC)GetWindowLong(rt[id].hChk[1],  GWL_WNDPROC);
	rt[id].pCallChk[2]  = (CALLFUNC)GetWindowLong(rt[id].hChk[2],  GWL_WNDPROC);
	rt[id].pCallChk[3]  = (CALLFUNC)GetWindowLong(rt[id].hChk[3],  GWL_WNDPROC);
	rt[id].pCallBtn[0]  = (CALLFUNC)GetWindowLong(rt[id].hBtn[0],  GWL_WNDPROC);
	rt[id].pCallBtn[1]  = (CALLFUNC)GetWindowLong(rt[id].hBtn[1],  GWL_WNDPROC);
	rt[id].pCallBtn[2]  = (CALLFUNC)GetWindowLong(rt[id].hBtn[2],  GWL_WNDPROC);
	SetWindowLong(rt[id].hEdit[0], GWL_WNDPROC, (LONG)RtWndProcEditX);
	SetWindowLong(rt[id].hEdit[1], GWL_WNDPROC, (LONG)RtWndProcEditY);
	SetWindowLong(rt[id].hEdit[2], GWL_WNDPROC, (LONG)RtWndProcEditW);
	SetWindowLong(rt[id].hEdit[3], GWL_WNDPROC, (LONG)RtWndProcEditH);
	SetWindowLong(rt[id].hEdit[4], GWL_WNDPROC, (LONG)RtWndProcEditF);
	SetWindowLong(rt[id].hEdit[5], GWL_WNDPROC, (LONG)RtWndProcEditB);
	SetWindowLong(rt[id].hEdit[6], GWL_WNDPROC, (LONG)RtWndProcEditT);
	SetWindowLong(rt[id].hEdit[7], GWL_WNDPROC, (LONG)RtWndProcEditC);
	SetWindowLong(rt[id].hChk[0],  GWL_WNDPROC, (LONG)RtWndProcChkF);
	SetWindowLong(rt[id].hChk[1],  GWL_WNDPROC, (LONG)RtWndProcChkO);
	SetWindowLong(rt[id].hChk[2],  GWL_WNDPROC, (LONG)RtWndProcChkE);
	SetWindowLong(rt[id].hChk[3],  GWL_WNDPROC, (LONG)RtWndProcChkL);
	SetWindowLong(rt[id].hBtn[0],  GWL_WNDPROC, (LONG)RtWndProcBtnOk);
	SetWindowLong(rt[id].hBtn[1],  GWL_WNDPROC, (LONG)RtWndProcBtnCan);
	SetWindowLong(rt[id].hBtn[2],  GWL_WNDPROC, (LONG)RtWndProcBtnApl);
	
	rt[id].tabStopIdx = 0;
	rt[id].tabStops[0] = rt[id].hEdit[0];
	rt[id].tabStops[1] = rt[id].hEdit[1];
	rt[id].tabStops[2] = rt[id].hEdit[2];
	rt[id].tabStops[3] = rt[id].hEdit[3];
	rt[id].tabStops[4] = rt[id].hEdit[4];
	rt[id].tabStops[5] = rt[id].hRgb[0];
	rt[id].tabStops[6] = rt[id].hEdit[5];
	rt[id].tabStops[7] = rt[id].hRgb[1];
	rt[id].tabStops[8] = rt[id].hEdit[6];
	rt[id].tabStops[9] = rt[id].hEdit[7];
	rt[id].tabStops[10]= rt[id].hChk[0];
	rt[id].tabStops[11]= rt[id].hChk[1];
	rt[id].tabStops[12]= rt[id].hChk[2];
	rt[id].tabStops[13]= rt[id].hChk[3];
	rt[id].tabStops[14]= rt[id].hBtn[0];
	rt[id].tabStops[15]= rt[id].hBtn[1];
	rt[id].tabStops[16]= rt[id].hBtn[2];
	
	SetFocus  (rt[id].hEdit[0]);
	EditSelAll(rt[id].hEdit[0]);
}

/*------------------------------------------------------------------------------
    Fvoid RtDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void RtDialog(LONG id)
{
	RtInit(id);
	RtLoad(id);
	RtTmpCreate(id, fm[id].pc[0].img.w, fm[id].pc[0].img.h);
	RtInst(id);
	PpPlacement(id, rt[id].hWnd);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = rt[id].hWnd;
	
	ShowWindow(rt[id].hPd[1], 0x1);
	ShowWindow(rt[id].hCn,    0x1);
	ShowWindow(rt[id].hPc,    0x1);
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid RtLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void RtLoad(LONG id)
{
	rt[id].fore = g_rtFore;
	rt[id].back = g_rtBack;
	rt[id].t    = g_rtThick;
	rt[id].c    = g_rtCorner;
	rt[id].fill = g_rtFill;
	rt[id].only = g_rtOnly;
	rt[id].elip = g_rtElip;
	rt[id].l    = g_rtL;
}

/*------------------------------------------------------------------------------
    Fvoid RtStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void RtStore(LONG id)
{
	g_rtFore   = rt[id].fore;
	g_rtBack   = rt[id].back;
	g_rtThick  = rt[id].t;
	g_rtCorner = rt[id].c;
	g_rtFill   = rt[id].fill;
	g_rtOnly   = rt[id].only;
	g_rtElip   = rt[id].elip;
	g_rtL      = rt[id].l;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProc(,,,)
    F-
    ߒlF-
    @\FRTCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_USER:  RtUpdate(id);  break;  // WMU_RGBEND
	case WM_SIZE:           RtSize         (id, wp, lp);  break;
	case WM_GETMINMAXINFO:  RtGetMinMaxInfo(id, wp, lp);  break;
	case WM_SETFOCUS:       RtSetFocus     (id, wp, lp);  break;
	case WM_CLOSE:          RtClose        (id, wp, lp);  break;
	case WM_DESTROY:        RtDestroy      (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcPd(,,,)
    F-
    ߒlF-
    @\FPDCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idP;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:
		if (idP == 0) {
			RtPdCommand(id, wp, lp);
		}
		break;
	case WM_PAINT:
		if (idP == 0) {
			RtPdPaint(id, wp, lp);
		}
		break;
	case WM_CTLCOLORSTATIC:
		if (((HWND)lp == rt[id].hChk[0]) ||
			((HWND)lp == rt[id].hChk[1]) ||
			((HWND)lp == rt[id].hChk[2]) ||
			((HWND)lp == rt[id].hChk[3])) {return (LRESULT)hBrWhite;}
		break;
	default:  break;
	}
	
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcEditX(,,,)
    F-
    ߒlF-
    @\FEDIT XCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcEditX(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   RtEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  RtEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		RtKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (RtEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return rt[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcEditY(,,,)
    F-
    ߒlF-
    @\FEDIT YCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcEditY(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   RtEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  RtEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		RtKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (RtEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return rt[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcEditW(,,,)
    F-
    ߒlF-
    @\FEDIT WCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcEditW(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   RtEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  RtEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		RtKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (RtEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return rt[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcEditH(,,,)
    F-
    ߒlF-
    @\FEDIT HCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcEditH(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   RtEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  RtEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		RtKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (RtEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default: break;
	}
	
	return rt[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcEditF(,,,)
    F-
    ߒlF-
    @\FEDIT FORECxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcEditF(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   RtEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  RtEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    RtKeyDown    (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (RtEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:  break;
	}
	
	return rt[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcEditB(,,,)
    F-
    ߒlF-
    @\FEDIT BACKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcEditB(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   RtEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  RtEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    RtKeyDown    (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (RtEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:  break;
	}
	
	return rt[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcEditT(,,,)
    F-
    ߒlF-
    @\FEDIT THICKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcEditT(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   RtEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  RtEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		RtKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (RtEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:  break;
	}
	
	return rt[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcEditC(,,,)
    F-
    ߒlF-
    @\FEDIT CORNERCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcEditC(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   RtEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  RtEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		RtKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (RtEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:  break;
	}
	
	return rt[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcRgbF(,,,)
    F-
    ߒlF-
    @\FRGB F  Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcRgbF(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idR;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idR = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:        RtRbPaint      (id, idR, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     RtRbSetFocus   (id, idR, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    RtRbKillFocus  (id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  RtRbLButtonDown(id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    RtRbLButtonUp  (id, idR, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      RtKeyDown      (id, wp, lp, hWnd);       break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcRgbB(,,,)
    F-
    ߒlF-
    @\FRGB wiCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcRgbB(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idR;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idR = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:        RtRbPaint      (id, idR, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     RtRbSetFocus   (id, idR, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    RtRbKillFocus  (id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  RtRbLButtonDown(id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    RtRbLButtonUp  (id, idR, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      RtKeyDown      (id, wp, lp, hWnd);       break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcChkF(,,,)
    F-
    ߒlF-
    @\FCHECK FILLCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcChkF(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  RtEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   RtKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	
	res = rt[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  RtChSetCheck(id, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcChkO(,,,)
    F-
    ߒlF-
    @\FCHECK ONLYCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcChkO(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  RtEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   RtKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	
	res = rt[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  RtChSetCheck(id, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcChkE(,,,)
    F-
    ߒlF-
    @\FCHECK ELIPCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcChkE(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  RtEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   RtKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	
	res = rt[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  RtChSetCheck(id, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcChkL(,,,)
    F-
    ߒlF-
    @\FCHECK LCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcChkL(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  RtEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   RtKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	
	res = rt[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  RtChSetCheck(id, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FBTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  RtEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   RtKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return rt[id].pCallBtn[0](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FBTN CANCELCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  RtEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   RtKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return rt[id].pCallBtn[1](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcBtnApl(,,,)
    F-
    ߒlF-
    @\FBTN APPLYCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcBtnApl(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  RtEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   RtKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return rt[id].pCallBtn[2](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK RtWndProcPc(,,,)
    F-
    ߒlF-
    @\FPCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK RtWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        RtPcPaint      (id, wp, lp);  break;
	case WM_MOUSEMOVE:    RtPcMouseMove  (id, wp, lp);  break;
	case WM_LBUTTONDOWN:  RtPcLButtonDown(id, wp, lp);  break;
	case WM_LBUTTONUP:    RtPcLButtonUp  (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid RtSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_SIZECxg
------------------------------------------------------------------------------*/
void RtSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	
	if (fm[id].cntSkipEdit != 0) {fm[id].cntSkipEdit--;  return;}
	
	GetClientRect(rt[id].hWnd, &rc);
	a_SetWindowPos(rt[id].hPd[1], SZ_WEDIT3, PADD8, rc.right-SZ_WEDIT3-PADD8, rc.bottom-PADD8*2);
	
	RtSetPane(id);
	RtView(id);
	
	a_SetWindowPos(rt[id].hPc, rt[id].pc.x, rt[id].pc.y,
							   rt[id].pc.w, rt[id].pc.h);
	
	InvalidateRect(rt[id].hWnd,   NULL, TRUE);
	InvalidateRect(rt[id].hPd[1], NULL, TRUE);
	InvalidateRect(rt[id].hCn,    NULL, TRUE);
	InvalidateRect(rt[id].hPc,    NULL, FALSE);
	UpdateWindow(rt[id].hWnd);
	UpdateWindow(rt[id].hPd[1]);
	UpdateWindow(rt[id].hCn);
	UpdateWindow(rt[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid RtGetMinMaxInfo(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void RtGetMinMaxInfo(LONG id, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	INT32 w;
	INT32 h;
	
	w = SZ_WEDIT3+PADD8*3+GetSystemMetrics(SM_CYSIZEFRAME)*2;
	h = 404      +PADD8*2+GetSystemMetrics(SM_CYSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = w;
	mmi->ptMinTrackSize.y = h;
}

/*------------------------------------------------------------------------------
    Fvoid RtSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void RtSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(rt[id].tabStops[rt[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid RtKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FWM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void RtKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  RtKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    RtKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    RtKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_SP:     RtKeyDownSpace(id, wp, lp, hWnd);  break;
	case KEY_F5:     RtKeyDownF5   (id, wp, lp, hWnd);  break;
	case KEY_UP:
	case KEY_DW:     RtKeyDownUpDw (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid RtKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[enter]L[Cxg
------------------------------------------------------------------------------*/
void RtKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if      (hWnd == rt[id].hBtn[1]) {RtEnterCan(id);}
	else if (hWnd == rt[id].hBtn[2]) {RtEnterApl(id);}
	else                             {RtEnterOk(id);}
}

/*------------------------------------------------------------------------------
    Fvoid RtKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[esc]L[Cxg
------------------------------------------------------------------------------*/
void RtKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(rt[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid RtKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[tab]L[Cxg
------------------------------------------------------------------------------*/
void RtKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (rt[id].tabStopIdx == 0) {rt[id].tabStopIdx = TBSP_RECT-1;}
		else                        {rt[id].tabStopIdx--;}
	}
	else {
		rt[id].tabStopIdx = (rt[id].tabStopIdx + 1) % TBSP_RECT;
	}
	SetFocus(rt[id].tabStops[rt[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid RtKeyDownSpace(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[space]L[Cxg
------------------------------------------------------------------------------*/
void RtKeyDownSpace(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (hWnd == rt[id].hRgb[0]) {
		GetWindowText(rt[id].hEdit[4], buffRgb, 6+1);
		RbDialog(id, rt[id].hWnd, rt[id].hEdit[4], rt[id].hRgb[0], buffRgb);
	}
	else if (hWnd == rt[id].hRgb[1]) {
		GetWindowText(rt[id].hEdit[5], buffRgb, 6+1);
		RbDialog(id, rt[id].hWnd, rt[id].hEdit[5], rt[id].hRgb[1], buffRgb);
	}
}

/*------------------------------------------------------------------------------
    Fvoid RtKeyDownF5(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[F5]L[Cxg
------------------------------------------------------------------------------*/
void RtKeyDownF5(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	RtUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid RtKeyDownUpDw(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[][]L[Cxg
------------------------------------------------------------------------------*/
void RtKeyDownUpDw(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT16 tmp;
	UINT16 comb;
	BOOL shift;
	INT32 step;
	WCHAR text[5+1];
	INT32 val;
	INT32 limL;
	INT32 limH;
	
	comb  = 0x000;
	shift = FALSE;
	tmp = GetKeyState(KEY_CTRL);   if((tmp & 0x80)!=0){comb |= 0x100;}
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){comb |= 0x010;  shift = TRUE;}
	
	if ((hWnd != rt[id].hEdit[0]) &&
		(hWnd != rt[id].hEdit[1]) &&
		(hWnd != rt[id].hEdit[2]) &&
		(hWnd != rt[id].hEdit[3]) &&
		(hWnd != rt[id].hEdit[6]) &&
		(hWnd != rt[id].hEdit[7]))
	{
		return;
	}
	
	if      (comb == 0x000) {step = 1;}
	else if (comb == 0x100) {step = 10;}
	else if (comb == 0x010) {step = 100;}
	else                    {return;}
	
	GetWindowText(hWnd, text, 5+1);
	val = _wtoi(text);
	
	if      (hWnd == rt[id].hEdit[6]) {limL = 0;      limH = 99;}
	else if (hWnd == rt[id].hEdit[7]) {limL = 0;      limH = 999;}
	else                                  {limL = -9999;  limH = 9999;}
	
	if (wp == KEY_UP) {val += step;}
	else              {val -= step;}
	
	if (val < limL) {val = limL;}
	if (limH < val) {val = limH;}
	
	_itow(val, text, 10);
	SetWindowText(hWnd, text);
	EditSelAll(hWnd);
	RtUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid RtClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_CLOSECxg
------------------------------------------------------------------------------*/
void RtClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid RtDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_DESTROYCxg
------------------------------------------------------------------------------*/
void RtDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	RtTmpDelete(id);
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid RtPdCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_COMMANDCxg
------------------------------------------------------------------------------*/
void RtPdCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if      ((HWND)lp == rt[id].hBtn[0]) {RtEnterOk(id);}
	else if ((HWND)lp == rt[id].hBtn[1]) {RtEnterCan(id);}
	else if ((HWND)lp == rt[id].hBtn[2]) {RtEnterApl(id);}
}

/*------------------------------------------------------------------------------
    Fvoid RtPdPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPD WM_PAINTCxg
------------------------------------------------------------------------------*/
void RtPdPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1;
	INT32 x2, y2;
	INT32 x3, y3;
	INT32 x4, y4;
	INT32 x5, y5;
	INT32 x6, y6;
	
	hdc = BeginPaint(rt[id].hPd[0], &ps);
	GetClientRect(rt[id].hPd[0], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	a_TextOut(hdc, 67, 13, L"X");
	a_TextOut(hdc, 67, 43, L"Y");
	
	switch (g_idxLang) {
	case 0:
		x1 = 63;
		x2 = 59;
		x3 = 63;
		x4 = 56;
		x5 = 59;
		x6 = 63;
		break;
	case 1:
		x1 = 53;
		x2 = 53;
		x3 = 58;
		x4 = 57;
		x5 = 57;
		x6 = 51;
		break;
	default: break;
	}
	y1 = 73;
	y2 = 103;
	y3 = 133;
	y4 = 163;
	y5 = 193;
	y6 = 223;
	a_TextOut(hdc, x1, y1, TxEd(E_RTWIDTH));
	a_TextOut(hdc, x2, y2, TxEd(E_RTHEIGHT));
	a_TextOut(hdc, x3, y3, TxEd(E_RTFORE));
	a_TextOut(hdc, x4, y4, TxEd(E_RTBACK));
	a_TextOut(hdc, x5, y5, TxEd(E_RTTHICK));
	a_TextOut(hdc, x6, y6, TxEd(E_RTCORNER));
	
	SelectClipRgn(hdc, NULL);
	EndPaint(rt[id].hPd[0], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid RtEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FWM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void RtEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_RECT; i++) {
		if (hWnd == rt[id].tabStops[i]) {
			rt[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid RtEdKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FWM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void RtEdKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_RECT; i++) {
		if ((HWND)wp == rt[id].tabStops[i]) {
			RtUpdate(id);
			break;
		}
	}
}

/*------------------------------------------------------------------------------
    FBOOL RtEdChar(LONG, WPARAM, LPARAM, HWND )
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    ߒlFBOOL    -
    @\FWM_CHARCxg
------------------------------------------------------------------------------*/
BOOL RtEdChar(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if ((hWnd == rt[id].hEdit[0]) ||
		(hWnd == rt[id].hEdit[1]) ||
		(hWnd == rt[id].hEdit[2]) ||
		(hWnd == rt[id].hEdit[3]) ||
		(hWnd == rt[id].hEdit[6]) ||
		(hWnd == rt[id].hEdit[7]))
	{
		if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	}
	else if ((hWnd == rt[id].hEdit[4]) ||
			 (hWnd == rt[id].hEdit[5]))
	{
		if (((0x30 <= wp) && (wp <= 0x39)) ||  // 0-9
			((0x41 <= wp) && (wp <= 0x46)) ||  // a-f
			((0x61 <= wp) && (wp <= 0x66)))    // A-F
		{
			return TRUE;
		}
	}
	
	switch (wp) {
	case 0x03:  // ctrl+C
	case 0x08:  // back space
	case 0x16:  // ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid RtRbPaint(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_PAINTCxg
------------------------------------------------------------------------------*/
void RtRbPaint(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	RbBoxPaint(id, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid RtRbSetFocus(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void RtRbSetFocus(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_RECT; i++) {
		if ((HWND)wp == rt[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
	
	RtEdSetFocus(id, wp, lp, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid RtRbKillFocus(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void RtRbKillFocus(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_RECT; i++) {
		if ((HWND)wp == rt[id].tabStops[i]) {
			res = TRUE;
		}
	}
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid RtRbLButtonDown(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void RtRbLButtonDown(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	rt[id].flgClick[idR] = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid RtRbLButtonUp(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void RtRbLButtonUp(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (rt[id].flgClick[idR] == FALSE) {return;}
	rt[id].flgClick[idR] = FALSE;
	SetFocus(hWnd);
	
	GetWindowText(rt[id].hEdit[4+idR], buffRgb, 6+1);
	RbDialog(id, rt[id].hWnd, rt[id].hEdit[4+idR], rt[id].hRgb[idR], buffRgb);
}

/*------------------------------------------------------------------------------
    Fvoid RtChSetCheck(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FCHECK BM_SETCHECKCxg
------------------------------------------------------------------------------*/
void RtChSetCheck(LONG id, WPARAM wp, LPARAM lp)
{
	RtUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid RtPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_PAINTCxg
------------------------------------------------------------------------------*/
void RtPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1, w1, h1;
	INT32 x2, y2, w2, h2;
	INT32 mode;
	
	hdc = BeginPaint(rt[id].hPc, &ps);
	GetClientRect(rt[id].hPc, &rc);
	SetClipRgn(hdc, &rc);
	
	x2 = 0;
	y2 = 0;
	w2 = rt[id].pc.w;
	h2 = rt[id].pc.h;
	x1 = 0;
	y1 = 0;
	w1 = fm[id].pc[0].img.w;
	h1 = fm[id].pc[0].img.h;
	
	if (rt[id].pc.percent < 10000) {mode = HALFTONE;}
	else                           {mode = COLORONCOLOR;}
	
	memcpy(rt[id].pc.tmp.pB, fm[id].pc[0].img.pB, w1 * h1 * 4);
	
	RtTmpDraw(id);
	
	SetStretchBltMode(hdc, mode);
	StretchBlt(hdc,               x2, y2, w2, h2,
			   rt[id].pc.tmp.hdc, x1, y1, w1, h1, SRCCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w2;
	rc.bottom = h2;
	FrameRect(hdc, &rc, hBrGray);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(rt[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid RtPcMouseMove(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_MOUSEMOVECxg
------------------------------------------------------------------------------*/
void RtPcMouseMove(LONG id, WPARAM wp, LPARAM lp)
{
	INT16 x, y;
	RECT rc;
	
	x = LOWORD(lp);
	y = HIWORD(lp);
	
	GetClientRect(rt[id].hPc, &rc);
	if (x < rc.left)   {x = rc.left;}
	if (rc.right < x)  {x = rc.right;}
	if (y < rc.top)    {y = rc.top;}
	if (rc.bottom < y) {y = rc.bottom;}
	
	if ((wp & MK_LBUTTON) != 0) {RtMouse(id, x, y);}
	else                        {RtSetCursor(id, x, y);}
}

/*------------------------------------------------------------------------------
    Fvoid RtPcLButtonDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void RtPcLButtonDown(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 x, y;
	INT32 x1, y1, x2, y2;
	INT32 x1L, x1H;
	INT32 y1L, y1H;
	INT32 x2L, x2H;
	INT32 y2L, y2H;
	INT32 xBase;
	INT32 yBase;
	WCHAR buff[2][10+1];
	WCHAR text[5+1];
	
	x = LOWORD(lp);
	y = HIWORD(lp);
	
	SetCapture(rt[id].hPc);
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	x1 = (double)(rt[id].pc.x1     * rt[id].pc.w) / fm[id].pc[0].img.w;
	y1 = (double)(rt[id].pc.y1     * rt[id].pc.h) / fm[id].pc[0].img.h;
	x2 = (double)((rt[id].pc.x2+1) * rt[id].pc.w) / fm[id].pc[0].img.w;
	y2 = (double)((rt[id].pc.y2+1) * rt[id].pc.h) / fm[id].pc[0].img.h;
	x1L = x1-5;    x1H = x1+5;
	y1L = y1-5;    y1H = y1+5;
	x2L = x2-5;    x2H = x2+5;
	y2L = y2-5;    y2H = y2+5;
	
	rt[id].pc.flgsBorder = 0;
	if ((x2L<x) && (x<x2H)) {
		if      ((y2L<y) && (y<y2H)) {rt[id].pc.flgsBorder = BIT_EAST|BIT_SOUTH;}
		else if ((y1L<y) && (y<y1H)) {rt[id].pc.flgsBorder = BIT_EAST|BIT_NORTH;}
		else if ((y1L<y) && (y<y2H)) {rt[id].pc.flgsBorder = BIT_EAST;}
		else if ((y2L<y) && (y<y1H)) {rt[id].pc.flgsBorder = BIT_EAST;}
	}
	else if ((x1L<x) && (x<x1H)) {
		if      ((y2L<y) && (y<y2H)) {rt[id].pc.flgsBorder = BIT_WEST|BIT_SOUTH;}
		else if ((y1L<y) && (y<y1H)) {rt[id].pc.flgsBorder = BIT_WEST|BIT_NORTH;}
		else if ((y1L<y) && (y<y2H)) {rt[id].pc.flgsBorder = BIT_WEST;}
		else if ((y2L<y) && (y<y1H)) {rt[id].pc.flgsBorder = BIT_WEST;}
	}
	else if ((x1L<x) && (x<x2H)) {
		if      ((y2L<y) && (y<y2H)) {rt[id].pc.flgsBorder = BIT_SOUTH;}
		else if ((y1L<y) && (y<y1H)) {rt[id].pc.flgsBorder = BIT_NORTH;}
	}
	else if ((x2L<x) && (x<x1H)) {
		if      ((y2L<y) && (y<y2H)) {rt[id].pc.flgsBorder = BIT_SOUTH;}
		else if ((y1L<y) && (y<y1H)) {rt[id].pc.flgsBorder = BIT_NORTH;}
	}
	
	if(rt[id].pc.flgsBorder != 0x00000000) {
		rt[id].pc.flgClick = TRUE;
		RtSetCursor(id, x, y);
	}
	else {
		xBase = (double)(x * fm[id].pc[0].img.w) / rt[id].pc.w;
		yBase = (double)(y * fm[id].pc[0].img.h) / rt[id].pc.h;
		
		_itow(xBase, buff[0], 10);
		_itow(yBase, buff[1], 10);
		SetWindowText(rt[id].hEdit[0], buff[0]);
		SetWindowText(rt[id].hEdit[1], buff[1]);
		
		if (((rt[id].pc.x2 - rt[id].pc.x1) == 0) &&
			((rt[id].pc.y2 - rt[id].pc.y1) == 0))
		{
			_itow(1, text, 10);
			SetWindowText(rt[id].hEdit[2], text);
			SetWindowText(rt[id].hEdit[3], text);
		}
		RtUpdate(id);
	}
}

/*------------------------------------------------------------------------------
    Fvoid RtPcLButtonUp(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void RtPcLButtonUp(LONG id, WPARAM wp, LPARAM lp)
{
	ReleaseCapture();
	rt[id].pc.flgClick = FALSE;
}

/*------------------------------------------------------------------------------
    Fvoid RtEnterOk(LONG id)
    FLONG    FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void RtEnterOk(LONG id)
{
	WCHAR buffRgbF[6+1];
	WCHAR buffRgbB[6+1];
	WCHAR buffT   [2+1];
	WCHAR buffC   [3+1];
	INT32 checkedF;
	INT32 checkedO;
	INT32 checkedE;
	INT32 checkedL;
	
	RtUpdate(id);
	if (rt[id].flgUpdate == FALSE) {CLOSE(rt[id].hWnd);  return;}
	
	memcpy(fm[id].pc[0].img.pB, rt[id].pc.tmp.pB, fm[id].pc[0].img.w * fm[id].pc[0].img.h * 4);
	LiViewDelete(id, 0);
	
	InvalidateRect(fm[id].hPict[0], NULL, TRUE);
	UpdateWindow(fm[id].hPict[0]);
	
	fm[id].flgRect = TRUE;
	SetFormText(id);
	MnFlushFile(id);
	
	GetWindowText(rt[id].hEdit[4], buffRgbF, 6+1);
	GetWindowText(rt[id].hEdit[5], buffRgbB, 6+1);
	GetWindowText(rt[id].hEdit[6], buffT,    2+1);
	GetWindowText(rt[id].hEdit[7], buffC,    3+1);
	
	rt[id].fore = _wtoh(buffRgbF, 6);
	rt[id].back = _wtoh(buffRgbB, 6);
	rt[id].t    = _wtoi(buffT);
	rt[id].c    = _wtoi(buffC);
	
	checkedF = B_GETCHECK(rt[id].hChk[0]);
	checkedO = B_GETCHECK(rt[id].hChk[1]);
	checkedE = B_GETCHECK(rt[id].hChk[2]);
	checkedL = B_GETCHECK(rt[id].hChk[3]);
	if (checkedF == BST_CHECKED) {rt[id].fill=TRUE;}  else {rt[id].fill=FALSE;}
	if (checkedO == BST_CHECKED) {rt[id].only=TRUE;}  else {rt[id].only=FALSE;}
	if (checkedE == BST_CHECKED) {rt[id].elip=TRUE;}  else {rt[id].elip=FALSE;}
	if (checkedL == BST_CHECKED) {rt[id].l   =TRUE;}  else {rt[id].l   =FALSE;}
	
	RtStore(id);
	CLOSE(rt[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid RtEnterCan(LONG id)
    FLONG    FORM ID
    @\F[CANCEL]{^s
------------------------------------------------------------------------------*/
void RtEnterCan(LONG id)
{
	CLOSE(rt[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid RtEnterApl(LONG id)
    FLONG    FORM ID
    @\F[APPLY]{^s
------------------------------------------------------------------------------*/
void RtEnterApl(LONG id)
{
	WCHAR fmt[100] = L"%d\r\n"
					 L"%d\r\n"
					 L"%d\r\n"
					 L"%d\r\n"
					 L"%s\r\n"
					 L"%s\r\n"
					 L"%d\r\n"
					 L"%d\r\n"
					 L"%s\r\n"
					 L"%s\r\n"
					 L"%s\r\n"
					 L"%s\r\n";
	WCHAR str[100];
	WCHAR strFore[6+1];
	WCHAR strBack[6+1];
	WCHAR strFill[5+1];
	WCHAR strOnly[5+1];
	WCHAR strElip[5+1];
	WCHAR strL   [5+1];
	
	RtUpdate(id);
	memcpy(fm[id].pc[0].img.pB, rt[id].pc.tmp.pB, fm[id].pc[0].img.w * fm[id].pc[0].img.h * 4);
	LiViewDelete(id, 0);
	
	InvalidateRect(fm[id].hPict[0], NULL, TRUE);
	UpdateWindow(fm[id].hPict[0]);
	
	fm[id].flgRect = TRUE;
	SetFormText(id);
	
	_rtow(rt[id].fore, strFore);
	_rtow(rt[id].back, strBack);
	_btow(rt[id].fill, strFill);
	_btow(rt[id].only, strOnly);
	_btow(rt[id].elip, strElip);
	_btow(rt[id].l,    strL);
	
	swprintf(str, fmt, rt[id].x,
					   rt[id].y,
					   rt[id].w,
					   rt[id].h,
					   strFore,
					   strBack,
					   rt[id].t,
					   rt[id].c,
					   strFill,
					   strOnly,
					   strElip,
					   strL);
	MbDialog(id, rt[id].hWnd, str, TxEd(E_APPLY), MB_OK);
}

/*------------------------------------------------------------------------------
    Fvoid RtUpdate(LONG id)
    FLONG    FORM ID
    @\F`̕\XV
------------------------------------------------------------------------------*/
void RtUpdate(LONG id)
{
	WCHAR rcEditX[5+1];
	WCHAR rcEditY[5+1];
	WCHAR rcEditW[5+1];
	WCHAR rcEditH[5+1];
	WCHAR rcEditF[6+1];
	WCHAR rcEditB[6+1];
	WCHAR rcEditT[2+1];
	WCHAR rcEditC[3+1];
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	INT32 fore;
	INT32 back;
	INT32 c;
	INT32 t;
	INT32 checkedF;
	INT32 checkedO;
	INT32 checkedE;
	INT32 checkedL;
	BOOL  fill;
	BOOL  only;
	BOOL  elip;
	BOOL  l;
	
	GetWindowText(rt[id].hEdit[0], rcEditX, 5+1);
	GetWindowText(rt[id].hEdit[1], rcEditY, 5+1);
	GetWindowText(rt[id].hEdit[2], rcEditW, 5+1);
	GetWindowText(rt[id].hEdit[3], rcEditH, 5+1);
	GetWindowText(rt[id].hEdit[4], rcEditF, 6+1);
	GetWindowText(rt[id].hEdit[5], rcEditB, 6+1);
	GetWindowText(rt[id].hEdit[6], rcEditT, 2+1);
	GetWindowText(rt[id].hEdit[7], rcEditC, 3+1);
	
	x    = _wtoi(rcEditX);
	y    = _wtoi(rcEditY);
	w    = _wtoi(rcEditW);
	h    = _wtoi(rcEditH);
	fore = _wtoh(rcEditF, 6);
	back = _wtoh(rcEditB, 6);
	t    = _wtoi(rcEditT);
	c    = _wtoi(rcEditC);
	checkedF = B_GETCHECK(rt[id].hChk[0]);
	checkedO = B_GETCHECK(rt[id].hChk[1]);
	checkedE = B_GETCHECK(rt[id].hChk[2]);
	checkedL = B_GETCHECK(rt[id].hChk[3]);
	if (checkedF == BST_CHECKED) {fill=TRUE;}  else {fill=FALSE;}
	if (checkedO == BST_CHECKED) {only=TRUE;}  else {only=FALSE;}
	if (checkedE == BST_CHECKED) {elip=TRUE;}  else {elip=FALSE;}
	if (checkedL == BST_CHECKED) {l   =TRUE;}  else {l   =FALSE;}
	
	if ((x    != rt[id].x)    ||
		(y    != rt[id].y)    ||
		(w    != rt[id].w)    ||
		(h    != rt[id].h)    ||
		(fore != rt[id].fore) ||
		(back != rt[id].back) ||
		(t    != rt[id].t)    ||
		(c    != rt[id].c)    ||
		(fill != rt[id].fill) ||
		(only != rt[id].only) ||
		(elip != rt[id].elip) ||
		(l    != rt[id].l))
	{
		InvalidateRect(rt[id].hPc, NULL, FALSE);
		UpdateWindow  (rt[id].hPc);
		
		rt[id].flgUpdate = TRUE;
	}
	
	rt[id].x    = x;
	rt[id].y    = y;
	rt[id].w    = w;
	rt[id].h    = h;
	rt[id].fore = fore;
	rt[id].back = back;
	rt[id].t    = t;
	rt[id].c    = c;
	rt[id].fill = fill;
	rt[id].only = only;
	rt[id].elip = elip;
	rt[id].l    = l;
	
	rt[id].pc.x1 = x;
	rt[id].pc.y1 = y;
	rt[id].pc.x2 = x+w;
	rt[id].pc.y2 = y+h;
}

/*------------------------------------------------------------------------------
    Fvoid RtTmpCreate(LONG, INT32, INT32)
    FLONG     FORM ID
          INT32    
          INT32    
    @\F` ꎞC[W쐬
------------------------------------------------------------------------------*/
void RtTmpCreate(LONG id, INT32 w, INT32 h)
{
	ImageCreate(&rt[id].pc.tmp, w, h);
}

/*------------------------------------------------------------------------------
    Fvoid RtTmpDraw(LONG)
    FLONG     FORM ID
    @\F` ꎞC[W`
------------------------------------------------------------------------------*/
void RtTmpDraw(LONG id)
{
	HDC hdc;
	WCHAR buffX   [5+1];
	WCHAR buffY   [5+1];
	WCHAR buffW   [5+1];
	WCHAR buffH   [5+1];
	WCHAR buffRgbF[6+1];
	WCHAR buffRgbB[6+1];
	WCHAR buffT   [2+1];
	WCHAR buffC   [3+1];
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	INT32 rgbF;
	INT32 rgbB;
	INT32 rF, gF, bF;
	INT32 rB, gB, bB;
	INT32 c;
	INT32 t;
	INT32 checkedF;
	INT32 checkedO;
	INT32 checkedE;
	INT32 checkedL;
	BOOL  fill;
	BOOL  only;
	BOOL  elip;
	BOOL  l;
	HPEN   hPen;
	HBRUSH hBr;
	HPEN   hOld1;
	HBRUSH hOld2;
	RECT rc;
	
	GetWindowText(rt[id].hEdit[0], buffX,    5+1);
	GetWindowText(rt[id].hEdit[1], buffY,    5+1);
	GetWindowText(rt[id].hEdit[2], buffW,    5+1);
	GetWindowText(rt[id].hEdit[3], buffH,    5+1);
	GetWindowText(rt[id].hEdit[4], buffRgbF, 6+1);
	GetWindowText(rt[id].hEdit[5], buffRgbB, 6+1);
	GetWindowText(rt[id].hEdit[6], buffT,    2+1);
	GetWindowText(rt[id].hEdit[7], buffC,    3+1);
	x = _wtoi(buffX);
	y = _wtoi(buffY);
	w = _wtoi(buffW);
	h = _wtoi(buffH);
	
	rgbF = _wtoh(buffRgbF, 6);
	rgbB = _wtoh(buffRgbB, 6);
	rF = (rgbF & 0x00FF0000) >> 16;
	gF = (rgbF & 0x0000FF00) >> 8;
	bF = (rgbF & 0x000000FF) >> 0;
	rB = (rgbB & 0x00FF0000) >> 16;
	gB = (rgbB & 0x0000FF00) >> 8;
	bB = (rgbB & 0x000000FF) >> 0;
	
	checkedF = B_GETCHECK(rt[id].hChk[0]);
	checkedO = B_GETCHECK(rt[id].hChk[1]);
	checkedE = B_GETCHECK(rt[id].hChk[2]);
	checkedL = B_GETCHECK(rt[id].hChk[3]);
	if (checkedF == BST_CHECKED) {fill=TRUE;} else {fill=FALSE;}
	if (checkedO == BST_CHECKED) {only=TRUE;} else {only=FALSE;}
	if (checkedE == BST_CHECKED) {elip=TRUE;} else {elip=FALSE;}
	if (checkedL == BST_CHECKED) {l   =TRUE;} else {l   =FALSE;}
	
	t = _wtoi(buffT);
	c = _wtoi(buffC);
	
	hdc = rt[id].pc.tmp.hdc;
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = rt[id].pc.tmp.w;
	rc.bottom = rt[id].pc.tmp.h;
	SetClipRgn(hdc, &rc);
	
	if ((only == TRUE) && (l == FALSE)) {
		hPen = CreatePen(PS_SOLID, t, RGB(rB,gB,bB));
	}
	else {
		hPen = CreatePen(PS_SOLID, t, RGB(rF,gF,bF));
	}
	hOld1 = (HPEN)SelectObject(hdc, hPen);
	
	hBr   = CreateSolidBrush(RGB(rB,gB,bB));
	hOld2 = (HBRUSH)SelectObject(hdc, hBr);
	
	if (l == TRUE) {
		MoveToEx(hdc, x,   y, NULL);
		LineTo  (hdc, x,   y+h);
		LineTo  (hdc, x+w, y+h);
	}
	else if (elip == TRUE) {
		if      (only == TRUE)  {/*SelectObject(hdc, hPnNull);*/}
		else if (fill == FALSE) {SelectObject(hdc, hBrNull);}
		Ellipse(hdc, x, y, x+w, y+h);
	}
	else {
		if      (only == TRUE)  {/*SelectObject(hdc, hPnNull);*/}
		else if (fill == FALSE) {SelectObject(hdc, hBrNull);}
		
		if (c != 0) {
			RoundRect(hdc, x, y, x+w, y+h, c, c);
		}
		else {
			Rectangle(hdc, x, y, x+w, y+h);
		}
	}
	
	SelectObject(hdc, hOld1);
	SelectObject(hdc, hOld2);
	DeleteObject(hPen);
	DeleteObject(hBr);
	SelectClipRgn(hdc, NULL);
	
//	LOGBRUSH lbr;
//	lbr.lbStyle = BS_NULL;
//	lbr.lbColor = 0x000000;
//	lbr.lbHatch = NULL;
//	hBr = CreateBrushIndirect(&lbr);
//	hBr = CreateSolidBrush(NULL);
//	hBr = NULL;
	
//	rc.left   = x;
//	rc.top    = y;
//	rc.right  = x+w;
//	rc.bottom = y+h;
//	FrameRect(hdc, &rc, hBrBlack);		// pen
}

/*------------------------------------------------------------------------------
    Fvoid RtTmpDelete(LONG)
    FLONG     FORM ID
    @\F` ꎞC[W폜
------------------------------------------------------------------------------*/
void RtTmpDelete(LONG id)
{
	DeleteDC    (rt[id].pc.tmp.hdc);
	DeleteObject(rt[id].pc.tmp.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid RtSetCursor(LONG id, INT32, INT32)
    FLONG    FORM ID
          INT32   XW
          INT32   YW
    @\F` J[\ύX
------------------------------------------------------------------------------*/
void RtSetCursor(LONG id, INT32 x, INT32 y)
{
	INT32 x1, y1, x2, y2;
	INT32 x1L, x1H;
	INT32 y1L, y1H;
	INT32 x2L, x2H;
	INT32 y2L, y2H;
	HCURSOR hCur;
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	x1 = (double)(rt[id].pc.x1     * rt[id].pc.w) / fm[id].pc[0].img.w;
	y1 = (double)(rt[id].pc.y1     * rt[id].pc.h) / fm[id].pc[0].img.h;
	x2 = (double)((rt[id].pc.x2+1) * rt[id].pc.w) / fm[id].pc[0].img.w;
	y2 = (double)((rt[id].pc.y2+1) * rt[id].pc.h) / fm[id].pc[0].img.h;
	x1L = x1-5;    x1H = x1+5;
	y1L = y1-5;    y1H = y1+5;
	x2L = x2-5;    x2H = x2+5;
	y2L = y2-5;    y2H = y2+5;
	
	hCur = hCurArrow;
	if ((x2L<x) && (x<x2H)) {
		if      ((y2L<y) && (y<y2H)) {hCur = hCurSzNwse;}
		else if ((y1L<y) && (y<y1H)) {hCur = hCurSzNesw;}
		else if ((y1L<y) && (y<y2H)) {hCur = hCurSzWe;}
		else if ((y2L<y) && (y<y1H)) {hCur = hCurSzWe;}
	}
	else if ((x1L<x) && (x<x1H)) {
		if      ((y2L<y) && (y<y2H)) {hCur = hCurSzNesw;}
		else if ((y1L<y) && (y<y1H)) {hCur = hCurSzNwse;}
		else if ((y1L<y) && (y<y2H)) {hCur = hCurSzWe;}
		else if ((y2L<y) && (y<y1H)) {hCur = hCurSzWe;}
	}
	else if ((x1L<x) && (x<x2H)) {
		if      ((y2L<y) && (y<y2H)) {hCur = hCurSzNs;}
		else if ((y1L<y) && (y<y1H)) {hCur = hCurSzNs;}
	}
	else if ((x2L<x) && (x<x1H)) {
		if      ((y2L<y) && (y<y2H)) {hCur = hCurSzNs;}
		else if ((y1L<y) && (y<y1H)) {hCur = hCurSzNs;}
	}
	SetCursor(hCur);
	SetClassLong(rt[id].hPc, GCL_HCURSOR, (LONG)hCur);
}

/*------------------------------------------------------------------------------
    Fvoid RtMouse(LONG id, INT32, INT32)
    FLONG    FORM ID
          INT32   XW
          INT32   YW
    @\F` }EX
------------------------------------------------------------------------------*/
void RtMouse(LONG id, INT32 x, INT32 y)
{
	HWND hWnd;
	HWND hWnd1;
	HWND hWnd2;
	INT32 val;
	INT32 val1;
	INT32 val2;
	INT32 wImg;
	INT32 hImg;
	INT32 wRt;
	INT32 hRt;
	
	if (rt[id].pc.flgClick == FALSE) {return;}
	if (rt[id].pc.flgsBorder == 0)   {return;}
	
	wImg = fm[id].pc[0].img.w;
	hImg = fm[id].pc[0].img.h;
	wRt  = rt[id].pc.w;
	hRt  = rt[id].pc.h;
	TryZeroDivision(wRt);
	TryZeroDivision(hRt);
	x = ((double)x * wImg)/wRt;
	y = ((double)y * hImg)/hRt;
	
	if (IsBit(rt[id].pc.flgsBorder, BIT_NORTH)) {
		val1 = y;
		val2 = (rt[id].pc.y2 - rt[id].pc.y1) + (rt[id].pc.y1 - y);
		hWnd1 = rt[id].hEdit[1];
		hWnd2 = rt[id].hEdit[3];
		EditSetValue(hWnd1, val1);
		EditSetValue(hWnd2, val2);
	}
	
	if (IsBit(rt[id].pc.flgsBorder, BIT_WEST)) {
		val1 = x;
		val2 = (rt[id].pc.x2 - rt[id].pc.x1) + (rt[id].pc.x1 - x);
		hWnd1 = rt[id].hEdit[0];
		hWnd2 = rt[id].hEdit[2];
		EditSetValue(hWnd1, val1);
		EditSetValue(hWnd2, val2);
	}
	
	if (IsBit(rt[id].pc.flgsBorder, BIT_SOUTH)) {
		val = y - rt[id].pc.y1;
		hWnd = rt[id].hEdit[3];
		EditSetValue(hWnd, val);
	}
	
	if (IsBit(rt[id].pc.flgsBorder, BIT_EAST)) {
		val = x - rt[id].pc.x1;
		hWnd = rt[id].hEdit[2];
		EditSetValue(hWnd, val);
	}
	RtUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid RtView(LONG)
    FLONG    FORM ID
    @\F`̕ҏW\p
------------------------------------------------------------------------------*/
void RtView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	gainW = (double)rt[id].cn.w / fm[id].pc[0].img.w;
	gainH = (double)rt[id].cn.h / fm[id].pc[0].img.h;
	
	if ((1 < gainW) && (1 < gainH)) {
		gainW = gainH = (double)1;
	}
	else {
		if (CmpGain(gainW, gainH) == TRUE) {
			limW = TRUE;
			limH = TRUE;
		}
		else {
			if (gainW < gainH) {
				gainH = gainW;
				limW = TRUE;
			}
			else {
				gainW = gainH;
				limH = TRUE;
			}
		}
	}
	
	x = (double)rt[id].cn.w / 2 - (double)fm[id].pc[0].img.w * gainW / 2;
	y = (double)rt[id].cn.h / 2 - (double)fm[id].pc[0].img.h * gainH / 2;
	w = (double)fm[id].pc[0].img.w * gainW;
	h = (double)fm[id].pc[0].img.h * gainH;
	
	if (limW == TRUE) {x = 0;  w = rt[id].cn.w;}
	if (limH == TRUE) {y = 0;  h = rt[id].cn.h;}
	
	if (limW == TRUE) {TryZeroDivision(fm[id].pc[0].img.w);  rt[id].pc.percent = ((double)w / fm[id].pc[0].img.w) * 10000;}
	else              {TryZeroDivision(fm[id].pc[0].img.h);  rt[id].pc.percent = ((double)h / fm[id].pc[0].img.h) * 10000;}
	
	rt[id].pc.x = x;
	rt[id].pc.y = y;
	if (w <= 0) {rt[id].pc.w = 1;}
	else        {rt[id].pc.w = w;}
	if (h <= 0) {rt[id].pc.h = 1;}
	else        {rt[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    Fvoid RtSetPane(LONG)
    FLONG    FORM ID
    @\F`̕\̘g\
------------------------------------------------------------------------------*/
void RtSetPane(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(rt[id].hPd[1], &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	a_SetWindowPos(rt[id].hCn, PADD8, PADD8, w-PADD8*2, h-PADD8*2);
	
	GetClientRect(rt[id].hCn, &rc);
	rt[id].cn.x = rc.left;
	rt[id].cn.y = rc.top;
	rt[id].cn.w = rc.right - rc.left;
	rt[id].cn.h = rc.bottom - rc.top;
}
