/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define SK_CPP
#include "../common.h"
//  ShortCutKeyFV[gJbgL[

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 x;
	INT32 y;
	BOOL flgCtrl;
	BOOL flgShift;
	
	struct {
		INT32 x;
		INT32 y;
		INT32 w;
		INT32 h;
		INT32 xStr;
		INT32 fntSz;
		WCHAR str1[10];
		WCHAR str2[10];
		TRACKMOUSEEVENT tme;
		BOOL flgEnter;
		BOOL flgClick;
		INT32 flgsBk;
	} sb[CNT_SKEY];
	
	HWND hWnd;
	HWND hEdit[2];
	HWND hBrd;
	HWND hBtn[CNT_SKEY];
} sk;

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void SkInitClass(void);
void SkInit(void);
void SkInitSb(LONG,INT32,INT32,INT32,INT32,INT32,INT32,WCHAR *,WCHAR *);
void SkInst(void);
void SkDialog(void);
void SkLoad(void);
void SkStore(void);
void SkIfClose(void);
LRESULT CALLBACK SkWndProc   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK SkWndProcBtn(HWND, UINT, WPARAM, LPARAM);
void SkCreate     (WPARAM, LPARAM);
void SkKeyDown    (WPARAM, LPARAM);
void SkClose      (WPARAM, LPARAM);
void SkPaint      (LONG, WPARAM, LPARAM);
void SkLButtonDown(LONG, WPARAM, LPARAM);
void SkLButtonUp  (LONG, WPARAM, LPARAM);
void SkEraseBkGnd (LONG, WPARAM, LPARAM);
void SkMouseMove  (LONG, WPARAM, LPARAM);
void SkMouseLeave (LONG, WPARAM, LPARAM);
void SkGetColor(LONG, INT32 *, HBRUSH *);
BOOL SkIsCtrl (LONG);
BOOL SkIsShift(LONG);

/*------------------------------------------------------------------------------
    Fvoid SkInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void SkInitClass(void)
{
	WNDCLASS wcSkey;
	WNDCLASS wcSkeybrd;
	WNDCLASS wcSkeybtn;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrWhite, NM_SKEY,   &wcSkey);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrBrGray,NM_SKEYBRD,&wcSkeybrd);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_SKEYBTN,&wcSkeybtn);
	
	RegisterClass(&wcSkey);
	RegisterClass(&wcSkeybrd);
	RegisterClass(&wcSkeybtn);
}

/*------------------------------------------------------------------------------
    Fvoid SkInit(void)
    @\FV[gJbgL[ 
------------------------------------------------------------------------------*/
void SkInit(void)
{
	INT32 i;
	
	sk.x        = 0;
	sk.y        = 0;
	sk.flgCtrl  = FALSE;
	sk.flgShift = FALSE;
	
	i = 0;
	SkInitSb(i,10,        10,  45,20, 2,FONT_SIZE12,(WCHAR *)L"esc",   (WCHAR *)L"");       i++;
	SkInitSb(i,65+35* 0,  10,  30,20, 2,FONT_SIZE10,(WCHAR *)L"F1",    (WCHAR *)L"");       i++;
	SkInitSb(i,65+35* 1,  10,  30,20, 2,FONT_SIZE10,(WCHAR *)L"F2",    (WCHAR *)L"");       i++;
	SkInitSb(i,65+35* 2,  10,  30,20, 2,FONT_SIZE10,(WCHAR *)L"F3",    (WCHAR *)L"");       i++;
	SkInitSb(i,65+35* 3,  10,  30,20, 2,FONT_SIZE10,(WCHAR *)L"F4",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+35* 4,  10,  30,20, 2,FONT_SIZE10,(WCHAR *)L"F5",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+35* 5,  10,  30,20, 2,FONT_SIZE10,(WCHAR *)L"F6",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+35* 6,  10,  30,20, 2,FONT_SIZE10,(WCHAR *)L"F7",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+35* 7,  10,  30,20, 2,FONT_SIZE10,(WCHAR *)L"F8",    (WCHAR *)L"");       i++;
	SkInitSb(i,75+35* 8,  10,  30,20, 2,FONT_SIZE10,(WCHAR *)L"F9",    (WCHAR *)L"");       i++;
	SkInitSb(i,75+35* 9,  10,  30,20, 2,FONT_SIZE10,(WCHAR *)L"F10",   (WCHAR *)L"");       i++;
	SkInitSb(i,75+35*10,  10,  30,20, 2,FONT_SIZE10,(WCHAR *)L"F11",   (WCHAR *)L"");       i++;
	SkInitSb(i,75+35*11,  10,  30,20, 2,FONT_SIZE10,(WCHAR *)L"F12",   (WCHAR *)L"");       i++;
	SkInitSb(i,500+35* 0, 10,  30,20, 3,FONT_SIZE10,(WCHAR *)L"scroll",(WCHAR *)L"");       i++;
	SkInitSb(i,500+35* 1, 10,  30,20, 3,FONT_SIZE10,(WCHAR *)L"pause", (WCHAR *)L"");       i++;
	SkInitSb(i,500+35* 2, 10,  30,20, 3,FONT_SIZE10,(WCHAR *)L"insert",(WCHAR *)L"");       i++;
	SkInitSb(i,500+35* 3, 10,  30,20, 3,FONT_SIZE10,(WCHAR *)L"delete",(WCHAR *)L"");       i++;
	SkInitSb(i,10,        35,  35,35, 3,FONT_SIZE20,(WCHAR *)L"",      (WCHAR *)L"");       i++;
	SkInitSb(i,50+40* 0,  35,  35,35, 4,FONT_SIZE20,(WCHAR *)L"P",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40* 1,  35,  35,35, 4,FONT_SIZE20,(WCHAR *)L"Q",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40* 2,  35,  35,35, 4,FONT_SIZE20,(WCHAR *)L"R",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40* 3,  35,  35,35, 4,FONT_SIZE20,(WCHAR *)L"S",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40* 4,  35,  35,35, 4,FONT_SIZE20,(WCHAR *)L"T",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40* 5,  35,  35,35, 4,FONT_SIZE20,(WCHAR *)L"U",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40* 6,  35,  35,35, 4,FONT_SIZE20,(WCHAR *)L"V",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40* 7,  35,  35,35, 4,FONT_SIZE20,(WCHAR *)L"W",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40* 8,  35,  35,35, 4,FONT_SIZE20,(WCHAR *)L"X",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40* 9,  35,  35,35, 4,FONT_SIZE20,(WCHAR *)L"O",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40*10,  35,  35,35, 3,FONT_SIZE20,(WCHAR *)L"|",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40*11,  35,  35,35, 5,FONT_SIZE20,(WCHAR *)L"O",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40*12,  35,  35,35, 2,FONT_SIZE20,(WCHAR *)L"",    (WCHAR *)L"");       i++;
	SkInitSb(i,50+40*13,  35,  35,35, 2,FONT_SIZE12,(WCHAR *)L"back",  (WCHAR *)L"space");  i++;
	SkInitSb(i,10,        75,  55,35, 2,FONT_SIZE12,(WCHAR *)L"tab",   (WCHAR *)L"");       i++;
	SkInitSb(i,70+40* 0,  75,  35,35, 4,FONT_SIZE20,(WCHAR *)L"p",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+40* 1,  75,  35,35, 4,FONT_SIZE20,(WCHAR *)L"v",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+40* 2,  75,  35,35, 4,FONT_SIZE20,(WCHAR *)L"d",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+40* 3,  75,  35,35, 4,FONT_SIZE20,(WCHAR *)L"q",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+40* 4,  75,  35,35, 4,FONT_SIZE20,(WCHAR *)L"s",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+40* 5,  75,  35,35, 4,FONT_SIZE20,(WCHAR *)L"x",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+40* 6,  75,  35,35, 4,FONT_SIZE20,(WCHAR *)L"t",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+40* 7,  75,  35,35, 4,FONT_SIZE20,(WCHAR *)L"h",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+40* 8,  75,  35,35, 4,FONT_SIZE20,(WCHAR *)L"n",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+40* 9,  75,  35,35, 4,FONT_SIZE20,(WCHAR *)L"o",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+40*10,  75,  35,35, 3,FONT_SIZE20,(WCHAR *)L"",    (WCHAR *)L"");       i++;
	SkInitSb(i,70+40*11,  75,  35,35, 4,FONT_SIZE20,(WCHAR *)L"m",    (WCHAR *)L"");       i++;
	SkInitSb(i,10,       115,  63,35, 2,FONT_SIZE20,(WCHAR *)L"",      (WCHAR *)L"");       i++;
	SkInitSb(i,78+40* 0, 115,  35,35, 4,FONT_SIZE20,(WCHAR *)L"`",    (WCHAR *)L"");       i++;
	SkInitSb(i,78+40* 1, 115,  35,35, 4,FONT_SIZE20,(WCHAR *)L"r",    (WCHAR *)L"");       i++;
	SkInitSb(i,78+40* 2, 115,  35,35, 4,FONT_SIZE20,(WCHAR *)L"c",    (WCHAR *)L"");       i++;
	SkInitSb(i,78+40* 3, 115,  35,35, 4,FONT_SIZE20,(WCHAR *)L"e",    (WCHAR *)L"");       i++;
	SkInitSb(i,78+40* 4, 115,  35,35, 4,FONT_SIZE20,(WCHAR *)L"f",    (WCHAR *)L"");       i++;
	SkInitSb(i,78+40* 5, 115,  35,35, 4,FONT_SIZE20,(WCHAR *)L"g",    (WCHAR *)L"");       i++;
	SkInitSb(i,78+40* 6, 115,  35,35, 4,FONT_SIZE20,(WCHAR *)L"i",    (WCHAR *)L"");       i++;
	SkInitSb(i,78+40* 7, 115,  35,35, 4,FONT_SIZE20,(WCHAR *)L"j",    (WCHAR *)L"");       i++;
	SkInitSb(i,78+40* 8, 115,  35,35, 4,FONT_SIZE20,(WCHAR *)L"k",    (WCHAR *)L"");       i++;
	SkInitSb(i,78+40* 9, 115,  35,35, 5,FONT_SIZE20,(WCHAR *)L"G",    (WCHAR *)L"");       i++;
	SkInitSb(i,78+40*10, 115,  35,35, 5,FONT_SIZE20,(WCHAR *)L"F",    (WCHAR *)L"");       i++;
	SkInitSb(i,78+40*11, 115,  35,35, 5,FONT_SIZE20,(WCHAR *)L"n",    (WCHAR *)L"");       i++;
	SkInitSb(i,10,       155,  73,35, 2,FONT_SIZE12,(WCHAR *)L"shift", (WCHAR *)L"");       i++;
	SkInitSb(i,88+40* 0, 155,  35,35, 4,FONT_SIZE20,(WCHAR *)L"y",    (WCHAR *)L"");       i++;
	SkInitSb(i,88+40* 1, 155,  35,35, 4,FONT_SIZE20,(WCHAR *)L"w",    (WCHAR *)L"");       i++;
	SkInitSb(i,88+40* 2, 155,  35,35, 4,FONT_SIZE20,(WCHAR *)L"b",    (WCHAR *)L"");       i++;
	SkInitSb(i,88+40* 3, 155,  35,35, 4,FONT_SIZE20,(WCHAR *)L"u",    (WCHAR *)L"");       i++;
	SkInitSb(i,88+40* 4, 155,  35,35, 4,FONT_SIZE20,(WCHAR *)L"a",    (WCHAR *)L"");       i++;
	SkInitSb(i,88+40* 5, 155,  35,35, 4,FONT_SIZE20,(WCHAR *)L"m",    (WCHAR *)L"");       i++;
	SkInitSb(i,88+40* 6, 155,  35,35, 4,FONT_SIZE20,(WCHAR *)L"l",    (WCHAR *)L"");       i++;
	SkInitSb(i,88+40* 7, 155,  35,35, 5,FONT_SIZE20,(WCHAR *)L"C",    (WCHAR *)L"");       i++;
	SkInitSb(i,88+40* 8, 155,  35,35, 5,FONT_SIZE20,(WCHAR *)L"D",    (WCHAR *)L"");       i++;
	SkInitSb(i,88+40* 9, 155,  35,35, 2,FONT_SIZE20,(WCHAR *)L"^",    (WCHAR *)L"");       i++;
	SkInitSb(i,88+40*10, 155,  35,35, 2,FONT_SIZE20,(WCHAR *)L"",      (WCHAR *)L"");       i++;
	SkInitSb(i,88+40*11, 155,  35,35, 2,FONT_SIZE12,(WCHAR *)L"shift", (WCHAR *)L"");       i++;
	SkInitSb(i, 10,      195,  40,35, 2,FONT_SIZE12,(WCHAR *)L"ctrl",  (WCHAR *)L"");       i++;
	SkInitSb(i, 55,      195,  30,35, 2,FONT_SIZE12,(WCHAR *)L"",      (WCHAR *)L"");       i++;
	SkInitSb(i, 90,      195,  30,35, 2,FONT_SIZE12,(WCHAR *)L"",      (WCHAR *)L"");       i++;
	SkInitSb(i,125,      195,  35,35, 2,FONT_SIZE12,(WCHAR *)L"",      (WCHAR *)L"");       i++;
	SkInitSb(i,165,      195,  35,35, 2,FONT_SIZE12,(WCHAR *)L"",      (WCHAR *)L"");       i++;
	SkInitSb(i,205,      195, 125,35, 3,FONT_SIZE16,(WCHAR *)L"space", (WCHAR *)L"");       i++;
	SkInitSb(i,335,      195,  35,35, 2,FONT_SIZE12,(WCHAR *)L"",      (WCHAR *)L"");       i++;
	SkInitSb(i,375,      195,  35,35, 2,FONT_SIZE12,(WCHAR *)L"",      (WCHAR *)L"");       i++;
	SkInitSb(i,415,      195,  30,35, 2,FONT_SIZE12,(WCHAR *)L"",      (WCHAR *)L"");       i++;
	SkInitSb(i,450,      195,  30,35, 2,FONT_SIZE12,(WCHAR *)L"app",   (WCHAR *)L"");       i++;
	SkInitSb(i,485,      195,  30,35, 2,FONT_SIZE12,(WCHAR *)L"ctrl",  (WCHAR *)L"");       i++;
	SkInitSb(i,610,       35,  35,35, 2,FONT_SIZE12,(WCHAR *)L"home",  (WCHAR *)L"");       i++;
	SkInitSb(i,610,       75,  35,35, 2,FONT_SIZE12,(WCHAR *)L"pg up", (WCHAR *)L"");       i++;
	SkInitSb(i,610,      115,  35,35, 2,FONT_SIZE12,(WCHAR *)L"pg dw", (WCHAR *)L"");       i++;
	SkInitSb(i,610,      155,  35,35, 2,FONT_SIZE12,(WCHAR *)L"end",   (WCHAR *)L"");       i++;
	SkInitSb(i,568,      155,  35,35,12,FONT_SIZE20,(WCHAR *)L"",    (WCHAR *)L"");       i++;
	SkInitSb(i,528,      195,  35,35, 5,FONT_SIZE20,(WCHAR *)L"",    (WCHAR *)L"");       i++;
	SkInitSb(i,568,      195,  35,35,12,FONT_SIZE20,(WCHAR *)L"",    (WCHAR *)L"");       i++;
	SkInitSb(i,608,      195,  35,35, 5,FONT_SIZE20,(WCHAR *)L"",    (WCHAR *)L"");       i++;
	SkInitSb(i,558,       75,  47,75, 3,FONT_SIZE16,(WCHAR *)L"enter", (WCHAR *)L"");       i++;
	
	sk.hWnd = NULL;
	for (i = 0; i <2; i++) {sk.hEdit[i] = NULL;}
	sk.hBrd = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid SkInitSb()
    F-
    @\FV[gJbgL[  L[
------------------------------------------------------------------------------*/
void SkInitSb(LONG id,INT32 x,INT32 y,INT32 w,INT32 h,INT32 xStr,INT32 fntSz,WCHAR *str1,WCHAR *str2)
{
	sk.sb[id].x     = x;
	sk.sb[id].y     = y;
	sk.sb[id].w     = w;
	sk.sb[id].h     = h;
	sk.sb[id].xStr  = xStr;
	sk.sb[id].fntSz = fntSz;
	wcscpy(sk.sb[id].str1, str1);
	wcscpy(sk.sb[id].str2, str2);
	
	sk.sb[id].flgEnter = FALSE;
	sk.sb[id].flgClick = FALSE;
	sk.sb[id].flgsBk   = 0x00000000;
	InitTme(&sk.sb[id].tme, sk.hBtn[id]);
}

/*------------------------------------------------------------------------------
    Fvoid SkInst(void)
    @\FSKEỶ
------------------------------------------------------------------------------*/
void SkInst(void)
{
	DWORD styleSk  = WS_CAPTION|WS_MINIMIZEBOX|WS_SYSMENU;
	DWORD styleSb  = WS_CHILD|WS_BORDER|WS_CLIPCHILDREN;
	DWORD styleEd1 = WS_CHILD|WS_BORDER|ES_LEFT|ES_MULTILINE|ES_AUTOHSCROLL|ES_NOHIDESEL|WS_VSCROLL;
	DWORD styleEd2 = WS_CHILD|WS_BORDER|ES_LEFT|ES_MULTILINE|ES_AUTOHSCROLL|ES_NOHIDESEL;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|WS_BORDER;
	INT32 i;
	
	sk.hWnd     = a_CreateWindow(NM_SKEY,   TxTl(E_TTLSHK),styleSk, 0,0,0,0,NULL);
	sk.hEdit[0] = a_CreateWindow(L"Edit",   TxSc1(),       styleEd1,0,0,0,0,sk.hWnd);
	sk.hEdit[1] = a_CreateWindow(L"Edit",   L"",           styleEd2,0,0,0,0,sk.hWnd);
	sk.hBrd     = a_CreateWindow(NM_SKEYBRD,L"",           styleSb, 0,0,0,0,sk.hWnd);
	SetWindowLong(sk.hWnd,  GWL_WNDPROC, (LONG)SkWndProc);
	
	for (i = 0; i < CNT_SKEY; i++) {
		sk.hBtn[i] = a_CreateWindow(NM_SKEYBTN, L"", styleBt, sk.sb[i].x, sk.sb[i].y, sk.sb[i].w, sk.sb[i].h, sk.hBrd);
		
		SetWindowLong(sk.hBtn[i], GWL_USERDATA, i);
		SetWindowLong(sk.hBtn[i], GWL_WNDPROC, (LONG)SkWndProcBtn);
	}
	E_SETFONT(sk.hEdit[0], hFtMsGothic);
	E_SETFONT(sk.hEdit[1], hFtMsGothic);
}

/*------------------------------------------------------------------------------
    Fvoid SkDialog(void)
    @\F_CAO
------------------------------------------------------------------------------*/
void SkDialog(void)
{
	WINDOWPLACEMENT plcm;
	RECT rc;
	
	if (sk.hWnd != NULL) {SetForegroundWindow(sk.hWnd);  return;}
	
	SkInit();
	SkLoad();
	SkInst();
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = sk.x;
	plcm.rcNormalPosition.top    = sk.y;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + 1000;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + 470;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(sk.hWnd, &plcm);
	
	GetClientRect(sk.hWnd, &rc);
	a_SetWindowPos(sk.hBrd, rc.right-655-5, rc.bottom-240-5, 655, 240);
	ShowWindow(sk.hBrd, 0x1);
	
	a_SetWindowPos(sk.hEdit[0], 5, 5, rc.right-655-15, rc.bottom - rc.top-10);
	ShowWindow(sk.hEdit[0], 0x1);
	
	a_SetWindowPos(sk.hEdit[1], rc.right-655-5, 5, 655, rc.bottom - 240-15);
	ShowWindow(sk.hEdit[1], 0x1);
}

/*------------------------------------------------------------------------------
    Fvoid SkLoad(void)
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void SkLoad(void)
{
	sk.x = g_skX;
	sk.y = g_skY;
}

/*------------------------------------------------------------------------------
    Fvoid SkStore(void)
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void SkStore(void)
{
	g_skX = sk.x;
	g_skY = sk.y;
}

/*------------------------------------------------------------------------------
    Fvoid SkIfClose(void)
    @\FJĂ
------------------------------------------------------------------------------*/
void SkIfClose(void)
{
	if (sk.hWnd != NULL) {CLOSE(sk.hWnd);}
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK SkWndProc(,,,)
    F-
    ߒlF-
    @\FSKEYCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK SkWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg) {
	case WM_CREATE:   SkCreate (wp, lp);  break;
	case WM_KEYDOWN:  SkKeyDown(wp, lp);  break;
	case WM_CLOSE:    SkClose  (wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK SkWndProcBtn(,,,)
    F-
    ߒlF-
    @\FSKEYBTNCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK SkWndProcBtn(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_KEYDOWN:      SkKeyDown    (wp, lp);      break;
	case WM_PAINT:        SkPaint      (id, wp, lp);  break;
	case WM_LBUTTONDOWN:  SkLButtonDown(id, wp, lp);  break;
	case WM_LBUTTONUP:    SkLButtonUp  (id, wp, lp);  break;
	case WM_ERASEBKGND:   SkEraseBkGnd (id, wp, lp);  break;
	case WM_MOUSEMOVE:    SkMouseMove  (id, wp, lp);  break;
	case WM_MOUSELEAVE:   SkMouseLeave (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid SkCreate(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FSKEYBTN WM_CREATECxg
------------------------------------------------------------------------------*/
void SkCreate(WPARAM wp, LPARAM lp)
{
	sk.flgCtrl  = FALSE;
	sk.flgShift = FALSE;
}

/*------------------------------------------------------------------------------
    Fvoid SkKeyDown(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FSKEYBTN WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void SkKeyDown(WPARAM wp, LPARAM lp)
{
	if (wp == KEY_ESC) {CLOSE(sk.hWnd);}
}

/*------------------------------------------------------------------------------
    Fvoid SkClose(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FSKEYBTN WM_CLOSECxg
------------------------------------------------------------------------------*/
void SkClose(WPARAM wp, LPARAM lp)
{
	RECT rc;
	
	GetWindowRect(sk.hWnd, &rc);
	sk.x = rc.left;
	sk.y = rc.top;
	SkStore();
	sk.hWnd = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid SkPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSKEYBTN WM_PAINTCxg
------------------------------------------------------------------------------*/
void SkPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	HFONT pFont = NULL;
	WCHAR *pStr1;
	WCHAR *pStr2;
	HPEN hPen;
	INT32 color;
	HBRUSH hbr;
	INT32 x;
	RECT rc;
	
	hdc = BeginPaint(sk.hBtn[id], &ps);
	GetClientRect(sk.hBtn[id], &rc);
	SetClipRgn(hdc, &rc);
	
	pStr1 = sk.sb[id].str1;
	pStr2 = sk.sb[id].str2;
	
	switch (sk.sb[id].fntSz) {
	case FONT_SIZE10: pFont = hFtArial10; break;
	case FONT_SIZE12: pFont = hFtArial12; break;
	case FONT_SIZE16: pFont = hFtArial16; break;
	case FONT_SIZE20: pFont = hFtArial20; break;
	default: break;
	}
	
	x = sk.sb[id].xStr;
	
	SelectObject(hdc, pFont);
	SetBkMode(hdc, TRANSPARENT);
	
	SkGetColor(id, &color, &hbr);
	
	if (id == 69) {
		hPen = CreatePen(PS_SOLID, 1, color);
		SelectObject(hdc, hPen);
		MoveToEx(hdc, 4, 2, NULL);
		LineTo(hdc, 11, 17);
		DeleteObject(hPen);
	}
	else {
		SetTextColor(hdc, color);
		a_TextOut(hdc, x, 1, pStr1);
		if (pStr2 != NULL) {
			a_TextOut(hdc, x, 1+sk.sb[id].fntSz+1, pStr2);
		}
	}
	
	SelectClipRgn(hdc, NULL);
	EndPaint(sk.hBtn[id], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid SkLButtonDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSKEYBTN WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void SkLButtonDown(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(sk.hBtn[id]);
	sk.sb[id].flgsBk |= BIT_PUSH;
	sk.sb[id].flgClick = TRUE;
	InvalidateRect(sk.hBtn[id], NULL, TRUE);
}

/*------------------------------------------------------------------------------
    Fvoid SkLButtonUp(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSKEYBTN WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void SkLButtonUp(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 i;
	const WCHAR *pStr;
	
	sk.sb[id].flgsBk &= ~BIT_PUSH;
	if (sk.sb[id].flgClick == TRUE) {
		if (sk.flgCtrl == TRUE) {
			if (sk.flgShift == TRUE) {pStr = TxSc2(id,3);}
			else                     {pStr = TxSc2(id,1);}
		}
		else {
			if (sk.flgShift == TRUE) {pStr = TxSc2(id,2);}
			else                     {pStr = TxSc2(id,0);}
		}
		
//		if (wcslen(pStr) == 0) {MessageBeep(MB_ICONERROR);}
		SetWindowText(sk.hEdit[1], pStr);
		
		if (SkIsCtrl(id)) {
			if (sk.flgCtrl == FALSE) {sk.flgCtrl = TRUE;}
			else                     {sk.flgCtrl = FALSE;}
			for (i = 0; i < CNT_SKEY; i++) {InvalidateRect(sk.hBtn[i], NULL, TRUE);}
		}
		else if (SkIsShift(id)) {
			if (sk.flgShift == FALSE) {sk.flgShift = TRUE;}
			else                      {sk.flgShift = FALSE;}
			for (i = 0; i < CNT_SKEY; i++) {InvalidateRect(sk.hBtn[i], NULL, TRUE);}
		}
	}
	InvalidateRect(sk.hBtn[id], NULL, TRUE);
}

/*------------------------------------------------------------------------------
    Fvoid SkEraseBkGnd(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSKEYBTN WM_ERASEBKGNDCxg
------------------------------------------------------------------------------*/
void SkEraseBkGnd(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 color;
	HBRUSH hbr;
	
	SkGetColor(id, &color, &hbr);
	SetClassLong(sk.hBtn[id], GCL_HBRBACKGROUND, (LONG)hbr);
}

/*------------------------------------------------------------------------------
    Fvoid SkMouseMove(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSKEYBTN WM_MOUSEMOVECxg
------------------------------------------------------------------------------*/
void SkMouseMove(LONG id, WPARAM wp, LPARAM lp)
{
	if (sk.sb[id].flgEnter == FALSE) {
		sk.sb[id].flgEnter = TRUE;
		
		sk.sb[id].flgsBk |= BIT_HOVER;
		InvalidateRect(sk.hBtn[id], NULL, TRUE);
		
		InitTme(&sk.sb[id].tme, sk.hBtn[id]);
		_TrackMouseEvent(&sk.sb[id].tme);
	}
}

/*------------------------------------------------------------------------------
    Fvoid SkMouseLeave(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSKEYBTN WM_MOUSELEAVECxg
------------------------------------------------------------------------------*/
void SkMouseLeave(LONG id, WPARAM wp, LPARAM lp)
{
	sk.sb[id].flgEnter = FALSE;
	sk.sb[id].flgClick = FALSE;
	
	sk.sb[id].flgsBk = 0x00000000;
	InvalidateRect(sk.hBtn[id], NULL, TRUE);
}

/*------------------------------------------------------------------------------
    Fvoid SkGetColor(LONG, INT32 *, HBRUSH *)
    FLONG      
          INT32 *   OiF
	      HBRUSH *  wiF
    @\FL[̑OiFAwiF
------------------------------------------------------------------------------*/
void SkGetColor(LONG id, INT32 *pFore, HBRUSH *pBack)
{
	if (IsBit(sk.sb[id].flgsBk, BIT_PUSH)) {
		*pFore = RGB_DPGRAY;
		*pBack = hBrGray;
	}
	else if (IsBit(sk.sb[id].flgsBk, BIT_HOVER)) {
		*pFore = RGB_DPGRAY;
		*pBack = hBrSkyBlue;
	}
	else if (SkIsCtrl(id)) {
		if (sk.flgCtrl == TRUE) {*pFore = RGB_LTGRAY;  *pBack = hBrBlack;}
		else                    {*pFore = RGB_LTGRAY;  *pBack = hBrDpBlue;}
	}
	else if (SkIsShift(id)) {
		if (sk.flgShift == TRUE) {*pFore = RGB_LTGRAY;  *pBack = hBrBlack;}
		else                     {*pFore = RGB_LTGRAY;  *pBack = hBrDpBlue;}
	}
	else if (((sk.flgCtrl == TRUE)  && (sk.flgShift == TRUE)  && (wcslen(TxSc2(id,3)) != 0)) ||
			 ((sk.flgCtrl == TRUE)  && (sk.flgShift == FALSE) && (wcslen(TxSc2(id,1)) != 0)) ||
			 ((sk.flgCtrl == FALSE) && (sk.flgShift == TRUE)  && (wcslen(TxSc2(id,2)) != 0)) ||
			 ((sk.flgCtrl == FALSE) && (sk.flgShift == FALSE) && (wcslen(TxSc2(id,0)) != 0))) {
		*pFore = RGB_LTGRAY;
		*pBack = hBrDpBlue;
	}
	else {
		*pFore = RGB_DPGRAY;
		*pBack = hBrWhite;
	}
}

/*------------------------------------------------------------------------------
    FBOOL SkIsCtrl(LONG)
    FLONG    
    ߒlFBOOL    -
    @\F[ctrl]L[ǂ
------------------------------------------------------------------------------*/
BOOL SkIsCtrl(LONG id)
{
	if ((id == 71) || (id == 81)) {return TRUE;}
	else                          {return FALSE;}
}

/*------------------------------------------------------------------------------
    FBOOL SkIsShift(LONG)
    FLONG    
    ߒlFBOOL    -
    @\F[shift]L[ǂ
------------------------------------------------------------------------------*/
BOOL SkIsShift(LONG id)
{
	if ((id == 58) || (id == 70)) {return TRUE;}
	else                          {return FALSE;}
}
