/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define SW_CPP
#include "../common.h"
//  SwapFu

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 src;
	INT32 dst;
	
	BOOL flgClick[2];
	INT32 tabStopIdx;
	HWND tabStops[TBSP_SWAP];
	
	HWND hWnd;
	HWND hEdit[2];
	HWND hRgb[2];
	HWND hBtn;
	
	LRESULT (CALLBACK *pCallEdit[2]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn)     (HWND,UINT,WPARAM,LPARAM);
} sw[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void SwInitClass(void);
void SwInit(LONG);
void SwInst(LONG);
void SwDialog(LONG);
void SwLoad(LONG);
void SwStore(LONG);
LRESULT CALLBACK WndProcSwap     (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK WndProcSwapEditS(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK WndProcSwapEditD(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK WndProcSwapRgbS (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK WndProcSwapRgbD (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK WndProcSwapBtn  (HWND, UINT, WPARAM, LPARAM);
void SwPaint        (LONG, WPARAM, LPARAM);
void SwCommand      (LONG, WPARAM, LPARAM);
void SwSetFocus     (LONG, WPARAM, LPARAM);
void SwKeyDown      (LONG, WPARAM, LPARAM, HWND);
void SwKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void SwKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void SwKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void SwKeyDownSpace (LONG, WPARAM, LPARAM, HWND);
void SwClose        (LONG, WPARAM, LPARAM);
void SwDestroy      (LONG, WPARAM, LPARAM);
void SwEdSetFocus   (LONG, WPARAM, LPARAM, HWND);
void SwRbPaint      (LONG, LONG, WPARAM, LPARAM, HWND);
void SwRbSetFocus   (LONG, LONG, WPARAM, LPARAM, HWND);
void SwRbKillFocus  (LONG, LONG, WPARAM, LPARAM, HWND);
void SwRbLButtonDown(LONG, LONG, WPARAM, LPARAM, HWND);
void SwRbLButtonUp  (LONG, LONG, WPARAM, LPARAM, HWND);
void SwapEnter(LONG);

/*------------------------------------------------------------------------------
    Fvoid SwInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void SwInitClass(void)
{
	WNDCLASS wcSwap;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_SWAP,&wcSwap);
	
	RegisterClass(&wcSwap);
}

/*------------------------------------------------------------------------------
    Fvoid SwInit(LONG)
    FLONG    FORM ID
    @\Fu
------------------------------------------------------------------------------*/
void SwInit(LONG id)
{
	INT32 i;
	
	sw[id].src = 0x000000;
	sw[id].dst = 0x000000;
	
	sw[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_SWAP; i++) {sw[id].tabStops[i] = NULL;}
	
	sw[id].hWnd = NULL;
	for (i = 0; i < 2; i++) {sw[id].hEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {sw[id].hRgb [i] = NULL;}
	sw[id].hBtn = NULL;
	
	for (i = 0; i < 2; i++) {sw[id].pCallEdit[i] = NULL;}
	sw[id].pCallBtn = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid SwInst(LONG)
    FLONG      FORM ID
    @\FSWAP̉
------------------------------------------------------------------------------*/
void SwInst(LONG id)
{
	DWORD styleSw = WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU;
	DWORD styleEd = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleRb = WS_CHILD|WS_VISIBLE|WS_BORDER;
	DWORD styleBt = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	WCHAR strSrc[6+1];
	WCHAR strDst[6+1];
	
	_htow(sw[id].src, strSrc, 6);
	_htow(sw[id].dst, strDst, 6);
	
	sw[id].hWnd     = a_CreateWindow(NM_SWAP,  TxTl(E_TTLSWP),styleSw,0,  0, 0, 0, fm[id].hWnd);
	sw[id].hEdit[0] = a_CreateWindow(L"Edit",  strSrc,        styleEd,34, 18,73,17,sw[id].hWnd);
	sw[id].hEdit[1] = a_CreateWindow(L"Edit",  strDst,        styleEd,34, 53,73,17,sw[id].hWnd);
	sw[id].hRgb[0]  = a_CreateWindow(NM_RGBBOX,NULL,          styleRb,115,19,16,16,sw[id].hWnd);
	sw[id].hRgb[1]  = a_CreateWindow(NM_RGBBOX,NULL,          styleRb,115,54,16,16,sw[id].hWnd);
	sw[id].hBtn     = a_CreateWindow(L"Button",L"OK",         styleBt,35, 88,70,25,sw[id].hWnd);
	
	SetWindowLong(sw[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(sw[id].hEdit[0], GWL_USERDATA, id);
	SetWindowLong(sw[id].hEdit[1], GWL_USERDATA, id);
	SetWindowLong(sw[id].hRgb[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(sw[id].hRgb[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(sw[id].hBtn,     GWL_USERDATA, id);
	
	SetWindowLong(sw[id].hWnd,    GWL_WNDPROC, (LONG)WndProcSwap);
	SetWindowLong(sw[id].hRgb[0], GWL_WNDPROC, (LONG)WndProcSwapRgbS);
	SetWindowLong(sw[id].hRgb[1], GWL_WNDPROC, (LONG)WndProcSwapRgbD);
	
	E_SETLIMITTEXT(sw[id].hEdit[0], 6);
	E_SETLIMITTEXT(sw[id].hEdit[1], 6);
	
	E_SETFONT(sw[id].hEdit[0], hFtCourier);
	E_SETFONT(sw[id].hEdit[1], hFtCourier);
	B_SETFONT(sw[id].hBtn,     hFtArial14);
	
	sw[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(sw[id].hEdit[0], GWL_WNDPROC);
	sw[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(sw[id].hEdit[1], GWL_WNDPROC);
	sw[id].pCallBtn     = (CALLFUNC)GetWindowLong(sw[id].hBtn,     GWL_WNDPROC);
	SetWindowLong(sw[id].hEdit[0], GWL_WNDPROC, (LONG)WndProcSwapEditS);
	SetWindowLong(sw[id].hEdit[1], GWL_WNDPROC, (LONG)WndProcSwapEditD);
	SetWindowLong(sw[id].hBtn,     GWL_WNDPROC, (LONG)WndProcSwapBtn);
	
	sw[id].tabStopIdx = 0;
	sw[id].tabStops[0] = sw[id].hEdit[0];
	sw[id].tabStops[1] = sw[id].hRgb[0];
	sw[id].tabStops[2] = sw[id].hEdit[1];
	sw[id].tabStops[3] = sw[id].hRgb[1];
	sw[id].tabStops[4] = sw[id].hBtn;
	
	SetFocus  (sw[id].hEdit[0]);
	EditSelAll(sw[id].hEdit[0]);
}

/*------------------------------------------------------------------------------
    Fvoid SwDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void SwDialog(LONG id)
{
	WINDOWPLACEMENT plcm;
	RECT rc;
	
	SwInit(id);
	SwLoad(id);
	SwInst(id);
	
	GetWindowRect(fm[id].hWnd, &rc);
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = rc.left - 5 + 4;
	plcm.rcNormalPosition.top    = rc.top  + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left  + 157;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top   + 161;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(sw[id].hWnd, &plcm);
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = sw[id].hWnd;
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid SwLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void SwLoad(LONG id)
{
	sw[id].src = g_swSrc;
	sw[id].dst = g_swDst;
}

/*------------------------------------------------------------------------------
    Fvoid SwStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void SwStore(LONG id)
{
	g_swSrc = sw[id].src;
	g_swDst = sw[id].dst;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK WndProcSwap(,,,)
    F-
    ߒlF-
    @\FSWAPCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK WndProcSwap(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:     SwPaint   (id, wp, lp);  break;
	case WM_COMMAND:   SwCommand (id, wp, lp);  break;
	case WM_SETFOCUS:  SwSetFocus(id, wp, lp);  break;
	case WM_CLOSE:     SwClose   (id, wp, lp);  break;
	case WM_DESTROY:   SwDestroy (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK WndProcSwapEditS(,,,)
    F-
    ߒlF-
    @\FSWAP EDIT SRCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK WndProcSwapEditS(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:  SwEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   SwKeyDown   (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (wp == KEY_TAB)   {return 0;}
		if (wp == KEY_ENTER) {return 0;}
		break;
	default:
		break;
	}
	return sw[id].pCallEdit[0](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK WndProcSwapEditD(,,,)
    F-
    ߒlF-
    @\FSWAP EDIT DSTCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK WndProcSwapEditD(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:  SwEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   SwKeyDown   (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (wp == KEY_TAB)   {return 0;}
		if (wp == KEY_ENTER) {return 0;}
		break;
	default:
		break;
	}
	return sw[id].pCallEdit[1](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK WndProcSwapRgbS(,,,)
    F-
    ߒlF-
    @\FSWAP RGB Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK WndProcSwapRgbS(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG idR;
	LONG id;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idR = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:        SwRbPaint      (id, idR, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     SwRbSetFocus   (id, idR, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    SwRbKillFocus  (id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  SwRbLButtonDown(id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    SwRbLButtonUp  (id, idR, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      SwKeyDown      (id,      wp, lp, hWnd);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK WndProcSwapRgbD(,,,)
    F-
    ߒlF-
    @\FSWAP RGB Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK WndProcSwapRgbD(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idR;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idR = tmp / 100;
	
	switch (msg) {
	case WM_PAINT:        SwRbPaint      (id, idR, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     SwRbSetFocus   (id, idR, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    SwRbKillFocus  (id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  SwRbLButtonDown(id, idR, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    SwRbLButtonUp  (id, idR, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      SwKeyDown      (id,      wp, lp, hWnd);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK WndProcSwapBtn(,,,)
    F-
    ߒlF-
    @\FSWAP BTNCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK WndProcSwapBtn(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:  SwEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   SwKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	return sw[id].pCallBtn(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid SwPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSWAP WM_PAINTCxg
------------------------------------------------------------------------------*/
void SwPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	
	hdc = BeginPaint(sw[id].hWnd, &ps);
	GetClientRect(sw[id].hWnd, &rc);
	SetClipRgn(hdc, &rc);
	SelectObject(hdc, hBrWhite);
	
	PatBlt(hdc, rc.left+PADD8,
				rc.top +PADD8,
				rc.right-rc.left-PADD8*2,
				rc.bottom-rc.top-PADD8*2, PATCOPY);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(sw[id].hWnd, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid SwCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSWAP WM_COMMANDCxg
------------------------------------------------------------------------------*/
void SwCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	if ((HWND)lp != sw[id].hBtn) {return;}
	
	SwapEnter(id);
	CLOSE(sw[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid SwSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSWAP WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void SwSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(sw[id].tabStops[sw[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid SwKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSWAP WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void SwKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  SwKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    SwKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    SwKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_SP:     SwKeyDownSpace(id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid SwKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSWAP [enter]L[Cxg
------------------------------------------------------------------------------*/
void SwKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	SwapEnter(id);
	CLOSE(sw[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid SwKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSWAP [esc]L[Cxg
------------------------------------------------------------------------------*/
void SwKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(sw[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid SwKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSWAP [tab]L[Cxg
------------------------------------------------------------------------------*/
void SwKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT8 tmp;
	BOOL shift;
	
	tmp = GetKeyState(KEY_SHIFT);
	if((tmp & 0x80)!=0){shift=TRUE;}else{shift=FALSE;}
	
	if (shift == TRUE) {
		if (sw[id].tabStopIdx == 0) {sw[id].tabStopIdx = TBSP_SWAP-1;}
		else                        {sw[id].tabStopIdx--;}
	}
	else {
		sw[id].tabStopIdx = (sw[id].tabStopIdx + 1) % TBSP_SWAP;
	}
	SetFocus(sw[id].tabStops[sw[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid SwKeyDownSpace(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSWAP [space]L[Cxg
------------------------------------------------------------------------------*/
void SwKeyDownSpace(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (hWnd == sw[id].hRgb[0]) {
		GetWindowText(sw[id].hEdit[0], buffRgb, 6+1);
		RbDialog(id, sw[id].hWnd, sw[id].hEdit[0], sw[id].hRgb[0], buffRgb);
	}
	else if (hWnd == sw[id].hRgb[1]) {
		GetWindowText(sw[id].hEdit[1], buffRgb, 6+1);
		RbDialog(id, sw[id].hWnd, sw[id].hEdit[1], sw[id].hRgb[1], buffRgb);
	}
}

/*------------------------------------------------------------------------------
    Fvoid SwClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSWAP WM_CLOSECxg
------------------------------------------------------------------------------*/
void SwClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid SwDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FSWAP WM_DESTROYCxg
------------------------------------------------------------------------------*/
void SwDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid SwEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSWAP WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void SwEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_SWAP; i++) {
		if (hWnd == sw[id].tabStops[i]) {
			sw[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid SwRbPaint(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSWAP RGBBOX WM_PAINTCxg
------------------------------------------------------------------------------*/
void SwRbPaint(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	RbBoxPaint(id, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid SwRbSetFocus(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSWAP RGBBOX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void SwRbSetFocus(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_SWAP; i++) {
		if ((HWND)wp == sw[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
	
	SwEdSetFocus(id, wp, lp, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid SwRbKillFocus(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSWAP RGBBOX WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void SwRbKillFocus(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_SWAP; i++) {
		if ((HWND)wp == sw[id].tabStops[i]) {
			res = TRUE;
		}
	}
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid SwRbLButtonDown(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSWAP RGBBOX WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void SwRbLButtonDown(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	sw[id].flgClick[idR] = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid SwRbLButtonUp(LONG, LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          LONG    RGB  ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FSWAP RGBBOX WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void SwRbLButtonUp(LONG id, LONG idR, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (sw[id].flgClick[idR] == FALSE) {return;}
	sw[id].flgClick[idR] = FALSE;
	SetFocus(hWnd);
	
	GetWindowText(sw[id].hEdit[0+idR], buffRgb, 6+1);
	RbDialog(id, sw[id].hWnd, sw[id].hEdit[0+idR], sw[id].hRgb[idR], buffRgb);
}

/*------------------------------------------------------------------------------
    Fvoid SwapEnter(LONG id)
    FLONG    FORM ID
    @\Fus
------------------------------------------------------------------------------*/
void SwapEnter(LONG id)
{
	WCHAR strSrc[6+1];
	WCHAR strDst[6+1];
	
	GetWindowText(sw[id].hEdit[0], strSrc, 6+1);
	GetWindowText(sw[id].hEdit[1], strDst, 6+1);
	sw[id].src = _wtoh(strSrc, 6);
	sw[id].dst = _wtoh(strDst, 6);
	
	SwStore(id);
	
	CmdEffect(id, M_SWAP);
}
