/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define TB_CPP
#include "../common.h"
//  TextBoxFeLXg{bNX

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 w;
	INT32 h;
	
	HWND hWnd;
	HWND hEdit;
	
	LRESULT (CALLBACK *pCallEdit) (HWND,UINT,WPARAM,LPARAM);
} tb[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void TbInitClass(void);
void TbInit(LONG);
void TbInst(LONG);
void TbDialog(LONG, WCHAR *,const WCHAR *,HFONT);
void TbLoad(LONG);
void TbStore(LONG);
LRESULT CALLBACK TbWndProc(HWND,UINT,WPARAM,LPARAM);
LRESULT CALLBACK TbWndProcEdit(HWND,UINT,WPARAM,LPARAM);
void TbSize(LONG,WPARAM,LPARAM);
void TbClose(LONG,WPARAM,LPARAM);
void TbDestroy(LONG,WPARAM,LPARAM);
void TbSetFocus(LONG,WPARAM,LPARAM);

/*------------------------------------------------------------------------------
    Fvoid TbInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void TbInitClass(void)
{
	WNDCLASS wcTextbx;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_TXBX,&wcTextbx);
	
	RegisterClass(&wcTextbx);
}

/*------------------------------------------------------------------------------
    Fvoid TbInit(LONG)
    FLONG    FORM ID
    @\FeLXg{bNX 
------------------------------------------------------------------------------*/
void TbInit(LONG id)
{
	tb[id].w = 0;
	tb[id].h = 0;
	
	tb[id].hWnd  = NULL;
	tb[id].hEdit = NULL;
	
	tb[id].pCallEdit = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid TbInst(LONG)
    FLONG      FORM ID
    @\FTEXTBOX̉
------------------------------------------------------------------------------*/
void TbInst(LONG id)
{
	DWORD styleTb = WS_CAPTION|WS_THICKFRAME|WS_SYSMENU;
	DWORD styleEd = WS_CHILD|WS_VSCROLL|WS_VISIBLE|WS_BORDER|ES_LEFT|ES_MULTILINE|ES_AUTOHSCROLL;
	
	tb[id].hWnd  = a_CreateWindow(NM_TXBX,NULL,styleTb,0,0,0,0,fm[id].hWnd);
	tb[id].hEdit = a_CreateWindow(L"Edit", NULL,styleEd,0,0,0,0,tb[id].hWnd);
	SetWindowLong(tb[id].hWnd,  GWL_USERDATA, id);
	SetWindowLong(tb[id].hEdit, GWL_USERDATA, id);
	SetWindowLong(tb[id].hWnd,  GWL_WNDPROC, (LONG)TbWndProc);
	
	tb[id].pCallEdit = (CALLFUNC)GetWindowLong(tb[id].hEdit, GWL_WNDPROC);
	SetWindowLong(tb[id].hEdit, GWL_WNDPROC, (LONG)TbWndProcEdit);
}

/*------------------------------------------------------------------------------
    Fvoid TbDialog(LONG, WCHAR *, const WCHAR *, HFONT)
    FLONG           FORM ID
          WCHAR *        -
          const WCHAR *  -
          HFONT          -
    @\F_CAO
------------------------------------------------------------------------------*/
void TbDialog(LONG id, WCHAR *pStr, const WCHAR *pTitle, HFONT hFt)
{
	WINDOWPLACEMENT plcm;
	
	TbInit(id);
	TbInst(id);
	TbLoad(id);
	SetWindowText(tb[id].hWnd,  pTitle);
	SetWindowText(tb[id].hEdit, pStr);
	E_SETFONT(tb[id].hEdit, hFt);
	
	if ((tb[id].w == 0) && (tb[id].h == 0)) {
		tb[id].w = 500;
		tb[id].h = 600;
	}
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + tb[id].w;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + tb[id].h;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(tb[id].hWnd, &plcm);
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = tb[id].hWnd;
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid TbLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void TbLoad(LONG id)
{
	tb[id].w = g_txbxW;
	tb[id].h = g_txbxH;
}

/*------------------------------------------------------------------------------
    Fvoid TbStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void TbStore(LONG id)
{
	g_txbxW = tb[id].w;
	g_txbxH = tb[id].h;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TbWndProc(,,,)
    F-
    ߒlF-
    @\FTextbxCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TbWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SIZE:      TbSize    (id, wp, lp);  break;
	case WM_CLOSE:     TbClose   (id, wp, lp);  break;
	case WM_DESTROY:   TbDestroy (id, wp, lp);  break;
	case WM_SETFOCUS:  TbSetFocus(id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK TbWndProcEdit(,,,)
    F-
    ߒlF-
    @\FTEXTBOX EDITCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK TbWndProcEdit(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_KEYDOWN:
		switch (wp) {
		case KEY_ESC:  CLOSE(tb[id].hWnd);  break;
		default:  break;
		}
		break;
	default:
		break;
	}
	return tb[id].pCallEdit(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid TbSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXTBOX WM_SIZECxg
------------------------------------------------------------------------------*/
void TbSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	
	GetClientRect(tb[id].hWnd, &rc);
	a_SetWindowPos(tb[id].hEdit, rc.left+5, rc.top+5,
								 rc.right-rc.left-10, rc.bottom-rc.top-10);
	InvalidateRect(tb[id].hEdit, NULL, FALSE);
	InvalidateRect(tb[id].hWnd,  NULL, TRUE);
}

/*------------------------------------------------------------------------------
    Fvoid TbClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXTBOX WM_CLOSECxg
------------------------------------------------------------------------------*/
void TbClose(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rcTextbx;
	
	GetWindowRect(tb[id].hWnd, &rcTextbx);
	tb[id].w = rcTextbx.right  - rcTextbx.left;
	tb[id].h = rcTextbx.bottom - rcTextbx.top;
	TbStore(id);
	
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid TbDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXTBOX WM_DESTROYCxg
------------------------------------------------------------------------------*/
void TbDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid TbSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FTEXTBOX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void TbSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(tb[id].hEdit);
}
