/*------------------------------------------------------------------------------
    \
------------------------------------------------------------------------------*/
typedef struct st_Image {
	BOOL res;
	INT32 stat;
	HBITMAP hBmp;
	HDC hdc;
	INT32 w;
	INT32 h;
	INT32 bpp;
	BYTE *pB;
	BOOL Mflg;
	PixelFormat pxFmt;
	INT32 fmt;
	INT32 fmtIco;
	FILETIME dateModify;
	UINT64 fileSize;
} st_Image;

typedef struct st_Linear {
	st_Linear *front;
	st_Linear *back;
	WCHAR pathF[MAX_PATH];
} st_Linear;

typedef struct st_Stack {
	st_Stack *front;
	st_Stack *back;
	INT32 left;
	INT32 right;
} st_Stack;

/*------------------------------------------------------------------------------
    EBhEf[^
------------------------------------------------------------------------------*/
typedef struct st_Cntn {
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	INT32 align;
	HBRUSH hBrAvg;
	INT8 avgRed;
	INT8 avgGreen;
	INT8 avgBlue;
} st_Cntn;

typedef struct st_Pict {
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	INT32 zoomX;
	INT32 zoomY;
	INT32 zoomW;
	INT32 zoomH;
	INT32 imgClipX;
	INT32 imgClipY;
	INT32 imgClipW;
	INT32 imgClipH;
	st_Image img;
	st_Image lgt[10];
	st_Image tmp;
	INT32 idxLgt;
	INT32 percent;
	INT32 percentRaw;
	double percentMoveX;
	double percentMoveY;
	INT32 imgNo;
	INT32 imgCnt;
	WCHAR pathF[MAX_PATH];
	WCHAR path [MAX_PATH];
	BOOL flgEnter;
	BOOL flgPosi;
	BOOL flgZmMv;
	BOOL flgEdge;
	TRACKMOUSEEVENT tme;
	INT32 nowX;
	INT32 nowY;
	INT32 iniX;
	INT32 iniY;
} st_Pict;

typedef struct st_Item {
	BOOL flgEnter;
	BOOL flgClick;
	TRACKMOUSEEVENT tme;
} st_Item;

typedef struct st_Info {
	INT32 idxStr;
	BOOL onoff;
	INT32 prgPos;
	INT32 prgMax;
} st_Info;

typedef struct st_VBack {
	INT32 y;
	INT32 h;
	INT32 cnt;
	INT32 idxPage;
	INT32 cntPage;
	INT32 cntFile;
	BOOL flgClick;
	INT32 nowX;
	INT32 nowY;
	SCROLLINFO sci;
} st_VBack;

typedef struct st_VPict {
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	INT32 y1Ov;
	INT32 y2Ov;
	st_Image img;
	WCHAR path[MAX_PATH];
	BOOL resWH;
	BOOL resInArea;
	BOOL flgClick;
	INT32 nowX;
	INT32 nowY;
	INT32 iniX;
	INT32 iniY;
} st_VPict;

typedef struct st_TBack {
	INT32 y;
	INT32 h;
	INT32 cnt;
	INT32 idxPage;
	INT32 cntPage;
	INT32 cntFile;
	BOOL flgClick;
	INT32 nowX;
	INT32 nowY;
	SCROLLINFO sci;
} st_TBack;

typedef struct st_TPict {
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	INT32 y1Ov;
	INT32 y2Ov;
	st_Image img;
	WCHAR path[MAX_PATH];
	BOOL resInArea;
	BOOL flgClick;
	INT32 nowX;
	INT32 nowY;
	INT32 iniX;
	INT32 iniY;
} st_TPict;

/*------------------------------------------------------------------------------
    Xbhf[^
------------------------------------------------------------------------------*/
typedef struct st_Thr {
	INT32 prog;
	INT32 max;
	INT32 idx;
	INT32 cnt;
	BOOL sync;
	BOOL enable[CNT_PAGE];
	WCHAR path[CNT_PAGE][MAX_PATH];
	st_Image img[CNT_PAGE];
	INT32 mode;
} st_Thr;

typedef struct st_ThrVt {
	INT32 prog;
	INT32 toggle;
	INT32 idx;
	INT32 cnt;
	WCHAR path[CNT_VERT][MAX_PATH];
	st_Image img[CNT_VERT];
} st_ThrVt;

typedef struct st_ThrTh {
	INT32 prog;
	INT32 toggle;
	INT32 idx;
	INT32 cnt;
	WCHAR path[CNT_THUMB][MAX_PATH];
	st_Image img[CNT_THUMB];
} st_ThrTh;

typedef struct st_ThrLt {
	WCHAR path[MAX_PATH];
	st_Image img;
} st_ThrLt;

typedef struct st_ThrMo {
	WCHAR path[2][MAX_PATH];
	st_Image img[2];
} st_ThrMo;

/*------------------------------------------------------------------------------
    FORMf[^
------------------------------------------------------------------------------*/
typedef struct st_Form {
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	BOOL  maxi;
	INT32 wTmp;
	INT32 hTmp;
	INT32 xCur;
	INT32 yCur;
	/*------------------------------------------------------------------------*/
	WINDOWPLACEMENT plcm;
	BOOL flgTb;
	BOOL flgSb;
	BOOL flgScrl;
	BOOL flgPv;
	BOOL flgTrim;
	INT32 idxTurn;
	INT32 idxDlOrder;
	INT32 idxVtWidth;
	INT32 idxVtPages;
	INT32 idxVtMarg;
	INT32 idxThCol;
	INT32 idxThCnt;
	INT32 idxThSize;
	INT32 idxTbPos;
	INT32 bkColor;
	INT32 rgbFree;
	HBRUSH bkBrush;
	HBRUSH hBrFree;
	/*------------------------------------------------------------------------*/
	WCHAR pathD[MAX_PATH];
	/*------------------------------------------------------------------------*/
	st_Cntn cn[CNT_PAGE];
	st_Pict pc[CNT_PAGE];
	st_Item it[CNT_ITEM];
	st_Info in;
	st_VBack vbk;
	st_VPict vpc[CNT_VERT];
	st_TBack tbk;
	st_TPict tpc[CNT_THUMB];
	/*------------------------------------------------------------------------*/
	HWND hWnd;
	HWND hModal;
	HWND hForm;
	HWND hCntn[CNT_PAGE];
	HWND hPict[CNT_PAGE];
	HWND hVPage;
	HWND hVBack;
	HWND hVPict[CNT_VERT];
	HWND hVScrl;
	HWND hTPage;
	HWND hTBack;
	HWND hTPict[CNT_THUMB];
	HWND hTScrl;
	HWND hTb;
	HWND hItem[CNT_ITEM];
	HWND hSb;
	HWND hChip[CNT_CHIP];
	HWND hInfo;
	/*------------------------------------------------------------------------*/
	MENUITEMINFO miiBar   [8];
	MENUITEMINFO miiFile  [25];
	MENUITEMINFO miiBook  [2];
	MENUITEMINFO miiFolder[5];
	MENUITEMINFO miiView  [16];
	MENUITEMINFO miiPage  [11];
	MENUITEMINFO miiWindow[6];
	MENUITEMINFO miiEffect[18];
	MENUITEMINFO miiEdit  [19];
	MENUITEMINFO miiClip  [6];
	MENUITEMINFO miiOption[69];
	MENUITEMINFO miiThr   [5];
	MENUITEMINFO miiThrVt [5];
	MENUITEMINFO miiThrTh [5];
	MENUITEMINFO miiThrLt [5];
	MENUITEMINFO miiEtc   [10];
	MENUITEMINFO miiDebug [14];
	MENUITEMINFO miiIgnore[12];
	HMENU hMenu;
	HMENU hSubFile;
	HMENU hSubRecent;
	HMENU hSubBook;
	HMENU hSubFolder;
	HMENU hSubSaveAs;
	HMENU hSubView;
	HMENU hSubPage;
	HMENU hSubDesign;
	HMENU hSubWindow;
	HMENU hSubEffect;
	HMENU hSubEdit;
	HMENU hSubClip;
	HMENU hSubOption;
	HMENU hSubEtc;
	HMENU hSubTurn;
	HMENU hSubDual;
	HMENU hSubVt;
	HMENU hSubVtWidth;
	HMENU hSubVtPages;
	HMENU hSubVtMarg;
	HMENU hSubTh;
	HMENU hSubThCnt;
	HMENU hSubThSize;
	HMENU hSubTbPos;
	HMENU hSubLang;
	HMENU hSubPrio;
	HMENU hSubThr;
	HMENU hSubThrVt;
	HMENU hSubThrTh;
	HMENU hSubThrLt;
	HMENU hSubEndeco;
	HMENU hSubBmp;
	HMENU hSubPng;
	HMENU hSubJpg;
	HMENU hSubIco;
	HMENU hSubDebug;
	HMENU hSubIgnore;
	WCHAR strMnRecent[MAX_PATH];  // init  flush ŃXR[v؂邩
	WCHAR strMnBook  [MAX_PATH];
	/*------------------------------------------------------------------------*/
	MENUITEMINFO miiPict [26];
	MENUITEMINFO miiVPict[1];
	MENUITEMINFO miiTPict[1];
	MENUITEMINFO miiCntn [11];
	HMENU hSubPict;
	HMENU hSubVPict;
	HMENU hSubTPict;
	HMENU hSubCntn;
	/*------------------------------------------------------------------------*/
	BOOL modeFullScreen;
	BOOL modeZoom;
	BOOL modeGrid;
	BOOL modeXY;
	BOOL modeFit;
	BOOL modeAlpha;
	BOOL modeDual;
	BOOL modeTriple;
	BOOL modeQuad;
	BOOL modeOcta;
	BOOL modeHexade;
	BOOL modeDotria;
	BOOL modeVert;
	BOOL modeThumb;
	/*------------------------------------------------------------------------*/
	struct {
		BOOL busy;
		BOOL latch;
		INT32 cnt;
		BOOL sync;
		BOOL enable[CNT_PAGE];
		WCHAR path[CNT_PAGE][MAX_PATH];
	} thr;
	
	struct {
		BOOL busy;
		BOOL latch;
		INT32 idx;
		INT32 cnt;
		WCHAR path[CNT_VERT][MAX_PATH];
	} thrVt;
	
	struct {
		BOOL busy;
		BOOL latch;
		INT32 idx;
		INT32 cnt;
		WCHAR path[CNT_THUMB][MAX_PATH];
	} thrTh;
	
	struct {
		BOOL busy;
	} thrLt;
	
	struct {
		BOOL busy;
	} thrMo;
	/*------------------------------------------------------------------------*/
	st_Linear rootF;
	st_Linear rootD;
	INT32 cntF;
	INT32 cntD;
	HGLOBAL memF;
	HGLOBAL memD;
	st_Linear **arrayF;
	st_Linear **arrayD;
	/*------------------------------------------------------------------------*/
	st_Stack rootS;
	st_Stack *pCurS;
	INT32 cntS;
	/*------------------------------------------------------------------------*/
	WPARAM wpSize;
	INT32 cntSkip;
	INT32 cntSkipEdit;
	/*------------------------------------------------------------------------*/
	SCROLLINFO sci[2];
	BOOL scrlEnable;
	/*------------------------------------------------------------------------*/
	BOOL flgRotate;
	BOOL flgFlip;
	BOOL flgEff;
	BOOL flgArea;
	BOOL flgMargin;
	BOOL flgDeform;
	BOOL flgAngle;
	BOOL flgText;
	BOOL flgLine;
	BOOL flgRect;
	BOOL flgCsv;
	BOOL flgPen;
	BOOL flgFill;
	BOOL flgWhite;
	BOOL flgPaste;
	BOOL flgPapara;
	BOOL flgResize;
	/*------------------------------------------------------------------------*/
	INT32 cntRoundUp;
	INT32 cntRoundDw;
	INT32 cntResize;
	/*------------------------------------------------------------------------*/
	COLORREF rgb;
} st_Form;

/*------------------------------------------------------------------------------
    GR[_^fR[_
------------------------------------------------------------------------------*/
typedef struct BmHeader{
	INT16 type;
	INT32 size;
	INT16 reserved1;
	INT16 reserved2;
	INT32 offset;
} BmHeader;

typedef struct BmInfo {
	INT32 size;
	INT32 width;
	INT32 height;
	INT16 planes;
	INT16 bpp;
	INT32 compression;
	INT32 sizeImage;
	INT32 xPixPerMeter;
	INT32 yPixPerMeter;
	INT32 clrUsed;
	INT32 clrImportant;
} BmInfo;

typedef struct IcHeader {
	INT16 reserved;
	INT16 type;
	INT16 count;
} IcHeader;

typedef struct IcInfo {
	INT8  width;
	INT8  height;
	INT8  colorCount;
	INT8  reserved;
	INT16 hotSpotX;
	INT16 hotSpotY;
	INT32 size;
	INT32 offset;
} IcInfo;

typedef struct IcBmpInfo {
	INT32 size;
	INT32 reserved1;
	INT32 reserved2;
	INT16 planes;
	INT16 bpp;
	INT32 compression;
	INT32 sizeImage;
	INT32 xPixPerMeter;
	INT32 yPixPerMeter;
	INT32 clrUsed;
	INT32 clrImportant;
} IcBmpInfo;
