/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define WRAPPER_CPP
#include "common.h"

/*------------------------------------------------------------------------------
    Fvoid *a_malloc(,,,)
    F-
    @\FmalločĂѕς
------------------------------------------------------------------------------*/
void *a_malloc(size_t size)
{
	void *res;
	
	res = malloc(size);
	if (res == NULL) {
		MessageBox(NULL, L"danger malloc", L_FATAL, MB_OK);
		exit(1);
	}
	return res;
}

/*------------------------------------------------------------------------------
    Fwchar_t * wcscmb(,,,)
    F-
    ߒlF-
    @\FwcscaťĂѕς
------------------------------------------------------------------------------*/
wchar_t * wcscmb(wchar_t *v1, const wchar_t *v2)
{
	if (wcslen(v1) == 0) {return wcscat(v1, v2);}
	
	if (PathIsNetworkPath(v1)) {
		if (PathIsRoot(v1)) {
			wcscat(v1, L"\\");
		}
		else {
			wcscat(v1, L"\\");
		}
	}
	else {
		if (PathIsRoot(v1)) {
			
		}
		else {
			wcscat(v1, L"\\");
		}
	}
	return wcscat(v1, v2);
}

/*------------------------------------------------------------------------------
    FBOOL PathIsProtect(,,,)
    F-
    ߒlF-
    @\FPathIsRoot̉
------------------------------------------------------------------------------*/
BOOL PathIsProtect(LPCWSTR pStr)
{
	WCHAR path [MAX_PATH];
	WCHAR pathC[MAX_PATH];  // uC:\v
	WCHAR pathW[MAX_PATH];  // uC:\Windowsv ȉ
	WCHAR pathP[MAX_PATH];  // uC:\Program Filesvȉ
	INT32 lenW;
	INT32 lenP;
	
	wcscpy(path, pStr);
	SHGetSpecialFolderPath(NULL, pathC, CSIDL_WINDOWS,       FALSE);  PathRemoveFileSpec(pathC);
	SHGetSpecialFolderPath(NULL, pathW, CSIDL_WINDOWS,       FALSE);
	SHGetSpecialFolderPath(NULL, pathP, CSIDL_PROGRAM_FILES, FALSE);
	CharUpper(path);
	CharUpper(pathC);
	CharUpper(pathW);
	CharUpper(pathP);
	
	if (wcscmp(pathC, path) == 0) {return TRUE;}
	
	lenW = wcslen(pathW);
	lenP = wcslen(pathP);
	if (wcsncmp(pathW, path, lenW) == 0) {return TRUE;}
	if (wcsncmp(pathP, path, lenP) == 0) {return TRUE;}
	
	return FALSE;
}

/*------------------------------------------------------------------------------
    FHWND a_CreateWindow(,,,)
    F-
    ߒlF-
    @\FCreateWindow̌Ăѕς
------------------------------------------------------------------------------*/
HWND a_CreateWindow(LPCWSTR v1,LPCWSTR v2,DWORD v3,int v4,int v5,int v6,int v7,HWND v8)
{
	HWND hWnd;
	
	hWnd = CreateWindow(v1,v2,v3,v4,v5,v6,v7,v8,NULL,gInst,NULL);
	if (hWnd == NULL) {
		MessageBox(NULL, L"danger create window", L_FATAL, MB_OK);
		exit(1);
	}
	return hWnd;
}

/*------------------------------------------------------------------------------
    FHFONT a_CreateFont(,,,)
    F-
    ߒlF-
    @\FCreateFonťĂѕς
------------------------------------------------------------------------------*/
HFONT a_CreateFont(int v1,LPCWSTR v2)
{
	INT32 w;
	
	if (wcscmp(v2, L"lr SVbN") == 0) {
		w = v1/2;
	}
	else {
		w = 0;
	}
	
	return CreateFont(v1,                        // cHeight
					  w,                         // cWidth
					  0,                         // cEscapement  v 10Pʈȉ؂̂
					  0,                         // cOrientation
					  FW_DONTCARE,               // cWeight
//					  FW_BOLD,
//					  FW_NORMAL,
					  FALSE,                     // bItalic
					  FALSE,                     // bUnderline
					  FALSE,                     // bStrikeOut
					  ANSI_CHARSET,              // iCharSet
					  OUT_DEFAULT_PRECIS,        // iOutPrecision
					  CLIP_DEFAULT_PRECIS,       // iClipPrecision
					  DEFAULT_QUALITY,           // iQuality
//					  CLEARTYPE_QUALITY,
//					  ANTIALIASED_QUALITY,
					  DEFAULT_PITCH|FF_DONTCARE, // iPitchAndFamily
					  v2);                       // pszFaceName
}

/*------------------------------------------------------------------------------
    FHBITMAP a_CreateDIBSection(,,,)
    F-
    ߒlF-
    @\FCreateDIBSectioňĂѕς
------------------------------------------------------------------------------*/
HBITMAP a_CreateDIBSection(HDC v1,const BITMAPINFO *v2,UINT v3,VOID **v4,HANDLE v5,DWORD v6)
{
	HBITMAP res;
	
	res = CreateDIBSection(v1,v2,v3,v4,v5,v6);
	if (res == NULL) {
		MessageBox(NULL, L"danger CreateDIBSection", L_FATAL, MB_OK);
		exit(1);
	}
	return res;
}

/*------------------------------------------------------------------------------
    FBOOL a_SetWindowPos(,,,);
    F-
    ߒlF-
    @\FSetWindowPošĂѕς
          EBhENCAg͈͊Oɂ邱Ƃ͐ݓIȃoO܂܂B
          ͈͊ȌꍇI[[
------------------------------------------------------------------------------*/
BOOL a_SetWindowPos(HWND v1, int v2, int v3, int v4, int v5)
{
	HWND hWnd;
	RECT rc;
	
	if (v1 == NULL) {return FALSE;}
	
	hWnd = GetParent(v1);
	if (hWnd == NULL) {
		if ((v2 <  0) ||
			(v3 <  0) ||
			(v4 <= 0) ||
			(v5 <= 0))
		{
			v2 = 0;
			v3 = 0;
			v4 = 0;
			v5 = 0;
		}
	}
	else {
		GetClientRect(hWnd, &rc);
		
		if ((v2 < rc.left) ||
			(v3 < rc.top)  ||
			(rc.right  < (v2+v4)) ||
			(rc.bottom < (v3+v5)))
		{
			v2 = 0;
			v3 = 0;
			v4 = 0;
			v5 = 0;
		}
	}
	
	return SetWindowPos(v1, NULL, v2, v3, v4, v5, 0x071C);
}

/*------------------------------------------------------------------------------
    FBOOL a_SetWindowPosLim(,,,);
    F-
    ߒlF-
    @\F͈͊Ȍꍇ
------------------------------------------------------------------------------*/
BOOL a_SetWindowPosL(HWND v1, int v2, int v3, int v4, int v5)
{
	HWND hWnd;
	RECT rc;
	INT32 left;
	INT32 top;
	INT32 right;
	INT32 bottom;
	
	if (v1 == NULL) {return FALSE;}
	
	hWnd = GetParent(v1);
	if (hWnd != NULL) {
		left   = v2;
		top    = v3;
		right  = v2+v4;
		bottom = v3+v5;
		
		GetClientRect(hWnd, &rc);
		
		if (left      < rc.left) {left   = rc.left;}
		if (top       < rc.top)  {top    = rc.top;}
		if (rc.right  < right)   {right  = rc.right;}
		if (rc.bottom < bottom)  {bottom = rc.bottom;}
		
		v2 = left;
		v3 = top;
		v4 = right - left;
		v5 = bottom - top;
	}
	
	return SetWindowPos(v1, NULL, v2, v3, v4, v5, 0x071C);
}

/*------------------------------------------------------------------------------
    FBOOL a_TextOut(,,,);
    F-
    ߒlF-
    @\FTextOuťĂѕς
------------------------------------------------------------------------------*/
BOOL a_TextOut(HDC hdc, int x, int y, LPCWSTR lpString)
{
	if (hdc == NULL) {return FALSE;}
	
	return TextOut(hdc, x, y, lpString, wcslen(lpString));
}

/*------------------------------------------------------------------------------
    Fvoid _wtoh(WCHAR *, INT32)
    FACHAR *  
          INT32    
    ߒlFINT32 *  16i
    @\F_wtoỉ
------------------------------------------------------------------------------*/
INT32 _wtoh(WCHAR *pStr, INT32 digit)
{
	INT32 i;
	INT32 len;
	INT32 weight;
	INT32 hex;
	
	hex = 0x000000;
	len = wcslen(pStr);
	
	if (digit == 6) {
		if (len != 6) {return hex;}
	}
	else if (digit == 3) {
		if (len == 3) {
		}
		else if (len == 2) {
			pStr[3] = 0;
			pStr[2] = pStr[1];
			pStr[1] = pStr[0];
			pStr[0] = L'0';
		}
		else if (len == 1) {
			pStr[3] = 0;
			pStr[2] = pStr[0];
			pStr[1] = L'0';
			pStr[0] = L'0';
		}
		else {
			return hex;
		}
	}
	else {
		return hex;
	}
	
	for (i = 0; i < digit; i++) {
		if (((L'0' <= pStr[i]) && (pStr[i] <= L'9')) ||
			((L'A' <= pStr[i]) && (pStr[i] <= L'F')) ||
			((L'a' <= pStr[i]) && (pStr[i] <= L'f')))
		{
			weight = 0x00000001 << (4*(digit-1-i));
			hex += GetHex(pStr[i]) * weight;
		}
		else {
			hex = 0x000000;
			break;
		}
	}
	return hex;
}

/*------------------------------------------------------------------------------
    FINT32 _wtor(WCHAR *)
    FWCHAR *  
    ߒlFINT32    Fl
    @\F_wtoỉ
------------------------------------------------------------------------------*/
INT32 _wtor(WCHAR *pStr)
{
	INT32 rgb;
	
	if (wcslen(pStr) != 6) {return 0x00000000;}
	
	rgb = 0x00000000;
	rgb += GetHex(pStr[0]) * 0x00000010;
	rgb += GetHex(pStr[1]) * 0x00000001;
	rgb += GetHex(pStr[2]) * 0x00001000;
	rgb += GetHex(pStr[3]) * 0x00000100;
	rgb += GetHex(pStr[4]) * 0x00100000;
	rgb += GetHex(pStr[5]) * 0x00010000;
	return rgb;
}

/*------------------------------------------------------------------------------
    FBOOL _wtob(WCHAR *)
    FWCHAR *  
    ߒlFBOOL     ^U
    @\F_wtob̉
------------------------------------------------------------------------------*/
BOOL _wtob(WCHAR *pStr)
{
	if (wcscmp(pStr, L"TRUE") == 0) {return TRUE;}
	else                            {return FALSE;}
}

/*------------------------------------------------------------------------------
    Fvoid _htow(INT32, WCHAR *, INT32)
    FINT32    16i
          WCHAR *  
          INT32    
    @\F_itow̉
------------------------------------------------------------------------------*/
void _htow(INT32 hex, WCHAR *pStr, INT32 digit)
{
	INT32 i;
	INT32 weight;
	
	for (i = 0; i < digit; i++) {
		weight = 0x00000001 << (4*(digit-1-i));
		pStr[i] = GetHChar(hex / weight);
		hex = hex % weight;
	}
	pStr[i] = 0x0000;
}

/*------------------------------------------------------------------------------
    Fvoid _rtow(INT32, WCHAR *)
    FINT32    Fl
          WCHAR *  
    @\F_itow̉
------------------------------------------------------------------------------*/
void _rtow(INT32 rgb, WCHAR *pStr)
{
	rgb &= 0x00FFFFFF;
	pStr[4] = GetHChar(rgb / 0x00100000);  rgb = rgb % 0x00100000;
	pStr[5] = GetHChar(rgb / 0x00010000);  rgb = rgb % 0x00010000;
	pStr[2] = GetHChar(rgb / 0x00001000);  rgb = rgb % 0x00001000;
	pStr[3] = GetHChar(rgb / 0x00000100);  rgb = rgb % 0x00000100;
	pStr[0] = GetHChar(rgb / 0x00000010);  rgb = rgb % 0x00000010;
	pStr[1] = GetHChar(rgb / 0x00000001);
	pStr[6] = L'\0';
}

/*------------------------------------------------------------------------------
    Fvoid _btow(BOOL, WCHAR *)
    FBOOL     ^U
          WCHAR *  
    @\F_itow̉
------------------------------------------------------------------------------*/
void _btow(BOOL flg, WCHAR *pStr)
{
	if (flg) {wcscpy(pStr, L"TRUE");}
	else     {wcscpy(pStr, L"FALSE");}
}

/*------------------------------------------------------------------------------
    FINT32 GetHex(WCHAR)
    FWCHAR   16i
    ߒlFINT32   16i
    @\F16i擾
------------------------------------------------------------------------------*/
INT32 GetHex(WCHAR chr)
{
	if      ((L'0' <= chr) && (chr <= L'9')) {return  chr - L'0';}
	else if ((L'a' <= chr) && (chr <= L'f')) {return (chr - L'a') + 10;}
	else                                     {return (chr - L'A') + 10;}
}

/*------------------------------------------------------------------------------
    FWCHAR GetHChar(INT32)
    FINT32   16i
    ߒlFWCHAR   16i
    @\F16i擾
------------------------------------------------------------------------------*/
WCHAR GetHChar(INT32 hex)
{
	if (hex < 10) {return L'0' + hex;}
	else          {return L'A' + (hex - 10);}
}

/*------------------------------------------------------------------------------
    FINT32 _htor(INT32)
    FINT32   16i
          INT32   Fl
    @\FRGBlɓւ
------------------------------------------------------------------------------*/
INT32 _htor(INT32 hex)
{
	INT32 rgb;
	
	rgb = 0x00000000;
	rgb += (hex / 0x00100000) <<  4;  hex = hex % 0x00100000;
	rgb += (hex / 0x00010000) <<  0;  hex = hex % 0x00010000;
	rgb += (hex / 0x00001000) << 12;  hex = hex % 0x00001000;
	rgb += (hex / 0x00000100) <<  8;  hex = hex % 0x00000100;
	rgb += (hex / 0x00000010) << 20;  hex = hex % 0x00000010;
	rgb += (hex / 0x00000001) << 16;  hex = hex % 0x00000001;
	return rgb;
}
