# <span style="color:blue;">MarkdownEditor</span>
![画像の説明](./resources/main.png)

シェアウェア版Markdownエディタ
## 概要

MarkdownEditorは、リアルタイムプレビューとPDFエクスポート機能を持つデスクトップMarkdownエディタです。日本語UIに対応し、直感的な操作でMarkdown文書の作成・編集が可能です。ライブプレビュー機能とPDFエクスポート機能を有し、マニュアル書きなどで簡単に利用できるように、必要最低限で構成しています。

さらに、LM Studio（ローカルLLMサーバー）と連携したAI機能を搭載しており、エディタの内容や任意のテキストをAIで処理することができます。ローカル環境で動作するため、プライバシーを保護しながらAIの力を活用できます。

## 主要機能

### 編集機能
- **ライブプレビュー**: リアルタイムでMarkdownをHTMLに変換・表示
- **スクロール同期**: エディタとプレビューのスクロール位置を自動同期
- **ドラッグ&ドロップ**: ファイルを直接ドラッグ&ドロップで開く
- **画像ドラッグ&ドロップ**: 画像ファイルをエディタにドラッグ&ドロップで挿入
  - 「リンク」: 元の画像ファイルのパスを使用
  - 「コピー」: resourcesフォルダにコピー（スケール調整可能: 20%, 40%, 60%, 80%, 100%, 150%, 200%）
- **画像削除確認**: エディタ内で画像タグを含む行を削除すると、画像ファイルの削除確認ダイアログが表示される（新規作成・ファイルを開く時は除く）
- **CSV自動変換**: カンマ区切りテキストをMarkdownテーブルに自動変換
- **自動インデント**: Enterキーで4文字以上のスペースを自動継続
- **TAB変換**: TABキーを4文字の半角スペースに変換
- **リストのインデント**: TABキーでリスト項目のインデントを増やす（4スペース追加）、Shift+TABで減らす（4スペース削除）
  - リストマーカー（`1.`, `-`, `*`, `+`, `>`）で始まる行に適用
  - 複数行選択時も対応
- **スペース削除**: Backspaceキーで連続するスペースを効率的に削除

### ファイル操作
- **新規作成**: `Ctrl+N`
- **ファイルを開く**: `Ctrl+O`
- **保存**: `Ctrl+S`（ライセンス解除後のみ有効）
- **名前を付けて保存**: `Ctrl+Shift+S`（ライセンス解除後のみ有効）
- **よく使う書類**: よく使用するファイルを登録して素早く開くことができます
  - ファイルリスト: 登録済みのファイルをメニューから選択して開く（ファイル名のみ表示）
  - 現在のファイルを追加: 開いているファイルをよく使う書類に追加（ビープ音で確認）
  - 現在のファイルを削除: 開いているファイルをよく使う書類から削除（ビープ音で確認）
  - 設定は`settings.json`に保存され、起動時に自動読み込みされます
- **エクスプローラーからの起動**: Windowsエクスプローラーで`.md`ファイルをダブルクリックすると、そのファイルが自動的に開きます(要Windows登録)

### エクスポート機能
- **HTMLエクスポート**: `Ctrl+E`
- **PDFエクスポート**: `Ctrl+Shift+E`
- **PDF設定**: 余白・スケール調整可能
- **ブラウザプレビュー**: `Ctrl+P`

### 表示制御
- **分割表示**: `Ctrl+1`
- **エディタ最大化**: `Ctrl+2`
- **プレビュー最大化**: `Ctrl+3`
- **ズーム拡大**: `Ctrl+=`
- **ズーム縮小**: `Ctrl+-`

### Markdown挿入
- **タイトル**: `Ctrl+T` (H1→H2→...→H6→H1の循環)
- **太字**: `Ctrl+B`
- **イタリック**: `Ctrl+I`
- **表**: `Ctrl+Shift+T`
- **コードブロック**: `Ctrl+K`
- **水平線**: `Ctrl+H`
- **改行**: `Ctrl+R`
- **色付きテキスト**: `Ctrl+8`(黒), `Ctrl+9`(赤), `Ctrl+0`(青)
- **リンク**: `Ctrl+4`
- **引用**: `Ctrl+5`
- **ファイル**: `Ctrl+6`
- **画像**: `Ctrl+7`

### カスタム機能
- **F1～F10**: ユーザーが自由に設定可能なショートカットキー
- **カスタム設定**: 「カスタム」メニューから設定可能
- **デフォルト設定**:
  - F1: 数字付き段落 → `1. `
  - F2: 箇条書き → `- `
  - F3～F10: 未設定（自由に設定可能）
- **設定保存**: 設定は`settings.json`に保存されます
- **フォーマット**: JSON形式で保存されます

### AI機能
- **AI機能の有効/無効設定**: `設定 → アプリ`タブで個別に設定可能
  - **AI有効**: LM Studio（ローカルAI）の有効/無効を設定
  - **AI(Gemini)有効**: Gemini（クラウドAI）の有効/無効を設定
  - 各AI機能は独立して有効/無効を設定でき、起動時の接続確認も個別に実行されます
- **起動時のAI機能確認**: AI機能が有効な場合、起動時に接続確認ダイアログが表示されます
  - プログレスバー付きのダイアログで、接続確認の進行状況を表示
  - 確認完了後、自動的にダイアログが閉じます
- **ローカルAI (LM Studio)**:
  - ローカルでホストしたモデルを利用して高速かつプライバシー重視のAI処理
  - モデル選択: `AI` メニューからダウンロード済みモデルをチェックマークで切替
  - サーバーURL設定: `AI → 設定` から OpenAI 互換APIのベースURL（例: `http://localhost:1234/v1`）を編集可能。設定値は `settings.json` に保存され、次回起動時に自動で読み込まれます
  - 実行: `Ctrl+D`（エディタ内容） / `Ctrl+Shift+D`（入力ダイアログ）
- **Gemini (クラウドAI)**:
  - Google Gemini APIを利用し、モデル名・APIキーは `AI(Gemini) → 設定` で登録（`settings.json`に保存）
  - 実行: `Ctrl+G`（エディタ内容） / `Ctrl+Shift+G`（入力ダイアログ）
- **共通UI**:
  - プロンプトと出力を上下に分割表示
  - プログレスバーと経過時間表示（MM:SS形式）
  - `Send` ボタンで再処理、`Stop` ボタンでAI処理のみ中断（ダイアログは開いたまま）
  - `コピー` ボタンで結果をクリップボードへ（必要に応じてプロンプトも含める）
- **利用要件**:
  - LM Studio: API互換サーバーを有効化し、`openai` モジュールをインストール（`pip install openai`）
  - Gemini: `google-generativeai` モジュール（`pip install google-generativeai`）と有効なAPIキー
  - `settings.json` に両方の設定が保存され、旧 `setting.txt` / `Settings.txt` は自動移行

### ヘルプ機能
- **このアプリについて**: バージョン情報と著作権表示
- **ライセンス情報**: 使用しているライブラリのライセンス情報を表示
- **解除キー入力**: シェアウェア解除用のキーを入力してライセンスを解除（未解除時のみ表示）

### UI機能
- **日本語メニュー**: 完全日本語化
- **ステータス表示**: 文字位置・行番号・選択文字数表示（例：`223/2245(25/128)[123]`）
- **ウィンドウタイトル**: ビルド日付+ファイル名表示（例: `MarkdownEditor(2025/10/27) - Untitled`）
- **ズーム機能**: プレビューエリアの文字サイズを段階的に調整可能

## インストール・実行

### 実行ファイルの実行
1. `MarkdownEditor.exe`をダブルクリックして起動
2. 初回起動時は、ライセンス条項に同意してください
3. **ライセンス解除**: 保存機能を使用するには、ライセンス解除が必要です（後述の「ライセンス解除について」を参照）

### 対応OS
- Windows 10/11

### 必要な環境
- **基本機能**: 追加のインストール不要
- **AI機能（オプション）**: 
  - **ローカルAI (LM Studio)**: LM Studio（ローカルLLMサーバー）と`openai`モジュール（`pip install openai`）
  - **Gemini**: `google-generativeai`モジュール（`pip install google-generativeai`）と有効なAPIキー

### ファイル形式
- **入力**: `.md`, `.txt`, `.markdown`, `.rst`
- **出力**: `.md`, `.html`, `.pdf`

## 使用方法

### 基本的な使い方
1. アプリケーションを起動
2. 左側のエディタでMarkdownを記述
3. 右側のプレビューでリアルタイム確認
4. `Ctrl+S`で保存、`Ctrl+Shift+E`でPDFエクスポート

### タイトル機能
- **新規タイトル**: タイトル設定のない行で`Ctrl+T` → 行の先頭に`# `を挿入
- **レベル変更**: 既存の見出し行で`Ctrl+T` → H1→H2→...→H6→H1の順で循環
- **HTMLタグ対応**: `<span style="color:red;">テキスト</span>`のようなHTMLタグを含む行でも正しく動作

### CSVからテーブルへの変換
1. カンマ区切りのテキストを選択
2. 「MarkDown」→「表」メニューを選択
3. 自動的にMarkdownテーブル形式に変換

**入力例：**
```
名前,年齢,職業
太郎,25,エンジニア
花子,30,デザイナー
```

**変換後：**
```markdown
| 名前 | 年齢 | 職業 |
|------|------|------|
| 太郎 | 25   | エンジニア |
| 花子 | 30   | デザイナー |
```
| 名前 | 年齢 | 職業 |
|------|------|------|
| 太郎 | 25   | エンジニア |
| 花子 | 30   | デザイナー |
### リンク挿入
テキストを選択して`Ctrl+4`を押すと、Markdownリンク形式が挿入されます。

**例：**
- 選択テキスト: `Google` → `Ctrl+4`
- 結果: `[Google](url)` ← url部分を手動で編集

### ファイル埋め込み
`Ctrl+6`を押すと、ファイル埋め込みテンプレートが挿入されます。

**例：**
```markdown
<file path="example.txt">
ファイル内容がここに表示されます
</file>
```

### 画像埋め込み

#### メニューから挿入
`Ctrl+7`を押すと、画像埋め込みテンプレートが挿入されます。

**例：**
```markdown
![画像の説明](path/to/image.png) <-相対パス
![画像の説明](C:/path/to/aaa.png) <-フルパス
```

#### ドラッグ&ドロップで挿入
画像ファイルをエディタにドラッグ&ドロップすると、挿入方法を選択するダイアログが表示されます。

**選択肢：**
- **リンク**: 元の画像ファイルのパスをそのまま使用します。画像ファイルを移動すると表示できなくなる可能性があります。
- **コピー**: 画像をresourcesフォルダにコピーして使用します。スケール調整が可能です。

**スケール調整（コピー選択時のみ）:**
- 20%, 40%, 60%, 80%, 100%（デフォルト）, 150%, 200%から選択可能
- 選択したスケールで画像をリサイズしてからコピーします
- 高品質なリサンプリング（LANCZOS）を使用してリサイズされます

**resourcesフォルダの場所:**
- ソースコード実行時: ソースコードのフォルダ内の`resources`フォルダ
- exe実行時: exeファイルのフォルダ内の`resources`フォルダ

#### 画像削除確認
画像タグ（`![alt](path)`）を含む行をエディタ内で削除すると、画像ファイルの削除確認ダイアログが表示されます。

- **「はい」を選択**: 画像ファイルも削除されます
- **「いいえ」を選択**: 行のみ削除され、画像ファイルは残ります

複数の画像タグが含まれる場合は、すべての画像ファイルがリスト表示されます。

**注意**: 新規作成（`Ctrl+N`）やファイルを開く（`Ctrl+O`）などのプログラムによる変更時は、画像削除の確認ダイアログは表示されません。ユーザーがエディタ内で直接削除した場合のみ確認ダイアログが表示されます。

### 色付きテキスト
1. テキストを選択
2. 「MarkDown」→「色」→「黒/赤/青」を選択、またはショートカットキー（`Ctrl+8`(黒), `Ctrl+9`(赤), `Ctrl+0`(青)）を使用
3. `<span style="color:色;">テキスト</span>`形式で挿入

### スペース削除機能
Backspaceキーで連続する半角スペースを効率的に削除できます。

**動作**:
- カーソル位置の左側に4文字以上の連続するスペースがある場合、特殊処理を実行
- スペース数が4の倍数の場合: 4文字を一括削除
- それ以外の場合: 1文字削除

**例**:
- 8文字のスペース → 4文字一括削除
- 12文字のスペース → 4文字一括削除  
- 5文字のスペース → 1文字削除
- 9文字のスペース → 1文字削除
- 13文字のスペース → 1文字削除

これにより、インデント用の4スペースを素早く削除できます。

### リストのインデント機能
TABキーとShift+TABキーを使用して、リスト項目のインデントレベルを変更できます。

**動作**:
- **TABキー**: リスト項目のインデントを増やす（4スペース追加）
  - リストマーカー（`1.`, `-`, `*`, `+`, `>`）で始まる行に適用
  - 複数行選択時は、選択されたすべてのリスト項目に適用
- **Shift+TABキー**: リスト項目のインデントを減らす（4スペース削除）
  - 4スペース以上のインデントがある場合のみ適用
  - 複数行選択時は、選択されたすべてのリスト項目に適用

**例**:
```markdown
- 項目1
  - 項目1-1  ← TABキーで4スペース追加
    - 項目1-1-1  ← さらにTABキーで4スペース追加
- 項目2  ← Shift+TABキーでインデントを減らす
```

### PDFエクスポート設定
1. 「ファイル」→「エクスポート」→「PDFエクスポート設定...」
2. 余白（上・下・左・右）とスケールを調整
3. 「OK」で設定を保存

### よく使う書類の使い方
よく使う書類機能を使用すると、頻繁に使用するファイルを登録して、メニューから素早く開くことができます。

**ファイルの追加方法**:
1. 開きたいファイルを開く
2. 「ファイル」→「よく使う書類」→「現在のファイルを追加」を選択
3. ビープ音で追加が完了したことを確認

**ファイルの開き方**:
1. 「ファイル」→「よく使う書類」メニューを開く
2. 登録済みのファイル名をクリック（ファイル名のみ表示、パスは非表示）
3. ファイルが開きます

**ファイルの削除方法**:
1. 削除したいファイルを開く
2. 「ファイル」→「よく使う書類」→「現在のファイルを削除」を選択
3. ビープ音で削除が完了したことを確認

**注意事項**:
- 登録されたファイルは`settings.json`の`frequently_used_files`に保存されます
- ファイルが移動または削除された場合、起動時に自動的にリストから削除されます
- 最新に追加したファイルがメニューの一番上に表示されます

### カスタム機能の使い方
カスタム機能を使用すると、F1～F10キーに任意のテキストを割り当てることができます。

**初期設定**:
- F1を押すと `1. ` が挿入される（数字付き段落）
- F2を押すと `- ` が挿入される（箇条書き）

**カスタム設定の変更方法**:
1. 「カスタム」→「設定...」メニューを選択
2. 設定ダイアログが表示されます
3. F1～F10の各行を編集します：
   - **設定名称**: メニューに表示される名前（例: "箇条書き"）
   - **入力するキー**: キーを押した時に挿入されるテキスト（例: `- `）
4. 「OK」をクリックして保存

**使用例**:
- F3に `## ` を設定 → `Ctrl+T`の代わりにF3でH2レベルを直接入力
- F4に `> ` を設定 → 引用ブロックを素早く開始
- F5に ```` ` を設定 → コードブロックを開始

設定はアプリ終了後も保持されます。

### AI機能の使い方
AI機能は、ローカルAI（LM Studio）とGemini（クラウドAI）の2種類に対応しています。`settings.json` に各種設定が保存されます。

**ローカルAI (LM Studio) を使う**:
1. LM Studioを起動し、使用したいモデルをロード（OpenAI互換APIが有効になっていることを確認）
2. 別ホストのローカルLLMサーバーを使用する場合は、MarkdownEditor内の `AI → 設定` でベースURLを指定します（例: `http://192.168.1.10:1234/v1`）
3. 履歴機能を使用する場合は、同じ設定ダイアログで「履歴を使用」にチェックを入れ、履歴数を設定します
4. MarkdownEditorを起動
5. `AI` メニューから使用するモデルを選択（初回は自動的に先頭モデルを選択）
6. 実行ショートカット:
   - `Ctrl+D`: エディタの内容をプロンプトとして送信
   - `Ctrl+Shift+D`: ダイアログに入力したテキストを送信

**Gemini (クラウドAI) を使う**:
1. `pip install google-generativeai` でモジュールをインストール
2. Google Gemini APIキーを発行
3. MarkdownEditor内の `AI(Gemini) → 設定` でAPIキーとモデル名を入力し保存
   - **モデル一覧の自動取得**: 設定ダイアログを開くと、APIキーが設定されている場合、自動的に利用可能なモデル一覧を取得してコンボボックスに表示されます
   - 「モデル一覧を取得」ボタンで手動取得も可能です
   - コンボボックスから選択するか、手動入力も可能です
   - 保存時に接続確認を行い、成功すると `AI(Gemini)` のエディタ/ダイアログメニューが有効化
   - 履歴機能を使用する場合は、同じ設定ダイアログで「履歴を使用」にチェックを入れ、履歴数を設定します
4. 実行ショートカット:
   - `Ctrl+G`: エディタの内容をGeminiへ送信
   - `Ctrl+Shift+G`: ダイアログに入力したテキストをGeminiへ送信

**AIダイアログ共通の操作**:
- 上段: プロンプト（編集可能） / 下段: 出力結果（読み取り専用）
- `Send`: 現在のプロンプトで再処理を実行
- **送信ショートカット**: `Ctrl+Enter` または `Ctrl+Shift+Return` で送信できます
- `Stop`: 実行中のAIスレッドのみ停止（ダイアログは開いたまま）
- `コピー`: 出力をクリップボードへ。チェックONでプロンプト＋出力をまとめてコピー
- `新しいチャット`: チェックONでチャット履歴をすべてクリアして新しい会話を開始
- 処理中はプログレスバーと経過時間（MM:SS）を表示

**AIチャット履歴機能**:
- **履歴の有効化**: `AI → 設定` または `AI(Gemini) → 設定` で「履歴を使用」にチェックを入れる
- **履歴数の設定**: 同じ設定ダイアログで履歴数を指定（0-100、デフォルト: 5）
  - 履歴数は会話のペア数（ユーザーとアシスタントの1往復=1ペア）を意味します
  - 指定した数を超えると、古い会話から自動的に削除されます
- **履歴の保存**: 履歴は `history.json` に保存され、アプリ終了時に自動保存されます
- **履歴の読み込み**: アプリ起動時に `history.json` から履歴を自動読み込み
- **履歴の使用**: 履歴が有効な場合、過去の会話が新しいプロンプトの先頭に自動的に付与されます
  - ローカルAI（LM Studio）: 過去の会話をmessagesリストに含めて送信
  - Gemini: 過去の会話をテキスト形式でプロンプトの先頭に付与
- **履歴のクリア**: AIダイアログの「新しいチャット」チェックボックスで履歴を即座にクリア可能

**ヒント**:
- Gemini設定を保存したのにメニューが無効なままの場合は、APIキー・モデル名・ネットワークを再確認
- `settings.json` を直接編集してショートカットやAPI設定を一括管理することも可能
- 旧 `setting.txt` / `Settings.txt` は起動時に自動移行され、削除しても問題ありません
- 履歴機能は `history.json` に保存され、ローカルAIとGeminiで別々に管理されます
- 履歴を使用しない場合（「履歴を使用」がOFF）は、履歴への記録もプロンプトへの付与も行われません

## ライセンス解除について

本ソフトウェアはシェアウェアです。保存機能を使用するには、ライセンス解除が必要です。

### ライセンス解除の方法

1. **解除キーの取得**: 正規の解除キーを取得してください
2. **解除キーの入力**:
   - 「ヘルプ」→「解除キー入力」メニューを選択
   - 解除キーを入力（パスワード入力モードで表示）
   - 「OK」をクリック
3. **解除成功**: 解除に成功すると、以下のようになります
   - 保存メニュー（「保存」「名前を付けて保存」）が有効化されます
   - 「解除キー入力」メニューが削除されます
   - 解除キーは`settings.json`に保存され、次回起動時も有効です

### ライセンス解除前の制限

- **保存機能が無効**: 「保存」と「名前を付けて保存」メニューが無効（グレーアウト）になります
- **その他の機能**: 編集、プレビュー、エクスポート、AI機能などは制限なく使用できます

### 解除キーの管理

- 解除キーは`settings.json`の`license_unlock_key`に保存されます
- 解除状態は`license_unlocked`フラグで管理されます
- 解除キーが正しく保存されている場合、起動時に自動的に解除状態が復元されます

## トラブルシューティング

### よくある問題
- **起動しない**: 管理者権限で実行を試してください
- **ファイルが開けない**: ファイルの文字エンコーディングを確認してください
- **PDFエクスポートエラー**: PDF設定で余白を調整してください
- **AI機能が使えない**:
  - LM Studio: サーバーが起動済みか、`openai` モジュールがインストールされているか確認
  - Gemini: `google-generativeai` がインストールされているか、APIキー・モデル名が正しいか確認
  - `settings.json` の内容が壊れていないかチェック（必要なら削除して再設定）
- **AI処理で接続エラー**:
  - LM Studioの場合: OpenAI互換ポートが開いているか、選択したモデルがロード済みか確認
  - Geminiの場合: ネットワーク環境やAPIキーの権限／利用制限を確認
- **Stopボタンが効かない**: すでに処理が完了している可能性があります。ダイアログ右上の×ボタンで閉じた後、再度Sendしてください

### サポート
問題が解決しない場合は、info[at]easymeasurements.comまでメールでお知らせください。

## ライセンス

本ソフトウェアはシェアウェアです。保存機能を使用するには、ライセンス解除が必要です。

### ライセンス条項

- **試用期間**: 保存機能を除くすべての機能を無料で試用できます
- **保存機能**: ライセンス解除後に使用可能になります
- **解除キー**: 正規の解除キーを取得して、ライセンスを解除してください

### 使用ライブラリのライセンス

使用しているライブラリのライセンス情報および商用利用・ソース開示に関する要件については、同梱の`LICENSE`ファイルをご参照ください。

---
