using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Linq;
using Compiler.Data;

namespace Compiler
{

    public partial class Compiler : Form
    {
        string filename = string.Empty;
        string folderPath = string.Empty;
        GotakuFile quiz = null;
        const int MAX_QUIZ_NUM = 65536;

        public Compiler()
        {
            InitializeComponent();
            comboBox1.SelectedIndex = 0;
        }


        private void Compiler_Load(object sender, EventArgs e)
        {
            string[] argv = Environment.GetCommandLineArgs();
            if (argv.Length == 2)
            {
                if (File.Exists(argv[1]))
                {
                    this.filename = argv[1];
                    OpenProcess();
                }
            }
        }

        /// <summary>
        /// J
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolOpen_Click(object sender, EventArgs e)
        {
            using (OpenFileDialog dlg = new OpenFileDialog())
            {
                dlg.CheckFileExists = true;

                dlg.InitialDirectory = @".\";
                dlg.Filter =
                    "5tqt@C(*.5tq)|*.5tq|5txt@C(*.5tx)|*.5tx|qt1`qt8Wt@C(*.qt*)|*.qt*";
                dlg.FilterIndex = 0;

                DialogResult res = dlg.ShowDialog();
                if (res == DialogResult.OK &&
                   File.Exists(dlg.FileName))
                {
                    this.filename = dlg.FileName;
                    OpenProcess();
                }
            }
        }


        private void OpenProcess()
        {
            string extension = Path.GetExtension(filename);
            folderPath = Path.GetDirectoryName(filename);

            extension = extension.ToLower();
            if (extension.Equals(".5tq"))
            {
                // ViI쐬
                if (MakeFile(filename, GotakuFile.ReadFileType.GOTAKU_5TQ) == false) return;

            }
            else if (extension.Equals(".5tx"))
            {
                // ViI쐬
                if (MakeFile(filename, GotakuFile.ReadFileType.GOTAKU_5TX) == false) return;
            }
            else if (extension.StartsWith(".qt") && 
                extension.Length == 4 &&
                int.TryParse(extension[3].ToString(), out int number) &&
                number >= 1 && 
                number <= 8)
            {
                // ViI쐬
                if (MakeFile(filename, GotakuFile.ReadFileType.GOTAKU_QTN) == false) return;
            }
            else
            {
                MessageBox.Show("Ώۂ̃t@Cł͂܂B");
                return;
            }

            MessageBox.Show("ViI쐬܂B");
        }

        private bool MakeFile(string filename, GotakuFile.ReadFileType type)
        {
            // ViI쐬
            string scenaName = Path.GetFileNameWithoutExtension(filename);

            // NCYǂݍ
            switch (type)
            {
                case GotakuFile.ReadFileType.GOTAKU_5TQ:
                case GotakuFile.ReadFileType.GOTAKU_5TX:
                case GotakuFile.ReadFileType.GOTAKU_QTN:
                    ReadQuiz(filename, type);
                    break;
                default:
                    MessageBox.Show("肦ȂNCY`łB");
                    return false;
            }

            int quizNum = quiz.quizDatas.Count;
            if (quizNum == 0)
            {
                MessageBox.Show("NCY݂܂B");
                return false;
            } 
            else if (quizNum >= MAX_QUIZ_NUM)
            {
                MessageBox.Show("NCY" + MAX_QUIZ_NUM + "薢̂̂ɂĂB");
                return false;
            }

            quiz.timeOverCount = (int)numericUpDown1.Value;
            quiz.quizMode = comboBox1.SelectedIndex;
            quiz.unofficialXE = checkBox1.Checked;
            quiz.Write(folderPath + "\\" + scenaName + ".cwx");
            
            ////eLXgt@C炷ׂĂ̍sǂݍ
            string[] lines = System.IO.File.ReadAllLines(folderPath + "\\" + scenaName + ".cwx", Encoding.GetEncoding("SHIFT-JIS"));
            //ŏ1s폜ȂÂ悤ɂ
            lines = lines.Skip(1).ToArray();
            //eLXgt@Cɏ㏑ۑ
            System.IO.File.WriteAllLines(folderPath + "\\" + scenaName + ".cwx", lines, Encoding.GetEncoding("SHIFT-JIS"));
            return true;
        }

        private void ReadQuiz(string filename, GotakuFile.ReadFileType type)
        {
            //NCYǂݍ
            try
            {
                quiz = new GotakuFile(type);
                quiz.Read(filename);
            }
            catch (Exception ex)
            {
                MessageBox.Show("NCYǂݍ݂Ɏs܂B" + ex.Message);
                Application.Exit();
            }
            
        }

        /// <summary>
        /// hbOG^[Cxg
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Compiler_DragEnter(object sender, DragEventArgs e)
        {
            //hbOĂf[^ DataFormats.FileDrop ׁA
            //ł΃hbvʂAllɂ
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
                e.Effect = DragDropEffects.All;
        }

        /// <summary>
        /// hbOhbvCxg
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Compiler_DragDrop(object sender, DragEventArgs e)
        {
            //hbvꂽf[^string^ׂ
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                // Ώ
                string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
                if (files.Length == 1 && File.Exists(files[0]))
                {
                    this.filename = files[0];
                    OpenProcess();
                }
            }
        }

        private void ComboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (checkBox1.Checked == true)
            {
                //CW Unofficial XE
                comboBox1.Enabled = true;
                if (comboBox1.SelectedIndex == 1)
                {
                    numericUpDown1.Value = 0;
                    numericUpDown1.Enabled = false;
                }
                else
                {
                    numericUpDown1.Enabled = true;
                }
            }
            else
            {
                //cwxeditor
                comboBox1.Enabled = true;
                numericUpDown1.Value = 0;
                numericUpDown1.Enabled = false;
            }
        }

        private void CheckBox1_CheckedChanged(object sender, EventArgs e)
        {
            ComboBox1_SelectedIndexChanged(sender, e);
        }
    }

}