using System;
using System.IO;
using System.Drawing;

namespace Compiler.Data
{

    /// <summary>
    /// f[^Ƀt@C̃[hCg\bh{ۃNXB
    /// wǂ̃f[^\NXɌpB
    /// </summary>
    public abstract class FileIO
    {
        public string FullPath
        {
            set
            {
                fullpath = value;
            }
            get
            {
                return fullpath;
            }
        }
        private string fullpath;

        public abstract void Read(ShiftJisReader r);
        public abstract void Write(ShiftJisWriter w);

        public FileIO()
        {
            // RXgN^
        }

        public FileIO(string fullpath)
        {
            // t@CwRXgN^̎
            // ̂܂ܓǂݍ
            this.Read(fullpath);
        }

        /// <summary>
        /// t@CI[vÃf[^ǂݍ݂܂B
        /// </summary>
        /// <param name="file">ǂݍރt@C̖OitpXj</param>
        public virtual void Read(string fullpath)
        {
            this.fullpath = fullpath;

            using (ShiftJisReader r 
                = new ShiftJisReader(File.OpenRead(fullpath)))
            {
                Read(r);
            }
        }

        /// <summary>
        /// oCgz̃Xg[f[^ǂݍ݂܂B
        /// </summary>
        /// <param name="allBytes">oCgz</param>
        public virtual void Read(byte[] allBytes)
        {
            using (ShiftJisReader r = new ShiftJisReader(new MemoryStream(allBytes)))
            {
                Read(r);
            }
        }

        /// <summary>
        /// t@CI[vÃf[^݂܂B
        /// </summary>
        /// <param name="file">ރt@C̖OitpXj</param>
        public virtual void Write(string fullpath)
        {
            using (ShiftJisWriter w
                = new ShiftJisWriter(File.OpenWrite(fullpath)))
            {
                Write(w);
            }
        }

        public virtual void Write()
        {
            //OX[邩͂ƂŁB
            //f[^̒iKł͂ƗOX[ق
            //̂Ă
            Write(fullpath);
        }

        public virtual void Delete()
        {
            //OX[邩͂ƂŁB
            //f[^̒iKł͂ƗOX[ق
            //̂Ă
            if (File.Exists(fullpath))
            {
                File.Delete(fullpath);
            }
        }

    }
}
