using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using Microsoft.VisualBasic;
using System.Collections.Specialized;

namespace Compiler.Data
{
    public class GotakuCommandOption
    {
        public const string HC = "@HC";	//IPsŕ\(horizontal choice)
        public const string EE = "@EE";	//̌ɉtĂ܂(expression exists) @HCꍇ@HCO
        public const string EQ = "@EQ";	//蕶̏I[(end of question) @EE ŉꍇɖ蕶Ɖ؂邽߂Ɏgp
    }

    public class GotakuFile : FileIO
    {
        public enum ReadFileType
        {
            GOTAKU_5TQ,
            GOTAKU_5TX,
            GOTAKU_QTN
        }

        public enum GOTAKU_5TX_VERSION
        {
            VERSION1,
            VERSION2
        }

        private const string V2 = "v2";

        private ReadFileType type = ReadFileType.GOTAKU_5TQ;
        private GOTAKU_5TX_VERSION version = GOTAKU_5TX_VERSION.VERSION1;
        /// <summary>
        /// ^CI[o[JEg(0.1b)
        /// </summary>
        public int timeOverCount = 0;
        /// <summary>
        /// NCY[h
        /// OF_oAPFËL[h
        /// </summary>
        public int quizMode = 0;
        /// <summary>
        /// UnofficialXEΉǂ
        /// </summary>
        public bool unofficialXE = false;
        public List<GotakuHeader> listHeaders = new List<GotakuHeader>();
        public List<GotakuQuestion> quizDatas = new List<GotakuQuestion>();
        public GotakuFile() { }
        public GotakuFile(ReadFileType readType) { type = readType; }

        #region [hCg

        public override void Read(ShiftJisReader r)
        {
            switch (type)
            {
                case GotakuFile.ReadFileType.GOTAKU_5TQ:
                    {
                        // .5tq
                        Stream stream = r.BaseStream;

                        for (int genreNo = 0; genreNo < 8; genreNo++)
                        {
                            GotakuHeader header = new GotakuHeader();
                            header.Read(r);
                            listHeaders.Add(header);
                        }

                        for (int genreNo = 0; genreNo < 8; genreNo++)
                        {
                            int quizCount = listHeaders[genreNo].questionCnt;

                            for (int i = 0; i < quizCount; i++)
                            {
                                GotakuQuestion ques = new GotakuQuestion();
                                ques.Read(r);
                                quizDatas.Add(ques);
                            }
                        }
                    }
                    break;
                case GotakuFile.ReadFileType.GOTAKU_5TX:
                    {
                        // .5tx
                        string[] listArray = File.ReadAllLines(this.FullPath, Encoding.GetEncoding(932));
                        List<string> list = new List<string>();
                        foreach (string data in listArray) list.Add(data);

                        if (list.Count == 0)
                        {
                            throw new IOException();
                        }
                        else
                        {
                            if (list[0] == "5TX - Source file for 'GOTAKU' - 1.00")
                            {
                                version = GOTAKU_5TX_VERSION.VERSION1;
                            }
                            else if (list[0] == "5TX - Source file for '5TQ2CW' - 2.00")
                            {
                                version = GOTAKU_5TX_VERSION.VERSION2;
                            }
                            else
                            {
                                throw new IOException();
                            }
                        }

                        for (int genreNo = 0; genreNo < 8; genreNo++)
                        {
                            GotakuHeader header = new GotakuHeader();
                            listHeaders.Add(header);
                        }

                        // ݈ʒu
                        // t@C.5tqɃRpCƂ̏o͐tpXiFC:\5TQ\GEN5TQW\TEST.5TQj
                        int pos = 1;
                        if (list.Count <= pos) return;
                        if (isHankaku(list[pos]) == true && list[pos].StartsWith("/") == false)
                        {
                            // pos = 1
                            pos++;
                            // v[[f[^t@Ci.5TDj
                            if (list.Count <= pos) return;
                            if (isHankaku(list[pos]) == true && list[pos].StartsWith("/") == false)
                            {
                                // pos = 2
                                string file5TD = list[pos];
                                file5TD = file5TD.ToLower();
                                if (file5TD.EndsWith(".5td") == true && file5TD.Length <= 12)
                                {
                                    // pŐ擪/ȂAgq.5td8.3`̏ꍇ
                                    for (int genreNo = 0; genreNo < 8; genreNo++)
                                    {
                                        // v[[f[^t@C
                                        listHeaders[genreNo].playerFileName = file5TD;
                                    }
                                }
                            }
                        }

                        pos++;
                        // WE

                        for (int genreNo = 0; genreNo < 8; genreNo++)
                        {
                            if (list.Count <= pos) return;
                            // W
                            listHeaders[genreNo].genreName = list[pos];
                            pos++;
                            if (list.Count <= pos) return;

                            // W̖萔
                            int quizCount = 0;
                            if (int.TryParse(list[pos], out quizCount) == true && quizCount > 0)
                            {
                                // W̖萔
                                listHeaders[genreNo].questionCnt = (ushort)quizCount;

                                pos++;

                                for (int i = 0; i < quizCount; i++)
                                {
                                    // e
                                    if (list.Count <= pos + 5) return;

                                    GotakuQuestion ques = new GotakuQuestion();

                                    // 
                                    string quesText = list[pos];

                                    if (version != GOTAKU_5TX_VERSION.VERSION1)
                                    {
                                        if (quesText.StartsWith(GotakuCommandOption.HC))
                                        {
                                            // Isɕׂ
                                            quesText = quesText.TrimStart(GotakuCommandOption.HC.ToCharArray());
                                            ques.IsHorizontalChoice = true;
                                        }

                                        if (quesText.StartsWith(GotakuCommandOption.EE))
                                        {
                                            // ܂
                                            quesText = quesText.TrimStart(GotakuCommandOption.EE.ToCharArray());
                                            string[] texts = 
                                                Strings.Split(quesText, 
                                                GotakuCommandOption.EQ, -1, CompareMethod.Binary);
                                            if (texts.Length != 2)
                                            {
                                                throw new IOException();
                                            }
                                            // 
                                            ques.Expression = texts[1];
                                            quesText = texts[0];
                                        }
                                    }

                                    // 
                                    ques.Question = quesText;

                                    // I
                                    ques.Answer.Add(list[pos + 1]);
                                    ques.Answer.Add(list[pos + 2]);
                                    ques.Answer.Add(list[pos + 3]);
                                    ques.Answer.Add(list[pos + 4]);
                                    ques.Answer.Add(list[pos + 5]);

                                    quizDatas.Add(ques);

                                    pos += 6;
                                    // ̖
                                }
                            }
                            else
                            {
                                // 萔Ȃ
                                listHeaders[genreNo].questionCnt = 0;

                                pos++;
                                // ̃W
                            }
                        }
                    }

                    break;
                case GotakuFile.ReadFileType.GOTAKU_QTN:
                    {
                        // qt1`qt8
                        bool notReadFile = true;

                        for (int genreNo = 0; genreNo < 8; genreNo++)
                        {
                            GotakuHeader header = new GotakuHeader();
                            listHeaders.Add(header);
                        }

                        // .qt1 ` .qt8 ̂Wt@CΏۂɂ
                        for (int genreNo = 0; genreNo < 8; genreNo++)
                        {
                            // W̖萔@l
                            listHeaders[genreNo].questionCnt = 0;

                            string filename = this.FullPath.Substring(0, this.FullPath.Length - 1) + (genreNo + 1);
                            if (File.Exists(filename) == false) continue;

                            string[] listArray = File.ReadAllLines(filename, Encoding.GetEncoding(932));
                            List<string> list = new List<string>(listArray);

                            // RgsO
                            for (int i = list.Count - 1; i >= 0; i--)
                            {
                                if (list[i].StartsWith("/") == true)
                                    list.RemoveAt(i);
                            }

                            ushort quizCount = 0;

                            // ݈ʒu
                            // W
                            int pos = 0;
                            if ((list.Count > pos) == false) continue;
                            listHeaders[genreNo].genreName = list[pos];

                            pos++;
                            // o[W
                            if ((list.Count > pos) == false) continue;
                            string versionString = list[pos];
                            GOTAKU_5TX_VERSION ver = versionString == V2 ?
                                GOTAKU_5TX_VERSION.VERSION2 :
                                GOTAKU_5TX_VERSION.VERSION1;
                            if (notReadFile)
                            {
                                // ܂Pt@CǂݍłȂꍇ
                                notReadFile = false;
                                version = ver;
                            }
                            else
                            {
                                // Qt@Cڈȍ~
                                if (version != ver)
                                {
                                    // .qtn ԂŃo[WvȂ
                                    throw new IOException();
                                }
                            }

                            pos++;

                            while (list.Count > pos)
                            {
                                // e
                                if ((list.Count > pos + 5) == false) break;

                                GotakuQuestion ques = new GotakuQuestion();

                                string quesText = list[pos];
                                if (version != GOTAKU_5TX_VERSION.VERSION1)
                                {
                                    if (quesText.StartsWith(GotakuCommandOption.HC))
                                    {
                                        // Isɕׂ
                                        quesText = quesText.TrimStart(GotakuCommandOption.HC.ToCharArray());
                                        ques.IsHorizontalChoice = true;
                                    }

                                    if (list.Count > pos + 6)
                                    {
                                        // 
                                        ques.Expression = list[pos + 6];
                                    }
                                }

                                // 
                                ques.Question = quesText;

                                // I
                                ques.Answer.Add(list[pos + 1]);
                                ques.Answer.Add(list[pos + 2]);
                                ques.Answer.Add(list[pos + 3]);
                                ques.Answer.Add(list[pos + 4]);
                                ques.Answer.Add(list[pos + 5]);

                                quizDatas.Add(ques);
                                quizCount++;
                                pos += 7;
                                // ̖
                            }

                            // W̖萔
                            listHeaders[genreNo].questionCnt = quizCount;
                        }
                    }
                    break;

            }
        }

        public override void Write(ShiftJisWriter w)
        {
            StringCollection list = new StringCollection();

            list.Add("start \"\"");

            list.Add("\tgostart \"WI\"");
            list.Add("");
            list.Add("start \"WI\"");
            List<int> genreNos = new List<int>();
            List<string> genreNames = new List<string>();
            for (int i = 0; i < 8; i++)
            {
                list.Add("\tlosegossip \"Q5tq2cwx2-" + i + "\"");
                if (listHeaders[i].questionCnt > 0)
                {
                    genreNos.Add(i);
                    genreNames.Add(listHeaders[i].genreName);
                }
            }
            if (genreNames.Count == 1)
            {
                list.Add("\tgostart \"\"");
            }
            else
            {
                if (unofficialXE)
                {
                    list.Add("\tmsg none, \"WIĂ\", \"\", 2, true, false, false, false, 0, false");
                }
                else
                {
                    list.Add("\tmsg none, \"WIĂ\", 2, true, false, false, false");
                }

                for (int i = 0; i < genreNames.Count; i++)
                {
                    if (i == 0)
                    {
                        list.Add("\tif \"" + genreNames[i] + "(" + listHeaders[genreNos[i]].questionCnt + ")" + "\"");
                    }
                    else
                    {
                        list.Add("\telif \"" + genreNames[i] + "(" + listHeaders[genreNos[i]].questionCnt + ")" + "\"");
                    }

                    list.Add("\t\tgetgossip \"Q5tq2cwx2-" + genreNos[i] + "\"");
                    list.Add("\t\tgostart \"\"");
                }
                list.Add("\tfi");
            }

            list.Add("");
            list.Add("start \"\"");
            if (genreNames.Count == 1)
            {
                list.Add("\tgostart \"" + genreNames[0] + "\"");
            } else {
                string brgossipTab = "\t";

                List<string> listFi = new List<string>();
                for (int i = 1; i < genreNames.Count; i++)
                {
                    list.Add(brgossipTab + "brgossip \"Q5tq2cwx2-" + genreNos[i - 1] + "\"");
                    list.Add(brgossipTab + "if true");
                    list.Add("\t" + brgossipTab + "gostart \"" + genreNames[i - 1] + "\"");
                    list.Add(brgossipTab + "elif false");
                    if (genreNames.Count == (i + 1))
                    {
                        list.Add("\t" + brgossipTab + "gostart \"" + genreNames[i] + "\"");
                    }
                    listFi.Add(brgossipTab + "fi");
                    brgossipTab = "\t" + brgossipTab;
                }

                listFi.Reverse();
                list.AddRange(listFi.ToArray());
            }

            if (quizMode == 0)
            {
                if (unofficialXE)
                {
                    list.Add("");
                    list.Add("start \"\"");
                    list.Add("\tmsg none, \"I\", \"\", 1, true, false, false, false, 0, false");
                    list.Add("\tgostart \"\"");

                    list.Add("");
                    list.Add("start \"듚\"");
                    list.Add("\tmsg none, \"ԈႢ(TT\", \"\", 1, true, false, false, false, 0, false");
                    list.Add("\tgostart \"\"");

                    if (timeOverCount != 0)
                    {
                        list.Add("");
                        list.Add("start \"^CI[o[\"");
                        list.Add("\tmsg none, \"^CI[o[I\", \"\", 1, true, false, false, false, 0, false");
                        list.Add("\tgostart \"\"");
                    }
                }
                else
                {

                    list.Add("");
                    list.Add("start \"\"");
                    list.Add("\tmsg none, \"I\", 1, true, false, false");
                    list.Add("\tgostart \"\"");

                    list.Add("");
                    list.Add("start \"듚\"");
                    list.Add("\tmsg none, \"ԈႢ(TT\", 1, true, false, false");
                    list.Add("\tgostart \"\"");

                }
            } 

            int no = 0;
            Random rnd = new Random();
            for (int i = 0; i < 8; i++)
            {
                if (listHeaders[i].questionCnt == 0) continue;

                list.Add("");
                list.Add("start \"" + listHeaders[i].genreName + "\"");
                if (quizMode == 0)
                {
                    list.Add("\tbrrandomm");
                    int answerNo; 
                    int seed = Environment.TickCount;
                    rnd = new Random(seed++);
                    for (int j = 1; j <= listHeaders[i].questionCnt; j++)
                    {                        
                        answerNo = 0;

                        if (j == 1)
                        {
                            list.Add("\tif");
                        }
                        else
                        {
                            list.Add("\telif");
                        }

                        list.Add("\t\tmsg none, @");
                        //list.Add("\t\tNo." + j.ToString("D3"));
                        list.Add("\t\t" + quizDatas[no].Question);


                        if (unofficialXE)
                        {
                            if (timeOverCount != 0)
                            {
                                list.Add("\t\t@, \"^CI[o[\", 1, true, false, false, true, " + timeOverCount + ", false");
                            }
                            else
                            {
                                list.Add("\t\t@, \"\", 1, true, false, false, false, 0, false");
                            }

                            list.Add("\t\tif \"" + quizDatas[no].Answer[0] + "\"");
                            list.Add("\t\t\tgostart \"\"");
                            for (int k = 1; k < 5; k++)
                            {
                                list.Add("\t\telif \"" + quizDatas[no].Answer[k] + "\"");
                                list.Add("\t\t\tgostart \"듚\"");
                            }
                            list.Add("\t\tfi");
                        }
                        else
                        {
                            list.Add("\t\t@, 1, true, false, false, false");

                            answerNo = 0;

                            int rnds = 0;
                            int rndl = 0;
                            string answer = quizDatas[no].Answer[0];
                            string ansBuff = null;
                            for (int x = 0; x < 100; x++)
                            {
                                rnds = rnd.Next(5);
                                rndl = rnd.Next(5);
                                while (rnds == rndl)
                                {
                                    rndl = rnd.Next(5);
                                }

                                if (answerNo != rnds && answerNo != rndl)
                                // rnds  rndl@answerNo ƈႤƂ
                                {
                                    ansBuff = quizDatas[no].Answer[rnds];
                                    quizDatas[no].Answer[rnds] = quizDatas[no].Answer[rndl];
                                    quizDatas[no].Answer[rndl] = ansBuff;
                                }
                                else if (answerNo == rnds)
                                {
                                    ansBuff = quizDatas[no].Answer[answerNo];
                                    quizDatas[no].Answer[answerNo] = quizDatas[no].Answer[rndl];
                                    quizDatas[no].Answer[rndl] = ansBuff;
                                    answerNo = rndl;
                                    answer = ansBuff;
                                }
                                else if (answerNo == rndl)
                                {
                                    ansBuff = quizDatas[no].Answer[answerNo];
                                    quizDatas[no].Answer[answerNo] = quizDatas[no].Answer[rnds];
                                    quizDatas[no].Answer[rnds] = ansBuff;
                                    answerNo = rnds;
                                    answer = ansBuff;
                                }

                            }

                            for (int k = 0; k < 5; k++)
                            {
                                if (k == answerNo)
                                {
                                    if (answerNo == 0)
                                    {
                                        list.Add("\t\tif \"" + quizDatas[no].Answer[0] + "\"");
                                    }
                                    else
                                    {
                                        list.Add("\t\telif \"" + quizDatas[no].Answer[k] + "\"");
                                    }
                                    list.Add("\t\t\tgostart \"\"");

                                }
                                else
                                // k != answerNo
                                {
                                    if (k == 0)
                                    {
                                        list.Add("\t\tif \"" + quizDatas[no].Answer[0] + "\"");
                                    }
                                    else
                                    {
                                        list.Add("\t\telif \"" + quizDatas[no].Answer[k] + "\"");
                                    }
                                    list.Add("\t\t\tgostart \"듚\"");
                                }
                            }

                            list.Add("\t\tfi");

                        }
                        no += 1;
                    }
                    list.Add("\tfi");
                }
                else
                {
                    // ËL[h
                    for (int j = 1; j <= listHeaders[i].questionCnt; j++)
                    {
                        list.Add("\tmsg none, @");
                        //list.Add("\tNo." + j.ToString("D3"));
                        list.Add("\t" + quizDatas[no].Question);
                        if (unofficialXE) { 
                            list.Add("\t@, \"\", 1, true, false, false, false, 0, false");
                        }
                        else
                        {
                            list.Add("\t@, 1, true, false, false, false");
                        }
                        list.Add("\tsif \"" + quizDatas[no].Answer[0] + "\"");

                        no += 1;
                    }
                    list.Add("\tgostart \"WI\"");
                }
            }

            w.Write(list);
        }
        #endregion

        
        #region \bh
        private bool isHankaku(string str)
        {
            int num = Encoding.GetEncoding(932).GetByteCount(str);
            return num == str.Length;
        }

        /// <summary>
        /// W擾
        /// </summary>
        /// <param name="quizIndex"></param>
        /// <returns></returns>
        public string GetGenreName(int quizIndex)
        {
            int count = 0;
            for (int genreNo = 0; genreNo < 8; genreNo++)
            {
                count += listHeaders[genreNo].questionCnt;
                if (count > quizIndex)
                {
                    return listHeaders[genreNo].genreName;
                }
            }

            // 肦Ȃ
            return string.Empty;
        }

        /// <summary>
        /// W̃CfbNX擾
        /// </summary>
        /// <param name="quizIndex"></param>
        /// <returns></returns>
        public int GetGenreIndex(int quizIndex)
        {
            int count = 0;
            int oldCount = 0;
            for (int genreNo = 0; genreNo < 8; genreNo++)
            {
                oldCount = count;
                count += listHeaders[genreNo].questionCnt;
                if (count > quizIndex)
                {
                    return quizIndex - oldCount;
                }
            }

            // 肦Ȃ
            return -1;
        }
        #endregion
    }
}
