using System;
using System.IO;
using System.Text;
using System.Collections.Specialized;

namespace Compiler.Data
{
    public class ShiftJisReader : BinaryReader
    {
        private static Encoding sjisEnc 
            = Encoding.GetEncoding("shift-jis");
        private static char[] CR = { '\r' };
        private static char[] LF = { '\n' };

        public ShiftJisReader(Stream output) : base(output, sjisEnc) 
        {
        }

        // 摜KvȂꍇɎ܂Ńt@C|C^ړ
        public void SkipToNext()
        {
            int size = ReadInt32();
            if (size != 0) SkipBytes(size);
        }

        // t@C|C^ړ
        public void SkipBytes(long size)
        {
            this.BaseStream.Seek(size, SeekOrigin.Current);
        }

        /// <summary>
        /// t@CI[H
        /// </summary>
        /// <returns></returns>
        public bool IsEOF()
        {
            return this.PeekChar() < 0;
        }

        //J[h[X4byte + NULLI[ɓK
        public override string ReadString()
        {
            int len = ReadInt32();
            byte[] bs = ReadBytes(len - 1);
            if (bs.Length < len - 1)
                throw new EndOfStreamException();
            ReadByte();
            return sjisEnc.GetString(bs);
        }

        //s؂肾stringňf[^p
        public string ReadStringCRLF()
        {
            int len = ReadInt32();
            byte[] bs = ReadBytes(len);
            if (bs.Length < len)
                throw new EndOfStreamException();
            return sjisEnc.GetString(bs);
        }

        /// <summary>
        /// unsigned char string(xor 0x80 ÍȂ)
        /// </summary>
        /// <param name="size"></param>
        /// <returns></returns>
        public string ReadCharString(int size)
        {
            byte[] bs = ReadBytes(size);
            if (bs.Length < size)
                throw new EndOfStreamException();
            return sjisEnc.GetString(bs);
        }

        /// <summary>
        /// unsigned char string(xor 0x80 Í)
        /// </summary>
        /// <param name="size"></param>
        /// <returns></returns>
        public string ReadXorCharString(int size)
        {
            byte[] bs = ReadBytes(size);
            if (bs.Length < size)
                throw new EndOfStreamException();
            int lastPos = bs.Length - 1;
            while (bs[lastPos] == 0x20)
            {
                lastPos--;
            }
            int currPos = 0;
            while (currPos <= lastPos)
            {
                bs[currPos] = (byte)(bs[currPos] ^ 0x80);
                byte b1 = bs[currPos];
                currPos++;
                if (b1 <= 0x7F || b1 >= 0xA1 && b1 <= 0xDF)
                {
                    // ASCII        : 0x00`0x7F
                    // pJ^Ji : 0xA1`0xDF
                }
                else if (0x81 <= b1 && b1 <= 0x9f || 0xe0 <= b1 && b1 <= 0xfc)
                {
                    bs[currPos] = (byte)(bs[currPos] ^ 0x80);
                    byte b2 = bs[currPos];
                    currPos++;
                    if (0x40 <= b2 && b2 <= 0x7E || 0x80 <= b2 && b2 <= 0xfc)
                    {
                        //  : 1oCg: 0x81`0x9FA0xE0`0xFC
                        //        2oCg: 0x40`0x7EA0x80`0xFC
                    }
                    else
                    {
                        // NOT@SHIFT-JISI
                        throw new EndOfStreamException();
                    }
                }
                else
                {
                    // NOT@SHIFT-JISI
                    throw new EndOfStreamException();
                }
            }

            // 0x20
            byte[] bss = new byte[currPos];
            Array.Copy(bs, bss, currPos);

            return sjisEnc.GetString(bss);

        }

        //sR[h؂蕶p
        public StringCollection ReadStringCollection()
        {
            int len = ReadInt32();
            if (len == 0)
            {
                return new StringCollection();
            }
            byte[] bs = ReadBytes(len);
            if (bs.Length < len)
                throw new EndOfStreamException();
            string s = sjisEnc.GetString(bs);
            string[] sa = s.Split(LF);
            StringCollection sc = new StringCollection();
            int i, leng = sa.Length - 1;
            for (i = 0; i < leng; i++)
                sc.Add(sa[i].TrimEnd(CR));
            return sc;
        }


    }
}
