using System;
using System.IO;
using System.Text;
using System.Collections.Specialized;

namespace Compiler.Data
{
    public class ShiftJisWriter : BinaryWriter
    {
        private static Encoding sjisEnc 
            = Encoding.GetEncoding("shift-jis");
        public ShiftJisWriter(Stream output) 
            : base(output, sjisEnc) { ;}

        //String^ւ̃I[o[Ch
        public override void Write(string value)
        {
            if (value == null)
            {
                Write(1);
                Write((byte)0);
                return;
            }
            byte[] bs = sjisEnc.GetBytes(value.ToCharArray());
            Write(bs.Length + 1);
            Write(bs);
            Write((byte)0);
        }

        //sR[h؂肾String^ňf[^ɓKp܂B
        public void WriteCRLF(string value)
        {
            if (value == null)
            {
                Write(0);
                return;
            }
            byte[] bs = sjisEnc.GetBytes(value.ToCharArray());
            Write(bs.Length);
            Write(bs);
        }

        //StringCollection^ւ̃I[o[[h
        //sR[h؂蕶ɓKp܂B
        public void Write(StringCollection value)
        {
            if (value == null || value.Count == 0)
            {
                Write(0);
                return;
            }
            else
            {
                int len = 0;
                foreach (string s in value)
                    len += sjisEnc.GetByteCount(s.ToCharArray()) + 2;
                Write(len);
                foreach (string s in value)
                {
                    byte[] bs = sjisEnc.GetBytes(s.ToCharArray());
                    Write(bs);
                    Write((byte)0x0d);
                    Write((byte)0x0a);
                }
            }
        }

    }
}
