﻿# StViewer (STellar image Viewer)

## Overview
StViewer (hereinafter referred to as "this app") is a multifunctional image viewer application.
In addition to supporting major image formats, it can display images compressed in .zip files.
It also supports .gif and .webp animations, .svg vector images, JPEG XL, iPhone's .heic, and .avif.
Furthermore, it includes various features conceived by the author (SATOX), such as animation filter functions, printing (PDF output), text extraction (OCR), and a ghost window mode (transparent window).

## Operating Environment
- Windows 10 or later (Confirmed to work on Windows 11)
- 64-bit OS (x64) only
- .NET 8.0 Runtime (https://dotnet.microsoft.com/en-us/download/dotnet/8.0)

## Feature Summary
1. **Japanese and English** support
2. **Supported File Formats**
    - .zip (File compression format)
    - .webp (Animation support)
    - .png
    - .gif (Animation support)
    - .jpg / .jpeg
    - .jxl (JPEG XL)
    - .jp2 / .jpf (JPEG 2000)
    - .psd (Photoshop)
    - .heic / .heif (iPhone)
    - .avif
    - .svg (🧪 Experimental: Simple display only; filters and some other features are unavailable)
    - .tif / .tiff
    - .tga / .targa
    - .bmp
    - .ico
    - .exr
    - .dng
    - .dds
3. **Mouse Operations**
    - Images can be displayed by dropping image files or zip files.
    - **Mouse Wheel**: Next image / Previous image (Shift key for ±10)
    - **Ctrl + Mouse Wheel**: Image zoom
    - **Double-click Left Mouse Button**: Next image (Ctrl key for previous, Shift key for ±10)
    - **Left Mouse Button Drag**: Image seek within folder or archive (Shift key for ±10)
    - **Right Mouse Button Drag**: Magnifier display
    - **Right + Left Mouse Button Vertical Drag**: Image zoom
    - **Middle Mouse Button Drag**: Image panning
    - **Mouse Forward Button**: Next folder or archive
    - **Mouse Back Button**: Previous folder or archive
    - HUD Buttons
        - **HUD Right Button**: Next image
        - **HUD Left Button**: Previous image
        - **HUD Up Button**: Go to the beginning of the folder or archive
        - **HUD Down Button**: Go to the end of the folder or archive
        - **HUD Folder Button**: Show/Hide built-in file viewer
        - **HUD Maximize Button**: Toggle full-screen mode
        - **HUD Close Button**: Close this app
4. **Toolbar Button Operations**
    - Select an image via the file selection dialog
    - Show/Hide built-in file viewer
    - Beginning of folder or archive
    - Previous archive
    - Previous folder
    - Previous image
    - Next image
    - Next folder
    - Next archive
    - End of folder or archive
    - Toggle filters (dropdown)
    - Display About dialog (version, documentation reference)
5. **Key Operations**
    - **0–9 (including Numpad)**: Seek to 0%–90% position within archive, folder, or during animation playback
    - **Numpad +**: Animation skip frames +1
    - **Numpad -**: Animation skip frames -1
    - **Numpad .**: Reset animation skip frames
    - Other shortcut keys are displayed in the right-click menu.
6. **Built-in File Viewer (🧪 Experimental)**
    - Select folders and files using the in-app filer.
7. **Magnifier Function**
    - Displays a magnified view of the mouse position when dragging with the right mouse button.
8. **Loop Settings**
    - Loop within folder (continuous navigation within a group)
    - Loop within archive (continuous navigation within a group)
9. **Auto-Rotate Function**
    - Automatically rotates images to maximize the display area.
10. **Filter Functions (🧪 Experimental)** (*Animation effects)
    - Grayscale
    - Sepia
    - Blur
    - HighContrast
    - EdgeDetect
    - SurfaceBlur
    - Pixelate (Mosaic)
    - RetroGraphics
    - SkinSmooth (Whitening filter)
    - Halftone
    - Thermal (Thermography)
    - *Glitch (Chromatic aberration)
    - *RetroCrt (Retro TV)
    - *Kaleidoscope
    - *EntropyDissolve (Particle diffusion)
    - *MangaFocusLines
11. **Full-screen Display Function**
    - Displays in full screen by hiding the title bar and taskbar.
12. **Always on Top Function**
    - Allows the window to be displayed on top of others.
13. **Zoom and Panning Function**
    - Fit-to-screen scale display (default)
    - Specified scale percentage display
14. **Dot Display Function**
    - Automatically uses Nearest Neighbor display when blurring from enlargement is significant.
15. **HUD Hide Function**
    - Suppresses certain message displays.
16. **Real-time Histogram Display (🧪 Experimental)**
    - Displays the image histogram.
17. **Exif Display (🧪 Experimental)**
    - Displays Exif information for JPEG files.
18. **Paste Image from Clipboard**
    - Possible to paste and display images (Bitmaps) from the clipboard.
    - Images are saved temporarily in the temp folder and deleted when the app is closed.
19. **Copy Image to Clipboard**
    - Possible to copy images (Bitmaps) to the clipboard to paste into other apps.
20. **Color Picker Function**
    - Copies the color at the cursor position in WEB format (text).
    - Copies as #RRGGBB if alpha is disabled, and #AARRGGBB if enabled.
21. **Transparency Color Setting**
    - Displays the background of transparent images with a checkerboard pattern.
    - White, Black, Gray, etc., can also be selected.
22. **Blur Backdrop Function**
    - Allows the background to display the image with a blur effect.
23. **Background Color Setting**
    - Allows choosing and changing the background color.
24. **Ghost Window Function**
    - Allows a semi-transparent window mode where mouse operations are not reflected.
    - Can be canceled by pressing the ESC key.
25. **System Context Menu Display**
    - Displays the context menu for the currently shown file.
26. **Explorer Function**
    - Allows showing the currently displayed file selected in Explorer.
27. **OCR Function**
    - Extracts text from the currently displayed image using OCR.
28. **Printing Function (PDF Output) (🧪 Experimental)**
    - Allows printing the currently displayed image (can also output as PDF).
    - Automatically rotates to display at maximum size according to the paper size.
29. **File Sharing**
    - Invokes the Windows file sharing function.
30. **Folder and File Association Function**
    - Possible to associate supported file formats via a dialog on the first launch.
    - Associations can be removed by closing the app while holding the Shift key.
31. **Taskbar Recent Files Support**
    - Only files opened directly are registered in the taskbar's "Recent" list.
32. **Cursor Auto-hide Function**
    - The cursor is hidden when kept stationary over the viewer.

## File List
- StViewer.exe: Executable file for this app
- StViewer.settings: Settings file for this app (created when the executable is closed)
- Readme(Jp).md: This document
- LICENSE.txt: License text file

## How to Reset Settings
- If you wish to reset settings, please delete the settings file `StViewer.settings` before starting the app.

## File Association
- On the first launch, a dialog will appear inquiring about file associations.
    - To display this dialog again, delete the app settings file `StViewer.settings` before starting.
    - Once file associations are set, this app will appear in the right-click menu for supported files.

## Removing File Association
- You can remove associations by **holding the Shift key while closing this app**.
- Please perform this operation before deleting the app.

## Support
- For any bugs or requests regarding this app, please contact the author.
    - Author: SATOX (https://x.com/satoxpochi)
    - Site: https://satox.skr.jp/StViewer

## Update History
- **2026-01-13 Ver.1.0.0**
    - Initial release

## Disclaimer
Copyright (c) 2025-2026 SATOX All rights reserved.

This app (StViewer) is provided "as is," and the author makes no guarantees regarding the integrity of its operation or suitability for any specific purpose.

1. **Responsibility for Damages**: The author assumes no responsibility for any direct or indirect damages (loss of data, PC failure, financial loss, etc.) resulting from the use or inability to use this app.
2. **Prohibitions**: Analysis (reverse engineering), modification, and unauthorized reproduction or redistribution to other sites or media without the author's permission are prohibited.
3. **Copyright**: Copyrights and intellectual property rights related to this app belong to the author (SATOX).

## License
This app uses third-party libraries as described in the "LICENSE" text.

Grateful appreciation to everyone providing useful OSS.