# StViewer (STellar image Viewer)

## 概要  
StViewer（以下、本アプリ）は多機能画像ビューアーアプリケーションです。  
主要な画像形式に対応するのはもちろん、.zipに圧縮された画像も表示することができます。
.gifや.webpのアニメーション表示、.svg ベクター画像、JPEG XLやiPhoneの.heic、.avifにも対応しています。
その他、アニメーションフィルター機能や印刷機能(PDF出力)、テキスト抽出(OCR)、ゴーストウィンドウモード(透かしウィンドウ)など作者(SATOX)が思いついた機能を詰め込みました。

## 動作環境  
- Windows 10 またはそれ以降（Windows11で動作確認しています）  
- 64bit OS (x64) のみ  
- .NET 8.0 Runtime (https://dotnet.microsoft.com/en-us/download/dotnet/8.0)  


## 機能概要  
1. **日本語**、**英語** 対応
2. **対応ファイル形式**
    - .zip（ファイル圧縮形式）
    - .webp (アニメーション対応)
    - .png
    - .gif (アニメーション対応)
    - .jpg / .jpeg
    - .jxl（JPEG XL）
    - .jp2 / .jpf（JPEG2000）
    - .psd（Photoshop）
    - .heic / .heif (iPhone)
    - .avif
    - .svg（🧪実験機能：簡易表示のみ、フィルターなど一部の機能が利用できません）
    - .tif / .tiff
    - .tga / .targa
    - .bmp
    - .ico
    - .exr
    - .dng
    - .dds
3. **マウス操作**
    - 画像ファイル、zipファイルのドロップで画像を表示することができます
    - **マウスホイール** ： 次の画像・前の画像（Shiftキーで+10）
    - **Ctrl+マウスホイール** ： 画像ズーム
    - **マウス左ボタンダブルクリック** ： 次の画像（Ctrlキーで前の画像、Shiftキーで±10）
    - **マウス左ボタンドラッグ** ： フォルダ内・アーカイブ内で画像シーク（Shiftキーで±10）
    - **マウス右ボタンドラッグ** ： 拡大鏡表示
    - **マウス右＋左ボタン上下ドラッグ** ： 画像ズーム
    - **マウス中ボタンドラッグ** ： 画像パンニング
    - **マウス進むボタン** : 次のフォルダー、またはアーカイブ
    - **マウス戻るボタン** : 前のフォルダー、またはアーカイブ
    - HUDボタン
        - **HUD右ボタン** ： 次の画像
        - **HUD左ボタン** ： 前の画像
        - **HUD上ボタン** ： フォルダー、またはアーカイブの最初へ
        - **HUD下ボタン** ： フォルダー、またはアーカイブの最後へ
        - **HUDフォルダボタン** ： 内蔵ファイルビューアーの表示・非表示
        - **HUD最大化ボタン** ： フルスクリーンモード切り替え
        - **HUD閉じるボタン** ： 本アプリを閉じる
4. **ツールバー上ボタン操作**
    - ファイル選択ダイアログで画像を選択
    - 内蔵ファイルビューアーの表示・非表示
    - フォルダー、またはアーカイブの最初
    - 前のアーカイブ
    - 前のフォルダー
    - 前の画像
    - 次の画像
    - 次のフォルダー
    - 次のアーカイブ
    - フォルダー、またはアーカイブの最後
    - フィルター切り替え（ドロップダウン）
    - Aboutダイアログ表示（バージョン、ドキュメント参照）
5. **キー操作**  
    - **0～9（テンキー含む）** : アーカイブ、フォルダー内、アニメーション再生時、0%～90%位置にシーク
    - **テンキー＋** : アニメーションスキップフレーム数＋1
    - **テンキー－** : アニメーションスキップフレーム数－1
    - **テンキー．** : アニメーションスキップフレーム数のリセット
    - その他、右クリックメニューにショートカットキーが表示されます
6. **内蔵ファイルビューアー機能（🧪実験機能）**
    - アプリ内蔵ファイラーでフォルダーやファイルを選択
7. **拡大鏡機能**
    - マウス右ドラッグでマウス位置を拡大表示した拡大鏡が表示されます
8. **ループ設定機能**
    - フォルダー内でループ（グループ内前後で連続）
    - アーカイブ内でループ（グループ内前後で連続）
9. **自動回転機能**
    - 画面を最大限に表示するために自動回転
10. **フィルター機能（🧪実験機能）** （*アニメーションエフェクト）
    - Grayscale（グレースケール）
    - Sepia（セピア）
    - Blur（ブラー）
    - HighContrast（ハイコントラスト）
    - EdgeDetect（エッジ検出）
    - SurfaceBlur（サーフェイスブラー）
    - Pixelate（モザイク）
    - RetroGraphics（レトログラフィック）
    - SkinSmooth（美白フィルター）
    - Halftone（ハーフトーン）
    - Thermal（サーモグラフ）
    - *Glitch（色収差）
    - *RetroCrt（レトロテレビ）
    - *Kaleidoscope（万華鏡）
    - *EntropyDissolve（粒子拡散）
    - *MangaFocusLines（まんが集中線）
11. **フルスクリーン表示機能**
    - タイトルバーやタスクバーを非表示にして全画面表示
12. **最前面表示機能**
    - 最前面に表示することができます
13. **ズーム、パンニング機能**
    - スクリーンにフィットするスケール表示（デフォルト）
    - スケール率指定表示
14. **ドット表示機能**
    - 拡大によるボケが顕著な場合に自動でドット表示（Nearest Neighbor）
15. **HUD非表示機能**
    - 一部メッセージ表示を抑止します
16. **リアルタイムヒストグラム表示機能（🧪実験機能）**
    - 画像のヒストグラムを表示します
17. **Exif表示機能（🧪実験機能）**
    - JPEGのExif情報を表示します
18. **クリップボードから画像ペースト機能**
    - クリップボードにある画像（Bitmap）をペーストして表示可能
    - 一時的にテンポラリフォルダに保存され、本アプリ終了時に削除されます
19. **クリップボード画像コピー機能**
    - 画像（Bitmap）をクリップボードにコピー、他アプリに貼り付け可能
20. **色のピックアップ機能**
    - カーソル位置のカラーがWEB形式（テキスト）でコピー
    - アルファが無効の場合 #RRGGBB、有効の場合 #AARRGGBB 形式でコピーされます
21. **透明色設定機能**
    - 透過画像の背景をチェッカーボードパターンで表示します
    - 他に、白、黒、グレーなどが選択可能です
22. **背景ブラー表示（ブラーバックドロップ）機能**
    - 背景に画像をぼかして表示することができます
23. **背景色設定機能**
    - 背景色を選択して変更することができます
24. **ゴーストウィンドウ機能**
    - マウス操作が反映されない半透明ウィンドウモードにすることができます
    - ESCキー押下で解除することができます
25. **システムコンテキストメニュー表示機能**
    - 表示中のファイルのコンテキストメニューを表示することができます
26. **エクスプローラー機能**
    - 表示中のファイルをエクスプローラー選択表示することができます
27. **OCR機能**
    - 表示中の画像をOCRでテキスト抽出することができます
28. **印刷機能（PDF出力）（🧪実験機能）**
    - 表示中の画像を印刷することができます（印刷機能でPDF出力もできます）
    - 用紙サイズに合わせて最大表示されるように自動回転されます
29. **ファイル共有**
    - Windowsのファイル共有機能を帯び出すことができます
30. **フォルダー、ファイル関連付け機能**
    - 初回起動時のダイアログで対応ファイル形式の関連付けが可能です
    - Shiftキーを押しながら本アプリを終了することで関連付けの削除ができます
31. **タスクバーの最近使ったファイルに対応**
    - 直接開いたファイルのみがタスクバーの「最近」に登録されます
32. **カーソル自動非表示機能**
    - ビューアー上でカーソルを静止すると非表示になります

## ファイル一覧
- StViewer.exe      ： 本アプリの実行ファイル
- StViewer.settings ： 本アプリの設定ファイル(実行ファイルを終了すると作成されます)
- Readme(Jp).md      ： 本ドキュメント
- LICENSE.txt        ： ライセンステキストファイル

## 設定削除方法  
- 設定をリセットしたい場合は、設定ファイル `StViewer.settings` を削除してから本アプリを起動してください。

## ファイルの関連付け  
- 本アプリの初回起動時に、ファイルの関連付けを問い合わせるダイアログが表示されます。
    - 再びダイアログを表示させるには、アプリ設定保存ファイル `StViewer.settings` を削除してから起動してください。
    - ファイルの関連付けを行うと、対応ファイルの右クリックメニューに本アプリの起動メニューが表示されます。

## ファイルの関連付けの削除  
- **Shiftキーを押しながら本アプリを終了** することで関連付けを削除することができます。
- 本アプリを削除する前に、必ずこの操作を行ってください。

## サポート  
- 本アプリについて、不具合や要望があれば作者までお願いします。    
    - 作者： SATOX（さとっくす） (https://x.com/satoxpochi)  
    - サイト： https://satox.skr.jp/StViewer

## 更新履歴  
- **2026-01-13 Ver.1.0.9509**
    - 新規リリース

## 免責事項  
Copyright (c) 2025-2026 SATOX All rights reserved.

本アプリ（StViewer）は「現状渡し」で提供され、動作の完全性や特定の目的への適合性について、作者はいかなる保証も行いません。

1. **損害への責任**: 本アプリの使用または使用不能によって生じた直接的・間接的な損害（データの消失、PCの故障、経済的損失等）について、作者は一切の責任を負いません。  
2. **禁止事項**: 本アプリの解析（リバースエンジニアリング）、改変、および作者の許可なく他のサイトやメディアへ転載・再配布することを禁じます。  
3. **著作権**: 本アプリに関する著作権および知的財産権は、作者（SATOX）に帰属します。  

## ライセンス 
本アプリは「LICENSE」テキストに記載されているサードパーティ製ライブラリを使用しています。

有用なOSSを提供してくださっている皆様に感謝します。


EOF