# DeleteEmptyLine

## Name

Delete Empty Line

## Category

Edit

## Notation

- All

## Shortcut

## Code

```pascal
var BB := Editor.BlockBegin;
var BE := Editor.BlockEnd;

Editor.BeginUndoBlock;
try
  if Editor.SelText <> '' then begin
    if BB.X > 1 then
      Editor.SelectRange(BB.Y, 1, BE.Y, BE.X);
    Editor.SelText := RegEx.Replace(Editor.SelText, '(^\s*\r?\n)+', '', False, True);
    Exit;
  end;

  var LineNum = Editor.CaretY;
  var LineText = Editor.GetLine(LineNum);
  if RegEx.IsMatch(LineText, '^\s*$', False, False) then
    Editor.DeleteLine(LineNum);
finally
  Editor.EndUndoBlock;
end;
```
