# Heading4

## Name

Heading 4

## Category

Format

## Notation

- Markdown

## Shortcut

## Code

```pascal
var BB := Editor.BlockBegin;
var BE := Editor.BlockEnd;
var Pattern: String;
var Mark: String;

function Convert(const Line: String): String;
begin
  Result := RegEx.Replace(Line, Pattern, Mark, False, False);
end;

procedure Heading;
var
  EndLine: Integer;
begin
  if (BE.X = 1) and (BB.Y < BE.Y) then
    EndLine := BE.Y - 1
  else
    EndLine := BE.Y;

  if BB.Y = EndLine then
  begin
    Editor.SetLine(EndLine, Convert(Editor.GetLine(EndLine)));
    Exit;
  end;

  for var I := BB.Y to EndLine do
  begin
    var Line := Editor.GetLine(I);
    if Trim(Line) = '' then
      Continue;
    Editor.SetLine(I, Convert(Line));
  end;
end;

procedure MarkdownHeading;
begin
  Pattern := '^( *#{0,6} +)?';
  Mark := '#### ';
  Heading;
end;

Editor.BeginUndoBlock;
try
  case Editor.Notation of
    NotationMarkdown: 
      MarkdownHeading;
  end;
finally
  Editor.EndUndoBlock;
end;
```
