# OrderedList

## Name

Ordered List

## Category

Format

## Notation

- Markdown
- PukiWiki
- Text

## Shortcut

## Code

```pascal
var BB := Editor.BlockBegin;
var BE := Editor.BlockEnd;

procedure NumberList;
begin
  var Number := 1;
  if BB.Y > 1 then
  begin
    var Line := Editor.GetLine(BB.Y - 1);
    var NumberStr := RegEx.Match(Line, '^\d+(?=\. )', False, False);
    if NumberStr <> '' then
      Number := NumberStr.ToInteger + 1;
  end;

  var EndLine := BE.Y;
  if (BE.X = 1) and (BB.Y < BE.Y) then
    Dec(EndLine);

  if (BB.Y = EndLine) and (Editor.GetLine(BB.Y) = '') then
  begin
    Editor.SetLine(BB.Y, Format('%d. ', [Number]));
    Exit;
  end;

  for var I := BB.Y to EndLine do
  begin
    var Line := Editor.GetLine(I);
    if Line = '' then
      Continue;
    var NumberStr := Format('%d. ', [Number]);
    Line := RegEx.Replace(Line, '^(\d*\. )?', NumberStr, False, False);
    Editor.SetLine(I, Line);
    Inc(Number);
  end;

  Editor.ExecuteCommand(ecRight);
end;

procedure PukiWikiList;
begin
  var EndLine := BE.Y;
  if (BE.X = 1) and (BB.Y < BE.Y) then
    Dec(EndLine);

  if (BB.Y = EndLine) and (Editor.GetLine(BB.Y) = '') then
  begin
    Editor.SetLine(BB.Y, '+ ');
    Exit;
  end;

  for var I := BB.Y to EndLine do
  begin
    var Line := Editor.GetLine(I);
    if Line = '' then
      Continue;

    Line := RegEx.Replace(Line, '^(\+ )?', '+ ', False, False);
    Editor.SetLine(I, Line);
  end;

  Editor.ExecuteCommand(ecRight);
end;


Editor.BeginUndoBlock;
try
  case Editor.Notation of
    NotationMarkdown:
      NumberList;
    NotationPukiWiki:
      PukiWikiList;
    NotationText: 
      NumberList;
  end;
finally
  Editor.EndUndoBlock;
end;
```
