/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import jp.ne.sk_mine.util.andr_applet.ButtonSelectable;
import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMButton;
import jp.ne.sk_mine.util.andr_applet.SKMButtonGroup;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;

public class SKMRadioButton
extends SKMButton
implements ButtonSelectable {
    protected boolean mIsSelected;
    protected boolean mIsStandardMode;
    private int mBlankImageWidth;
    protected SKMColor mSelectedColor = SKMColor.BLACK;
    protected SKMColor mNotSelectedColor = SKMColor.GRAY;
    private SKMButtonGroup mGroup;
    protected int mGapW;
    protected SKMImage mOnImage;
    protected SKMImage mOffImage;

    public SKMRadioButton(String text) {
        this(text, -100, -100, false, null);
    }

    public SKMRadioButton(String text, boolean isCenter) {
        this(text, -100, -100, isCenter, null);
    }

    public SKMRadioButton(String text, int x, int y, boolean isCenter) {
        this(text, x, y, isCenter, null);
    }

    public SKMRadioButton(String text, boolean isCenter, SKMFont font) {
        this(text, -100, -100, isCenter, font);
    }

    public SKMRadioButton(String text, int x, int y, boolean isCenter, SKMFont font) {
        super(text, x, y, isCenter, font);
    }

    public SKMRadioButton(SKMImage image) {
        this(image, 0, 0, false);
    }

    public SKMRadioButton(SKMImage image, int x, int y, boolean isCenter) {
        super(image, x, y, isCenter);
    }

    public void setStandardMode(boolean f) {
        this.mIsStandardMode = f;
        if (f) {
            String basePath = SKMImage.getBasePath();
            SKMImage.setBasePath(null);
            String imagePath = "jp/ne/sk_mine/util/andr_applet/res/image/";
            this.mOnImage = new SKMImage("jp/ne/sk_mine/util/andr_applet/res/image/radio_on.png");
            this.mOffImage = new SKMImage("jp/ne/sk_mine/util/andr_applet/res/image/radio_off.png");
            SKMImage.setBasePath(basePath);
            this.mGapW = 8;
            SKMGraphics g = SKM.getGraphics();
            if (this.mFont != null) {
                g.setFont(this.mFont);
            }
            this.mWidth = this.mText == null ? this.mOnImage.getWidth() : this.mOnImage.getWidth() + this.mGapW + g.stringWidth(this.mText);
            this.mHeight = this.mOnImage.getHeight();
        } else {
            SKMGraphics g = SKM.getGraphics();
            if (this.mFont != null) {
                g.setFont(this.mFont);
            }
            this.mWidth = g.stringWidth(this.mText);
            this.mHeight = g.stringHeight();
        }
    }

    public void setImages(SKMImage onImage, SKMImage offImage) {
        this.mOnImage = onImage;
        this.mOffImage = offImage;
        SKMGraphics g = SKM.getGraphics();
        if (this.mFont != null) {
            g.setFont(this.mFont);
        }
        if (onImage != null) {
            this.mWidth = this.mText == null ? onImage.getWidth() : g.stringWidth(this.mText) + onImage.getWidth() + this.mGapW;
            this.mHeight = onImage.getHeight();
        }
    }

    @Override
    public void setFont(SKMFont font) {
        super.setFont(font);
        if (this.mIsStandardMode && this.mOnImage != null) {
            this.mWidth += this.mOnImage.getWidth() + this.mGapW;
        }
    }

    public void setColors(SKMColor selected, SKMColor notSelected) {
        this.mSelectedColor = selected;
        this.mNotSelectedColor = notSelected;
    }

    @Override
    public void setSelected(boolean f) {
        this.mIsSelected = f;
    }

    @Override
    public boolean isSelected() {
        return this.mIsSelected;
    }

    @Override
    public void setGroup(SKMButtonGroup group) {
        this.mGroup = group;
    }

    public void setBlankImageWidth(int w) {
        this.mBlankImageWidth = w;
    }

    @Override
    public boolean isHit(double x, double y, boolean isPress, boolean isJudgeOnly) {
        boolean ret = super.isHit(x, y, isPress, isJudgeOnly);
        if (isPress && ret && !isJudgeOnly && !this.isSelected()) {
            this.setSelected(!this.isSelected());
            if (this.mGroup != null) {
                this.mGroup.adjustState(this);
            }
        }
        return ret;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        if (this.mIsStandardMode) {
            if (this.mImage != null) {
                if (this.mIsPressed && this.mPressedImage != null) {
                    g.drawImage(this.mPressedImage, this.mX + this.mOnImage.getWidth(), this.mY);
                } else {
                    g.drawImage(this.mImage, this.mX + this.mOnImage.getWidth(), this.mY);
                }
            }
            if (this.mText != null) {
                if (this.mFont != null) {
                    g.setFont(this.mFont);
                }
                if (this.mIsEnabled) {
                    if (this.mTextColor != null) {
                        g.setColor(this.mTextColor);
                    }
                } else if (this.mDisabledTextColor != null) {
                    g.setColor(this.mDisabledTextColor);
                } else if (this.mTextColor != null) {
                    g.setColor(this.mTextColor);
                }
                this.paintText(g);
            }
            if (this.mOnImage != null && this.mOffImage != null) {
                g.drawImage(this.mIsSelected ? this.mOnImage : this.mOffImage, this.mX, this.mY + this.mHeight / 2 - this.mOnImage.getHeight() / 2);
            }
        } else {
            this.setTextColor(this.mIsSelected ? this.mSelectedColor : this.mNotSelectedColor);
            super.myPaint(g);
        }
    }

    @Override
    protected void paintText(SKMGraphics g) {
        int lineH = SKMUtil.toInt(1.3 * (double)this.mFont.getSize());
        int baseCx = this.mX;
        int topCy = this.mY + this.mHeight / 2 - SKMUtil.toInt(this.mTexts.length / 2) * lineH / 2;
        if (this.mIsStandardMode) {
            if (this.mOnImage == null) {
                for (int i = this.mTexts.length - 1; 0 <= i; --i) {
                    int x = baseCx + this.mBlankImageWidth + this.mGapW + g.stringWidth(this.mTexts[i]) / 2;
                    g.drawCenteringString(this.mTexts[i], x, topCy + i * lineH);
                }
            } else {
                int imageW = this.mOnImage.getWidth();
                for (int i = this.mTexts.length - 1; 0 <= i; --i) {
                    int x = baseCx + imageW + this.mGapW + g.stringWidth(this.mTexts[i]) / 2;
                    g.drawCenteringString(this.mTexts[i], x, topCy + i * lineH);
                }
            }
        } else {
            super.paintText(g);
        }
    }
}

