/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMIntFuncs;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.effect.Effect;

public final class DamageNumber
extends Effect {
    private static boolean sIsDraw = true;
    private static int sBigDigit = 3;
    private static int sStayCount = 8;
    private int mPhase;
    private int mStartY;
    private int mDigit;
    private int[] mYs;
    private int[] mDrawXs;
    private int[] mDrawYs;
    private SKMImage[] mImages;

    public static void setDraw(boolean f) {
        sIsDraw = f;
    }

    public static void setBigDigit(int digit) {
        sBigDigit = digit;
    }

    public static void setStayCount(int count) {
        sStayCount = count;
    }

    public DamageNumber(int x, int y, int damage, SKMImage[] images, SKMImage[] smallImages) {
        super(x, y);
        this.mStartY = y;
        this.mIsVisible = sIsDraw;
        this.mDigit = SKMIntFuncs.getDigit(damage);
        this.mImages = new SKMImage[this.mDigit];
        this.mYs = new int[this.mDigit];
        SKMImage[] useImages = this.mDigit < sBigDigit && smallImages != null ? smallImages : images;
        for (int i = this.mDigit - 1; 0 <= i; --i) {
            this.mImages[this.mDigit - i - 1] = useImages[damage % 10];
            damage = SKMUtil.toInt(damage / 10);
            this.mYs[i] = y;
        }
        this.mDrawXs = new int[this.mDigit];
        this.mDrawYs = new int[this.mDigit];
    }

    @Override
    protected void myMove() {
        if (this.mPhase == 1) {
            if (sStayCount < this.mCount) {
                this.kill();
            }
            return;
        }
        double dx = 14.0;
        double a = -0.2;
        double c = 39.2;
        boolean isSecond = true;
        for (int i = this.mImages.length - 1; 0 <= i; --i) {
            double oy = -0.2 * ((double)(this.mCount - i * 4) - 14.0) * ((double)(this.mCount - i * 4) - 14.0) + 39.2;
            if (oy < 0.0) continue;
            this.mYs[this.mImages.length - 1 - i] = SKMUtil.toInt((double)this.mStartY - oy);
            if (!(0.0 <= oy)) continue;
            isSecond = false;
        }
        if (isSecond) {
            this.mPhase = 1;
            this.mCount = 0;
        }
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        int w = 9 * this.mImages[0].getWidth() / 10;
        int xOffset = w * this.mDigit / 2 - w;
        int yOffset = this.mImages[0].getHeight() / 2;
        for (int i = this.mImages.length - 1; 0 <= i; --i) {
            if (this.mPhase == 0 && this.mCount - (i - this.mImages.length - 1) * 4 < 0) continue;
            this.mDrawXs[i] = this.mX + xOffset - i * w;
            this.mDrawYs[i] = this.mYs[i] - yOffset;
            g.drawImage(this.mImages[i], this.mDrawXs[i], this.mDrawYs[i]);
        }
    }
}

