/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import jp.ne.sk_mine.util.andr_applet.ReceiveCallback;
import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMButton;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMConnectUtil;
import jp.ne.sk_mine.util.andr_applet.SKMDate;
import jp.ne.sk_mine.util.andr_applet.SKMEnvUtil;
import jp.ne.sk_mine.util.andr_applet.SKMFlowString;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMI18N;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMImageLoader;
import jp.ne.sk_mine.util.andr_applet.SKMMap;
import jp.ne.sk_mine.util.andr_applet.SKMSettings;
import jp.ne.sk_mine.util.andr_applet.SKMStringBuilder;
import jp.ne.sk_mine.util.andr_applet.SKMUI;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.SKMView;
import jp.ne.sk_mine.util.andr_applet.game.Block;
import jp.ne.sk_mine.util.andr_applet.game.DirectionButton;
import jp.ne.sk_mine.util.andr_applet.game.GameCharacter;
import jp.ne.sk_mine.util.andr_applet.game.GameMapBase;
import jp.ne.sk_mine.util.andr_applet.game.PauseButton;
import jp.ne.sk_mine.util.andr_applet.game.ShotCharacter;
import jp.ne.sk_mine.util.andr_applet.game.ViewCamera;
import jp.ne.sk_mine.util.andr_applet.game.effect.Effect;
import jp.ne.sk_mine.util.andr_applet.game.event.EventManager;
import jp.ne.sk_mine.util.andr_applet.game.event.StageRecord;
import jp.ne.sk_mine.util.twitter.TwitterDialog;
import org.json.JSONObject;

public class GameView
extends SKMView {
    public static final int PHASE_OPENING = 0;
    public static final int PHASE_STAGE_START = 1;
    public static final int PHASE_GAME = 2;
    public static final int PHASE_STAGE_CLEAR = 3;
    public static final int PHASE_ENDING = 4;
    public static final int PHASE_GAMEOVER = 5;
    public static final int PHASE_NONE = -9999;
    public static final int SUBPHASE_NONE = -9999;
    public static final int DIFFICULTY_EASY = 0;
    public static final int DIFFICULTY_NORMAL = 1;
    public static final int DIFFICULTY_HARD = 2;
    protected int mPhase;
    protected int mSubPhase;
    protected int mStage;
    protected int mMaxStage;
    protected int mNextPhase;
    protected int mNextSubPhase;
    protected int mPhaseAfterOpening;
    protected int mRecordNum;
    private int mCoverAlpha;
    private int mCoverDAlpha;
    protected boolean mIsUpKeyPressed;
    protected boolean mIsDownKeyPressed;
    protected boolean mIsLeftKeyPressed;
    protected boolean mIsRightKeyPressed;
    protected boolean mIsShiftKeyPressed;
    protected boolean mIsCtrlKeyPressed;
    protected boolean mIsAltKeyPressed;
    protected boolean mIsUsePauseButton;
    protected boolean mIsUseResetOnPausingButton;
    protected boolean mIsPaintMineMembersAfterMine;
    protected boolean mIsPaintEnemiesAfterMine;
    protected boolean mIsEventRun;
    protected boolean mIsSeasonalEffectDisabled;
    private boolean mIsSpecialOpeningDone;
    protected String mNameSettingCheckKey;
    protected EventManager mEvents;
    protected SKMFlowString[] mFlowStrings;
    protected SKMArray<GameCharacter> mObjects;
    protected SKMArray<GameCharacter> mNearObjects;
    protected SKMArray<GameCharacter> mEnemies;
    protected SKMArray<GameCharacter> mMineMembers;
    protected SKMArray<Effect> mEffects;
    protected SKMArray<Effect> mUiEffects;
    private SKMColor mCoverColor;
    protected GameMapBase mMap;
    protected ShotCharacter mMine;
    protected PauseButton mPauseButton;
    protected DirectionButton mDirectionButton;
    protected SKMArray<SKMButton> mButtonsOnPausing;
    private boolean mIsTweet;
    private String mTweet;
    private String mHashTag;

    public GameView() {
        SKMImageLoader.getInstance().setUseCache(true);
        this.mIsUseResetOnPausingButton = true;
        this.mIsEventRun = true;
        this.mRecordNum = 10;
        this.mNameSettingCheckKey = "ns_ch";
        this.mEvents = new EventManager();
        this.mMine = new ShotCharacter(0.0, 0.0, 4096);
        this.mMap = new GameMapBase();
        this.mFlowStrings = new SKMFlowString[10];
        this.mEnemies = new SKMArray();
        this.mMineMembers = new SKMArray();
        this.mObjects = new SKMArray();
        this.mNearObjects = new SKMArray();
        this.mEffects = new SKMArray();
        this.mUiEffects = new SKMArray();
        this.mButtonsOnPausing = new SKMArray();
        this.mIsUsePauseButton = !SKMEnvUtil.isPc();
        this.mPhaseAfterOpening = 1;
    }

    @Override
    public void setAppId(String id) {
        super.setAppId(id);
        this.mDirectionButton = new DirectionButton(10, this.getDrawHeight() - 10 - 150, 150);
        this.mDirectionButton.setVisible(false);
    }

    @Override
    public void init() {
        super.init();
        int runCount = this.getIntSetting("run_count", 0);
        this.setSetting("run_count", runCount + 1);
        this.saveSettings();
    }

    @Override
    protected void libInit() {
        super.libInit();
        SKM.setManager(this);
    }

    @Override
    protected void initBeforeLoop() {
        super.initBeforeLoop();
        String basePath = SKMImage.getBasePath();
        SKMImage.setBasePath(null);
        this.mPauseButton = this.getNewPauseButton();
        this.mPauseButton.setCenterXY(this.mPauseButton.getCoreWidth() / 2 + 5, this.mPauseButton.getCoreHeight() / 2 + 5);
        this.mPauseButton.setVisible(false);
        this.addButton(this.mPauseButton);
        String imagePath = "jp/ne/sk_mine/util/andr_applet/res/image/";
        SKMImage.setBasePath("jp/ne/sk_mine/util/andr_applet/res/image/");
        new SKMImage("w_check_on.png");
        new SKMImage("w_check_off.png");
        SKMImage.setBasePath(basePath);
    }

    protected PauseButton getNewPauseButton() {
        String imageRes = "jp/ne/sk_mine/util/andr_applet/game/res/image/";
        return new PauseButton(new SKMImage("jp/ne/sk_mine/util/andr_applet/game/res/image/pause_button.png"), new SKMImage("jp/ne/sk_mine/util/andr_applet/game/res/image/play_button.png"));
    }

    protected void setUsePauseButton(boolean f) {
        this.mIsUsePauseButton = f;
    }

    protected boolean isUsePauseButton() {
        return this.mIsUsePauseButton;
    }

    protected void setUseResetOnPausingButton(boolean f) {
        this.mIsUseResetOnPausingButton = f;
    }

    public void addButtonOnPausing(SKMButton button) {
        this.removeButtonOnPausing(button);
        this.mButtonsOnPausing.add(button);
    }

    public boolean removeButtonOnPausing(SKMButton button) {
        return this.mButtonsOnPausing.remove(button) != null;
    }

    public void removeAllButtonsOnPausing() {
        this.mButtonsOnPausing.clear();
    }

    protected void setDirectionButtonVisible(boolean f) {
        this.mIsUpKeyPressed = false;
        this.mIsDownKeyPressed = false;
        this.mIsLeftKeyPressed = false;
        this.mIsRightKeyPressed = false;
        this.mDirectionButton.setVisible(f);
    }

    public DirectionButton getDirectionButton() {
        return this.mDirectionButton;
    }

    @Override
    protected void switchPauseProc() {
        if (this.mIsUsePauseButton) {
            if (this.isPausing()) {
                for (int i = this.mButtonsOnPausing.size() - 1; 0 <= i; --i) {
                    this.mButtonsOnPausing.get(i).setVisible(false);
                }
                this.mPauseButton.reset();
            } else if (this.mButtonsOnPausing.size() != 0) {
                this.layoutButtonsOnPausing();
                for (int i = this.mButtonsOnPausing.size() - 1; 0 <= i; --i) {
                    this.mButtonsOnPausing.get(i).setVisible(true);
                }
            }
        }
        super.switchPauseProc();
    }

    protected void layoutButtonsOnPausing() {
        SKMButton baseButton = this.mButtonsOnPausing.get(0);
        int buttonX = this.mPauseButton.getWidth() + 20;
        int buttonY = baseButton.getHeight() / 2 + 5;
        for (int i = 0; i < this.mButtonsOnPausing.size(); ++i) {
            SKMButton button = this.mButtonsOnPausing.get(i);
            int buttonW = button.getWidth();
            button.setCenterXY(buttonX + buttonW / 2, buttonY);
            buttonX += buttonW + 20;
        }
    }

    public void setPaintMineMembersAfterMine(boolean f) {
        this.mIsPaintMineMembersAfterMine = f;
    }

    public void setPaintEnemiesAfterMine(boolean f) {
        this.mIsPaintEnemiesAfterMine = f;
    }

    public void setPhaseAfterOpening(int phase) {
        this.mPhaseAfterOpening = phase;
    }

    public void setSpecialOpeningDone(boolean f) {
        this.mIsSpecialOpeningDone = f;
    }

    public boolean isSpecialOpeningDone() {
        return this.mIsSpecialOpeningDone;
    }

    public void setNameSettingCheckKey(String key) {
        this.mNameSettingCheckKey = key;
    }

    public String getNameSettingCheckKey() {
        return this.mNameSettingCheckKey;
    }

    public GameCharacter getMine() {
        return this.mMine;
    }

    public GameMapBase getMap() {
        return this.mMap;
    }

    public void setStage(int stage) {
        this.mStage = stage;
    }

    public int getStage() {
        return this.mStage;
    }

    public void setMaxStage(int stage) {
        this.mMaxStage = stage;
    }

    public int getMaxStage() {
        return this.mMaxStage;
    }

    public EventManager getEventManager() {
        return this.mEvents;
    }

    public double getScreenLeftX() {
        if (this.mViewCamera == null) {
            return 0.0;
        }
        return this.mViewCamera.getX() - (double)(this.getDrawWidth() / 2);
    }

    public double getScreenRightX() {
        if (this.mViewCamera == null) {
            return this.getDrawWidth();
        }
        return this.mViewCamera.getX() + (double)(this.getDrawWidth() / 2);
    }

    public double getScreenTopY() {
        if (this.mViewCamera == null) {
            return 0.0;
        }
        return this.mViewCamera.getY() - (double)(this.getDrawHeight() / 2);
    }

    public double getScreenBottomY() {
        if (this.mViewCamera == null) {
            return this.getDrawHeight();
        }
        return this.mViewCamera.getY() + (double)(this.getDrawHeight() / 2);
    }

    public void setPhase(int phase) {
        this.mCount = 0;
        this.mEvents.clear();
        this.clearFlowStrings();
        if (this.mPauseButton != null) {
            this.mPauseButton.setVisible(this.mIsUsePauseButton && this.shouldPauseButtonShow(phase));
            this.mPauseButton.reset();
        }
        if (this.isUpdateI18NExtensionEnabled(phase)) {
            SKMI18N.setExtensionEnabled(this.isNameSettingAvailable() && this.getBooleanSetting(this.mNameSettingCheckKey, false));
        }
        this.mySetPhase(phase);
        this.mPhase = phase;
        this.mSubPhase = 0;
    }

    protected boolean isUpdateI18NExtensionEnabled(int phase) {
        return phase == 0;
    }

    protected boolean shouldPauseButtonShow(int phase) {
        return phase == 2;
    }

    public void setSeasonalEffectDisabled(boolean f) {
        this.mIsSeasonalEffectDisabled = f;
        this.setSetting("disable_seasonal_effect", f);
        this.saveSettings();
    }

    public boolean isSeasonalEffectDisabled() {
        return this.mIsSeasonalEffectDisabled;
    }

    public boolean isChristmasSeason() {
        return new SKMDate().getMonth() == 11;
    }

    @Override
    public void removeAllUis() {
        int i;
        for (i = this.mButtons.size() - 1; 0 <= i; --i) {
            SKMButton button = (SKMButton)this.mButtons.get(i);
            if (button == this.mPauseButton) continue;
            this.mButtons.removeAt(i);
        }
        for (i = this.mComponents.size() - 1; 0 <= i; --i) {
            this.removeUi((SKMUI)this.mComponents.get(i));
        }
        this.mComponents.clear();
    }

    protected void mySetPhase(int phase) {
    }

    public void setSubPhase(int subPhase) {
        this.mySetSubPhase(subPhase);
        this.mSubPhase = subPhase;
        this.mCount = 0;
    }

    protected void mySetSubPhase(int subPhase) {
    }

    @Override
    public void reset() {
        this.mIsUpKeyPressed = false;
        this.mIsDownKeyPressed = false;
        this.mIsLeftKeyPressed = false;
        this.mIsRightKeyPressed = false;
        this.mIsShiftKeyPressed = false;
        this.mIsCtrlKeyPressed = false;
        this.mIsAltKeyPressed = false;
        this.mIsTweet = false;
        this.mIsEventRun = true;
        this.mNextPhase = -9999;
        this.mNextSubPhase = -9999;
        this.mTweet = null;
        this.mEvents.clear();
        this.mMine.reset();
        this.clearFlowStrings();
        this.clearEnemies();
        this.clearMineMembers();
        this.clearObjects();
        this.clearNearObjects();
        this.clearEffects();
        this.clearUiEffects();
        super.reset();
    }

    public boolean addEnemy(GameCharacter enemy) {
        this.mEnemies.add(enemy);
        return true;
    }

    public boolean addEnemyToFront(GameCharacter enemy) {
        this.mEnemies.add(0, enemy);
        return true;
    }

    public boolean removeEnemy(GameCharacter enemy) {
        return this.mEnemies.remove(enemy) != null;
    }

    public SKMArray<GameCharacter> getEnemies() {
        return this.mEnemies;
    }

    public void clearEnemies() {
        for (int i = this.mEnemies.size() - 1; 0 <= i; --i) {
            GameCharacter enemy = this.mEnemies.get(i);
            if (enemy == null) continue;
            enemy.finalize();
        }
        this.mEnemies.clear();
    }

    public boolean addMineMember(GameCharacter mineMember) {
        this.mMineMembers.add(mineMember);
        return true;
    }

    public boolean addMineMemberToFront(GameCharacter mineMember) {
        this.mMineMembers.add(0, mineMember);
        return true;
    }

    public boolean removeMineMember(GameCharacter mineMember) {
        return this.mMineMembers.remove(mineMember) != null;
    }

    public SKMArray<GameCharacter> getMineMembers() {
        return this.mMineMembers;
    }

    public void clearMineMembers() {
        for (int i = this.mMineMembers.size() - 1; 0 <= i; --i) {
            GameCharacter mineMember = this.mMineMembers.get(i);
            if (mineMember == null) continue;
            mineMember.finalize();
        }
        this.mMineMembers.clear();
    }

    public boolean addObject(GameCharacter object) {
        this.mObjects.add(object);
        return true;
    }

    public boolean addObjectToFront(GameCharacter object) {
        this.mObjects.add(0, object);
        return true;
    }

    public GameCharacter removeObject(GameCharacter object) {
        return this.mObjects.remove(object);
    }

    public void clearObjects() {
        for (int i = this.mObjects.size() - 1; 0 <= i; --i) {
            GameCharacter gc = this.mObjects.get(i);
            if (gc == null) continue;
            gc.finalize();
        }
        this.mObjects.clear();
    }

    public boolean addNearObject(GameCharacter object) {
        this.mNearObjects.add(object);
        return true;
    }

    public boolean addNearObjectToFront(GameCharacter object) {
        this.mNearObjects.add(0, object);
        return true;
    }

    public GameCharacter removeNearObject(GameCharacter object) {
        return this.mNearObjects.remove(object);
    }

    public void clearNearObjects() {
        for (int i = this.mNearObjects.size() - 1; 0 <= i; --i) {
            GameCharacter gc = this.mNearObjects.get(i);
            if (gc == null) continue;
            gc.finalize();
        }
        this.mNearObjects.clear();
    }

    public boolean addEffect(Effect effect) {
        this.mEffects.add(effect);
        return true;
    }

    public boolean addEffectToFront(Effect effect) {
        this.mEffects.add(0, effect);
        return true;
    }

    public boolean addEffectExclusive(Effect effect) {
        String className = effect.getClass().getCanonicalName();
        for (int i = this.mEffects.size() - 1; 0 <= i; --i) {
            if (!this.mEffects.get(i).getClass().getCanonicalName().equals(className)) continue;
            this.mEffects.removeAt(i);
        }
        return this.addEffect(effect);
    }

    public boolean addEffectExclusiveToFront(Effect effect) {
        String className = effect.getClass().getCanonicalName();
        for (int i = this.mEffects.size() - 1; 0 <= i; --i) {
            if (!this.mEffects.get(i).getClass().getCanonicalName().equals(className)) continue;
            this.mEffects.removeAt(i);
        }
        return this.addEffectToFront(effect);
    }

    public Effect removeEffect(Effect effect) {
        return this.mEffects.remove(effect);
    }

    public void clearEffects() {
        for (int i = this.mEffects.size() - 1; 0 <= i; --i) {
            Effect effect = this.mEffects.get(i);
            if (effect == null) continue;
            effect.finalize();
        }
        this.mEffects.clear();
    }

    public boolean addUiEffect(Effect effect) {
        this.mUiEffects.add(effect);
        return true;
    }

    public boolean addUiEffectToFront(Effect effect) {
        this.mUiEffects.add(0, effect);
        return true;
    }

    public Effect removeUiEffect(Effect effect) {
        return this.mUiEffects.remove(effect);
    }

    public void clearUiEffects() {
        for (int i = this.mUiEffects.size() - 1; 0 <= i; --i) {
            Effect effect = this.mUiEffects.get(i);
            if (effect == null) continue;
            effect.finalize();
        }
        this.mUiEffects.clear();
    }

    public boolean addFlowString(SKMFlowString fs) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] != null) continue;
            this.mFlowStrings[i] = fs;
            return true;
        }
        return false;
    }

    public boolean removeFlowString(SKMFlowString fs) {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            if (this.mFlowStrings[i] != fs) continue;
            this.mFlowStrings[i] = null;
            return true;
        }
        return false;
    }

    public void clearFlowStrings() {
        for (int i = 0; i < this.mFlowStrings.length; ++i) {
            this.mFlowStrings[i] = null;
        }
    }

    public void setNextPhase(int phase) {
        this.mNextPhase = phase;
    }

    public void setNextSubPhase(int subPhase) {
        this.mNextSubPhase = subPhase;
    }

    @Deprecated
    public void setTriggerToNextPhase(int phase) {
        this.mNextPhase = phase;
    }

    @Override
    protected void myMousePressed(MouseEvent me) {
        int button = 0;
        if (SwingUtilities.isRightMouseButton(me)) {
            button = 2;
        } else if (SwingUtilities.isMiddleMouseButton(me)) {
            button = 1;
        }
        this.myMousePressed(me.getX(), me.getY(), button);
    }

    protected boolean myMousePressed(int mx, int my, int button) {
        if (this.isPausing() || this.mPauseButton.isHit(mx, my, false, false)) {
            return true;
        }
        if (this.mDirectionButton.isHit(mx, my)) {
            this.mIsUpKeyPressed = false;
            this.mIsDownKeyPressed = false;
            this.mIsLeftKeyPressed = false;
            this.mIsRightKeyPressed = false;
            int dir = this.mDirectionButton.getDir();
            if ((dir & 1) != 0) {
                this.mIsUpKeyPressed = true;
            }
            if ((dir & 4) != 0) {
                this.mIsDownKeyPressed = true;
            }
            if ((dir & 8) != 0) {
                this.mIsLeftKeyPressed = true;
            }
            if ((dir & 2) != 0) {
                this.mIsRightKeyPressed = true;
            }
        }
        if (this.mIsEventRun && this.mEvents.hasEvent() && this.mEvents.mousePressed(mx, my, button)) {
            this.mIsMouseLeftPressed = false;
            this.mIsMouseMiddlePressed = false;
            this.mIsMouseRightPressed = false;
            return true;
        }
        return false;
    }

    @Override
    protected void myMouseReleased(MouseEvent me) {
        int button = 0;
        if (SwingUtilities.isRightMouseButton(me)) {
            button = 2;
        } else if (SwingUtilities.isMiddleMouseButton(me)) {
            button = 1;
        }
        this.myMouseReleased(me.getX(), me.getY(), button);
    }

    protected boolean myMouseReleased(int mx, int my, int button) {
        if (this.isPausing()) {
            this.mIsMouseLeftReleased = false;
            this.mIsMouseRightReleased = false;
            this.mIsMouseMiddleReleased = false;
            return true;
        }
        this.mIsUpKeyPressed = false;
        this.mIsDownKeyPressed = false;
        this.mIsLeftKeyPressed = false;
        this.mIsRightKeyPressed = false;
        this.mDirectionButton.setPressed(false);
        if (this.mIsEventRun && this.mEvents.hasEvent() && this.mEvents.mouseReleased(mx, my, button)) {
            this.mIsMouseLeftReleased = false;
            this.mIsMouseRightReleased = false;
            this.mIsMouseMiddleReleased = false;
            return true;
        }
        return false;
    }

    protected void applyDirectionButton(double x, double y) {
        this.mIsUpKeyPressed = false;
        this.mIsDownKeyPressed = false;
        this.mIsLeftKeyPressed = false;
        this.mIsRightKeyPressed = false;
        if (this.mDirectionButton.isPressed()) {
            int dir = this.mDirectionButton.calcDir(x, y);
            if ((dir & 1) != 0) {
                this.mIsUpKeyPressed = true;
            }
            if ((dir & 4) != 0) {
                this.mIsDownKeyPressed = true;
            }
            if ((dir & 8) != 0) {
                this.mIsLeftKeyPressed = true;
            }
            if ((dir & 2) != 0) {
                this.mIsRightKeyPressed = true;
            }
        }
    }

    @Override
    protected void myMouseMoved(MouseEvent me) {
        this.myMouseMoved(me.getX(), me.getY());
    }

    protected boolean myMouseMoved(int mx, int my) {
        if (this.isPausing()) {
            return true;
        }
        return this.mEvents.hasEvent() && this.mEvents.mouseMoved(mx, my);
    }

    @Override
    protected void myMouseDragged(MouseEvent me) {
        this.myMouseDragged(me.getX(), me.getY());
    }

    protected boolean myMouseDragged(int mx, int my) {
        if (this.isPausing()) {
            return true;
        }
        return this.mEvents.hasEvent() && this.mEvents.mouseDragged(mx, my);
    }

    @Override
    protected void myMouseWheelMoved(MouseWheelEvent mwe) {
        this.myMouseWheelMoved(mwe.getWheelRotation());
    }

    protected boolean myMouseWheelMoved(int rotation) {
        if (this.mEvents.hasEvent()) {
            this.mEvents.mouseWheelMoved(rotation);
            return true;
        }
        return false;
    }

    @Override
    protected boolean systemKeyPressed(KeyEvent ke) {
        int keyCode = ke.getKeyCode();
        if (keyCode == this.mPauseKey) {
            this.mPauseButton.pressed();
            return true;
        }
        return super.systemKeyPressed(ke);
    }

    @Override
    protected boolean gameKeyPressed(KeyEvent ke) {
        boolean isShift = (ke.getModifiersEx() & 0x40) != 0;
        boolean isCtrl = (ke.getModifiersEx() & 0x80) != 0;
        boolean isAlt = (ke.getModifiersEx() & 0x200) != 0;
        int keyCode = ke.getKeyCode();
        if (this.mEvents.hasEvent() && this.mEvents.keyPressed(keyCode, isShift, isCtrl, isAlt)) {
            return true;
        }
        return this.gameKeyPressed(keyCode, isShift, isCtrl, isAlt);
    }

    protected boolean gameKeyPressed(int keyCode, boolean isShift, boolean isCtrl, boolean isAlt) {
        if (this.isUpKey(keyCode)) {
            this.mIsUpKeyPressed = true;
        } else if (this.isDownKey(keyCode)) {
            this.mIsDownKeyPressed = true;
        } else if (this.isLeftKey(keyCode)) {
            this.mIsLeftKeyPressed = true;
        } else if (this.isRightKey(keyCode)) {
            this.mIsRightKeyPressed = true;
        } else if (keyCode == 16) {
            this.mIsShiftKeyPressed = true;
        } else if (keyCode == 17) {
            this.mIsCtrlKeyPressed = true;
        } else if (keyCode == 18) {
            this.mIsAltKeyPressed = true;
        }
        return false;
    }

    @Override
    protected boolean gameKeyReleased(KeyEvent ke) {
        boolean isShift = (ke.getModifiersEx() & 0x40) != 0;
        boolean isCtrl = (ke.getModifiersEx() & 0x80) != 0;
        boolean isAlt = (ke.getModifiersEx() & 0x200) != 0;
        int keyCode = ke.getKeyCode();
        if (this.mEvents.hasEvent() && this.mEvents.keyReleased(keyCode, isShift, isCtrl, isAlt)) {
            return true;
        }
        return this.gameKeyReleased(keyCode, isShift, isCtrl, isAlt);
    }

    protected boolean gameKeyReleased(int keyCode, boolean isShift, boolean isCtrl, boolean isAlt) {
        if (this.isUpKey(keyCode)) {
            this.mIsUpKeyPressed = false;
        } else if (this.isDownKey(keyCode)) {
            this.mIsDownKeyPressed = false;
        } else if (this.isLeftKey(keyCode)) {
            this.mIsLeftKeyPressed = false;
        } else if (this.isRightKey(keyCode)) {
            this.mIsRightKeyPressed = false;
        } else if (keyCode == 16) {
            this.mIsShiftKeyPressed = false;
        } else if (keyCode == 17) {
            this.mIsCtrlKeyPressed = false;
        } else if (keyCode == 18) {
            this.mIsAltKeyPressed = false;
        }
        return false;
    }

    @Override
    protected boolean systemInputProc() {
        if (this.shouldPauseButtonShow(this.mPhase) && this.mIsMouseLeftPressed && this.mPauseButton != null && this.mPauseButton.isHit(this.mMousePressedX, this.mMousePressedY)) {
            this.mPauseButton.pressed();
            this.mIsMouseLeftPressed = false;
            return true;
        }
        return false;
    }

    @Override
    protected void myRun() {
        if (this.mNextPhase != -9999) {
            this.setPhase(this.mNextPhase);
            this.mNextPhase = -9999;
        }
        if (this.mNextSubPhase != -9999) {
            this.setSubPhase(this.mNextSubPhase);
            this.mNextSubPhase = -9999;
        }
        this.runBeforeAllPhases();
        switch (this.mPhase) {
            case 0: {
                this.runOpening();
                break;
            }
            case 1: {
                this.runStageStart();
                break;
            }
            case 2: {
                this.runGame();
                break;
            }
            case 3: {
                this.runStageClear();
                break;
            }
            case 5: {
                this.runGameOver();
                break;
            }
            case 4: {
                this.runEnding();
                break;
            }
            default: {
                this.runOtherPhases();
            }
        }
        this.runEffects();
        this.runUiEffects();
        this.runAfterAllPhases();
        this.clearInput();
        if (this.mIsTweet) {
            this.mIsTweet = false;
            this.tweetProc();
        }
        this.moveFlowStrings();
    }

    protected void runBeforeAllPhases() {
    }

    protected void runEffects() {
        for (int i = this.mEffects.size() - 1; 0 <= i; --i) {
            Effect effect = this.mEffects.get(i);
            effect.move();
            if (!effect.isDead()) continue;
            this.mEffects.remove(effect);
        }
    }

    protected void runUiEffects() {
        for (int i = this.mUiEffects.size() - 1; 0 <= i; --i) {
            Effect effect = this.mUiEffects.get(i);
            effect.move();
            if (!effect.isDead()) continue;
            this.mUiEffects.remove(effect);
        }
    }

    protected void runOpening() {
        if (this.mEvents.hasEvent()) {
            this.mEvents.runEvent();
            if (this.mEvents.isEventFinished()) {
                this.mEvents.removeFinishedEvents();
                this.setPhase(this.mPhaseAfterOpening);
            }
        }
    }

    protected void runStageStart() {
        if (this.mEvents.hasEvent()) {
            this.mEvents.runEvent();
            if (this.mEvents.isEventFinished()) {
                this.mEvents.removeFinishedEvents();
                this.setPhase(2);
            }
        }
    }

    protected void runGame() {
        int n;
        int i;
        if (this.canMapMove()) {
            this.mMap.move(this.mStage, this.mCount);
        }
        SKMArray<Block> blocks = this.mMap.getBlocks();
        if (this.canCharactersMove()) {
            this.mMine.move(blocks);
            for (int i2 = this.mMineMembers.size() - 1; 0 <= i2; --i2) {
                GameCharacter mineMember = this.mMineMembers.get(i2);
                mineMember.move(blocks);
                if (!mineMember.isDead()) continue;
                mineMember.finalize();
                this.mMineMembers.removeAt(i2);
            }
            int enemyNum = this.mEnemies.size();
            for (i = enemyNum - 1; 0 <= i; --i) {
                int j;
                int k;
                GameCharacter enemy = this.mEnemies.get(i);
                if (enemy == null) continue;
                enemy.move(blocks);
                if (enemy instanceof ShotCharacter) {
                    ShotCharacter sc = (ShotCharacter)enemy;
                    for (int j2 = sc.mBullets.size() - 1; 0 <= j2; --j2) {
                        GameCharacter bullet = sc.mBullets.get(j2);
                        if (bullet == null) continue;
                        if (this.mMine.isAttacked(bullet)) {
                            this.mMine.attackEach(bullet);
                            continue;
                        }
                        for (k = this.mMineMembers.size() - 1; 0 <= k; --k) {
                            GameCharacter mineMember = this.mMineMembers.get(k);
                            if (mineMember == null || !mineMember.isAttacked(bullet)) continue;
                            mineMember.attackEach(bullet);
                        }
                    }
                }
                if (this.mMine instanceof ShotCharacter) {
                    for (int j3 = this.mMine.mBullets.size() - 1; 0 <= j3; --j3) {
                        GameCharacter bullet = this.mMine.mBullets.get(j3);
                        if (bullet == null || !enemy.isAttacked(bullet)) continue;
                        enemy.attackEach(bullet);
                    }
                }
                for (j = this.mMineMembers.size() - 1; 0 <= j; --j) {
                    GameCharacter mineMember = this.mMineMembers.get(j);
                    if (!(mineMember instanceof ShotCharacter)) continue;
                    ShotCharacter mineShooter = (ShotCharacter)mineMember;
                    for (k = mineShooter.mBullets.size() - 1; 0 <= k; --k) {
                        GameCharacter bullet = mineShooter.mBullets.get(k);
                        if (bullet == null || !enemy.isAttacked(bullet)) continue;
                        enemy.attackEach(bullet);
                    }
                }
                if (enemy.isDead()) {
                    enemy.finalize();
                    i = this.mEnemies.indexOf(enemy);
                    this.mEnemies.remove(enemy);
                    continue;
                }
                if (enemy.isAttacked(this.mMine)) {
                    enemy.attackEach(this.mMine);
                } else {
                    for (j = this.mMineMembers.size() - 1; 0 <= j; --j) {
                        GameCharacter mineMember = this.mMineMembers.get(j);
                        if (!enemy.isAttacked(mineMember)) continue;
                        enemy.attackEach(mineMember);
                    }
                }
                n = this.mEnemies.size();
                if (enemyNum == n) continue;
                enemyNum = n;
                i = this.mEnemies.indexOf(enemy);
            }
        }
        if (this.canObjectsMove()) {
            int objectNum = this.mObjects.size();
            for (i = objectNum - 1; 0 <= i; --i) {
                GameCharacter object = this.mObjects.get(i);
                if (object == null) continue;
                object.move(blocks);
                if (object.isDead()) {
                    i = this.mObjects.indexOf(object);
                    this.mObjects.remove(object);
                    continue;
                }
                n = this.mObjects.size();
                if (objectNum == n) continue;
                objectNum = this.mObjects.size();
                i = this.mObjects.indexOf(object);
            }
            int nearObjectNum = this.mNearObjects.size();
            for (int i3 = nearObjectNum - 1; 0 <= i3; --i3) {
                GameCharacter object = this.mNearObjects.get(i3);
                if (object == null) continue;
                object.move(blocks);
                if (object.isDead()) {
                    i3 = this.mNearObjects.indexOf(object);
                    this.mNearObjects.remove(object);
                    continue;
                }
                int n2 = this.mNearObjects.size();
                if (nearObjectNum == n2) continue;
                nearObjectNum = n2;
                i3 = this.mNearObjects.indexOf(object);
            }
        }
    }

    protected boolean canMapMove() {
        return true;
    }

    protected boolean canCharactersMove() {
        return true;
    }

    protected boolean canObjectsMove() {
        return true;
    }

    protected void runStageClear() {
    }

    protected void runGameOver() {
    }

    protected void runEnding() {
    }

    protected void runOtherPhases() {
    }

    protected void runAfterAllPhases() {
    }

    public void tweet(String text, String id, String hashTag) {
        this.repaint();
        this.mTweet = text;
        this.mIsTweet = true;
        this.mHashTag = hashTag;
    }

    public void tweet(String text, String id) {
        this.tweet(text, id, null);
    }

    protected void tweetProc() {
        String consumerKey = this.mI18N.getString(this.mIsApplication ? "tweet_consumerkey_app" : "tweet_consumerkey_web");
        String consumerSecret = this.mI18N.getString(this.mIsApplication ? "tweet_consumersecret_app" : "tweet_consumersecret_web");
        TwitterDialog tc = new TwitterDialog(consumerKey, consumerSecret, this.getSettings());
        tc.tweet(this.mTweet, this.mI18N.getString("url"), (this.mHashTag == null ? this.mI18N.getString("tweet_tag") : this.mHashTag) + " #mines_game");
    }

    public void share(String text, String id) {
        this.tweet(text, id, null);
    }

    @Override
    protected void pauseProc() {
        if (this.mIsMouseLeftPressed) {
            double px = this.getViewsX(this.mMousePressedX);
            double py = this.getViewsY(this.mMousePressedY);
            if (this.mPauseButton != null && this.mPauseButton.isHit(px, py)) {
                this.mPauseButton.pressed();
                this.mIsMouseLeftPressed = false;
            } else {
                for (int i = this.mButtonsOnPausing.size() - 1; 0 <= i; --i) {
                    SKMButton button;
                    if (!(this.mButtonsOnPausing.get(i) instanceof SKMButton) || !(button = this.mButtonsOnPausing.get(i)).isHit(px, py, false)) continue;
                    button.pressed();
                    this.togglePause();
                    this.mIsMouseLeftPressed = false;
                    break;
                }
            }
        }
    }

    protected void moveFlowStrings() {
        int fsSize = this.mFlowStrings.length;
        for (int i = 0; i < fsSize; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].move();
        }
    }

    @Override
    public void quit() {
        this.clearEnemies();
        this.clearMineMembers();
        this.clearObjects();
        this.clearNearObjects();
        this.clearNearObjects();
        this.clearFlowStrings();
        this.mMap.finalize();
        super.quit();
    }

    public boolean isScoreExist(int stage) {
        return true;
    }

    public boolean isTimeExist(int stage) {
        return true;
    }

    public String getStageName(int stage) {
        return "" + stage;
    }

    public String getDifficultyName(int difficulty) {
        return SKM.getI18NCommon().getString("difficulty_" + this.getDifficultyKey(difficulty));
    }

    public String getDifficultyKey(int difficulty) {
        if (difficulty == 0) {
            return "easy";
        }
        if (difficulty == 2) {
            return "hard";
        }
        return "normal";
    }

    public String getRecordKey(int stage, int difficulty, SKMMap<String, String> recordOptionMap) {
        if (difficulty == -1 || difficulty == 1) {
            return "record_" + stage;
        }
        return "record_" + this.getDifficultyKey(difficulty) + "_" + stage;
    }

    public String getScoreIndexName(int stage) {
        return SKM.getI18NCommon().getString("score");
    }

    public String getTimeIndexName(int stage) {
        return SKM.getI18NCommon().getString("time");
    }

    public SKMArray<StageRecord> getStageRecords(int stage, int difficulty, SKMMap<String, String> recordOptionMap) {
        String[] tokens = this.getStringSetting(this.getRecordKey(stage, difficulty, recordOptionMap), "").split(",");
        SKMArray<StageRecord> ret = new SKMArray<StageRecord>();
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].equals("")) continue;
            ret.add(this.createStageRecord(tokens[i]));
        }
        return ret;
    }

    public StageRecord createStageRecord(String data) {
        return new StageRecord(data);
    }

    public StageRecord createStageRecord(int score, String time, SKMMap<String, String> recordOptionMap, long dateMsec) {
        return new StageRecord(score, time, dateMsec);
    }

    public int updateRecord(int stage, int difficulty, SKMMap<String, String> recordOptionMap, int score, String time, long dateMsec) {
        SKMArray<StageRecord> records = this.getStageRecords(stage, difficulty, recordOptionMap);
        StageRecord newRecord = this.createStageRecord(score, time, recordOptionMap, dateMsec);
        int rank = -1;
        if (records.size() == 0) {
            records.add(newRecord);
            rank = 0;
        } else {
            for (int i = 0; i < this.mRecordNum; ++i) {
                if (i < records.size()) {
                    StageRecord record = records.get(i);
                    if (record.isDataExist()) {
                        if (0 >= this.compareStageRecordTo(stage, newRecord, record)) continue;
                        records.add(i, newRecord);
                        rank = i;
                        break;
                    }
                    records.add(i, newRecord);
                    rank = i;
                    break;
                }
                records.add(i, newRecord);
                rank = i;
                break;
            }
        }
        if (rank != -1) {
            SKMStringBuilder buf = new SKMStringBuilder();
            for (int i = 0; i < records.size() && i < this.mRecordNum; ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(records.get(i).toString());
            }
            this.setSetting(this.getRecordKey(stage, difficulty, recordOptionMap), buf.toString());
            this.saveSettings();
        }
        return rank;
    }

    protected int compareStageRecordTo(int stage, StageRecord data1, StageRecord data2) {
        int score1 = data1.getScore();
        int score2 = data2.getScore();
        if (score2 < score1) {
            return 1;
        }
        if (score1 < score2) {
            return -1;
        }
        return -data1.getTime().compareTo(data2.getTime());
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        if (this.mNextPhase != -9999) {
            return;
        }
        if (this.mIsEventRun && this.mEvents.hasEvent()) {
            this.paintEvent(g);
        } else {
            if (this.mPhase != 0) {
                this.paintMain(g);
            }
            switch (this.mPhase) {
                case 0: {
                    this.paintOpening(g);
                    break;
                }
                case 1: {
                    this.paintStageStart(g);
                    break;
                }
                case 2: {
                    this.paintGame(g);
                    break;
                }
                case 3: {
                    this.paintStageClear(g);
                    break;
                }
                case 5: {
                    this.paintGameOver(g);
                    break;
                }
                case 4: {
                    this.paintEnding(g);
                    break;
                }
                default: {
                    this.paintOtherPhases(g);
                }
            }
            this.paintAfterAllPhases(g);
            this.paintUi(g);
            this.paintUiEffects(g);
            this.paintFlowStrings(g);
        }
    }

    protected void paintEvent(SKMGraphics g) {
        this.mEvents.paintEvent(g);
    }

    protected void paintMain(SKMGraphics g) {
        this.mMap.paintBeforeCamera(g, this.mCount);
        ViewCamera camera = this.getViewCamera();
        if (camera != null) {
            g.saveTransform();
            this.applyCamera(g, camera);
        }
        this.mMap.paint(g, this.mCount);
        if (camera != null) {
            this.cancelCamera(g, camera);
            g.restoreTransform();
        }
        this.paintBackgroundUi(g);
        if (camera != null) {
            g.saveTransform();
            this.applyCamera(g, camera);
        }
        this.paintObjects(g);
        if (!this.mIsPaintEnemiesAfterMine) {
            this.paintEnemies(g);
        }
        if (!this.mIsPaintMineMembersAfterMine) {
            this.paintMineMembers(g);
        }
        this.mMine.paint(g);
        if (this.mIsPaintEnemiesAfterMine) {
            this.paintEnemies(g);
        }
        if (this.mIsPaintMineMembersAfterMine) {
            this.paintMineMembers(g);
        }
        this.paintNearObjects(g);
        this.paintEffects(g);
        this.mMap.paintCover(g, this.mCount);
        if (camera != null) {
            this.cancelCamera(g, camera);
            g.restoreTransform();
        }
    }

    protected void paintEffects(SKMGraphics g) {
        for (int i = this.mEffects.size() - 1; 0 <= i; --i) {
            Effect effect = this.mEffects.get(i);
            if (effect == null) continue;
            effect.paint(g);
        }
    }

    protected void paintUiEffects(SKMGraphics g) {
        for (int i = this.mUiEffects.size() - 1; 0 <= i; --i) {
            Effect effect = this.mUiEffects.get(i);
            if (effect == null) continue;
            effect.paint(g);
        }
    }

    @Override
    protected void clearBackground(SKMGraphics g, int marginX, int marginY, int viewW, int viewH) {
        if (this.mPhase == 2 || this.mPhase == 3 || this.mPhase == 5) {
            this.mMap.clearBackground(g, marginX, marginY, viewW, viewH);
        }
    }

    protected void applyCamera(SKMGraphics g, ViewCamera camera) {
    }

    protected void cancelCamera(SKMGraphics g, ViewCamera camera) {
    }

    protected void paintOpening(SKMGraphics g) {
    }

    protected void paintStageStart(SKMGraphics g) {
    }

    protected void paintGame(SKMGraphics g) {
    }

    protected void paintStageClear(SKMGraphics g) {
    }

    protected void paintGameOver(SKMGraphics g) {
    }

    protected void paintEnding(SKMGraphics g) {
    }

    protected void paintOtherPhases(SKMGraphics g) {
    }

    protected void paintAfterAllPhases(SKMGraphics g) {
    }

    protected void paintUi(SKMGraphics g) {
    }

    protected void paintBackgroundUi(SKMGraphics g) {
    }

    @Override
    protected void paintButtons(SKMGraphics g) {
        super.paintButtons(g);
        this.mDirectionButton.paint(g);
    }

    protected void paintFlowStrings(SKMGraphics g) {
        int fsSize = this.mFlowStrings.length;
        for (int i = 0; i < fsSize; ++i) {
            if (this.mFlowStrings[i] == null) continue;
            this.mFlowStrings[i].paint(g);
        }
    }

    public void paintObjects(SKMGraphics g) {
        for (int i = this.mObjects.size() - 1; 0 <= i; --i) {
            GameCharacter gc = this.mObjects.get(i);
            if (gc == null) continue;
            gc.paint(g);
        }
    }

    public void paintNearObjects(SKMGraphics g) {
        for (int i = this.mNearObjects.size() - 1; 0 <= i; --i) {
            GameCharacter gc = this.mNearObjects.get(i);
            if (gc == null) continue;
            gc.paint(g);
        }
    }

    public void paintEnemies(SKMGraphics g) {
        for (int i = this.mEnemies.size() - 1; 0 <= i; --i) {
            GameCharacter gc = this.mEnemies.get(i);
            if (gc == null) continue;
            gc.paint(g);
        }
    }

    public void paintMineMembers(SKMGraphics g) {
        for (int i = this.mMineMembers.size() - 1; 0 <= i; --i) {
            GameCharacter gc = this.mMineMembers.get(i);
            if (gc == null) continue;
            gc.paint(g);
        }
    }

    public void startFade(SKMColor coverColor, int dAlpha) {
        this.mCoverColor = coverColor;
        this.mCoverAlpha = 0 < dAlpha ? 0 : 255;
        this.mCoverDAlpha = dAlpha;
    }

    public boolean isFading() {
        return this.mCoverColor != null;
    }

    public void finishFade() {
        this.mCoverColor = null;
    }

    public boolean fade() {
        int newCoverAlpha = this.mCoverAlpha + this.mCoverDAlpha;
        if (0 < this.mCoverDAlpha) {
            if (255 <= newCoverAlpha) {
                this.mCoverAlpha = 255;
                return true;
            }
        } else if (newCoverAlpha <= 0) {
            this.mCoverAlpha = 0;
            return true;
        }
        this.mCoverAlpha = newCoverAlpha;
        return false;
    }

    public void paintCover(SKMGraphics g) {
        if (this.mCoverColor != null) {
            g.setColor(SKMColor.getAlphaColor(this.mCoverColor, this.mCoverAlpha));
            if (this.mViewCamera == null) {
                g.fillRect(0, 0, this.getBaseDrawWidth() + 1, this.getBaseDrawHeight() + 1);
            } else {
                g.fillRect(0, 0, this.getDrawWidth() + 1, this.getDrawHeight() + 1);
            }
        }
    }

    public String getAllSettingDataString() {
        String commonName = this.mAppId + "_";
        SKMSettings settings = this.getSettings();
        String[] keys = settings.getKeys(null);
        JSONObject obj = new JSONObject();
        for (int i = 0; i < keys.length; ++i) {
            String orgKey;
            String key = keys[i];
            String string = orgKey = key.startsWith(commonName) ? key.substring(commonName.length()) : key;
            if (orgKey.equals("user_id") || orgKey.equals("password") || orgKey.startsWith("twitter_access_") || orgKey.equals("run_count") || this.isSecretSettingKey(orgKey)) continue;
            obj.put(key, (Object)settings.get(key));
        }
        return obj.toString();
    }

    protected boolean isSecretSettingKey(String key) {
        return false;
    }

    public boolean isNameSettingAvailable() {
        return false;
    }

    @Override
    public void applySettings() {
        super.applySettings();
        this.mIsSeasonalEffectDisabled = this.getBooleanSetting("disable_seasonal_effect", false);
    }

    public void applySettingDataString(String jsonStr) {
        String commonName = this.mAppId + "_";
        SKMSettings settings = this.getSettings();
        String[] keys = settings.getKeys(null);
        for (int i = 0; i < keys.length; ++i) {
            String orgKey;
            String key = keys[i];
            String string = orgKey = key.startsWith(commonName) ? key.substring(commonName.length()) : key;
            if (orgKey.equals("user_id") || orgKey.equals("password") || orgKey.startsWith("twitter_access_") || orgKey.equals("jkc") || orgKey.equals("p_ck")) continue;
            settings.remove(key);
        }
        try {
            JSONObject json = new JSONObject(jsonStr);
            Iterator itr = json.keys();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                Object value = json.get(key);
                try {
                    int intValue = Integer.parseInt(value.toString());
                    this.setSetting(key, intValue);
                }
                catch (Exception e2) {
                    try {
                        double doubleValue = Double.parseDouble(value.toString());
                        this.setSetting(key, doubleValue);
                    }
                    catch (Exception e3) {
                        if ("true".equals(value.toString())) {
                            this.setSetting(key, true);
                            continue;
                        }
                        if ("false".equals(value.toString())) {
                            this.setSetting(key, false);
                            continue;
                        }
                        this.setSetting(key, value.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            this.logging(e);
        }
        this.saveSettings();
        this.applySettings();
    }

    public void resetAllData() {
        SKMSettings settings = this.getSettings();
        String[] keys = settings.getKeys(null);
        for (int i = keys.length - 1; 0 <= i; --i) {
            if (this.isSecretSettingKey(keys[i])) continue;
            settings.remove(keys[i]);
        }
        settings.save();
    }

    public void doIfConnected(ReceiveCallback callback) {
        this.doIfConnected(callback, true);
    }

    public void doIfConnected(final ReceiveCallback callback, final boolean isShowConnectionError) {
        SKMConnectUtil connectUtil = new SKMConnectUtil();
        connectUtil.setServerInfo(this.getServer() + "/soft/game/common/connection_test.json");
        final GameView manager = this;
        connectUtil.connectUrlByPost(null, new ReceiveCallback(){

            @Override
            public void receive(String jsonStr) {
                if (jsonStr == null) {
                    if (isShowConnectionError) {
                        SKMI18N i18nCommon = SKM.getI18NCommon();
                        manager.playSound("beep");
                        manager.showAlertDialog(i18nCommon.getString("TITLE_ERROR_INTERNET_CONNECTION"), i18nCommon.getString("ERROR_INTERNET_CONNECTION"));
                    }
                    return;
                }
                callback.receive(null);
            }
        });
    }

    public String getTimeString(long time) {
        String msec = "" + SKMUtil.toInt(time % 1000L / 10L);
        time = SKMUtil.toInt(time / 1000L);
        String sec = "" + time % 60L;
        time = SKMUtil.toInt(time / 60L);
        String min = "" + time;
        if (msec.length() < 2) {
            msec = '0' + msec;
        }
        if (sec.length() < 2) {
            sec = '0' + sec;
        }
        return min + "'" + sec + "''" + msec;
    }

    public String getTimeStringMinSec(long time) {
        time = SKMUtil.toInt(time / 1000L);
        String sec = "" + time % 60L;
        time = SKMUtil.toInt(time / 60L);
        String min = "" + time;
        if (sec.length() < 2) {
            sec = '0' + sec;
        }
        return min + "'" + sec;
    }
}

