#ifndef __HAL_UART_H__
#define __HAL_UART_H__

/***************************************************************************************/

/*UART ^Cv*/
typedef enum{
	UART_UNDEF		= -1,
	UART_DEFAULT	= 0,		//ȈՃVA,荞݂Ȃ
	UART_TERM		= 1,		//R\[[
	UART_16550		= 16550,	//16550
}UART_TYPE;

/*16550 荞݋WX^ (IER R/W) */
enum tagIER{
	IE16_RECV_READY		= 0x01,		/*Mf[^fB荞ݐݒ*/
	IE16_SEND_EMPTY		= 0x02,		/*MWX^󊄂荞ݐݒ*/
	IE16_LINE_CHANGED	= 0x04,		/*CXe[^X荞ݐݒ*/
	IE16_MODEM_CHANGED	= 0x08,		/*fXe[^X荞ݐݒ*/
};
/*16550 荞ݔFWX^ (IIR R)*/
enum tagIIR{
	II16_INT_NONE			= 0x01,	/*PŊݗvȂAOŊݗv*/
	II16_IID				= 0x0e,	/*ݗv*/
	II16_IID_LINE			= 0x06,	/*Dx1 C*/
	II16_IID_RECV_READY		= 0x04,	/*Dx2 Mf[^*/
	II16_IID_TIMEOUT		= 0x0c,	/*Dx2 M^CAEg(FIFO mode only)*/
	II16_IID_SEND_EMPTY		= 0x02,	/*Dx3 MFIFO*/
	II16_IID_MODEM			= 0x00,	/*Dx4 f*/
};
/*16550 FIFO䃌WX^ (FCR W) */
enum tagFCR{
	FC16_FIFO_ENABLE		= 0x01,		/*1FIFOgp*/
	FC16_RCVR_RESET			= 0x02,		/*MFIFOZbg*/
	FC16_XMIT_RESET			= 0x04,		/*MFIFOZbg*/
	FC16_RECV_TRIGGER		= 0xc0,		/*MFIFO̊荞݂MoCg*/
	FC16_RECV_TRIGGER_1		= 0x00,
	FC16_RECV_TRIGGER_4		= 0x40,
	FC16_RECV_TRIGGER_8		= 0x80,
	FC16_RECV_TRIGGER_14	= 0xc0,
};
/*16550 C䃌WX^ (LCR R/W) */
enum tagLCR{
	LC16_WORD_LENGTH1	= 0x01,
	LC16_WORD_LENGTH2	= 0x02,
	LC16_STOP_BITS		= 0x04,
	LC16_PARITY_ENABLE	= 0x08,
	LC16_EVEN_PARITY	= 0x10,
	LC16_STICK_PARITY	= 0x20,
	LC16_SEND_BREAK		= 0x40,		/**/
	LC16_DLAB			= 0x80,		/**/
};
/*16550 f䃌WX^ (MCR R/W) */
enum tagMCR{
	MC16_DTR			= 0x01,		/*óFERM*/
	MC16_RTS			= 0x02,		/*óFRSM*/
	MC16_OUT1			= 0x04,		/*óFFfZbg(DOS/V@jA	CI*/
	MC16_OUT2			= 0x08,		/*óFF荞݋(DOS/V@jA	CD*/
	MC16_LOOP			= 0x10,		/*[vobN*/
	MC16_AFE			= 0x20,		/*Autoflow Control EnableiTL16C550j*/
};
/*16550 CXe[^XWX^ (LSR R) */
/*bit1-bit4̓G[ԃrbg*/
enum tagLSR{
	LS16_RECV_READY		= 0x01,		/*Mf[^fBiMobt@܂͎MFIFOɃf[^j */
	LS16_BUFFER_OVERRUN	= 0x02,		/*I[o[G[ */
	LS16_PARITY_ERROR	= 0x04,		/*peBG[*/
	LS16_FRAMING_ERROR	= 0x08,		/*t[~OG[ */
	LS16_BREAK_SIGNAL	= 0x10,		/*breakMoibreak\j */
	LS16_SEND_READY		= 0x20,		/*Mobt@܂͑MFIFO͋*/
	LS16_SEND_EMPTY		= 0x40,		/*Mobt@܂͑MFIFOƃVtgWX^͋ */
	LS16_FIFO_ERROR		= 0x80,		/*MFIFOɃpeBG[At[~OG[Abreak\邱Ƃ*/
	LS16_LINE_ERROR		= (LS16_BUFFER_OVERRUN | LS16_PARITY_ERROR | LS16_FRAMING_ERROR | LS16_BREAK_SIGNAL),
	LS16_RESET			= (LS16_SEND_READY | LS16_SEND_EMPTY)
};
/*16550 fXe[^XWX^ (MSR R/W) */
enum tagMSR{
	MS16_CTS_CHANGED	= 0x01,		/*CTS͂ω*/
	MS16_DSR_CHANGED	= 0x02,		/*DSR͂ω*/
	MS16_RI_CHANGED		= 0x04,		/*RI͂ω*/
	MS16_DCD_CHANGED	= 0x08,		/*DCD͂ω*/
	MS16_CTS_ON			= 0x10,		/*CTS̓̓x*/
	MS16_DSR_ON			= 0x20,		/*DSR̓̓x*/
	MS16_RI_ON			= 0x40,		/*RI̓̓x*/
	MS16_DCD_ON			= 0x80,		/*DCD̓̓x*/
};

/*16550 Scratch Register (SCR R/W) */

/***************************************************************************************/

/*16550fɎgpꍇ
fM䃌WX^OUT1,OUT2ȉ̂悤ɎgƉB
	OUT1		CI	fĂяoMMĂ邩ǂDTEɎ
	OUT2		CD	fLAiMjMł邩ǂDTEɎ
DTEDTR16550DSRɂȂĂƉiDSRDTE̓dON/OFFoj
	DTE̓dONDTR ONAdOFFDTR OFFƂȂB
*/

#ifdef _CMTOY
/*WindowsV~[V*/

/*WX^}N*/
#define IE16550(c)			hal16550ReadIER((c))
#define IID16550(c)			hal16550ReadIID((c))
#define LSTAT16550(c)		hal16550ReadLSR((c))
#define MSTAT16550(c)		hal16550ReadMSR((c))
#define READ16550(c)		hal16550ReadDATA((c))
#define WRITE16550(c,d)		hal16550WriteDATA((c),(d))
#define WRITE_LCR(c,d)		hal16550WriteLCR((c),(d))
#define WRITE_IER(c,d)		hal16550WriteIER((c),(d))
#define WRITE_MCR(c,d)		hal16550WriteMCR((c),(d))
#define WRITE_FCR(c,d)		hal16550WriteFCR((c),(d))
/*fM*/
#define SET_DTR16550(c)		hal16550WriteMCR((c),(BYTE)(hal16550ReadMCR((c))|MC16_DTR))
#define CLEAR_DTR16550(c)	hal16550WriteMCR((c),(BYTE)(hal16550ReadMCR((c))&(~MC16_DTR)))
#define SET_RTS16550(c)		hal16550WriteMCR((c),(BYTE)(hal16550ReadMCR((c))|MC16_RTS))
#define CLEAR_RTS16550(c)	hal16550WriteMCR((c),(BYTE)(hal16550ReadMCR((c))&(~MC16_RTS)))
#define SET_OUT116550(c)	hal16550WriteMCR((c),(BYTE)(hal16550ReadMCR((c))|MC16_OUT1))
#define CLEAR_OUT116550(c)	hal16550WriteMCR((c),(BYTE)(hal16550ReadMCR((c))&(~MC16_OUT1)))
#define SET_OUT216550(c)	hal16550WriteMCR((c),(BYTE)(hal16550ReadMCR((c))|MC16_OUT2))
#define CLEAR_OUT216550(c)	hal16550WriteMCR((c),(BYTE)(hal16550ReadMCR((c))&(~MC16_OUT2)))
#define SET_LOOPBACK16550(c)	hal16550WriteMCR((c),(BYTE)(hal16550ReadMCR((c))|MC16_LOOP))
#define CLEAR_LOOPBACK16550(c)	hal16550WriteMCR((c),(BYTE)(hal16550ReadMCR((c))&(~MC16_LOOP)))
/*ݐ*/
#define ENA_RX16550(c)		hal16550WriteIER((c),(BYTE)(hal16550ReadIER((c))|IE16_RECV_READY))
#define DIS_RX16550(c)		hal16550WriteIER((c),(BYTE)(hal16550ReadIER((c))&(~IE16_RECV_READY)))
#define ENA_TX16550(c)		hal16550WriteIER((c),(BYTE)(hal16550ReadIER((c))|IE16_SEND_EMPTY))
#define DIS_TX16550(c)		hal16550WriteIER((c),(BYTE)(hal16550ReadIER((c))&(~IE16_SEND_EMPTY)))
/*BreakM*/
#define SET_BREAK16550(c)	hal16550WriteLCR((c),(BYTE)(hal16550ReadLCR((c))|LC16_SEND_BREAK))
#define CLEAR_BREAK16550(c)	hal16550WriteLCR((c),(BYTE)(hal16550ReadLCR((c))&(~LC16_SEND_BREAK)))

#else
/*@*/

#if 0
/*ȉMCC68K̗*/
#pragma asm
#include "device.inc"
	SECTION code,,C
#pragma endasm

#define IE16550			asm(unsigned char, " MOVE.W IE16,D0		;READ IE")
#define IID16550		asm(unsigned char, " MOVE.W IID16,D0	;READ IID")
#define STAT16550		asm(unsigned char, " MOVE.W LSTAT16,D0	;READ LINE STATUS")
#define MSTAT16550		asm(unsigned char, " MOVE.W MSTAT16,D0	;READ MODEM STATUS")
#define READ16550		asm(unsigned char, " MOVE.W DATA16,D0	;READ DATA")
#define WRITE16550		asm(unsigned char, " MOVE.W D0,DATA16	;WRITE DATA")
/*DTẼfM*/
#define SET_DTR16550	asm(unsigned char, " ORI.W	#01H,MCNTR16	;set DTR")
#define CLEAR_DTR16550	asm(unsigned char, " ANDI.W	#0FEH,MCNTR16	;clear DTR")
#define SET_RTS16550	asm(unsigned char, " ORI.W	#02H,MCNTR16	;set RTS")
#define CLEAR_RTS16550	asm(unsigned char, " ANDI.W	#0FDH,MCNTR16	;clear RTS")
#define SET_CI16550		asm(unsigned char, " ORI.W	#04H,MCNTR16	;set out1 for CI")
#define CLEAR_CI16550	asm(unsigned char, " ANDI.W	#0FBH,MCNTR16	;clear out1 for CI")
#define SET_CD16550		asm(unsigned char, " ORI.W	#08H,MCNTR16	;set out2 for CD")
#define CLEAR_CD16550	asm(unsigned char, " ANDI.W	#0F7H,MCNTR16	;clear out2 for CD")
/*DTE̊ݐ*/
#define ENA_RX16550		asm(unsigned char, " ORI.W	#01H,IE16	;enable RX ready")
#define DIS_RX16550		asm(unsigned char, " ANDI.W	#0FEH,IE16	;disable RX ready")
#define ENA_TX16550		asm(unsigned char, " ORI.W	#02H,IE16	;ENABLE TX READY")
#define DIS_TX16550		asm(unsigned char, " ANDI.W	#0FDH,IE16	;DISABLE TX READY")
#endif	//0

#endif/*_CMTOY*/

#endif	//__HAL_UART_H__