/*****************************************************************************
file name : kernel_cfg.h
  VXe\zp`

  Copyright(C) 2002 XؖF

Windows̃V~[Vœ삷AvP[VvÕRpCɂ͈ȉ̃}N`Kv
	_CMTOY
	_APP_EXPORT
*****************************************************************************/
/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́CFree Software Foundation ɂČ\Ă 
 *  GNU General Public License  Version 2 ɋLqĂC
 *  (1)`(4)̏𖞂ꍇɌC{\tgEFAi{\tgEF
 *  Aς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFAėp\ȃoCiR[hiP[^uIu
 *      WFNgt@C⃉CuȂǁǰ`ŗpꍇɂ́Cp
 *      ɔhLgip҃}jAȂǁjɁCL̒쌠\C
 *      ̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAėps\ȃoCiR[ȟ`܂͋@ɑg
 *      ݍ񂾌`ŗpꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) pɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) p̌`ԂCʂɒ߂@ɂāCL쌠҂ɕ񍐂
 *        ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂́C
 *  {\tgEFAɊւāC̓Kp\܂߂āCȂۏ؂s
 *  ȂD܂C{\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ
 *  Ȃ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */
#ifndef __KERNEL_CFG_H__
#define __KERNEL_CFG_H__



/*****************************************************************************/
/*ÓIIuWFNg`*/
//gpł鑮
//E^XN			(TA_HLNG | TA_ACT)
//EZ}tH		TA_TFIFO
//ECxgtO	(TA_TFIFO | TA_WMUL [| TA_CLR])
//EC{bNX	(TA_TFIFO | TA_MFIFO)
//E݃nh		TA_NULL
/*****************************************************************************/
#define ID_NULL			(ID)(-1)		//ÓI`IID
#define INTNO_NULL		(INTNO)(-1)		//ÓI`IINTNO

/*ÓI^XN`*/
typedef struct tagTaskDefinition
{
	ID		tskid;
	T_CTSK	ctsk;
}TASK_DEF;

/*ÓIZ}tH`*/
typedef struct tagSemaphoreDefinition
{
	ID		semid;
	T_CSEM	csem;
}SEMAPHORE_DEF;

/*ÓICxgtO`*/
typedef struct tagEventflagDefinition
{
	ID		flgid;
	T_CFLG	cflg;
}EVENTFLAG_DEF;

/*ÓIf[^L[`*/
typedef struct tagDataQueueDefinition
{
	ID		dtqid;
	T_CDTQ	cdtq;
}DATAQUEUE_DEF;

/*ÓIC{bNX`*/
typedef struct tagMailboxDefinition
{
	ID		mbxid;
	T_CMBX	cmbx;
}MAILBOX_DEF;

/*ÓIŒ蒷v[`*/
typedef struct tagFixedMemoryPoolDefinition
{
	ID		mpfid;
	T_CMPF	cmpf;
}MPF_DEF;

/*ÓInh`*/
typedef struct tagCyclicHandlerDefinition
{
	ID		cycid;
	T_CCYC	ccyc;
}CYCHDR_DEF;

/*ÓIA[nh`*/
typedef struct tagAlarmHandlerDefinition
{
	ID		almid;
	T_CALM	calm;
}ALMHDR_DEF;

/*ÓI荞݃nh`*/
typedef struct tagInterruptHandlerDefinition
{
	INHNO	inhno;
	T_DINH	dinh;
}INTHDR_DEF;

/*[``*/
typedef struct tagInitialRoutineDefinition
{
	ATR		iniatr;
	VP_INT	exinf;
	FP		inirtn;
}INIRTN_DEF;




#ifdef _CMTOY
/*WindowsV~[V*/
/*****************************************************************************
AvP[VvȌITRONJ[lɌJ@\`
	֐FAttachItronApplication

*****************************************************************************/
#define KERNEL_CFG_VER		(0x0104)	/*ȉITRON_CONFIG_TABLE\̂̎ʂɎg*/
#define FN_ATTACH_APPLICATION			AttachItronApplication				//֐
#define NAME_FN_ATTACH_APPLICATION		"AttachItronApplication"	
/*RtBO[Ve[u*/
typedef struct tagKernelConfig
{
	int			MySize;
	int			KernelCfgVer;
	int			EntriesOfTaskDefinitionTable;
	TASK_DEF	*pTaskDefinitionTable;
	int			EntriesOfSemaphoreDefinitionTable;
	SEMAPHORE_DEF *pSemaphoreDefinitionTable;
	int			EntriesOfEventflagDefinitionTable;
	EVENTFLAG_DEF *pEventflagDefinitionTable;
	int			EntriesOfDataQueueDefinitionTable;
	DATAQUEUE_DEF *pDataQueueDefinitionTable;
	int			EntriesOfMailboxDefinitionTable;
	MAILBOX_DEF *pMailboxDefinitionTable;
	int			EntriesOfFixedMemoryPoolDefinitionTable;
	MPF_DEF		*pFixedMemoryPoolDefinitionTable;
	int			EntriesOfCyclicHnadlerDefinitionTable;
	CYCHDR_DEF	*pCyclicHnadlerDefinitionTable;
	int			EntriesOfAlarmHnadlerDefinitionTable;
	ALMHDR_DEF	*pAlarmHnadlerDefinitionTable;
	int			EntriesOfInterruptHandlerDefinitionTable;
	INTHDR_DEF	*pInterruptHandlerDefinitionTable;
	int			EntriesOfInitialRoutineDefinitionTable;
	INIRTN_DEF	*pInitialRoutineDefinitionTable;
	
}ITRON_CONFIG_TABLE;


/*****************************************************************************
RtBO[Ve[uJ֐`
*****************************************************************************/
#define IMPLEMENT_ATTACH_APPLICATION			\
UINT FN_ATTACH_APPLICATION(ITRON_CONFIG_TABLE *pConfig)													\
{																										\
	if(pConfig->MySize < sizeof(ITRON_CONFIG_TABLE)) return -1;											\
	pConfig->KernelCfgVer								= KERNEL_CFG_VER;								\
	pConfig->EntriesOfTaskDefinitionTable				= NUM_OF_DEFINED_TASKS;							\
	pConfig->pTaskDefinitionTable						= TaskDefinitionTable;							\
	pConfig->EntriesOfSemaphoreDefinitionTable			= NUM_OF_DEFINED_SEMAPHORES;					\
	pConfig->pSemaphoreDefinitionTable					= SemaphoreDefinitionTable;						\
	pConfig->EntriesOfEventflagDefinitionTable			= NUM_OF_DEFINED_EVENTFLAGS;					\
	pConfig->pEventflagDefinitionTable					= EventflagDefinitionTable;						\
	pConfig->EntriesOfDataQueueDefinitionTable			= NUM_OF_DEFINED_DATAQUEUES;					\
	pConfig->pDataQueueDefinitionTable					= DataQueueDefinitionTable;						\
	pConfig->EntriesOfMailboxDefinitionTable			= NUM_OF_DEFINED_MAILBOXES;						\
	pConfig->pMailboxDefinitionTable					= MailboxDefinitionTable;						\
	pConfig->EntriesOfFixedMemoryPoolDefinitionTable	= NUM_OF_DEFINED_MPFS;							\
	pConfig->pFixedMemoryPoolDefinitionTable			= FixedMemoryPoolDefinitionTable;				\
	pConfig->EntriesOfCyclicHnadlerDefinitionTable		= 0;	/*NUM_OF_DEFINED_CYCHDRS;*/				\
	pConfig->pCyclicHnadlerDefinitionTable				= NULL;	/*CyclicHnadlerDefinitionTable;*/		\
	pConfig->EntriesOfAlarmHnadlerDefinitionTable		= 0;	/*NUM_OF_DEFINED_ALMHDRS;*/				\
	pConfig->pAlarmHnadlerDefinitionTable				= NULL;	/*AlarmHnadlerDefinitionTable;*/		\
	pConfig->EntriesOfInterruptHandlerDefinitionTable	= NUM_OF_DEFINED_INTHDRS;						\
	pConfig->pInterruptHandlerDefinitionTable			= InterruptHandlerDefinitionTable;				\
	pConfig->EntriesOfInitialRoutineDefinitionTable		= NUM_OF_DEFINED_INIRTNS;						\
	pConfig->pInitialRoutineDefinitionTable				= InitialRoutineDefinitionTable;				\
	return 0;																							\
}



#ifdef _APP_EXPORT
//DLL쐬Ɏgp`
#define APP_EXTERN __declspec(dllexport)
#else
//DLLĂяoŎgp`
#define APP_EXTERN __declspec( dllimport ) 
#endif/*_KP_EXPORT*/

APP_EXTERN UINT FN_ATTACH_APPLICATION(ITRON_CONFIG_TABLE *pConfig);
typedef UINT ( *PFN_ATTACH_APPLICATION )	( ITRON_CONFIG_TABLE *pConfig );	/* */

#endif	/*_CMTOY*/


#endif /*__KERNEL_CFG_H__*/