/*****************************************************************************
kernel_cfg.c :
  ITRONg[icmtoy TvvO
  Copyright(C) 2002 XؖF

VXe\zp`(Sample)

Windows̃V~[Vœ삷AvP[VvÕRpCɂ͈ȉ̃}N`Kv
	_CMTOY
	_APP_EXPORT
*****************************************************************************/

#include "hal.h"

#include "itron.h"
#include "kernel_id.h"
#include "kernel_cfg.h"

/*****************************************************************************/
/*[U^XNA݃nhA[` ֐vg^Cv錾*/
/*****************************************************************************/
EXTERN void InitHandler(void);
EXTERN void IntHdr16550(void);

EXTERN void WatchButtonTask(VP_INT exinf);
EXTERN void Task16550(VP_INT exinf);


/*****************************************************************************
ÓIIuWFNg`e[u
*****************************************************************************/

/*ÓI^XN`*/
TASK_DEF TaskDefinitionTable[] = {
	CRE_TSK(IDLE_TASK_ID,	(TA_HLNG | TA_ACT),NULL,NULL,			TMAX_TPRI,	0,NULL, "idle")	/*idle task*/
	CRE_TSK(5,				(TA_HLNG | TA_ACT),NULL,WatchButtonTask,8,			0,NULL, "Watch Button")	/*task5*/
	CRE_TSK(10,				(TA_HLNG | TA_ACT),NULL,Task16550,		5,			0,NULL, "16550")	/*task10*/
	CRE_TSK(ID_NULL,	(TA_NULL), NULL, NULL, 0, 0, NULL, "")	/*`I*/
};
#define NUM_OF_DEFINED_TASKS	sizeof(TaskDefinitionTable)/sizeof(TASK_DEF)
int	EntriesOfTaskDefinitionTable = NUM_OF_DEFINED_TASKS;

/*ÓIZ}tH`*/
SEMAPHORE_DEF SemaphoreDefinitionTable[] = {
	CRE_SEM(1,TA_TFIFO,0,32767,"")
	CRE_SEM(ID_NULL,0,0,0,"")	/*`I*/
};
#define NUM_OF_DEFINED_SEMAPHORES	sizeof(SemaphoreDefinitionTable)/sizeof(SEMAPHORE_DEF)
int	EntriesOfSemaphoreDefinitionTable = NUM_OF_DEFINED_SEMAPHORES;

/*ÓICxgtO`*/
EVENTFLAG_DEF EventflagDefinitionTable[] = {
	CRE_FLG(1,(TA_TFIFO | TA_WMUL | TA_CLR),0,"")
	CRE_FLG(ID_NULL,0,0,"")	/*`I*/
};
#define NUM_OF_DEFINED_EVENTFLAGS	sizeof(EventflagDefinitionTable)/sizeof(EVENTFLAG_DEF)
int	EntriesOfEventflagDefinitionTable = NUM_OF_DEFINED_EVENTFLAGS;

/*ÓIf[^L[`*/
DATAQUEUE_DEF DataQueueDefinitionTable[] = {
	CRE_DTQ(ID_NULL,0,16,NULL,"")	/*`I*/
};
#define NUM_OF_DEFINED_DATAQUEUES	sizeof(DataQueueDefinitionTable)/sizeof(DATAQUEUE_DEF)
int	EntriesOfDataQueueDefinitionTable = NUM_OF_DEFINED_DATAQUEUES;

/*ÓIC{bNX`*/
MAILBOX_DEF MailboxDefinitionTable[] = {
	CRE_MBX(1,(TA_TFIFO | TA_MFIFO),0,NULL,"")
	CRE_MBX(ID_NULL, 0, 1, NULL, "")	/*`I*/
};
#define NUM_OF_DEFINED_MAILBOXES	sizeof(MailboxDefinitionTable)/sizeof(MAILBOX_DEF)
int	EntriesOfMailboxDefinitionTable = NUM_OF_DEFINED_MAILBOXES;

/*ÓIŒ蒷[v[`*/
MPF_DEF FixedMemoryPoolDefinitionTable[] = {
	CRE_MPF(ID_NULL, 0, 0, 0, NULL, "")	/*`I*/
};
#define NUM_OF_DEFINED_MPFS		sizeof(FixedMemoryPoolDefinitionTable)/sizeof(MPF_DEF)
int	EntriesOfFixedMemoryPoolDefinitionTable = NUM_OF_DEFINED_MPFS;

/*ÓInh`*/
CYCHDR_DEF CyclicHnadlerDefinitionTable[] = {
	CRE_CYC(ID_NULL,0,NULL,NULL,1000,10,"")	/*`I*/
};
#define NUM_OF_DEFINED_CYCHDRS	sizeof(CyclicHnadlerDefinitionTable)/sizeof(CYCHDR_DEF)
int	EntriesOfCyclicHnadlerDefinitionTable = NUM_OF_DEFINED_CYCHDRS;

#if 0
/*ÓIA[nh`*/
ALMHDR_DEF AlarmHnadlerDefinitionTable[] = {
	DEF_ALM(ID_NULL,0,100000)	/*`I*/
};
#define NUM_OF_DEFINED_ALMHDRS	sizeof(AlarmHnadlerDefinitionTable)/sizeof(ALMHDR_DEF)
int	EntriesOfAlarmHnadlerDefinitionTable = NUM_OF_DEFINED_ALMHDRS;
#endif

/*ÓI荞݃nh`*/
INTHDR_DEF InterruptHandlerDefinitionTable[] = {
	DEF_INH(4,TA_NULL,IntHdr16550,"16550")
	DEF_INH(INTNO_NULL, 0, NULL, "")	/*`I*/
};
#define NUM_OF_DEFINED_INTHDRS	sizeof(InterruptHandlerDefinitionTable)/sizeof(INTHDR_DEF)
int	EntriesOfInterruptHandlerDefinitionTable = NUM_OF_DEFINED_INTHDRS;


/*ÓI[``*/
INIRTN_DEF InitialRoutineDefinitionTable[] = {
	ATT_INI(TA_NULL,NULL,InitHandler)
};
#define NUM_OF_DEFINED_INIRTNS	sizeof(InitialRoutineDefinitionTable)/sizeof(INIRTN_DEF)
int	EntriesOfInitialRoutineDefinitionTable = NUM_OF_DEFINED_INIRTNS;


#ifdef _CMTOY
IMPLEMENT_ATTACH_APPLICATION
#endif	/*_CMTOY*/
