/*****************************************************
led3.c :
  ITRON TvvO
  Copyright(C) 1998-2002 XؖF

LED^XN̎iėp^C}gpj

*****************************************************/

#include "hal.h"
#include "itron.h"
#include "system_def.h"
#include "event.h"
#include "timer.h"
#include "debug.h"

/*^CAEgʒmpbZ[Ẅm*/
MSGHEADER LedTimeoutMsg ={
	{0},	/*T_MSG os_rsv*/
	0,		/*id*/
	0,		/*sub*/
	0		/*length*/
};

/*****************************************************
//LED^XN
*****************************************************/
void LedTask(VP_INT exinf)
{
	ER ercd;
	MSGBLOCK *pMsg;
	BYTE led = 0x01;
	DebugPrintf("\rLedTask: started.\r");

	/*^C}`*/
	timSetTimer(TNO_Led,					/*^C}ԍ*/
			TC_LED_TIMEOUT,				/*^CAEgl*/
			MID_Led,					/*ʒmbZ[W󂯎郁C{bNXID*/
			sizeof(LedTimeoutMsg),		/*bZ[WTCY*/
			(MSGBLOCK*)&LedTimeoutMsg	/*ʒmbZ[W̃AhX*/
			);
	timStartTimer(TNO_Led);	/*^C}N*/
	while(1){
		//ercd = rcv_mbx(MID_Led, &pMsg);
		ercd = WaitEvent(MID_Led, &pMsg);
		if(ercd == E_OK){
			halSetLED(led);			/*LED ύX*/
			led <<= 1;
			if(!led) led = 0x01;
			timStartTimer(TNO_Led);	/*̃^CAEgN*/
		}else{
			DebugPrintf("LedTask: rcv_msg ercd = %04xh\r", ercd);
		}
	}
}

