/*****************************************************
irq1.c : Edited at 1998,6,22 by K.Sasaki
  Copyright(C) 1998-2002 XؖF

IRQ0̊ݏ^XN̎

*****************************************************/

#include "hal.h"
#include "itron.h"
#include "system_def.h"
#include "debug.h"



//eZOg̈ʒuvZ
//	==0==
//	5	1
//	==6==
//	4	2
//	==3== 7
//					    0     1     2     3     4     5     6     7     8     9
BYTE num_pattern[] = {0x3f, 0x06, 0x5b, 0x4f, 0x66, 0x6d, 0x7d, 0x27, 0x7f, 0x6f};
void DisplayDecimal(int num)
{
	WORD stat = num_pattern[(num/10)%10]<<8 | num_pattern[num%10];
	halSetSegLED(stat);
}

/*****************************************************
//IRQ1̊荞݃nh
*****************************************************/
void Int1Handler(void)
{
	ER ercd;
	ercd = isig_sem(SID_Int1);
//	ercd = iwup_tsk(TID_Int1);
	if(ercd != E_OK){
		DebugPrintf("Int1Handler: isig_sem ercd = %04xh\r", ercd);
	}
}

/*****************************************************
//IRQ1̊荞݃^XN
*****************************************************/
void Int1Task(VP_INT exinf)
{
	ER ercd;
	int	Int1_Count = 0;
	DebugPrintf("\rInt1Task: started.\r");

	DisplayDecimal(Int1_Count);
	/*IRQ1*/
	ena_int(1);
	while(1){
		ercd = wai_sem(SID_Int1);
//		ercd = slp_tsk();
		if(ercd == E_OK){
			++Int1_Count;
			CMTRACE("app: Int1 invoked. %d\n", Int1_Count);
			DisplayDecimal(Int1_Count);
		}else{
			DebugPrintf("Int1Task: wai_sem ercd = %04xh\r", ercd);
		}
	}
}



