/*****************************************************
timer.c :
  ITRON TvvO
  Copyright(C) 1998-2002 XؖF

^C}^XN̎

*****************************************************/

#include "hal.h"
#include "itron.h"
#include "event.h"
#include "debug.h"
#include "timer.h"

/* ^C}Ǘe[ům */
TIMERSLOT	TimerSlot[NUM_TIMERS];

/*VXeÑJEgl*/
DWORD	TimerCount;

/*****************************************************
^C}̂`oh
*****************************************************/
/*****************************************************
////^C}̐ݒ
	^C}͋NȂ
*****************************************************/
void timSetTimer(TNO tno,				/*^C}ԍiTNO_xxx)*/
			 TIMEOUT timeout,			/*^CAEgli~bj*/
			 ID		mbxid,				/*bZ[W{bNX̂hc*/
			 int	szMsg,				/*bZ[WTCY*/
			 MSGBLOCK* pMsg)			/*bZ[WAhX*/
{
	DECLARE_MASK;
	SET_MASK;					/* ݋֎~ */
	TimerSlot[tno].mbxid = mbxid;
	TimerSlot[tno].szMsg = szMsg;
	TimerSlot[tno].pMsg = pMsg;
	TimerSlot[tno].count = 0;
	TimerSlot[tno].timeout = timeout/TIMERUNIT;
	RESTORE_MASK;					/* ݋^֎~Ԃ̕A */
}

/*****************************************************
////^C}̖
*****************************************************/
void timCancelTimer(TNO tno)
{
	DECLARE_MASK;
	SET_MASK;					/* ݋֎~ */
	TimerSlot[tno].mbxid = 0;
	TimerSlot[tno].szMsg = 0;
	TimerSlot[tno].pMsg = NULL;
	TimerSlot[tno].count = 0;
	TimerSlot[tno].timeout = 0;
	RESTORE_MASK;					/* ݋^֎~Ԃ̕A */
}

/*****************************************************
////^C}̋N
*****************************************************/
void timStartTimer(TNO tno)
{
	DECLARE_MASK;
	SET_MASK;					/* ݋֎~ */
	TimerSlot[tno].count = TimerSlot[tno].timeout;
	RESTORE_MASK;					/* ݋^֎~Ԃ̕A */
}

/*****************************************************
////^C}̒~
*****************************************************/
void timStopTimer(TNO tno)
{
	DECLARE_MASK;
	SET_MASK;					/* ݋֎~ */
	TimerSlot[tno].count = 0;
	RESTORE_MASK;					/* ݋^֎~Ԃ̕A */
}


/*****************************************************
//ėp^C}^XN
*****************************************************/
void TimerTask(VP_INT exinf)
{
	ER ercd;
	int i;
	DebugPrintf("\rTimerTask: started.\r");
	TimerCount = 0;
	/*^C}Ǘe[u*/
	for(i=0; i<NUM_TIMERS; i++){
		timCancelTimer((TNO)i);
	}
	/**/
	while(1){
		tslp_tsk(TIMERUNIT);
		++ TimerCount;
		for(i=0; i<NUM_TIMERS; i++){
			if(TimerSlot[i].count){
				/*Ñ^C}*/
				if(--TimerSlot[i].count == 0){
					/*^CAbv̂ŃbZ[W𑗂*/
					/*TimerSlot[i].pMsg->mheader.os_rsv = 0;*/
					//ercd = snd_mbx(TimerSlot[i].mbxid, (T_MSG*)TimerSlot[i].pMsg);
					ercd = SendEvent(TimerSlot[i].mbxid, TimerSlot[i].pMsg);
				}
			}
		}
	}
}

