/*****************************************************
irq1_irq2.c : Edited at 1998,7,1 by K.Sasaki
  ITRON TvvO
  Copyright(C) 1998-2002 XؖF

ݏ^XN̎

*****************************************************/

#include "hal.h"
#include "itron.h"
#include "system_def.h"
#include "debug.h"

void SetLed(int volume);

/*****************************************************
//IRQ1̊荞݃nh
*****************************************************/
void Int1Handler(void)
{
	ER ercd;
	ercd = iset_flg(FID_Irq12, 0x0001);
	if(ercd != E_OK){
		DebugPrintf("Int1Handler: iset_flg ercd = %04xh\r", ercd);
	}
}

/*****************************************************
//IRQ2̊荞݃nh
*****************************************************/
void Int2Handler(void)
{
	ER ercd;
	ercd = iset_flg(FID_Irq12, 0x0002);
	if(ercd != E_OK){
		DebugPrintf("Int2Handler: iset_flg ercd = %04xh\r", ercd);
	}
}

/*****************************************************
//IRQ1,IRQ2̊荞݃^XN
*****************************************************/
void Irq12Task(VP_INT exinf)
{
	ER		ercd;
	T_RFLG	flginfo;
	UINT	flgptn;
	int		volume = 4;	/*{[li0 - 8j*/
	DebugPrintf("\rIrq12Task: started.\r");
	/*LED̏*/
	SetLed(volume);				/*LED*/

	/*IRQ1*/
	ena_int(1);
	/*IRQ2*/
	ena_int(2);
	while(1){
		ercd = wai_flg(FID_Irq12, 0x0003, TWF_ORW, &flgptn);
		if(ercd == E_OK){
			ref_flg(FID_Irq12, &flginfo);
			DebugPrintf("flgptn = %04xH\r", flgptn);
			if(flgptn & 0x0001){
				/*炷*/
				if(volume > 0){
					-- volume;
					SetLed(volume);			/*LED_*/
				}
			}
			if(flgptn & 0x0002){
				/*₷*/
				if(volume < 8){
					++ volume;
					SetLed(volume);			/*LED_*/
				}
			}
		}else{
			DebugPrintf("Irq12Task: wai_flg ercd = %04xh\r", ercd);
		}
	}
}

BYTE VolumeToLed[] = {0x00, 0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff};
void SetLed(int volume)
{
	halSetLED((WORD)~VolumeToLed[volume]);
}


