/*****************************************************
Display6.c : Edited at 1998,6,22 by K.Sasaki
  ITRON TvvO
  Copyright(C) 1998-2002 XؖF

b̕\

*****************************************************/

#include "hal.h"
#include "itron.h"
#include "system_def.h"
#include "event6.h"
#include "timer6.h"
#include "debug.h"



//eZOg̈ʒuvZ
//	==0==
//	5	1
//	==6==
//	4	2
//	==3== 7
//					    0     1     2     3     4     5     6     7     8     9
BYTE num_pattern[] = {0x3f, 0x06, 0x5b, 0x4f, 0x66, 0x6d, 0x7d, 0x27, 0x7f, 0x6f,
					  0x77, 0x7c, 0x39, 0x5e, 0x79, 0x71	//	;a,b,c,d,e,f
};

void DisplayDecimal(int num)
{
	WORD stat = num_pattern[(num/10)%10]<<8 | num_pattern[num%10];
	halSetSegLED(stat);
}

void DisplayHexDecimal(int num)
{
	WORD stat = num_pattern[(num>>4)&0x0f]<<8 | num_pattern[num&0x0f];
	DebugPrintf("%02x\r", num);
	halSetSegLED(stat);
}


/*^C}Cxg`*/
void SetClockEvent()
{
	EVENT* pEvent	= kpCreateEvent(EV_TIC);
	pEvent->evMbx	= MID_Display;		/*ʒmbZ[W󂯎郁C{bNXID*/
	kpSetTimerEvent(TNO_Display_tic,	/*^C}ԍ*/
			TIME_1SEC,					/*^CAEgl*/
			pEvent						/*ʒmCxg*/
			);
}

/*****************************************************
//\^XN
*****************************************************/
typedef enum{
	DS_CLOCK,
	DS_VOLUME,
}DISPLAY_TASK_STATE;
void DisplayTask(VP_INT exinf)
{
	DISPLAY_TASK_STATE state = DS_CLOCK;
	EVENT *pEvent;
	int seconds = 0;
	DisplayDecimal(seconds);
	DebugPrintf("\rDisplayTask: started.\r");

	SetClockEvent();	/*^C}`*/
	while(1){
		//ercd = rcv_mbx(MID_Display, &pMsg);
		pEvent = kpWaitEvent(MID_Display);
		if(pEvent){
			switch(state){
			case DS_CLOCK:
				switch(pEvent->event){
				case EV_TIC:
					++ seconds;
					DisplayDecimal(seconds);
					SetClockEvent();					/*̃^CAEgN*/
					break;
				case EV_BUTTON_DOWN:
					DisplayHexDecimal(halGetVolume(0));
					state = DS_VOLUME;
					break;
				case EV_BUTTON_UP:
					break;
				}
				break;
			case DS_VOLUME:
				switch(pEvent->event){
				case EV_TIC:
					++ seconds;
					DisplayHexDecimal(halGetVolume(0));
					SetClockEvent();					/*̃^CAEgN*/
					break;
				case EV_BUTTON_DOWN:
					break;
				case EV_BUTTON_UP:
					DisplayDecimal(seconds);
					state = DS_CLOCK;
					break;
				}
				break;
			}
			kpDeleteEvent(pEvent);
		}else{
			DebugPrintf("DisplayTask: No event\r");
			FATAL_ERROR("DisplayTask: No event");
		}
	}
}



