/*****************************************************
timer6.c :
  ITRON TvvO
  Copyright(C) 1998-2003 XؖF

^C}^XN̎

*****************************************************/

#include "hal.h"
#include "itron.h"
#include "event6.h"
#include "debug.h"
#include "timer6.h"

/* ^C}Ǘe[ům */
TIMERSLOT	TimerSlot[NUM_TIMERS];

/*VXeÑJEgl*/
DWORD	TimerCount;

/*****************************************************
^C}̂`oh
*****************************************************/
/*****************************************************
////^C}̐ݒ
	^C}͋NȂ
*****************************************************/
static void timSetTimer(TNO tno,			/*^C}ԍiTNO_xxx)*/
			 TIMEOUT timeout,			/*^CAEgli~bj*/
			 ID		evMbx,				/*bZ[W{bNX̂hc*/
			 int	szEvent,			/*bZ[WTCY*/
			 EVENT* pEvent)				/*bZ[WAhX*/
{
	DECLARE_MASK;
	if(TimerSlot[tno].pEvent){
		kpDeleteEvent(TimerSlot[tno].pEvent);
	}
	SET_MASK;						/* ݋֎~ */
	TimerSlot[tno].evMbx	= evMbx;
	TimerSlot[tno].szEvent	= szEvent;
	TimerSlot[tno].pEvent	= pEvent;
	TimerSlot[tno].count	= 0;
	TimerSlot[tno].timeout	= timeout/TIMERUNIT;
	RESTORE_MASK;					/* ݋^֎~Ԃ̕A */
}

/*****************************************************
////^C}̋N
*****************************************************/
static void timStartTimer(TNO tno)
{
	DECLARE_MASK;
	SET_MASK;						/* ݋֎~ */
	if(TimerSlot[tno].pEvent){
		TimerSlot[tno].count = TimerSlot[tno].timeout;
	}
	RESTORE_MASK;					/* ݋^֎~Ԃ̕A */
}

/*****************************************************
////^C}̒~
*****************************************************/
static void timStopTimer(TNO tno)
{
	DECLARE_MASK;
	SET_MASK;						/* ݋֎~ */
	TimerSlot[tno].count = 0;
	RESTORE_MASK;					/* ݋^֎~Ԃ̕A */
}


/*****************************************************
//ėp^C}^XN
*****************************************************/
void TimerTask(VP_INT exinf)
{
	ER ercd;
	int i;
	DebugPrintf("\rTimerTask: started.\r");
	TimerCount = 0;
	/*^C}Ǘe[u*/
	for(i=0; i<NUM_TIMERS; i++){
		kpCancelTimer((TNO)i);
	}
	/**/
	while(1){
		tslp_tsk(TIMERUNIT);
		++ TimerCount;
		for(i=0; i<NUM_TIMERS; i++){
			if(TimerSlot[i].count){
				/*Ñ^C}*/
				if(--TimerSlot[i].count == 0){
					/*^CAbv̂ŃCxgibZ[Wj𑗂*/
					EVENT* pEvent	= TimerSlot[i].pEvent;
					ID evMbx		= TimerSlot[i].evMbx;
					TimerSlot[i].pEvent = NULL;
					TimerSlot[i].evMbx	= 0;
					//DIS_INT
					ercd = kpSendEvent(evMbx, pEvent);
					//ENA_INT
					if(ercd != E_OK){
						kpDeleteEvent(pEvent);
						CMTRACE("TimerTask: CxgMŃG[ %d N܂B\n", ercd);
					}
				}
			}
		}
	}
}


/*****************************************************
////^C}Cxg̐ݒ
	^C}N
//g
//EVENT* pEvent = kpCreateEvent(TIMEOUT_EVENT);
//pEvent->evMbx = ^C}Cxg󂯎郁C{bNXhcw;
//kpSetTimerEvent(tno, 1000, pEvent);
*****************************************************/
void kpSetTimerEvent(TNO tno, TIMEOUT timeout, EVENT* pEvent )
{
	/*^C}`*/
	if(timeout == 0) timeout = 1;
	timSetTimer(tno,					/*^C}ԍ*/
			timeout,					/*^CAEgl*/
			pEvent->evMbx,				/*ʒmbZ[W󂯎郁C{bNXID*/
			sizeof(EVENT),				/*bZ[WTCY*/
			pEvent						/*ʒmCxg*/
			);
	timStartTimer(tno);	/*^C}N*/
}


/*****************************************************
////^C}Cxg̖
*****************************************************/
void kpCancelTimer(TNO tno)
{
	DECLARE_MASK;
	if(TimerSlot[tno].pEvent){
		kpDeleteEvent(TimerSlot[tno].pEvent);
	}
	SET_MASK;						/* ݋֎~ */
	TimerSlot[tno].evMbx	= 0;
	TimerSlot[tno].szEvent	= 0;
	TimerSlot[tno].pEvent	= NULL;
	TimerSlot[tno].count	= 0;
	TimerSlot[tno].timeout	= 0;
	RESTORE_MASK;					/* ݋^֎~Ԃ̕A */
}

