/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;

public class SKMFlashString {
    public static final int DIR_NONE = 0;
    public static final int DIR_UP = 1;
    public static final int DIR_DOWN = 2;
    public static final int DIR_LEFT = 4;
    public static final int DIR_RIGHT = 8;
    public static final int DIR_IN = 16;
    public static final int DIR_OUT = 32;
    private final String mMessage;
    private int mX;
    private int mY;
    private SKMColor mMessageColor;
    private SKMFont mMessageFont;
    private int mFlashR;
    private int mFlashG;
    private int mFlashB;
    private int mFlashNum;
    private int mDFontSize;
    private int mFlashAlphaDiff;
    private int mFadeoutStartTime;
    private int mFadeoutDirection;
    private int mDFadeoutAlpha;
    private int mXOffset;
    private int mYOffset;
    private int mXOffsetBase;
    private int mYOffsetBase;
    private double mFlashSpeedX;
    private double mFlashSpeedY;
    private boolean mIsFlashing;
    private boolean mIsFadeout;
    private boolean mIsMessageBelow;
    private boolean mIsShadow;
    private SKMColor mShadowColor;
    private int mCount;

    public SKMFlashString(String message, int x, int y, SKMFont messageFont, SKMColor messageColor) {
        this.mMessage = message;
        this.mX = x;
        this.mY = y;
        this.mMessageFont = messageFont;
        this.mMessageColor = messageColor;
        this.setFlashNum(3);
        this.mDFontSize = 12;
        this.mDFadeoutAlpha = 3;
        this.mIsFadeout = true;
        this.mIsFlashing = true;
        this.setFadeoutDirection(16);
        this.mFlashR = 255;
        this.mFlashG = 255;
        this.mFlashB = 255;
    }

    public void setFlashColor(int r, int g, int b) {
        this.mFlashR = r;
        this.mFlashG = g;
        this.mFlashB = b;
    }

    public void setFlashNum(int n) {
        this.mFlashNum = n;
        this.mFlashAlphaDiff = 255 / (this.mFlashNum + 1);
    }

    public void setFadeoutDirection(int dir) {
        this.mFadeoutDirection = dir;
    }

    public void setFlashMoveSpeed(double speedX, double speedY) {
        this.mFlashSpeedX = speedX;
        this.mFlashSpeedY = speedY;
    }

    public void setFlashOffset(int xOffset, int yOffset) {
        this.mXOffsetBase = xOffset;
        this.mYOffsetBase = yOffset;
    }

    public void setFadeoutStartTime(int n) {
        this.mFadeoutStartTime = n;
    }

    public void setDFontSize(int n) {
        this.mDFontSize = n;
    }

    public void setDFadeoutAlpha(int n) {
        this.mDFadeoutAlpha = n;
    }

    public void setShadowColor(SKMColor c) {
        this.mShadowColor = c;
    }

    public void setShadow(boolean f) {
        this.mIsShadow = f;
    }

    public void setMessageBelow(boolean f) {
        this.mIsMessageBelow = f;
    }

    public void move() {
        ++this.mCount;
        this.mXOffset = this.mXOffsetBase + (int)(this.mFlashSpeedX * (double)this.mCount);
        this.mYOffset = this.mYOffsetBase + (int)(this.mFlashSpeedY * (double)this.mCount);
    }

    public void paint(SKMGraphics g) {
        if (this.mIsMessageBelow) {
            g.setFont(this.mMessageFont);
            if (this.mIsShadow) {
                g.setColor(this.mShadowColor);
                g.drawCenteringString(this.mMessage, this.mX + 3, this.mY + 3);
            }
            g.setColor(this.mMessageColor);
            g.drawCenteringString(this.mMessage, this.mX, this.mY);
        }
        if (this.mIsFlashing) {
            int fontName = this.mMessageFont.getFontName();
            int fontStyle = this.mMessageFont.getStyle();
            int baseFontSize = this.mMessageFont.getSize();
            for (int i = 0; i < this.mFlashNum; ++i) {
                int alpha = 0;
                if (this.mIsFadeout) {
                    if (this.mFadeoutDirection == 32) {
                        alpha = this.mFlashAlphaDiff * (i + 1);
                    } else if (this.mFadeoutDirection == 16) {
                        alpha = 255 - this.mFlashAlphaDiff * (i + 1);
                    }
                    if (this.mFadeoutStartTime <= this.mCount) {
                        alpha -= (this.mCount - this.mFadeoutStartTime) * this.mDFadeoutAlpha;
                    }
                }
                if (alpha <= 0) continue;
                if (255 < alpha) {
                    alpha = 255;
                }
                g.setColor(new SKMColor(this.mFlashR, this.mFlashG, this.mFlashB, alpha));
                g.setFont(new SKMFont(fontName, fontStyle, baseFontSize + this.mDFontSize * (i + 1)));
                g.drawCenteringString(this.mMessage, this.mX + this.mXOffset * (i + 1), this.mY + this.mYOffset * (i + 1));
            }
        }
        if (!this.mIsMessageBelow && this.mFadeoutDirection == 16) {
            g.setFont(this.mMessageFont);
            if (this.mIsShadow) {
                g.setColor(this.mShadowColor);
                g.drawCenteringString(this.mMessage, this.mX + 3, this.mY + 3);
            }
            g.setColor(this.mMessageColor);
            g.drawCenteringString(this.mMessage, this.mX, this.mY);
        }
    }
}

