/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import jp.ne.sk_mine.util.andr_applet.SKMView;
import jp.ne.sk_mine.util.image.ImageLoader;

public class SKMImage {
    private static String sBasePath;
    private Image mImage;
    private String mResourceName;
    private int mAlpha = 255;
    private int mDrawWidth;
    private int mDrawHeight;

    public static void setBasePath(String path) {
        sBasePath = path;
    }

    public static String getBasePath() {
        return sBasePath;
    }

    public SKMImage(String resourceName) {
        if (sBasePath != null && resourceName != null && !((String)resourceName).startsWith("-") && ((String)resourceName).indexOf(sBasePath) != 0) {
            resourceName = sBasePath + (String)resourceName;
        }
        this.mResourceName = resourceName;
        this.mImage = ImageLoader.getInstance().loadImage((String)resourceName);
    }

    public SKMImage(int[] pixels, int w, int h) {
        BufferedImage image = new BufferedImage(w, w, 2);
        image.setRGB(0, 0, w, w, pixels, 0, w);
        this.mImage = image;
    }

    public SKMImage(Image image) {
        this.mImage = image;
    }

    public SKMImage(String resourceName, Image image) {
        if (sBasePath != null && resourceName != null && !((String)resourceName).startsWith("-") && ((String)resourceName).indexOf(sBasePath) != 0) {
            resourceName = sBasePath + (String)resourceName;
        }
        this.mResourceName = resourceName;
        this.mImage = image;
    }

    public int getWidth() {
        if (this.mDrawWidth != 0) {
            return this.mDrawWidth;
        }
        return this.mImage.getWidth(null);
    }

    public int getHeight() {
        if (this.mDrawHeight != 0) {
            return this.mDrawHeight;
        }
        return this.mImage.getHeight(null);
    }

    public int getBaseWidth() {
        return this.mImage.getWidth(null);
    }

    public int getBaseHeight() {
        return this.mImage.getHeight(null);
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public Image getImage() {
        return this.mImage;
    }

    public SKMImage getScaledImage(double scale) {
        return this.getResizedImage((int)(scale * (double)this.getBaseWidth()), (int)(scale * (double)this.getBaseHeight()));
    }

    public SKMImage getResizedImage(int width, int height) {
        Image image;
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        ImageLoader loader = ImageLoader.getInstance();
        String resourceName = null;
        if (this.mResourceName != null && (image = loader.getCache(resourceName = this.mResourceName + this.getResizedKey(width, height))) != null) {
            return new SKMImage(resourceName, image);
        }
        image = this.mImage.getScaledInstance(width, height, 4);
        try {
            loader.waitImageLoading(image);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resourceName != null && image != null) {
            loader.cache(resourceName, image);
        }
        return new SKMImage(resourceName, image);
    }

    public SKMImage scale(double scale) {
        return this.resize((int)(scale * (double)this.getBaseWidth()), (int)(scale * (double)this.getBaseHeight()));
    }

    public SKMImage resize(int width, int height) {
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        this.mDrawWidth = width;
        this.mDrawHeight = height;
        return this;
    }

    private final String getResizedKey(int width, int height) {
        StringBuilder buf = new StringBuilder();
        buf.append("_");
        buf.append(width);
        buf.append("_");
        buf.append(height);
        return buf.toString();
    }

    public void copyView(SKMView view) {
        Image image = view.getOffscreenImage();
        Graphics g = this.mImage.getGraphics();
        g.drawImage(image, 0, 0, view);
        g.dispose();
    }

    public void release() {
        if (this.mImage != null && !ImageLoader.getInstance().isCached(this.mResourceName)) {
            this.mImage.flush();
            this.mImage = null;
        }
    }

    public void cleanUp() {
        this.release();
    }
}

