/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jp.ne.sk_mine.util.ResourceUtil;
import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMAlertDialog;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMButton;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMEnvUtil;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMI18N;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMRandomTool;
import jp.ne.sk_mine.util.andr_applet.SKMSettings;
import jp.ne.sk_mine.util.andr_applet.SKMTimer;
import jp.ne.sk_mine.util.andr_applet.SKMUI;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.SKMWindowFuncs;
import jp.ne.sk_mine.util.andr_applet.game.ViewCamera;
import jp.ne.sk_mine.util.andr_applet.game.event.EventBase;
import jp.ne.sk_mine.util.image.ImageLoader;
import jp.ne.sk_mine.util.sound.BgmPlayer;
import jp.ne.sk_mine.util.sound.SoundPlayer;
import org.json.JSONArray;
import org.json.JSONObject;

public class SKMView
extends JPanel
implements Runnable {
    protected int mViewWidth;
    protected int mViewHeight;
    public static final int STATE_BEFORE_LOADING = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_MAIN = 2;
    public static final int STATE_QUIT = 3;
    private static final String WEBSITE = "https://sorakomi.com/";
    private static final String SERVER = "https://sorakomi.com";
    private static final String STATE_MESSAGE_RES = "jp.ne.sk_mine.util.andr_applet.res.message.message";
    public static final String SETTING_KEY_SOUND = "isSoundEnabled";
    public static final String SETTING_KEY_BGM = "isBgmEnabled";
    public static final String SETTING_KEY_LANG = "lang";
    public static final String SETTING_KEY_WINDOW_X = "skmview_window_x";
    public static final String SETTING_KEY_WINDOW_Y = "skmview_window_y";
    private static final String sTranslationUrl = "https://sorakomi.com/soft/translation/$a/translation_$l.html";
    private static final String sRegisterUserUrl = "https://sorakomi.com/cgi-bin/tool/admin_user.html?lang=$l";
    private static final String sRegisterScoreUrl = "https://sorakomi.com/soft/game/$a/register_score.cgi";
    private static final String sRankingUrl = "https://sorakomi.com/soft/game/$a/print_score.cgi?lang=$l";
    private static final String sMaterialListUrl = "https://sorakomi.com/soft/$group/$a/material$l.html";
    private static final String sGameListUrl = "https://play.google.com/store/apps/developer?id=sk_Mine&hl=$l";
    private static final String sErrorLogFile = "sk_mine_error_log.txt";
    private static final String sPrivacyPolicyUrl = "https://sorakomi.com/soft/$group/$a/privacy_policy.html?lang=$l";
    private static final String sSupportMeUrl = "https://www.patreon.com/sk_mine";
    protected int[] mKeys = new int[]{73, 75, 74, 76, 90, 88};
    protected int mPauseKey = 80;
    protected int mResetKey = 82;
    protected int mViewScalingKey = 120;
    private boolean mIsShake;
    private int mScreenOffsetX;
    private int mScreenOffsetY;
    private int mShakeAmp;
    private int mShakeNum;
    private int mShakeType;
    public static final int TYPE_SHAKE_HORIZONTAL_DAMPING = 0;
    public static final int TYPE_SHAKE_VERTICAL_DAMPING = 1;
    public static final int TYPE_SHAKE_VERTICAL_HORIZONTAL_DAMPING = 2;
    public static final int TYPE_SHAKE_HORIZONTAL = 3;
    public static final int TYPE_SHAKE_VERTICAL = 4;
    public static final int TYPE_SHAKE_VERTICAL_HORIZONTAL = 5;
    private int mSystemMessageCount;
    private String mSystemMessage;
    private final int SYSTEM_MESSAGE_COUNT_MAX = 120;
    private boolean mIsPausing;
    private boolean mIsPauseSwitched;
    private boolean mIsPauseBeforeFocusLost;
    private boolean mIsResetSelected;
    private boolean mDoPaint;
    private boolean mIsFocused;
    private boolean mIsShowFocusLost = true;
    private boolean mIsRepaintAllBackground;
    private boolean mIsPauseWhenLostFocus;
    private boolean mIsSoundSwitched;
    private boolean mIsBgmSwitched;
    private boolean mIsButtonMouseOverEnabled;
    protected boolean mIsRemoveAllUisInInitI18N;
    private double mRunMspf = 33.333333333333336;
    protected boolean mIsMouseLeftPressed;
    protected boolean mIsMouseRightPressed;
    protected boolean mIsMouseMiddlePressed;
    protected boolean mIsMouseReleased;
    protected boolean mIsMouseLeftReleased;
    protected boolean mIsMouseRightReleased;
    protected boolean mIsMouseMiddleReleased;
    protected boolean mIsMouseDragged;
    protected boolean mIsApplication;
    protected boolean mIsPlaySound = true;
    protected int mViewVersion;
    protected int mMouseX;
    protected int mMouseY;
    protected int mMouseXPrev;
    protected int mMouseYPrev;
    protected int mMousePressedX;
    protected int mMousePressedY;
    protected int mMouseReleasedX;
    protected int mMouseReleasedY;
    protected int mCount;
    protected int mState;
    protected int mTimeRag;
    protected double mViewScale = 1.0;
    protected double mDrawScale = 1.0;
    protected float mViewMarginX;
    protected float mViewMarginY;
    protected List<Point> mMousePressedPointList;
    protected BgmPlayer mBgmPlayer;
    protected JFrame mFrame;
    protected SKMI18N mI18NSystem;
    protected SKMRandomTool mRandom = new SKMRandomTool();
    protected String mAppId;
    protected String mAppGroup = "game";
    protected String mFocusLostMessage;
    protected String mServer;
    protected String[] mSupportedLangs;
    protected ViewCamera mViewCamera;
    protected SKMArray<SKMButton> mButtons;
    protected SKMArray<SKMUI> mComponents;
    private SKMSettings mSettings;
    private SKMTimer mTimer;
    private SKMGraphics mG;
    protected SKMI18N mI18N;
    private boolean mIsRunning;
    private Image mOffI;
    private Thread mThread;
    private MainPanel mMainPanel;
    private SoundPlayer mSoundPlayer;
    private List<String> mPlaySounds;
    private List<String> mPlaySingleSounds;
    private List<String> mPlayLoopSounds;
    private List<String> mPlaySingleLoopSounds;
    private List<String> mStopSounds;
    private Map<String, Integer> mPlayNoContSounds;

    public void setAppId(String id) {
        this.mAppId = id;
        this.mSettings = new SKMSettings(id);
        this.mSettings.load();
        SKM.setSettings(this.getSettings());
    }

    public String getAppId() {
        return this.mAppId;
    }

    public void setAppGroup(String group) {
        this.mAppGroup = group;
    }

    public String getAppGroup() {
        return this.mAppGroup;
    }

    public JComponent getMainPanel() {
        return this.mMainPanel;
    }

    public void setRemoveAllUisInInitI18N(boolean f) {
        this.mIsRemoveAllUisInInitI18N = f;
    }

    public void setViewVersion(int version) {
        this.mViewVersion = version;
        if (1 < version) {
            this.setRemoveAllUisInInitI18N(true);
            SKMButton.setDefaultUseDarkCover(true);
            EventBase.setUpdateButtonPositionsInSetPhase(true);
            EventBase.setBaseViewSize(true);
        }
        if (2 < version) {
            this.setRemoveAllUisInInitI18N(false);
        }
    }

    public int getViewVersion() {
        return this.mViewVersion;
    }

    public void init() {
        this.mG = new SKMGraphics(this, (Graphics2D)this.getGraphics());
        System.setProperty("sun.jnu.encoding", "UTF-8");
        UIManager.put("OptionPane.messageFont", new Font("Serif", 0, 12));
        Dimension d = this.getSize();
        this.mViewWidth = d.width;
        this.mViewHeight = d.height;
        this.setPreferredSize(new Dimension(this.mViewWidth, this.mViewHeight));
        this.mMainPanel = new MainPanel(this);
        this.mMainPanel.setLayout(null);
        this.mMainPanel.setPreferredSize(new Dimension(this.mViewWidth, this.mViewHeight));
        this.mMainPanel.setBounds(0, 0, this.mViewWidth, this.mViewHeight);
        this.add(this.mMainPanel);
        this.mOffI = this.createImage(this.mViewWidth, this.mViewHeight);
        this.mBgmPlayer = new BgmPlayer();
        this.mSoundPlayer = new SoundPlayer();
        this.mRandom = new SKMRandomTool();
        this.mServer = SERVER;
        this.mMousePressedPointList = new ArrayList<Point>();
        this.mButtons = new SKMArray();
        this.mComponents = new SKMArray();
        this.mPlaySounds = new ArrayList<String>();
        this.mPlaySingleSounds = new ArrayList<String>();
        this.mPlayLoopSounds = new ArrayList<String>();
        this.mPlaySingleLoopSounds = new ArrayList<String>();
        this.mStopSounds = new ArrayList<String>();
        this.mPlayNoContSounds = new HashMap<String, Integer>();
        this.mIsRepaintAllBackground = true;
        this.mTimer = new SKMTimer();
        this.mScreenOffsetY = 0;
        this.mScreenOffsetX = 0;
        this.mShakeAmp = 0;
        this.mShakeNum = 0;
        this.mIsShake = false;
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ SKMView this$0;
            {
                SKMView sKMView = this$0;
                Objects.requireNonNull(sKMView);
                this.this$0 = sKMView;
            }

            @Override
            public void mousePressed(MouseEvent me) {
                if (!this.this$0.mIsFocused) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                    this.this$0.requestFocusInWindow();
                }
                this.this$0.mMouseX = this.this$0.mMousePressedX = me.getX();
                this.this$0.mMouseXPrev = this.this$0.mMousePressedX;
                this.this$0.mMouseY = this.this$0.mMousePressedY = me.getY();
                this.this$0.mMouseYPrev = this.this$0.mMousePressedY;
                if (SwingUtilities.isLeftMouseButton(me)) {
                    this.this$0.mIsMouseLeftPressed = true;
                }
                if (SwingUtilities.isRightMouseButton(me)) {
                    this.this$0.mIsMouseRightPressed = true;
                }
                if (SwingUtilities.isMiddleMouseButton(me)) {
                    this.this$0.mIsMouseMiddlePressed = true;
                }
                this.this$0.mMousePressedPointList.add(new Point(this.this$0.mMouseX, this.this$0.mMouseY));
                this.this$0.myMousePressed(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.this$0.setAllButtonNotPressed();
                if (SwingUtilities.isLeftMouseButton(me)) {
                    this.this$0.mIsMouseLeftPressed = false;
                    this.this$0.mIsMouseLeftReleased = true;
                }
                if (SwingUtilities.isRightMouseButton(me)) {
                    this.this$0.mIsMouseRightPressed = false;
                    this.this$0.mIsMouseRightReleased = true;
                }
                if (SwingUtilities.isMiddleMouseButton(me)) {
                    this.this$0.mIsMouseMiddlePressed = false;
                    this.this$0.mIsMouseMiddleReleased = true;
                }
                this.this$0.mIsMouseDragged = false;
                this.this$0.mIsMouseReleased = true;
                this.this$0.mMouseReleasedX = me.getX();
                this.this$0.mMouseReleasedY = me.getY();
                this.this$0.myMouseReleased(me);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ SKMView this$0;
            {
                SKMView sKMView = this$0;
                Objects.requireNonNull(sKMView);
                this.this$0 = sKMView;
            }

            @Override
            public void mouseDragged(MouseEvent me) {
                this.this$0.mMouseXPrev = this.this$0.mMouseX;
                this.this$0.mMouseYPrev = this.this$0.mMouseY;
                this.this$0.mMouseX = me.getX();
                this.this$0.mMouseY = me.getY();
                this.this$0.mIsMouseDragged = true;
                this.this$0.myMouseDragged(me);
            }

            @Override
            public void mouseMoved(MouseEvent me) {
                if (this.this$0.mIsButtonMouseOverEnabled) {
                    try {
                        for (int i = this.this$0.mButtons.size() - 1; 0 <= i; --i) {
                            this.this$0.mButtons.get(i).setMouseOver(this.this$0.mButtons.get(i).isHit(me.getX(), me.getY(), false));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.this$0.mMouseXPrev = this.this$0.mMouseX;
                this.this$0.mMouseYPrev = this.this$0.mMouseY;
                this.this$0.mMouseX = me.getX();
                this.this$0.mMouseY = me.getY();
                this.this$0.myMouseMoved(me);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(this){
            final /* synthetic */ SKMView this$0;
            {
                SKMView sKMView = this$0;
                Objects.requireNonNull(sKMView);
                this.this$0 = sKMView;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent mwe) {
                this.this$0.myMouseWheelMoved(mwe);
            }
        });
        this.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ SKMView this$0;
            {
                SKMView sKMView = this$0;
                Objects.requireNonNull(sKMView);
                this.this$0 = sKMView;
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (this.this$0.systemKeyPressed(ke)) {
                    return;
                }
                this.this$0.gameKeyPressed(ke);
            }

            @Override
            public void keyReleased(KeyEvent ke) {
                this.this$0.gameKeyReleased(ke);
            }
        });
        this.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ SKMView this$0;
            {
                SKMView sKMView = this$0;
                Objects.requireNonNull(sKMView);
                this.this$0 = sKMView;
            }

            @Override
            public void focusGained(FocusEvent fe) {
                if (this.this$0.mIsPauseWhenLostFocus) {
                    if (this.this$0.mIsPausing && !this.this$0.mIsPauseBeforeFocusLost) {
                        this.this$0.mIsPauseSwitched = true;
                    }
                    this.this$0.mIsPauseBeforeFocusLost = false;
                }
                this.this$0.setRepaintAllBackground(true);
                this.this$0.mIsFocused = true;
                this.this$0.repaint();
            }

            @Override
            public void focusLost(FocusEvent fe) {
                this.this$0.mIsFocused = false;
                if (this.this$0.mIsPauseWhenLostFocus) {
                    if (this.this$0.mIsPausing) {
                        this.this$0.mIsPauseBeforeFocusLost = true;
                    } else {
                        this.this$0.mIsPauseSwitched = true;
                    }
                }
                this.this$0.setAllButtonNotPressed();
                this.this$0.repaint();
            }
        });
        if (Locale.getDefault().getLanguage().equals("ja")) {
            SKMI18N.setLocale(Locale.forLanguageTag("ja-JP"));
        } else if (Locale.getDefault().getLanguage().equals("en")) {
            SKMI18N.setLocale(Locale.forLanguageTag("en-US"));
        } else {
            SKMI18N.setLocale(Locale.getDefault());
        }
        ImageLoader.getInstance().setApplet(this);
        this.libInit();
        this.mState = 1;
        this.initBeforeLoop();
        this.libInitAfter();
        this.initAfterLoading();
        this.mState = 2;
    }

    protected void setAllButtonNotPressed() {
        try {
            for (int i = this.mButtons.size() - 1; 0 <= i; --i) {
                this.mButtons.get(i).setPressed(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void libInit() {
        SKM.setSoundPlayer(this.getSoundPlayer());
        SKM.setBgmPlayer(this.mBgmPlayer);
        SKM.setRandom(this.mRandom);
        SKM.setRandomForRepro(new SKMRandomTool());
        SKM.setGraphics(this.getSKMGraphics());
    }

    protected void libInitAfter() {
        SKM.setI18N(this.mI18N);
    }

    public void setSupportedLangs(String[] langs) {
        this.mSupportedLangs = langs;
    }

    public String[] getSupportedLangs() {
        return this.mSupportedLangs;
    }

    public void initI18N(String lang) {
        if (this.mIsRemoveAllUisInInitI18N) {
            this.removeAllUis();
        }
        if (this.mSupportedLangs != null) {
            int i;
            for (i = this.mSupportedLangs.length - 1; 0 <= i && !this.mSupportedLangs[i].equals(lang); --i) {
            }
            if (i == -1) {
                lang = "en";
            }
        }
        if (lang.contains("_")) {
            String[] tokens = lang.split("_");
            SKMI18N.setLanguage(tokens[0]);
            SKMI18N.setCountry(tokens[1]);
        } else {
            SKMI18N.setLanguage(lang);
            SKMI18N.setCountry("");
        }
        this.mI18NSystem = new SKMI18N(STATE_MESSAGE_RES);
        this.mFocusLostMessage = this.mI18NSystem.getString("FOCUS_LOST");
        SKMI18N i18n = new SKMI18N(STATE_MESSAGE_RES);
        SKM.setI18NCommon(i18n);
        this.setSetting(SETTING_KEY_LANG, lang);
        this.saveSettings();
    }

    protected void initBeforeLoop() {
    }

    protected void initAfterLoading() {
        this.myInit();
        this.applySettings();
        this.reset();
        SKM.setI18N(this.mI18N);
    }

    protected void myInit() {
    }

    public int getViewWidth() {
        return this.mViewWidth;
    }

    public int getViewHeight() {
        return this.mViewHeight;
    }

    public int getDrawWidth() {
        return (int)(this.mViewScale * (double)this.mViewWidth / this.mDrawScale);
    }

    public int getDrawHeight() {
        return (int)(this.mViewScale * (double)this.mViewHeight / this.mDrawScale);
    }

    public int getBaseDrawWidth() {
        return this.mViewWidth;
    }

    public int getBaseDrawHeight() {
        return this.mViewHeight;
    }

    public double getDrawScale() {
        return this.mDrawScale;
    }

    public void setViewCamera(ViewCamera viewCamera) {
        this.mViewCamera = viewCamera;
    }

    public ViewCamera getViewCamera() {
        return this.mViewCamera;
    }

    public void setViewScale(double scale) {
        this.mViewScale = scale;
    }

    public double getViewScale() {
        return this.mViewScale;
    }

    public float getViewMarginX() {
        return this.mViewMarginX;
    }

    public float getViewMarginY() {
        return this.mViewMarginY;
    }

    public void setButtonMouseOverEnabled(boolean f) {
        this.mIsButtonMouseOverEnabled = f;
    }

    public boolean isButtonMouseOverEnabled() {
        return this.mIsButtonMouseOverEnabled;
    }

    public void applySettings() {
        this.getSoundPlayer().setEnabled(this.getBooleanSetting(SETTING_KEY_SOUND, true));
        this.mBgmPlayer.setEnabled(this.getBooleanSetting(SETTING_KEY_BGM, true));
        this.initI18N(this.getStringSetting(SETTING_KEY_LANG, SKMEnvUtil.getLanguage()));
    }

    public void setRunFps(int fps) {
        this.mRunMspf = 1000.0 / (double)fps;
    }

    public double getRunMspf() {
        return this.mRunMspf;
    }

    public void reset() {
        this.mCount = 0;
        this.mIsMouseLeftPressed = false;
        this.mIsMouseRightPressed = false;
        this.mIsMouseMiddlePressed = false;
        this.mIsMouseReleased = false;
        this.mIsMouseLeftReleased = false;
        this.mIsMouseRightReleased = false;
        this.mIsMouseMiddleReleased = false;
        this.mIsMouseDragged = false;
        this.mIsShake = false;
        this.mIsPlaySound = true;
        this.mScreenOffsetX = 0;
        this.mScreenOffsetY = 0;
        this.mMousePressedPointList.clear();
        this.mPlaySounds.clear();
        this.mPlaySingleSounds.clear();
        this.mPlayLoopSounds.clear();
        this.mPlaySingleLoopSounds.clear();
        this.mStopSounds.clear();
        this.mPlayNoContSounds.clear();
        this.mBgmPlayer.stopAll();
        this.mBgmPlayer.reset();
        this.mSoundPlayer.stopAll();
        if (this.mIsPausing) {
            this.switchPauseProc();
        }
        this.mTimer.stop();
        this.mTimer.reset();
        this.myReset();
    }

    protected void myReset() {
    }

    protected void myMousePressed(MouseEvent me) {
    }

    protected void myMouseReleased(MouseEvent me) {
    }

    protected void myMouseDragged(MouseEvent me) {
    }

    protected void myMouseMoved(MouseEvent me) {
    }

    protected void myMouseWheelMoved(MouseWheelEvent mwe) {
    }

    protected boolean systemKeyPressed(KeyEvent ke) {
        int keyCode = ke.getKeyCode();
        if (keyCode == 27) {
            this.quit();
        } else if (keyCode == this.mPauseKey) {
            this.mIsPauseSwitched = true;
        } else if (keyCode == this.mResetKey) {
            this.mIsResetSelected = true;
        } else if (keyCode == 115) {
            if (!this.mIsSoundSwitched) {
                this.mIsSoundSwitched = true;
            }
        } else if (keyCode == 116) {
            if (!this.mIsBgmSwitched) {
                this.mIsBgmSwitched = true;
            }
        } else if (keyCode == this.mViewScalingKey) {
            if (this.mIsApplication && this.mFrame != null) {
                this.mViewScale = this.mViewScale == 1.0 ? 2.0 : 1.0;
                this.adjustSize();
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean gameKeyPressed(KeyEvent ke) {
        return false;
    }

    protected boolean gameKeyReleased(KeyEvent ke) {
        return false;
    }

    public void addUi(SKMUI ui) {
        if (ui == null) {
            return;
        }
        if (ui instanceof SKMButton) {
            this.addButton((SKMButton)ui);
        } else {
            Component component = ui.getImpl();
            if (component != null) {
                this.getMainPanel().add(component);
            }
            this.mComponents.add(ui);
        }
    }

    public void removeUi(SKMUI ui) {
        if (ui == null) {
            return;
        }
        if (ui instanceof SKMButton) {
            this.removeButton((SKMButton)ui);
        } else {
            Component component = ui.getImpl();
            if (component != null) {
                this.getMainPanel().remove(component);
            }
            this.mComponents.remove(ui);
        }
    }

    public void removeAllUis() {
        this.mButtons.clear();
        for (int i = this.mComponents.size() - 1; 0 <= i; --i) {
            this.removeUi(this.mComponents.get(i));
        }
        this.mComponents.clear();
    }

    public boolean addButton(SKMButton button) {
        if (button == null) {
            return false;
        }
        this.removeButton(button);
        this.mButtons.add(button);
        return true;
    }

    public void removeButton(SKMButton button) {
        this.mButtons.remove(button);
    }

    public SKMButton isButtonHit(int x, int y) {
        for (int i = this.mButtons.size() - 1; 0 <= i; --i) {
            SKMButton button = this.mButtons.get(i);
            if (!button.isHit(x, y)) continue;
            return button;
        }
        return null;
    }

    public SKMTimer getTimer() {
        return this.mTimer;
    }

    public String getTranslationUrl() {
        return this.getTranslationUrl(this.getAppId());
    }

    public String getTranslationUrl(String appId) {
        String lang = SKM.getI18NCommon().getString(SETTING_KEY_LANG);
        return sTranslationUrl.replace("$a", appId).replace("$l", lang.equals("ja") ? "en" : lang);
    }

    public String getRegisterUserUrl() {
        return sRegisterUserUrl.replace("$l", SKM.getI18NCommon().getString(SETTING_KEY_LANG));
    }

    public String getRegisterScoreUrl() {
        return this.getRegisterScoreUrl(this.getAppId());
    }

    public String getRegisterScoreUrl(String appId) {
        return sRegisterScoreUrl.replace("$a", appId);
    }

    public String getRankingUrl() {
        return this.getRankingUrl(this.getAppId());
    }

    public String getRankingUrl(String appId) {
        return sRankingUrl.replace("$a", appId).replace("$l", SKM.getI18NCommon().getString(SETTING_KEY_LANG));
    }

    public String getMaterialListUrl() {
        return this.getMaterialListUrl(this.getAppId());
    }

    public String getMaterialListUrl(String appId) {
        return sMaterialListUrl.replace("$group", this.mAppGroup).replace("$a", appId).replace("$l", SKM.getI18NCommon().getString(SETTING_KEY_LANG).equals("ja") ? "" : "_en");
    }

    public String getGameListUrl() {
        return sGameListUrl.replace("$l", SKM.getI18NCommon().getString(SETTING_KEY_LANG));
    }

    public String getPrivacyPolicyUrl() {
        return this.getPrivacyPolicyUrl(this.getAppId());
    }

    public String getPrivacyPolicyUrl(String appId) {
        return sPrivacyPolicyUrl.replace("$group", this.mAppGroup).replace("$a", appId).replace("$l", SKM.getI18NCommon().getString(SETTING_KEY_LANG));
    }

    public String getSupportMeUrl() {
        return sSupportMeUrl;
    }

    public SKMGraphics getSKMGraphics() {
        return this.mG;
    }

    public SKMImage createSKMImage(int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        int[] pixels = new int[w * h];
        image.setRGB(0, 0, w, h, pixels, 0, w);
        return new SKMImage("-", image);
    }

    public SKMGraphics getDummyGraphics(SKMImage toImage) {
        return new SKMGraphics(this, (Graphics2D)toImage.getImage().getGraphics());
    }

    public void releaseDummyGraphics(SKMGraphics g, SKMImage toImage) {
        g.getGraphics().dispose();
    }

    protected void updateButtonPositions() {
    }

    public void triggerReset() {
        this.mIsResetSelected = true;
    }

    public Image getOffscreenImage() {
        return this.mOffI;
    }

    protected void adjustSize() {
        this.setPreferredSize(new Dimension((int)((double)this.mViewWidth * this.mViewScale), (int)((double)this.mViewHeight * this.mViewScale)));
        this.getMainPanel().setPreferredSize(new Dimension((int)((double)this.mViewWidth * this.mViewScale), (int)((double)this.mViewHeight * this.mViewScale)));
        this.invalidate();
        if (this.mFrame != null) {
            this.mFrame.setVisible(false);
            this.mFrame.pack();
            SKMWindowFuncs.centering(this.mFrame);
            this.mFrame.setVisible(true);
        }
    }

    public void setShowFocusLost(boolean f) {
        this.mIsShowFocusLost = f;
    }

    @Override
    public void run() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        this.requestFocusInWindow();
        this.mDoPaint = true;
        long frameStartTime = System.currentTimeMillis();
        Thread thread = Thread.currentThread();
        while (thread == this.mThread && this.mIsRunning) {
            if (this.mIsResetSelected) {
                this.mIsResetSelected = false;
                this.reset();
                continue;
            }
            if (this.mIsPauseSwitched) {
                this.switchPauseProc();
            }
            if (this.mIsSoundSwitched) {
                this.mSoundPlayer.setPlayable(!this.mSoundPlayer.isPlayable());
                if (this.mSoundPlayer.isPlayable()) {
                    this.setSystemMessage(this.mI18NSystem.getString("SOUND_ON"));
                } else {
                    this.mSoundPlayer.stopAll();
                    this.setSystemMessage(this.mI18NSystem.getString("SOUND_OFF"));
                }
                this.mIsSoundSwitched = false;
            }
            if (this.mIsBgmSwitched) {
                this.mBgmPlayer.setPlayable(!this.mBgmPlayer.isPlayable());
                if (this.mBgmPlayer.isPlayable()) {
                    this.mBgmPlayer.play();
                    this.setSystemMessage(this.mI18NSystem.getString("BGM_ON"));
                } else {
                    this.mBgmPlayer.pause();
                    this.setSystemMessage(this.mI18NSystem.getString("BGM_OFF"));
                }
                this.mIsBgmSwitched = false;
            }
            if (this.mIsPausing) {
                this.sleep(50.0);
                this.pauseProc();
                this.mTimer.pauseProc();
                this.repaint();
                continue;
            }
            ++this.mCount;
            if (!this.systemInputProc()) {
                this.inputProc();
            }
            this.moveButtons();
            try {
                this.myRun();
            }
            catch (Exception e) {
                this.logging(e);
            }
            this.mTimer.run();
            this.soundProc();
            this.clearInput();
            if (this.mIsShake && this.mCount % 2 == 0) {
                if (this.mShakeType == 0 || this.mShakeType == 1 || this.mShakeType == 2) {
                    --this.mShakeAmp;
                }
                if (this.mShakeAmp == 0) {
                    this.setScreenShake(false);
                } else if (this.mShakeType == 3 || this.mShakeType == 0) {
                    this.mScreenOffsetX = (this.mScreenOffsetX < 0 ? 1 : -1) * this.mShakeAmp;
                } else if (this.mShakeType == 4 || this.mShakeType == 1) {
                    this.mScreenOffsetY = (this.mScreenOffsetY < 0 ? 1 : -1) * this.mShakeAmp;
                } else if (this.mShakeType == 2 || this.mShakeType == 5) {
                    double[][] dxy = new double[][]{{0.7, -0.7}, {1.0, 0.0}, {-0.7, 0.7}, {0.0, -1.0}, {0.7, 0.7}, {-1.0, 0.0}, {0.0, 1.0}, {-0.7, -0.7}};
                    int dxyIndex = this.mCount % dxy.length;
                    this.mScreenOffsetX = (int)(dxy[dxyIndex][0] * (double)this.mShakeAmp);
                    this.mScreenOffsetY = (int)(dxy[dxyIndex][1] * (double)this.mShakeAmp);
                }
                if (0 < this.mShakeNum && --this.mShakeNum == 0) {
                    this.setScreenShake(false);
                }
            }
            this.repaint();
            long frameEndTime = System.currentTimeMillis();
            if ((double)(frameEndTime - frameStartTime) < this.mRunMspf) {
                this.sleep(this.mRunMspf - (double)(frameEndTime - frameStartTime));
            }
            if (this.mTimeRag != 0) {
                this.sleep(this.mTimeRag);
                this.mTimeRag = 0;
            }
            frameStartTime = System.currentTimeMillis();
        }
        this.repaint();
        if (this.mOffI != null) {
            this.mOffI.flush();
        }
    }

    protected void moveButtons() {
        try {
            for (int i = this.mButtons.size() - 1; 0 <= i; --i) {
                SKMButton button = this.mButtons.get(i);
                if (button == null) continue;
                button.move();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void logging(Exception e) {
        e.printStackTrace();
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String s = ((Object)stringWriter).toString();
        PrintWriter fileWriter = null;
        try {
            File file = new File(sErrorLogFile);
            fileWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(file)), true);
            fileWriter.println(new Date());
            fileWriter.println(s);
            fileWriter.println("----");
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTimeRag(int msec) {
        if (msec == 0 || this.mTimeRag < msec) {
            this.mTimeRag = msec;
        }
    }

    protected void myRun() {
    }

    protected boolean systemInputProc() {
        return false;
    }

    protected void inputProc() {
    }

    protected void clearInput() {
    }

    public void pause(boolean f) {
        if (f == this.mIsPausing) {
            return;
        }
        this.mIsPauseSwitched = true;
    }

    public void togglePause() {
        this.mIsPauseSwitched = true;
    }

    public boolean isPausing() {
        return this.mIsPausing;
    }

    protected void switchPauseProc() {
        this.mIsPausing = !this.mIsPausing;
        this.mIsPauseSwitched = false;
        if (this.isPausing()) {
            this.mSoundPlayer.stopAll();
            this.mBgmPlayer.pause();
        } else {
            this.mBgmPlayer.play();
        }
        this.mIsMouseLeftPressed = false;
        this.mIsMouseMiddlePressed = false;
        this.mIsMouseRightPressed = false;
        this.setRepaintAllBackground(true);
    }

    protected void pauseProc() {
    }

    public int getViewsX(int x) {
        return this.getViewsX(x, null);
    }

    public int getViewsX(int x, ViewCamera camera) {
        double vx = (double)((float)x - this.mViewMarginX) / this.mViewScale;
        if (camera == null) {
            return (int)vx;
        }
        return (int)(camera.getX() - (double)(this.getDrawWidth() / 2) + vx / this.mDrawScale);
    }

    public int getViewsY(int y) {
        return this.getViewsY(y, null);
    }

    public int getViewsY(int y, ViewCamera camera) {
        double vy = (double)((float)y - this.mViewMarginY) / this.mViewScale;
        if (camera == null) {
            return (int)vy;
        }
        return (int)(camera.getY() - (double)(this.getDrawHeight() / 2) + vy / this.mDrawScale);
    }

    public int getScreenX(double x) {
        if (this.mViewCamera == null) {
            return SKMUtil.toInt(x);
        }
        return (int)(this.mDrawScale * (x - this.mViewCamera.getX() + (double)(this.getDrawWidth() / 2)));
    }

    public int getScreenY(double y) {
        if (this.mViewCamera == null) {
            return SKMUtil.toInt(y);
        }
        return (int)(this.mDrawScale * (y - this.mViewCamera.getY() + (double)(this.getDrawHeight() / 2)));
    }

    protected void clearBackground(Graphics2D g, float marginX, float marginY, int viewW, int viewH) {
        this.mG.setGraphics(g);
        this.clearBackground(this.mG, (int)marginX, (int)marginY, viewW, viewH);
    }

    protected void clearBackground(SKMGraphics g, int marginX, int marginY, int viewW, int viewH) {
    }

    protected void myPaint(Graphics2D g) {
        this.mG.setGraphics(g);
        this.myPaint(this.mG);
        this.paintButtons(this.mG);
    }

    protected void myPaint(SKMGraphics g) {
    }

    protected void paintPause(SKMGraphics skmg) {
        if (this.mIsPauseSwitched) {
            return;
        }
        Graphics2D g = skmg.getGraphics();
        Dimension d = this.getSize();
        if (this.mIsPauseWhenLostFocus) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, d.width, d.height);
        }
        int fontSize = 32;
        int x = 20;
        int y = 38;
        g.setFont(new Font("Serif", 1, 32));
        String message = this.mIsPauseWhenLostFocus && !this.mIsFocused ? this.mFocusLostMessage : "Pause";
        g.setColor(Color.black);
        g.drawString(message, 22, 40);
        g.setColor(Color.white);
        g.drawString(message, 19, 37);
        g.setColor(new Color(255, 140, 0));
        g.drawString(message, 20, 38);
    }

    public void paintConnecting(SKMGraphics g, int count, SKMColor textColor, SKMColor backgroundColor) {
        int dw = this.getBaseDrawWidth();
        int dh = this.getBaseDrawHeight();
        if (backgroundColor != null) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, dw, dh);
        }
        if (textColor != null) {
            g.setColor(textColor);
        }
        g.setFont(new SKMFont(20));
        String connectingMessage = SKM.getI18NCommon().getString("connecting2");
        int halfLen = g.stringWidth(connectingMessage) / 2;
        g.drawCenteringString(connectingMessage, dw / 2, dh / 2);
        int cycle = 120;
        int c = count % 120;
        if (c < 30) {
            return;
        }
        String dots = c < 60 ? "." : (c < 90 ? ".." : "...");
        g.drawString(dots, dw / 2 + halfLen, dh / 2 + g.stringHeight() / 2 - g.getDescent());
    }

    protected void paintQuit(SKMGraphics skmg) {
        Graphics2D g = skmg.getGraphics();
        Dimension d = this.getSize();
        int R = 255;
        for (int i = 0; i <= d.width / 2 + 6; i += 3) {
            g.setColor(new Color(R, R, R));
            g.fillRect(0, d.height / 2 + i + 3, d.width, 3);
            g.fillRect(0, d.height / 2 - i, d.width, 3);
            if ((R -= 3) >= 0) continue;
            R = 0;
        }
        g.setFont(new Font("Serif", 1, 26));
        String message = "See you again!";
        FontMetrics fm = g.getFontMetrics();
        g.setColor(Color.red);
        g.drawString("See you again!", (d.width - fm.stringWidth("See you again!")) / 2, d.height / 2 + fm.getDescent());
    }

    protected void paintButtons(SKMGraphics g) {
        try {
            for (int i = this.mButtons.size() - 1; 0 <= i; --i) {
                SKMButton button = this.mButtons.get(i);
                if (button == null) continue;
                button.paint(this.mG);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showAlertDialog(String title, String message) {
        SKMAlertDialog dialog = new SKMAlertDialog("alert", title, message);
        dialog.setVisible(true);
    }

    protected void setSystemMessage(String message) {
        this.mSystemMessage = message;
        this.mSystemMessageCount = 1;
    }

    public void setRepaintAllBackground(boolean f) {
        this.mIsRepaintAllBackground = f;
    }

    public boolean isRepaintAllBackground() {
        return this.mIsRepaintAllBackground;
    }

    public void quit() {
        this.setSetting(SETTING_KEY_SOUND, this.getSoundPlayer().isEnabled());
        this.setSetting(SETTING_KEY_BGM, this.mBgmPlayer.isEnabled());
        this.setSetting(SETTING_KEY_WINDOW_X, this.mFrame.getX());
        this.setSetting(SETTING_KEY_WINDOW_Y, this.mFrame.getY());
        this.mState = 3;
        this.mIsRunning = false;
        this.mBgmPlayer.stopAll();
        this.mBgmPlayer.reset();
        this.mSoundPlayer.stopAll();
        this.myQuit();
        if (this.mSettings != null && this.mSettings.isAvailable()) {
            this.mSettings.save();
            this.mSettings = null;
        }
        if (this.mIsApplication) {
            if (this.mFrame != null) {
                this.mFrame.dispose();
            }
            System.exit(0);
        }
    }

    protected void myQuit() {
    }

    public boolean isApplication() {
        return this.mIsApplication;
    }

    public void setPauseWhenLostFocus(boolean f) {
        this.mIsPauseWhenLostFocus = f;
    }

    public String getWebSite() {
        return WEBSITE;
    }

    public String getServer() {
        return this.mServer;
    }

    public void setServer(String server) {
        this.mServer = server;
    }

    public JFrame getFrame() {
        return this.mFrame;
    }

    public boolean isInWebSite() {
        return false;
    }

    public boolean isZennkaku() {
        SKMI18N i18nCommon = SKM.getI18NCommon();
        if (i18nCommon == null) {
            return false;
        }
        String lang = i18nCommon.getString(SETTING_KEY_LANG);
        return lang.equals("ja") || lang.equals("zh") || lang.equals("zh_TW");
    }

    public boolean hasLangSpaces() {
        SKMI18N i18nCommon = SKM.getI18NCommon();
        if (i18nCommon == null) {
            return false;
        }
        String lang = i18nCommon.getString(SETTING_KEY_LANG);
        return !lang.equals("ja") && !lang.equals("zh") && !lang.equals("zh_TW");
    }

    public JSONObject loadJsonFromLocal(String filename) {
        try {
            if (new File(filename).exists()) {
                String s = Files.lines(Paths.get(filename, new String[0]), Charset.forName("UTF-8")).collect(Collectors.joining(System.getProperty("line.separator")));
                return new JSONObject(s);
            }
        }
        catch (Exception e) {
            this.logging(e);
        }
        return null;
    }

    public JSONArray loadJsonArrayFromLocal(String filename) {
        try {
            if (new File(filename).exists()) {
                String s = Files.lines(Paths.get(filename, new String[0]), Charset.forName("UTF-8")).collect(Collectors.joining(System.getProperty("line.separator")));
                return new JSONArray(s);
            }
        }
        catch (Exception e) {
            this.logging(e);
        }
        return null;
    }

    public JSONObject loadJsonFromResource(String filename) {
        try {
            String line = ResourceUtil.loadFileText(filename);
            if (line != null) {
                return new JSONObject(line);
            }
        }
        catch (Exception e) {
            this.logging(e);
        }
        return null;
    }

    public JSONArray loadJsonArrayFromResource(String filename) {
        try {
            String line = ResourceUtil.loadFileText(filename);
            if (line != null) {
                return new JSONArray(line);
            }
        }
        catch (Exception e) {
            this.logging(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveJsonToLocal(String filename, JSONObject obj) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "utf-8"));
            obj.write((Writer)writer);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logging(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveJsonToLocal(String filename, JSONArray obj) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "utf-8"));
            obj.write((Writer)writer);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logging(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public BgmPlayer getBgmPlayer() {
        return this.mBgmPlayer;
    }

    public SoundPlayer getSoundPlayer() {
        return this.mSoundPlayer;
    }

    public boolean loadSoundsFromList(String listFilename, String baseDirname) {
        return this.mSoundPlayer.loadFromList(listFilename, baseDirname);
    }

    public boolean loadSoundsFromList(String listFilename) {
        return this.mSoundPlayer.loadFromList(listFilename);
    }

    public void soundPreload() {
        this.mSoundPlayer.preload();
    }

    public void playSound(String name) {
        if (this.mIsPlaySound && !this.mPlaySounds.contains(name)) {
            this.mPlaySounds.add(name);
        }
    }

    public void playSingleSound(String name) {
        if (this.mIsPlaySound && !this.mPlaySingleSounds.contains(name)) {
            this.mPlaySingleSounds.add(name);
        }
    }

    public void playSoundImmediately(String name) {
        if (this.mIsPlaySound) {
            this.mSoundPlayer.play(name);
        }
    }

    public void playSound(String name, boolean isLoop) {
        if (this.mIsPlaySound) {
            if (isLoop) {
                if (!this.mPlayLoopSounds.contains(name)) {
                    this.mPlayLoopSounds.add(name);
                }
            } else {
                this.playSound(name);
            }
        }
    }

    public void playSingleSound(String name, boolean isLoop) {
        if (this.mIsPlaySound) {
            if (isLoop) {
                if (!this.mPlaySingleLoopSounds.contains(name)) {
                    this.mPlaySingleLoopSounds.add(name);
                }
            } else {
                this.playSingleSound(name);
            }
        }
    }

    public void stopSound(String name) {
        if (!this.mStopSounds.contains(name)) {
            this.mStopSounds.add(name);
        }
    }

    public void playNoContSound(String name, int dCount) {
        if (this.mIsPlaySound) {
            int count;
            if (this.mPlayNoContSounds.containsKey(name) && this.mCount - dCount <= (count = this.mPlayNoContSounds.get(name).intValue()) && count <= this.mCount) {
                return;
            }
            this.mPlayNoContSounds.put(name, this.mCount);
            this.playSound(name);
        }
    }

    public void stopAllSounds() {
        this.mPlaySounds.clear();
        this.mPlaySingleSounds.clear();
        this.mPlayLoopSounds.clear();
        this.mPlaySingleLoopSounds.clear();
        this.mStopSounds.clear();
        this.mSoundPlayer.stopAll();
    }

    private final void soundProc() {
        int i;
        for (i = this.mPlaySounds.size() - 1; 0 <= i; --i) {
            this.mSoundPlayer.play(this.mPlaySounds.get(i));
        }
        this.mPlaySounds.clear();
        for (i = this.mPlaySingleSounds.size() - 1; 0 <= i; --i) {
            this.mSoundPlayer.play(this.mPlaySingleSounds.get(i));
        }
        this.mPlaySingleSounds.clear();
        for (i = this.mPlayLoopSounds.size() - 1; 0 <= i; --i) {
            this.mSoundPlayer.play(this.mPlayLoopSounds.get(i), true);
        }
        this.mPlayLoopSounds.clear();
        for (i = this.mPlaySingleLoopSounds.size() - 1; 0 <= i; --i) {
            this.mSoundPlayer.play(this.mPlaySingleLoopSounds.get(i), true);
        }
        this.mPlaySingleLoopSounds.clear();
        for (i = this.mStopSounds.size() - 1; 0 <= i; --i) {
            this.mSoundPlayer.stop(this.mStopSounds.get(i));
        }
        this.mStopSounds.clear();
    }

    public final void setScreenShake(boolean f, int type, int num, int amp) {
        if (!f) {
            this.mScreenOffsetY = 0;
            this.mScreenOffsetX = 0;
            this.mShakeNum = 0;
            this.mShakeAmp = 0;
        } else {
            this.mShakeNum = num;
            this.mShakeAmp = amp;
        }
        this.mIsShake = f;
        this.mShakeType = type;
    }

    public final void setScreenShake(boolean f, int type, int num) {
        this.setScreenShake(f, type, num, 15);
    }

    public final void setScreenShake(boolean f, int type) {
        this.setScreenShake(f, type, -1, 15);
    }

    public final void setScreenShake(boolean f) {
        this.setScreenShake(f, 0, -1, 15);
    }

    public boolean isScreenShaking() {
        return this.mIsShake;
    }

    public final void setKey(int num, int key) {
        this.mKeys[num] = key;
    }

    public final void setPauseKey(int key) {
        this.mPauseKey = key;
    }

    public final void setResetKey(int key) {
        this.mResetKey = key;
    }

    public final void setViewScalingKey(int key) {
        this.mViewScalingKey = key;
    }

    public final int getKey(int num) {
        return this.mKeys[num];
    }

    public boolean isDecideKey(int c) {
        return c == this.mKeys[4] || c == 10 || c == 32;
    }

    public boolean isCancelKey(int c) {
        return c == this.mKeys[5];
    }

    public boolean isUpKey(int c) {
        return c == 38 || c == this.mKeys[0];
    }

    public boolean isDownKey(int c) {
        return c == 40 || c == this.mKeys[1];
    }

    public boolean isLeftKey(int c) {
        return c == 37 || c == this.mKeys[2];
    }

    public boolean isRightKey(int c) {
        return c == 39 || c == this.mKeys[3];
    }

    public boolean getBooleanSetting(String key, boolean defaultValue) {
        if (this.mSettings == null || !this.mSettings.isAvailable()) {
            return defaultValue;
        }
        return this.mSettings.getBoolean(key, defaultValue);
    }

    public int getIntSetting(String key, int defaultValue) {
        if (this.mSettings == null || !this.mSettings.isAvailable()) {
            return defaultValue;
        }
        return this.mSettings.getInt(key, defaultValue);
    }

    public long getLongSetting(String key, long defaultValue) {
        if (this.mSettings == null || !this.mSettings.isAvailable()) {
            return defaultValue;
        }
        return this.mSettings.getLong(key, defaultValue);
    }

    public double getDoubleSetting(String key, double defaultValue) {
        if (this.mSettings == null || !this.mSettings.isAvailable()) {
            return defaultValue;
        }
        return this.mSettings.getDouble(key, defaultValue);
    }

    public String getStringSetting(String key, String defaultValue) {
        if (this.mSettings == null || !this.mSettings.isAvailable()) {
            return defaultValue;
        }
        return this.mSettings.get(key, defaultValue);
    }

    public void setSetting(String key, boolean value) {
        if (this.mSettings == null || !this.mSettings.isAvailable()) {
            return;
        }
        this.mSettings.set(key, value);
    }

    public void setSetting(String key, int value) {
        if (this.mSettings == null || !this.mSettings.isAvailable()) {
            return;
        }
        this.mSettings.set(key, value);
    }

    public void setSetting(String key, long value) {
        if (this.mSettings == null || !this.mSettings.isAvailable()) {
            return;
        }
        this.mSettings.set(key, value);
    }

    public void setSetting(String key, double value) {
        if (this.mSettings == null || !this.mSettings.isAvailable()) {
            return;
        }
        this.mSettings.set(key, value);
    }

    public void setSetting(String key, String value) {
        if (this.mSettings == null || !this.mSettings.isAvailable()) {
            return;
        }
        this.mSettings.set(key, value);
    }

    public void removeSetting(String key) {
        if (this.mSettings == null || !this.mSettings.isAvailable()) {
            return;
        }
        this.mSettings.remove(key);
    }

    public void saveSettings() {
        if (this.mSettings == null || !this.mSettings.isAvailable()) {
            return;
        }
        this.mSettings.save();
    }

    public SKMSettings getSettings() {
        return this.mSettings;
    }

    public void start() {
        if (this.mThread == null) {
            this.mIsRunning = true;
            this.mThread = new Thread(this);
            this.mThread.start();
        }
    }

    public void stop() {
        this.quit();
        this.mThread = null;
        if (this.mIsApplication) {
            System.exit(0);
        }
    }

    protected final void sleep(double time) {
        try {
            Thread.sleep((int)time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void startApplication(String appName, final SKMView view, int viewWidth, int viewHeight) {
        JFrame frame = new JFrame(appName);
        frame.setResizable(false);
        view.setPreferredSize(new Dimension(viewWidth, viewHeight));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                view.quit();
                System.exit(0);
            }
        });
        view.mIsApplication = true;
        view.mFrame = frame;
        frame.getContentPane().setLayout(new BorderLayout(0, 0));
        frame.getContentPane().add(view);
        frame.pack();
        view.init();
        int windowX = view.getIntSetting(SETTING_KEY_WINDOW_X, -10000);
        int windowY = view.getIntSetting(SETTING_KEY_WINDOW_Y, -10000);
        if (windowX == -10000 && windowY == -10000) {
            SKMWindowFuncs.centering(frame);
        } else {
            frame.setLocation(windowX, windowY);
        }
        frame.setVisible(true);
        view.start();
        frame.setBackground(Color.BLACK);
    }

    class MainPanel
    extends JPanel {
        final /* synthetic */ SKMView this$0;

        MainPanel(SKMView this$0) {
            SKMView sKMView = this$0;
            Objects.requireNonNull(sKMView);
            this.this$0 = sKMView;
        }

        @Override
        public void paintComponent(Graphics g) {
            try {
                if (!this.this$0.mDoPaint) {
                    return;
                }
                this.this$0.mG.setGraphics((Graphics2D)g);
                if (!this.this$0.mIsRunning) {
                    this.this$0.paintQuit(this.this$0.mG);
                    return;
                }
                Graphics2D offG = (Graphics2D)this.this$0.mOffI.getGraphics();
                this.this$0.mG.setGraphics(offG);
                this.this$0.clearBackground(offG, 0.0f, 0.0f, this.this$0.mViewWidth, this.this$0.mViewHeight);
                this.this$0.myPaint(offG);
                if (this.this$0.mIsPausing) {
                    this.this$0.paintPause(this.this$0.mG);
                }
                if (0 < this.this$0.mSystemMessageCount) {
                    offG.setFont(new Font("Serif", 1, 16));
                    this.this$0.mG.drawRoundedString(this.this$0.mSystemMessage, 5, 24, SKMColor.YELLOW, SKMColor.BLACK);
                    if (120 < ++this.this$0.mSystemMessageCount) {
                        this.this$0.mSystemMessageCount = 0;
                    }
                }
                if (this.this$0.mIsShowFocusLost && !this.this$0.mIsFocused && !this.this$0.mIsPauseWhenLostFocus) {
                    offG.setFont(new Font("Serif", 1, 16));
                    FontMetrics fm = offG.getFontMetrics();
                    int offset = 2;
                    int width = fm.stringWidth(this.this$0.mFocusLostMessage) + 4;
                    int height = fm.getHeight() + 4;
                    offG.setColor(new Color(0, 0, 0, 180));
                    offG.fillRect(0, 0, width, height);
                    offG.setColor(Color.YELLOW);
                    this.this$0.mG.drawCenteringString(this.this$0.mFocusLostMessage, width / 2, height / 2);
                    offG.drawLine(0, height - 2 - 1, width - 1, height - 2 - 1);
                }
                offG.dispose();
                if (this.this$0.mViewScale == 1.0) {
                    g.drawImage(this.this$0.mOffI, this.this$0.mScreenOffsetX, this.this$0.mScreenOffsetY, this);
                } else {
                    int offsetX = (int)((double)this.this$0.mScreenOffsetX * this.this$0.mViewScale);
                    int offsetY = (int)((double)this.this$0.mScreenOffsetY * this.this$0.mViewScale);
                    int w = (int)((double)this.this$0.mViewWidth * this.this$0.mViewScale);
                    int h = (int)((double)this.this$0.mViewHeight * this.this$0.mViewScale);
                    g.drawImage(this.this$0.mOffI, offsetX, offsetY, w, h, this);
                }
            }
            catch (Exception e) {
                this.this$0.logging(e);
            }
        }
    }
}

