/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMImageLoader;
import jp.ne.sk_mine.util.andr_applet.SKMMath;
import jp.ne.sk_mine.util.andr_applet.SKMMineUtil;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.Block;
import jp.ne.sk_mine.util.andr_applet.game.ShotCharacter;

public class CChipCharacter
extends ShotCharacter {
    protected boolean mIsDiagonalEnabled;
    protected int mAnimKizami;
    protected int mDir;
    protected int mImageWidth;
    protected int mImageHeight;

    public CChipCharacter(double x, double y, int type, int w, int h, int animKizami, String imageName) {
        super(x, y, type);
        this.mImageWidth = w;
        this.mImageHeight = h;
        this.mAnimKizami = animKizami;
        this.mDir = 4;
        if (imageName != null) {
            this.setImage(imageName);
        }
        this.mIsNotDieOut = true;
        this.setMaxAndSize(w, h);
    }

    public void setImage(String imageName) {
        this.mImages = SKMImageLoader.getInstance().loadImages(imageName, 0, 0, this.mImageWidth, this.mImageHeight);
        this.mIsDiagonalEnabled = this.mImages.length == 8;
    }

    public void setDiagonalEnabled(boolean f) {
        this.mIsDiagonalEnabled = f;
    }

    protected void setMaxAndSize(int w, int h) {
        this.mSizeW = 3 * w / 4;
        this.mSizeH = 3 * h / 4;
        this.mMaxW = this.mSizeW / 2;
        this.mMaxH = this.mSizeH / 2;
    }

    public void setDir(int dir) {
        this.mDir = dir;
    }

    public int getDir() {
        return this.mDir;
    }

    @Override
    public void move(SKMArray<Block> blocks) {
        super.move(blocks);
        this.updateDir();
    }

    public void updateDir() {
        this.updateDir(this.mRealX - this.mTmpX, this.mRealY - this.mTmpY);
    }

    public void updateDir(double dx, double dy) {
        if (dx != 0.0 || dy != 0.0) {
            if (this.mIsDiagonalEnabled) {
                double rad = this.getRad(0.0, 0.0, dx, dy);
                double dRad = 0.39269908169872414;
                this.mDir = -1.9634954084936207 <= rad && rad <= -1.1780972450961724 ? 1 : (-2.748893571891069 < rad && rad < -1.9634954084936207 ? 9 : (-1.1780972450961724 < rad && rad < -0.39269908169872414 ? 3 : (-0.39269908169872414 <= rad && rad <= 0.39269908169872414 ? 2 : (0.39269908169872414 < rad && rad < 1.1780972450961724 ? 6 : (1.1780972450961724 <= rad && rad <= 1.9634954084936207 ? 4 : (1.9634954084936207 < rad && rad < 2.748893571891069 ? 12 : 8))))));
            } else {
                this.mDir = SKMMath.abs(dx) < SKMMath.abs(dy) ? (dy < 0.0 ? 1 : 4) : (dx < 0.0 ? 8 : 2);
            }
        }
    }

    public void setAlpha(int alpha) {
        if (this.mImages != null) {
            for (int i = this.mImages.length - 1; 0 <= i; --i) {
                for (int j = this.mImages[i].length - 1; 0 <= j; --j) {
                    this.mImages[i][j].setAlpha(alpha);
                }
            }
        }
    }

    public int getImageDirIndex(int dir) {
        int dirIndex = 0;
        if (SKMMineUtil.isLeftOn(dir)) {
            dirIndex = 3;
        } else if (SKMMineUtil.isRightOn(dir)) {
            dirIndex = 1;
        } else if (SKMMineUtil.isUpOn(dir)) {
            dirIndex = 0;
        } else if (SKMMineUtil.isDownOn(dir)) {
            dirIndex = 2;
        }
        if (this.mIsDiagonalEnabled && this.mImages != null && 8 <= this.mImages.length) {
            if (dir == 3) {
                dirIndex = 4;
            } else if (dir == 6) {
                dirIndex = 5;
            } else if (dir == 12) {
                dirIndex = 6;
            } else if (dir == 9) {
                dirIndex = 7;
            }
        }
        return dirIndex;
    }

    public int getImageIndex() {
        return this.getImageIndex(this.mCount, this.mAnimKizami);
    }

    public int getImageIndex(int count, int animKizami) {
        int xi = SKMUtil.toInt(count / animKizami) % 4;
        if (this.mImages == null) {
            return xi;
        }
        if (this.mSpeedX == 0.0 && this.mSpeedY == 0.0) {
            xi = 1;
        } else if (this.mImages[0].length == 2) {
            xi %= 2;
        } else if (this.mImages[0].length == 3 && xi == 3) {
            xi = 1;
        }
        return xi;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        if (this.mImages == null) {
            return;
        }
        SKMImage image = this.mImages[this.getImageDirIndex(this.mDir)][this.getImageIndex()];
        g.drawCenteringImage(image, this.mDrawX, this.mDrawY - (image.getHeight() - this.mSizeH) / 2);
    }
}

