/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMImageFilter;
import jp.ne.sk_mine.util.andr_applet.SKMImageFuncs;
import jp.ne.sk_mine.util.andr_applet.SKMMath;
import jp.ne.sk_mine.util.andr_applet.SKMRandomTool;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.SKMYellowFilter;
import jp.ne.sk_mine.util.andr_applet.game.Block;
import jp.ne.sk_mine.util.andr_applet.game.GameView;
import jp.ne.sk_mine.util.andr_applet.game.ViewCamera;

public class GameCharacter {
    public static final int MASK_TYPE_MINE = 4096;
    public static final int MASK_TYPE_ITEM = 8192;
    public static final int MASK_TYPE_BLOCK = 16384;
    public static final int MASK_TYPE_BULLET = 32768;
    public static final int GUARD_NUM = 1;
    protected int mEnergy;
    protected int mMaxEnergy;
    protected int mX;
    protected int mY;
    protected double mRealX;
    protected double mRealY;
    protected double mTmpX;
    protected double mTmpY;
    protected int mSizeW;
    protected int mSizeH;
    protected int mMaxW;
    protected int mMaxH;
    protected int mType;
    protected double mSpeed;
    protected double mSpeedX;
    protected double mSpeedY;
    protected double mAddSpeedX;
    protected double mAddSpeedY;
    protected double mBrake;
    protected double mBrakeRate;
    protected double mAddSpeedRad;
    protected double mAddSpeedSpeed;
    protected int mCount;
    protected double mDoubleCount;
    protected double mDDoubleCount;
    protected boolean mIsUseDoubleCount;
    protected int mDeadCount;
    protected int mDamageCount;
    protected int mMaxDamageCount;
    protected int mDamage;
    protected int mScore;
    protected boolean mIsContDamage;
    protected int mContDamagePitch;
    protected boolean mIsAvoidDamageCount;
    protected double mPowerRate;
    protected double[] mGuardRate;
    protected boolean mIsDeading;
    protected int mBurstType;
    protected boolean mIsNoDamage;
    protected boolean mIsThroughAttack;
    protected boolean mIsThroughDamage;
    protected boolean mIsThroughHoming;
    protected boolean mIsThroughBlock;
    protected boolean mIsNoRemain;
    protected boolean mIsNotDieOut;
    protected boolean mIsNotGoOut;
    protected boolean mIsOutStop;
    protected boolean mIsOutReflect;
    protected boolean mIsReflectOutWall;
    protected boolean mIsNotBlockDie;
    protected boolean mIsHitSizeBase;
    protected SKMImage[][] mImages;
    protected SKMImage[] mDamageImages;
    protected int mDamageR;
    protected int mDamageIdx;
    protected int mDamageDx;
    protected int mDamageDy;
    protected int[][] mBurstPoints;
    protected String mBurstSound = "burst";
    protected String mDamageSound = "hit";
    protected int mDrawX;
    protected int mDrawY;
    protected boolean mIsBurstDrawStarted;
    protected boolean mIsPaintEnergyMeter;
    protected boolean mIsDamageAndAddedSpeed;
    protected boolean mIsPaintEvenIfOut;
    protected boolean mIsVisible;
    protected int mPhase;
    protected int mSubPhase;

    public GameCharacter(double x, double y, int type) {
        this.mType = type;
        this.mRealX = this.mTmpX = x;
        this.mRealY = this.mTmpY = y;
        this.mDrawX = this.mX = SKMUtil.toInt(x);
        this.mDrawY = this.mY = SKMUtil.toInt(y);
        this.mIsVisible = true;
        this.mMaxEnergy = 1;
        this.mEnergy = 1;
        this.mDamage = 1;
        this.mSpeed = 1.0;
        this.mBrake = 0.5;
        this.mBrakeRate = 1.0;
        this.mDDoubleCount = 1.0;
        this.mContDamagePitch = 10;
        this.mMaxDamageCount = 20;
        this.mDeadCount = 100;
        this.mPowerRate = 1.0;
        this.mGuardRate = new double[1];
        for (int i = 0; 0 <= i; --i) {
            this.mGuardRate[i] = 1.0;
        }
    }

    public void reset() {
        this.mIsBurstDrawStarted = false;
    }

    public void move(SKMArray<Block> blocks) {
        int maxX;
        int minX;
        this.mIsDamageAndAddedSpeed = false;
        GameView manager = SKM.getManager();
        if (this.mEnergy <= 0) {
            if (this.mIsDeading) {
                this.deadMove();
                if (this.mDoubleCount == 0.0) {
                    manager.playSound(this.mBurstSound);
                }
                this.mDoubleCount += this.mDDoubleCount;
                this.mCount = this.mIsUseDoubleCount ? SKMUtil.toInt(this.mDoubleCount) : ++this.mCount;
            } else {
                this.mCount = 0;
                this.mDoubleCount = 0.0;
                this.mRealX += this.mSpeedX;
                this.mRealY += this.mSpeedY;
                this.mX = (int)this.mRealX;
                this.mY = (int)this.mRealY;
                this.deadAction();
                this.mIsDeading = true;
            }
            return;
        }
        this.mTmpX = this.mRealX;
        this.mTmpY = this.mRealY;
        this.myMove();
        ViewCamera viewCamera = manager.getViewCamera();
        int dw = manager.getDrawWidth();
        int dh = manager.getDrawHeight();
        if (0.0 < this.mAddSpeedSpeed) {
            this.mAddSpeedSpeed -= this.mBrake * this.mBrakeRate;
            if (this.mAddSpeedSpeed <= 0.0) {
                this.mAddSpeedSpeed = 0.0;
                this.setAddSpeedX(0.0);
                this.setAddSpeedY(0.0);
            }
        }
        if (this.mAddSpeedX != 0.0) {
            if (0.0 < this.mAddSpeedSpeed) {
                this.setAddSpeedX(this.mAddSpeedSpeed * SKMMath.cos(this.mAddSpeedRad));
            } else if (0.0 < this.mAddSpeedX) {
                this.setAddSpeedX(this.mAddSpeedX - this.mBrake * this.mBrakeRate);
                if (this.mAddSpeedX < 0.0) {
                    this.setAddSpeedX(0.0);
                }
            } else {
                this.setAddSpeedX(this.mAddSpeedX + this.mBrake * this.mBrakeRate);
                if (0.0 < this.mAddSpeedX) {
                    this.setAddSpeedX(0.0);
                }
            }
            if (this.mIsNotGoOut) {
                if (viewCamera == null) {
                    minX = Block.getMinSize();
                    maxX = dw - Block.getMinSize();
                } else {
                    int cx = (int)viewCamera.getX();
                    minX = cx - dw / 2 + Block.getMinSize();
                    maxX = cx + dw / 2 - Block.getMinSize();
                }
                if ((double)this.mX + this.mAddSpeedX < (double)minX || (double)maxX < (double)this.mX + this.mAddSpeedX) {
                    this.setAddSpeedX(0.0);
                }
            }
        }
        if (this.mAddSpeedY != 0.0) {
            if (0.0 < this.mAddSpeedSpeed) {
                this.setAddSpeedY(this.mAddSpeedSpeed * SKMMath.sin(this.mAddSpeedRad));
            } else if (0.0 < this.mAddSpeedY) {
                this.setAddSpeedY(this.mAddSpeedY - this.mBrake * this.mBrakeRate);
                if (this.mAddSpeedY < 0.0) {
                    this.setAddSpeedY(0.0);
                }
            } else if (this.mAddSpeedY < 0.0) {
                this.setAddSpeedY(this.mAddSpeedY + this.mBrake * this.mBrakeRate);
                if (0.0 < this.mAddSpeedY) {
                    this.setAddSpeedY(0.0);
                }
            }
            if (this.mIsNotGoOut) {
                int maxY;
                int minY;
                if (viewCamera == null) {
                    minY = Block.getMinSize();
                    maxY = dh - Block.getMinSize();
                } else {
                    int cy = (int)viewCamera.getY();
                    minY = cy - dh / 2 + Block.getMinSize();
                    maxY = cy + dh / 2 - Block.getMinSize();
                }
                if ((double)this.mY + this.mAddSpeedY < (double)minY || (double)maxY < (double)this.mY + this.mAddSpeedY) {
                    this.setAddSpeedY(0.0);
                }
            }
        }
        this.isAttackBlocks(blocks);
        this.mRealX += this.mSpeedX + this.mAddSpeedX;
        this.mRealY += this.mSpeedY + this.mAddSpeedY;
        if (this.mIsNotGoOut) {
            int maxY;
            int minY;
            int hw = this.mSizeW >> 1;
            int hh = this.mSizeH >> 1;
            if (viewCamera == null) {
                minX = hw;
                maxX = dw - hw;
                minY = hh;
                maxY = dh - hh;
            } else {
                int cx = (int)viewCamera.getX();
                int cy = (int)viewCamera.getY();
                minX = cx - dw / 2 + hw;
                maxX = cx + dw / 2 - hw;
                minY = cy - dh / 2 + hh;
                maxY = cy + dh / 2 - hh;
            }
            if (this.mRealX < (double)minX) {
                this.mRealX = minX;
                this.setAddSpeedX(0.0);
                if (this.mIsOutStop) {
                    this.setSpeedX(0.0);
                } else if (this.mIsOutReflect) {
                    this.setSpeedX(this.mSpeedX * -1.0);
                }
            } else if ((double)maxX < this.mRealX) {
                this.mRealX = maxX;
                this.setAddSpeedX(0.0);
                if (this.mIsOutStop) {
                    this.setSpeedX(0.0);
                } else if (this.mIsOutReflect) {
                    this.setSpeedX(this.mSpeedX * -1.0);
                }
            }
            if (this.mRealY < (double)minY) {
                this.mRealY = minY;
                this.setAddSpeedY(0.0);
                if (this.mIsOutStop) {
                    this.setSpeedY(0.0);
                } else if (this.mIsOutReflect) {
                    this.setSpeedY(this.mSpeedY * -1.0);
                }
            } else if ((double)maxY < this.mRealY) {
                this.mRealY = maxY;
                this.setAddSpeedY(0.0);
                if (this.mIsOutStop) {
                    this.setSpeedY(0.0);
                } else if (this.mIsOutReflect) {
                    this.setSpeedY(this.mSpeedY * -1.0);
                }
            }
        }
        if (this.mIsReflectOutWall) {
            int maxY;
            int minY;
            int maxX2;
            int minX2;
            int sizeW = 11 * this.mSizeW / 20;
            int sizeH = 11 * this.mSizeH / 20;
            int blockMinSize = Block.getMinSize();
            if (viewCamera == null) {
                minX2 = sizeW + blockMinSize;
                maxX2 = dw - sizeW - blockMinSize;
                minY = sizeH + blockMinSize;
                maxY = dh - sizeH - blockMinSize;
            } else {
                int cx = (int)viewCamera.getX();
                int cy = (int)viewCamera.getY();
                minX2 = cx - dw / 2 + sizeW + blockMinSize;
                maxX2 = cx + dw / 2 - sizeW - blockMinSize;
                minY = cy - dh / 2 + sizeH - blockMinSize;
                maxY = cy + dh / 2 - sizeH - blockMinSize;
            }
            if (this.mX < minX2) {
                this.mRealX = minX2;
                this.setSpeedX(this.mSpeedX * -1.0);
            } else if (maxX2 < this.mX) {
                this.mRealX = maxX2;
                this.setSpeedX(this.mSpeedX * -1.0);
            }
            if (this.mY < minY) {
                this.mRealY = minY;
                this.setSpeedY(this.mSpeedY * -1.0);
            } else if (maxY < this.mY) {
                this.mRealY = maxY;
                this.setSpeedY(this.mSpeedY * -1.0);
            }
        }
        this.mX = SKMUtil.toInt(SKMMath.round(this.mRealX));
        this.mY = SKMUtil.toInt(SKMMath.round(this.mRealY));
        if (!this.mIsNotDieOut && this.isOut()) {
            this.kill();
            return;
        }
        if (0 < this.mEnergy) {
            this.mDoubleCount += this.mDDoubleCount;
            this.mCount = this.mIsUseDoubleCount ? SKMUtil.toInt(this.mDoubleCount) : ++this.mCount;
            if (this.mCount < 0) {
                this.mCount = 0;
                this.mDoubleCount = 0.0;
            }
        }
        this.damageCount();
    }

    public void moveSimple() {
        this.mTmpX = this.mRealX;
        this.mTmpY = this.mRealY;
        this.mRealX += this.mSpeedX + this.mAddSpeedX;
        this.mRealY += this.mSpeedY + this.mAddSpeedY;
        this.mX = (int)this.mRealX;
        this.mY = (int)this.mRealY;
    }

    public void setPhase(int phase) {
        this.mySetPhase(phase);
        this.mPhase = phase;
        this.mSubPhase = 0;
        this.mCount = 0;
        this.mDoubleCount = 0.0;
    }

    protected void mySetPhase(int phase) {
    }

    public void setSubPhase(int subPhase) {
        this.mySetSubPhase(subPhase);
        this.mSubPhase = subPhase;
        this.mCount = 0;
        this.mDoubleCount = 0.0;
    }

    protected void mySetSubPhase(int subPhase) {
    }

    protected void deadAction() {
    }

    protected void deadMove() {
    }

    protected void myMove() {
    }

    protected void damageCount() {
        if (0 < this.mDamageCount) {
            this.updateDamagePaint();
            if (this.mMaxDamageCount <= ++this.mDamageCount) {
                this.mDamageCount = 0;
            }
        }
    }

    protected void updateDamagePaint() {
        if (this.mDamageImages != null && (this.mDamageCount - 1) % 3 == 0) {
            SKMRandomTool random = SKM.getRandom();
            this.mDamageIdx = random.nextInt(this.mDamageImages.length);
            this.mDamageDx = random.nextSignInt(this.mDamageR / 2);
            this.mDamageDy = random.nextSignInt(this.mDamageR / 2);
        }
        if (this.mEnergy == 0) {
            ++this.mDamageCount;
            this.mDamageCount %= 3;
        }
    }

    public void setDamageCount(int count) {
        this.mDamageCount = 0;
    }

    public boolean isBoss() {
        return false;
    }

    public boolean isPaintEnergyMeter() {
        return this.mIsPaintEnergyMeter;
    }

    public int isAttackBlocks(SKMArray<Block> blocks) {
        if (this.mIsThroughBlock || blocks == null) {
            return -1;
        }
        double xx = this.mRealX + this.mSpeedX + this.mAddSpeedX;
        double yy = this.mRealY + this.mSpeedY + this.mAddSpeedY;
        double tmpX = this.mRealX;
        double tmpY = this.mRealY;
        double tmpSpeedX = this.mSpeedX;
        double tmpSpeedY = this.mSpeedY;
        double hw = SKMUtil.toInt(this.mSizeW / 2);
        double hh = SKMUtil.toInt(this.mSizeH / 2);
        double e = 1.0E-5;
        int n = -1;
        for (int i = blocks.size() - 1; 0 <= i; --i) {
            Block block = blocks.get(i);
            if (!this.mIsNotBlockDie && (block == null || block.isDead())) continue;
            double bx = block.mRealX;
            double by = block.mRealY;
            double hbw = SKMUtil.toInt(block.mSizeW / 2);
            double hbh = SKMUtil.toInt(block.mSizeH / 2);
            double rw = hw + hbw;
            double rh = hh + hbh;
            if (!(SKMMath.abs(xx - bx) < rw) || !(SKMMath.abs(yy - by) < rh)) continue;
            this.hitBlock(block);
            block.hit(this);
            n = i;
            int hitX = 0;
            int hitY = 0;
            if (SKMMath.abs(this.mRealX - bx) < rw) {
                hitY = by < this.mRealY ? 1 : -1;
            } else if (SKMMath.abs(this.mRealY - by) < rh) {
                hitX = bx < this.mRealX ? 1 : -1;
            } else {
                double xt = (SKMMath.abs(this.mRealX - bx) - rw) / SKMMath.abs(this.mSpeedX + this.mAddSpeedX);
                double ty = this.mRealY + xt * (this.mSpeedY + this.mAddSpeedY);
                double tdy = SKMMath.abs(ty - by);
                if (this.mSpeedY == 0.0 && this.mAddSpeedY == 0.0) {
                    hitY = by < this.mRealY ? 1 : -1;
                } else if (SKMMath.abs(tdy - rh) < 1.0E-5) {
                    hitY = by < this.mRealY ? 1 : -1;
                    hitX = bx < this.mRealX ? 1 : -1;
                } else if (tdy < rh) {
                    hitY = by < this.mRealY ? 1 : -1;
                } else {
                    hitX = bx < this.mRealX ? 1 : -1;
                }
            }
            if (hitX == 1) {
                this.setX(bx + hbw + hw);
            } else if (hitX == -1) {
                this.setX(bx - hbw - hw);
            }
            if (hitX != 0) {
                this.setSpeedX(0.0);
                this.setAddSpeedX(0.0);
            }
            if (hitY == 1) {
                this.setY(by + hbh + hh);
            } else if (hitY == -1) {
                this.setY(by - hbh - hh);
            }
            if (hitY == 0) continue;
            this.setSpeedY(0.0);
            this.setAddSpeedY(0.0);
        }
        if (n != -1) {
            this.adjustAttackBlock(blocks.get(n), tmpX, tmpY, tmpSpeedX, tmpSpeedY);
            if (this.isNotAttackBlock(blocks.get(n), tmpX, tmpY, tmpSpeedX, tmpSpeedY)) {
                this.setXY(tmpX, tmpY);
                this.mSpeedX = tmpSpeedX;
                this.mSpeedY = tmpSpeedY;
                n = -1;
            }
        }
        return n;
    }

    protected void adjustAttackBlock(Block block, double tmpX, double tmpY, double tmpSpeedX, double tmpSpeedY) {
        if (SKMMath.abs(tmpSpeedX) <= 100.0 && SKMMath.abs(tmpSpeedY) <= 100.0) {
            if (100.0 < SKMMath.abs(tmpX - this.mRealX)) {
                this.setX(tmpX);
            }
            if (100.0 < SKMMath.abs(tmpY - this.mRealY)) {
                this.setY(tmpY);
            }
        }
    }

    public void hitBlock(Block block) {
    }

    public boolean isNotAttackBlock(Block block, double tmpX, double tmpY, double tmpSpeedX, double tmpSpeedY) {
        return false;
    }

    public boolean isMine() {
        return (this.mType & 0x1000) != 0;
    }

    public boolean isItem() {
        return (this.mType & 0x2000) != 0;
    }

    public boolean isBlock() {
        return (this.mType & 0x4000) != 0;
    }

    public boolean isBullet() {
        return (this.mType & 0x8000) != 0;
    }

    public int getMineType() {
        return this.mType & 0xFFFFEFFF;
    }

    public int getItemType() {
        return this.mType & 0xFFFFDFFF;
    }

    public int getBlockType() {
        return this.mType & 0xFFFFBFFF;
    }

    public int getBulletType() {
        return this.mType & 0xFFFF7FFF;
    }

    public void attackEach(GameCharacter gc) {
        if (this.isItem() && !gc.isMine()) {
            return;
        }
        boolean isDamaged = false;
        boolean isDamageToEnemy = false;
        if (0 < gc.mDamage && !this.mIsThroughDamage) {
            if (this.mIsNoDamage) {
                this.noDamaged(gc.mDamage, gc);
                this.playNoDamageSound(gc);
            } else if (!this.isDamaging() || gc.mIsAvoidDamageCount || gc.mIsContDamage && this.mDamageCount % gc.mContDamagePitch == 0) {
                this.damaged(gc.mDamage, gc);
                this.playDamageSound(gc);
                isDamaged = true;
            }
        } else if (gc.mDamage == 0) {
            gc.noDamageHit(this);
        }
        if (0 < this.mDamage && !gc.mIsThroughDamage) {
            if (!gc.mIsNoDamage && (!gc.isDamaging() || this.mIsAvoidDamageCount || this.mIsContDamage && gc.mDamageCount % this.mContDamagePitch == 0)) {
                gc.damaged(this.mDamage, this);
                this.playEnemyDamageSound(gc);
                isDamageToEnemy = true;
            }
        } else if (this.mDamage == 0) {
            this.noDamageHit(gc);
        }
        if (isDamaged) {
            gc.damageEnemy(this);
        }
        if (isDamageToEnemy) {
            this.damageEnemy(gc);
        }
    }

    protected void playDamageSound(GameCharacter opponent) {
        if (!this.isItem() && !this.isBlock()) {
            SKM.getManager().playSound(this.mDamageSound);
        }
    }

    protected void playNoDamageSound(GameCharacter opponent) {
        if (opponent.isMine()) {
            this.playDamageSound(opponent);
        }
    }

    protected void playEnemyDamageSound(GameCharacter opponent) {
        if (!this.isItem() && opponent.isMine()) {
            SKM.getManager().playSound(opponent.mDamageSound);
        }
    }

    public void damaged(int damage, GameCharacter enemy) {
        int realDamage = this.getRealDamage(damage, enemy);
        this.mEnergy -= realDamage;
        if (this.mEnergy < 0) {
            this.mEnergy = 0;
        }
        this.mDamageCount = 1;
        if (!this.mIsDamageAndAddedSpeed) {
            if (enemy != null) {
                this.addAddSpeed(enemy.getDamageSpeedX(this), enemy.getDamageSpeedY(this));
            }
            this.mIsDamageAndAddedSpeed = true;
        }
    }

    public void noDamaged(int damage, GameCharacter enemy) {
    }

    public int getRealDamage(int damage, GameCharacter enemy) {
        return damage;
    }

    public void damageEnemy(GameCharacter gc) {
    }

    public void noDamageHit(GameCharacter gc) {
    }

    public boolean isOut() {
        return this.isOut(1.0);
    }

    public boolean isOut(double mapScale) {
        double maxY;
        double minY;
        double maxX;
        double minX;
        if (mapScale == 0.0) {
            return true;
        }
        GameView manager = SKM.getManager();
        if (manager == null) {
            return false;
        }
        ViewCamera viewCamera = manager.getViewCamera();
        double dw = (double)manager.getDrawWidth() / mapScale;
        double dh = (double)manager.getDrawHeight() / mapScale;
        double sizeW = (double)this.mSizeW / mapScale;
        double sizeH = (double)this.mSizeH / mapScale;
        if (viewCamera == null) {
            minX = -sizeW;
            maxX = dw + sizeW;
            minY = -sizeH;
            maxY = dh + sizeH;
        } else {
            int cx = (int)viewCamera.getX();
            int cy = (int)viewCamera.getY();
            minX = (double)cx - dw / 2.0 - sizeW;
            maxX = (double)cx + dw / 2.0 + sizeW;
            minY = (double)cy - dh / 2.0 - sizeH;
            maxY = (double)cy + dh / 2.0 + sizeH;
        }
        return (double)this.mX < minX || maxX < (double)this.mX || (double)this.mY < minY || maxY < (double)this.mY;
    }

    public boolean isAttacked(GameCharacter gc) {
        if (gc == this || this.mEnergy <= 0 || gc.mEnergy <= 0 || this.mMaxW == 0 || this.mMaxH == 0 || this.mIsThroughAttack || gc.mIsThroughAttack) {
            return false;
        }
        return this.isIntersect(gc);
    }

    public boolean isAttackedImpl(GameCharacter gc) {
        if (this.mEnergy <= 0 || gc.mEnergy <= 0 || this.mMaxW == 0 || this.mMaxH == 0 || this.mIsThroughAttack || gc.mIsThroughAttack) {
            return false;
        }
        return this.isIntersect(gc);
    }

    public boolean isAttackedForHighSpeedCharacter(GameCharacter gc) {
        double tmpX = gc.getRealX();
        double tmpY = gc.getRealY();
        if (tmpX == this.mTmpX && tmpY == this.mTmpY) {
            return this.isAttackedImpl(gc);
        }
        double gcSpeedX = gc.getSpeedX();
        double gcSpeedY = gc.getSpeedY();
        double gcSpeed = SKMMath.sqrt(gcSpeedX * gcSpeedX + gcSpeedY * gcSpeedY);
        int gcMaxSize = SKMMath.min(SKMMath.min(this.mMaxW, this.mMaxH), SKMMath.min(gc.getMaxW(), gc.getMaxH())) / 2;
        if (gcMaxSize <= 0) {
            return this.isAttackedImpl(gc);
        }
        int loopN = SKMUtil.toInt(gcSpeed / (double)gcMaxSize);
        if (loopN <= 1) {
            return this.isAttackedImpl(gc);
        }
        double prevX = tmpX - gcSpeedX;
        double prevY = tmpY - gcSpeedY;
        double checkSpeedX = gcSpeedX / (double)loopN;
        double checkSpeedY = gcSpeedY / (double)loopN;
        for (int i = 1; i < loopN; ++i) {
            gc.setXY(prevX + checkSpeedX * (double)i, prevY + checkSpeedY * (double)i);
            if (!this.isAttackedImpl(gc)) continue;
            return true;
        }
        gc.setXY(tmpX, tmpY);
        return false;
    }

    public boolean isIntersect(GameCharacter gc) {
        double dx = this.mRealX - gc.mRealX;
        double dy = this.mRealY - gc.mRealY;
        double rw = (double)(this.mMaxW + gc.mMaxW) * 0.5;
        double rh = (double)(this.mMaxH + gc.mMaxH) * 0.5;
        return -rw < dx && dx < rw && -rh < dy && dy < rh;
    }

    public boolean isIntersectBySize(GameCharacter gc) {
        double dx = this.mRealX - gc.mRealX;
        double dy = this.mRealY - gc.mRealY;
        double rw = (double)(this.mSizeW + gc.mSizeW) * 0.5;
        double rh = (double)(this.mSizeH + gc.mSizeH) * 0.5;
        return -rw < dx && dx < rw && -rh < dy && dy < rh;
    }

    public boolean isHit(double x, double y) {
        if (!this.mIsVisible) {
            return false;
        }
        int hitHw = 0;
        int hitHh = 0;
        if (this.mIsHitSizeBase) {
            hitHw = this.mSizeW / 2;
            hitHh = this.mSizeH / 2;
        } else {
            hitHw = this.mMaxW / 2;
            hitHh = this.mMaxH / 2;
        }
        return this.mRealX - (double)hitHw <= x && x <= this.mRealX + (double)hitHw && this.mRealY - (double)hitHh <= y && y <= this.mRealY + (double)hitHh;
    }

    public void die() {
        this.mEnergy = 0;
        if (!this.mIsDeading) {
            this.deadAction();
        }
        this.mIsDeading = true;
        this.mCount = 0;
        this.mDoubleCount = 0.0;
    }

    public void kill() {
        this.die();
        this.mCount = this.mDeadCount;
        this.mDoubleCount = this.mDeadCount;
        this.cleanUp();
    }

    public void alive() {
        this.mEnergy = this.mMaxEnergy;
        this.mIsDeading = false;
        this.mCount = 0;
        this.mDoubleCount = 0.0;
        this.mDamageCount = 0;
        this.mIsBurstDrawStarted = false;
    }

    public void paint(SKMGraphics g) {
        if (!this.mIsVisible || this.isDead() || !this.mIsPaintEvenIfOut && this.isOut()) {
            return;
        }
        this.updateDrawPosition();
        g.saveTransform();
        if (this.mIsDeading) {
            this.burst(g);
        } else {
            this.myPaint(g);
        }
        g.restoreTransform();
    }

    protected void updateDrawPosition() {
        this.mDrawX = this.mX;
        this.mDrawY = this.mY;
    }

    protected void myPaint(SKMGraphics g) {
    }

    public void paintSize(SKMGraphics g) {
        g.setColor(SKMColor.BLUE);
        g.drawRect(this.mDrawX - this.mSizeW / 2 + 1, this.mDrawY - this.mSizeH / 2 + 1, this.mSizeW - 2, this.mSizeH - 2);
    }

    public void paintMax(SKMGraphics g) {
        g.setColor(SKMColor.RED);
        g.drawRect(this.mDrawX - this.mMaxW / 2, this.mDrawY - this.mMaxH / 2, this.mMaxW, this.mMaxH);
    }

    protected void burst(SKMGraphics g, int count) {
        this.mIsBurstDrawStarted = true;
        if (this.mBurstType == 6 || this.mBurstType == 7) {
            this.whiteBurst(g, count);
            return;
        }
        if (this.mBurstType == 8) {
            int[][] base = new int[2][10];
            int r = this.mSizeW / 5 < 20 ? 20 : this.mSizeW / 5;
            for (int i = 0; i < 5; ++i) {
                double rad = (double)(i * 2) * Math.PI / 5.0 - 1.5707963267948966;
                base[0][i * 2] = (int)((double)r * Math.cos(rad));
                base[1][i * 2] = (int)((double)r * Math.sin(rad));
                base[0][i * 2 + 1] = (int)((double)(r / 2) * Math.cos(rad + 0.6283185307179586));
                base[1][i * 2 + 1] = (int)((double)(r / 2) * Math.sin(rad + 0.6283185307179586));
            }
            int c = count - 15;
            int dx = count;
            int dy = (int)(0.1 * (double)(c * c) - 22.5);
            g.translate(this.mX + dx, this.mY + dy);
            g.setColor(this.mCount % 16 < 8 ? SKMColor.YELLOW : new SKMColor(200, 255, 200));
            g.fillPolygon(base[0], base[1]);
            g.translate(-(this.mX + dx), -(this.mY + dy));
            g.translate(this.mX - dx, this.mY + dy);
            g.setColor(8 <= this.mCount % 16 ? SKMColor.YELLOW : new SKMColor(200, 255, 200));
            g.fillPolygon(base[0], base[1]);
            g.translate(-(this.mX - dx), -(this.mY + dy));
            return;
        }
    }

    protected void burst(SKMGraphics g) {
        this.burst(g, this.mCount);
    }

    protected void whiteBurst(SKMGraphics g, int count) {
        int r = this.mSizeW * (this.mDeadCount - count) / this.mDeadCount;
        if (this.mBurstType == 6) {
            g.setColor(SKMColor.WHITE);
        } else if (this.mBurstType == 7) {
            g.setColor(SKMColor.BLACK);
        }
        g.fillOval(this.mDrawX - r, this.mDrawY - r, 2 * r, 2 * r);
    }

    public void paintEnergy(SKMGraphics g) {
    }

    public void paintDamage(SKMGraphics g, int x, int y) {
        g.drawImage(this.mDamageImages[this.mDamageIdx], x + this.mDamageDx - this.mDamageR, y + this.mDamageDy - this.mDamageR);
    }

    protected void setStateColor(SKMGraphics gg, int r, int g, int b) {
        if (this.isDamaging()) {
            gg.setColor(this.getDamagingColor(r, g, b, 255));
        } else {
            gg.setColor(new SKMColor(r, g, b));
        }
    }

    protected void setStateColor(SKMGraphics gg, int r, int g, int b, int a) {
        if (this.isDamaging()) {
            gg.setColor(this.getDamagingColor(r, g, b, a));
        } else {
            gg.setColor(new SKMColor(r, g, b, a));
        }
    }

    protected void setStateColor(SKMGraphics gg, SKMColor color) {
        if (this.isDamaging()) {
            gg.setColor(this.getDamagingColor(color));
        } else {
            gg.setColor(color);
        }
    }

    protected SKMColor getStateColor(SKMColor color) {
        return this.isDamaging() ? this.getDamagingColor(color) : color;
    }

    protected SKMColor getStateColor(int r, int g, int b) {
        return this.isDamaging() ? this.getDamagingColor(r, g, b, 255) : new SKMColor(r, g, b);
    }

    protected SKMColor getStateColor(int r, int g, int b, int a) {
        return this.isDamaging() ? this.getDamagingColor(r, g, b, a) : new SKMColor(r, g, b, a);
    }

    protected SKMColor getDamagingColor(SKMColor color) {
        return this.getDamagingColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    protected SKMColor getDamagingColor(int r, int g, int b, int a) {
        if ((g += 50) < (r += 50)) {
            g = r;
        } else {
            r = g;
        }
        if (255 < r) {
            r = 255;
        }
        if (255 < g) {
            g = 255;
        }
        b = 0;
        return new SKMColor(r, g, b, a);
    }

    public void setXY(double x, double y) {
        this.mX = (int)x;
        this.mRealX = x;
        this.mY = (int)y;
        this.mRealY = y;
    }

    public int getEnergy() {
        return this.mEnergy;
    }

    public void setEnergy(int energy) {
        this.mEnergy = energy;
    }

    public int getMaxEnergy() {
        return this.mMaxEnergy;
    }

    public void setMaxEnergy(int maxEnergy) {
        this.mMaxEnergy = maxEnergy;
    }

    public int getType() {
        return this.mType;
    }

    public void setSpeedByRadian(double rad, double speed) {
        this.mSpeedX = speed * Math.cos(rad);
        this.mSpeedY = speed * Math.sin(rad);
    }

    public void setSpeedByDegree(int degree, double speed) {
        this.setSpeedByRadian((double)degree * Math.PI / 180.0, speed);
    }

    public void setSpeedXY(double speedX, double speedY) {
        this.mSpeedX = speedX;
        this.mSpeedY = speedY;
    }

    public void setSpeedX(double speedX) {
        this.mSpeedX = speedX;
    }

    public void setSpeedY(double speedY) {
        this.mSpeedY = speedY;
    }

    public void setPowerRate(double rate) {
        this.mPowerRate = rate;
    }

    public double getPowerRate() {
        return this.mPowerRate;
    }

    public void setGuardRate(int guardType, double rate) {
        if (guardType < this.mGuardRate.length) {
            this.mGuardRate[guardType] = rate;
        }
    }

    public double getGuardRate(int guardType) {
        if (guardType < this.mGuardRate.length) {
            return this.mGuardRate[guardType];
        }
        return 1.0;
    }

    public void setBrakeRate(double rate) {
        this.mBrakeRate = rate;
    }

    public double getBrakeRate() {
        return this.mBrakeRate;
    }

    public boolean brakeX(double brakeSpeed) {
        if (0.0 < this.mSpeedX) {
            this.mSpeedX -= brakeSpeed;
            if (this.mSpeedX <= 0.0) {
                this.mSpeedX = 0.0;
                return true;
            }
        } else if (this.mSpeedX < 0.0) {
            this.mSpeedX += brakeSpeed;
            if (0.0 <= this.mSpeedX) {
                this.mSpeedX = 0.0;
                return true;
            }
        }
        return false;
    }

    public boolean brakeY(double brakeSpeed) {
        if (0.0 < this.mSpeedY) {
            this.mSpeedY -= brakeSpeed;
            if (this.mSpeedY <= 0.0) {
                this.mSpeedY = 0.0;
                return true;
            }
        } else if (this.mSpeedY < 0.0) {
            this.mSpeedY += brakeSpeed;
            if (0.0 <= this.mSpeedY) {
                this.mSpeedY = 0.0;
                return true;
            }
        }
        return false;
    }

    public void setDamage(int damage) {
        this.mDamage = damage;
    }

    public int getDamage() {
        return this.mDamage;
    }

    public boolean isDamaging() {
        return this.mDamageCount != 0;
    }

    public void setMaxDamageCount(int count) {
        this.mMaxDamageCount = count;
    }

    public int getMaxDamageCount() {
        return this.mMaxDamageCount;
    }

    public void setBurstType(int burstType) {
        this.mBurstType = burstType;
    }

    public void setNoDamage(boolean f) {
        this.mIsNoDamage = f;
    }

    public boolean isNoDamage() {
        return this.mIsNoDamage;
    }

    public void setThroughAttack(boolean f) {
        this.mIsThroughAttack = f;
    }

    public boolean isThroughAttack() {
        return this.mIsThroughAttack;
    }

    public int getCount() {
        return this.mCount;
    }

    public double getDoubleCount() {
        return this.mDoubleCount;
    }

    public void setDDoubleCount(double d) {
        this.mDDoubleCount = d;
    }

    public double getDDoubleCount() {
        return this.mDDoubleCount;
    }

    public double doubleModulo(double d, double m) {
        int id = (int)d;
        return (double)id % m + (d - (double)id);
    }

    public void setUseDoubleCount(boolean f) {
        this.mIsUseDoubleCount = f;
    }

    public void setX(double x) {
        this.mX = (int)x;
        this.mRealX = x;
    }

    public int getX() {
        return this.mX;
    }

    public double getRealX() {
        return this.mRealX;
    }

    public void setY(double y) {
        this.mY = (int)y;
        this.mRealY = y;
    }

    public int getY() {
        return this.mY;
    }

    public double getRealY() {
        return this.mRealY;
    }

    public int getMaxW() {
        return this.mMaxW;
    }

    public void setMaxW(int w) {
        this.mMaxW = w;
    }

    public int getMaxH() {
        return this.mMaxH;
    }

    public void setMaxH(int h) {
        this.mMaxH = h;
    }

    public void setSizeW(int w) {
        this.mSizeW = w;
    }

    public int getSizeW() {
        return this.mSizeW;
    }

    public void setSizeH(int h) {
        this.mSizeH = h;
    }

    public int getSizeH() {
        return this.mSizeH;
    }

    public double getSpeedX() {
        return this.mSpeedX;
    }

    public double getSpeedY() {
        return this.mSpeedY;
    }

    public double getSpeed() {
        return this.mSpeed;
    }

    public double getDamageSpeedX(GameCharacter target) {
        return 0.0;
    }

    public double getDamageSpeedY(GameCharacter target) {
        return 0.0;
    }

    public void setThroughDamage(boolean f) {
        this.mIsThroughDamage = f;
    }

    public boolean isThroughDamage() {
        return this.mIsThroughDamage;
    }

    public void setThroughHoming(boolean f) {
        this.mIsThroughHoming = f;
    }

    public boolean isThroughHoming() {
        return this.mIsThroughHoming;
    }

    public void setThroughBlock(boolean f) {
        this.mIsThroughBlock = f;
    }

    public boolean isThroughBlock() {
        return this.mIsThroughBlock;
    }

    public void setNotDieOut(boolean f) {
        this.mIsNotDieOut = f;
    }

    public boolean isNotDieOut() {
        return this.mIsNotDieOut;
    }

    public void setHitSizeBase(boolean f) {
        this.mIsHitSizeBase = f;
    }

    public void setAvoidDamageCount(boolean f) {
        this.mIsAvoidDamageCount = f;
    }

    public boolean isAvoidDamageCount() {
        return this.mIsAvoidDamageCount;
    }

    public void setDamageSound(String key) {
        this.mDamageSound = key;
    }

    public String getDamageSound() {
        return this.mDamageSound;
    }

    public void setBurstSound(String key) {
        this.mBurstSound = key;
    }

    public String getBurstSound() {
        return this.mBurstSound;
    }

    public boolean isNoRemain() {
        return this.mIsNoRemain;
    }

    public void setAddSpeedX(double speedX) {
        this.mAddSpeedX = speedX;
    }

    public double getAddSpeedX() {
        return this.mAddSpeedX;
    }

    public void setAddSpeedY(double speedY) {
        this.mAddSpeedY = speedY;
    }

    public double getAddSpeedY() {
        return this.mAddSpeedY;
    }

    public void setAddSpeedXY(double speedX, double speedY) {
        this.mAddSpeedX = speedX;
        this.mAddSpeedY = speedY;
    }

    public void setAddSpeedByRadian(double rad, double speed) {
        this.mAddSpeedX = speed * Math.cos(rad);
        this.mAddSpeedY = speed * Math.sin(rad);
        this.mAddSpeedRad = rad;
        this.mAddSpeedSpeed = speed;
    }

    public void addAddSpeed(double addX, double addY) {
        this.mAddSpeedX += addX;
        this.mAddSpeedY += addY;
    }

    public boolean isDead() {
        return this.isDeadOnlyMe();
    }

    public boolean isDeadOnlyMe() {
        return this.mIsDeading && this.mDeadCount <= this.mCount;
    }

    public void setScore(int score) {
        this.mScore = score;
    }

    public int getScore() {
        return this.mScore;
    }

    public void setPaintEvenIfOut(boolean f) {
        this.mIsPaintEvenIfOut = f;
    }

    public boolean isPaintEvenIfOut() {
        return this.mIsPaintEvenIfOut;
    }

    public void setVisible(boolean f) {
        this.mIsVisible = f;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public double getRadToMine() {
        GameCharacter mine = SKM.getManager().getMine();
        return this.getRad(this.mRealX, this.mRealY, mine.mRealX, mine.mRealY);
    }

    public double getRadToMine(double x, double y) {
        GameCharacter mine = SKM.getManager().getMine();
        return this.getRad(x, y, mine.mRealX, mine.mRealY);
    }

    public double getRad(double x, double y, double toX, double toY) {
        return Math.atan2(toY - y, toX - x);
    }

    public double getRad(double toX, double toY) {
        return Math.atan2(toY - this.mRealY, toX - this.mRealX);
    }

    public double getRad(GameCharacter to) {
        return Math.atan2(to.mRealY - this.mRealY, to.mRealX - this.mRealX);
    }

    public double getDistance2(GameCharacter to) {
        double dx = to.mRealX - this.mRealX;
        double dy = to.mRealY - this.mRealY;
        return dx * dx + dy * dy;
    }

    public double getDistance2(double tx, double ty) {
        double dx = tx - this.mRealX;
        double dy = ty - this.mRealY;
        return dx * dx + dy * dy;
    }

    public double getDistance2(double mx, double my, double tx, double ty) {
        double dx = tx - mx;
        double dy = ty - my;
        return dx * dx + dy * dy;
    }

    public SKMImage[] getDamagedImage(SKMImage[] inImages) {
        return SKMImageFuncs.getFilteredImage(inImages, (SKMImageFilter)new SKMYellowFilter());
    }

    public void cleanUp() {
    }
}

