/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.LineBorder;
import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMCTool;
import jp.ne.sk_mine.util.andr_applet.SKMConnectUtil;
import jp.ne.sk_mine.util.andr_applet.SKMI18N;
import jp.ne.sk_mine.util.andr_applet.SKMMineUtil;
import jp.ne.sk_mine.util.andr_applet.SKMRTool;
import jp.ne.sk_mine.util.andr_applet.SKMRuntimeFuncs;
import jp.ne.sk_mine.util.andr_applet.SKMTimer;
import jp.ne.sk_mine.util.andr_applet.SKMWindowFuncs;
import jp.ne.sk_mine.util.andr_applet.game.ScoreRegisterHandler;
import jp.ne.sk_mine.util.ui.ExJTextArea;
import jp.ne.sk_mine.util.ui.ExJTextField;

public class ScoreFrame
extends JFrame
implements ActionListener {
    public static final int TYPE_ENC_NONE = 0;
    public static final int TYPE_ENC_C = 1;
    public static final int TYPE_ENC_R = 2;
    private static final String sMessageRes = "jp.ne.sk_mine.util.andr_applet.res.message.message";
    private static String sUid;
    private static String sPwd;
    private int mEncType = 1;
    private ExJTextField mUidTf;
    private JPasswordField mPwdTf;
    private ExJTextArea mImpressionArea;
    private JButton mSendScoreButton;
    private JLabel mMainLabel;
    private String mMessage;
    private boolean mIsSending;
    private boolean mIsFinished;
    private boolean mIsImpressionEnabled;
    private int mImpressionMax;
    private int mScore;
    private int mRank;
    private String mDetail;
    private String mRegisterUserUrl;
    private String mRankingUrl;
    private SKMConnectUtil mConnectUtil;
    private SKMI18N mI18N;
    private String mKey;
    private ScoreRegisterHandler mHandler;
    private JPanel mMainLabelPanel = new JPanel();
    private ArrayList<Component> mUiList;
    private String mPrevScore;
    private long mPrevTime;

    public ScoreFrame(String registerScoreUrl, String registerUserUrl, String key, int score, String detail) {
        this.mI18N = new SKMI18N(sMessageRes);
        String title = this.mI18N.getString("send_score_title");
        title = title.replace("$score", "" + score);
        this.setTitle(title);
        this.mKey = key;
        this.mConnectUtil = new SKMConnectUtil();
        this.mConnectUtil.setServerInfo(registerScoreUrl);
        this.mConnectUtil.setSendEncoding("UTF-8");
        this.mRegisterUserUrl = registerUserUrl;
        this.mScore = score;
        this.mDetail = detail == null ? "" : "v2,P," + detail;
        this.mImpressionMax = 50;
        this.mUiList = new ArrayList();
    }

    public void setRankingUrl(String url) {
        this.mRankingUrl = url;
    }

    public void setImpressionEnabled(boolean f) {
        this.mIsImpressionEnabled = f;
    }

    public void setImpressionMax(int max) {
        this.mImpressionMax = max;
    }

    public void setHandler(ScoreRegisterHandler handler) {
        this.mHandler = handler;
    }

    public void setEncType(int type) {
        this.mEncType = type;
    }

    public void setup() {
        Container pane = this.getContentPane();
        pane.removeAll();
        pane.setLayout(new BorderLayout());
        this.mMainLabel = new JLabel(this.mI18N.getString("input_label"));
        this.mMainLabelPanel.add(this.mMainLabel);
        pane.add((Component)this.mMainLabelPanel, "North");
        JPanel labelAndInputPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(2, 1));
        JPanel inputPanel = new JPanel(new GridLayout(2, 1));
        JLabel uidLabel_ = new JLabel(this.mI18N.getString("codename"));
        this.mUidTf = new ExJTextField(sUid, 16);
        this.mUidTf.addActionListener(this);
        this.mUidTf.setMaxLength(16);
        labelPanel.add(uidLabel_);
        inputPanel.add(this.mUidTf);
        JLabel pwdLabel_ = new JLabel(this.mI18N.getString("password"));
        this.mPwdTf = new JPasswordField(sPwd, 16);
        this.mPwdTf.setEchoChar('*');
        this.mPwdTf.addActionListener(this);
        labelPanel.add(pwdLabel_);
        inputPanel.add(this.mPwdTf);
        labelAndInputPanel.add((Component)labelPanel, "West");
        labelAndInputPanel.add((Component)inputPanel, "Center");
        JPanel additionalPanel = this.getAdditionalUIPanel();
        if (additionalPanel != null) {
            labelAndInputPanel.add((Component)additionalPanel, "South");
        }
        if (this.mIsImpressionEnabled) {
            JPanel impressionPanel = new JPanel(new BorderLayout());
            JLabel impressionLabel = new JLabel(this.mI18N.getString("impression"));
            this.mImpressionArea = new ExJTextArea(3, 5);
            this.mImpressionArea.setMaxLength(this.mImpressionMax);
            String hint = this.mI18N.getString("impression_max");
            hint = hint.replace("$max", "" + this.mImpressionMax);
            this.mImpressionArea.setHint(hint);
            this.mImpressionArea.setBorder(new LineBorder(Color.GRAY));
            impressionPanel.add((Component)impressionLabel, "North");
            impressionPanel.add((Component)this.mImpressionArea, "Center");
            labelAndInputPanel.add((Component)impressionPanel, "South");
            this.addToUiList(this.mImpressionArea);
        }
        pane.add((Component)labelAndInputPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.mSendScoreButton = new JButton(SKM.getI18NCommon().getString("send_score"));
        this.mSendScoreButton.setActionCommand("send_score");
        this.mSendScoreButton.addActionListener(this);
        buttonPanel.add(this.mSendScoreButton);
        JButton explainButton = new JButton(this.mI18N.getString("explain_button"));
        explainButton.setActionCommand("explain");
        explainButton.addActionListener(this);
        buttonPanel.add(explainButton);
        JButton registerButton = new JButton(this.mI18N.getString("register_button"));
        registerButton.setActionCommand("register");
        registerButton.addActionListener(this);
        buttonPanel.add(registerButton);
        JButton deleteAccountButton = new JButton(this.mI18N.getString("delete_account_button"));
        deleteAccountButton.setActionCommand("delete_account");
        deleteAccountButton.addActionListener(this);
        buttonPanel.add(deleteAccountButton);
        if (this.mRankingUrl != null) {
            JButton rankingButton = new JButton(this.mI18N.getString("ranking_button"));
            rankingButton.setActionCommand("ranking");
            rankingButton.addActionListener(this);
            buttonPanel.add(rankingButton);
        }
        JButton finishButton = new JButton(this.mI18N.getString("close_button"));
        finishButton.setActionCommand("finish");
        finishButton.addActionListener(this);
        buttonPanel.add(finishButton);
        pane.add((Component)buttonPanel, "South");
        this.pack();
        this.addToUiList(this.mUidTf);
        this.addToUiList(this.mPwdTf);
        this.addToUiList(this.mSendScoreButton);
        this.addToUiList(finishButton);
        SKMWindowFuncs.centering(this);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ ScoreFrame this$0;
            {
                ScoreFrame scoreFrame = this$0;
                Objects.requireNonNull(scoreFrame);
                this.this$0 = scoreFrame;
            }

            @Override
            public void windowClosing(WindowEvent we) {
                this.this$0.close();
            }
        });
    }

    protected JPanel getAdditionalUIPanel() {
        return null;
    }

    protected String createSendData(String userId, String password) {
        String cpass = password;
        if (this.mEncType == 1) {
            cpass = SKMCTool.encrypt(password, this.mKey);
        } else if (this.mEncType == 2 && !password.equals("")) {
            String[] tokens = this.mKey.split("\\.");
            int e = Integer.parseInt(tokens[0]);
            int n = Integer.parseInt(tokens[1]);
            cpass = SKMRTool.encrypt(password, e, n);
        }
        StringBuilder data = new StringBuilder("argc=");
        data.append(userId);
        data.append("\t");
        data.append(cpass);
        data.append("\t");
        data.append(this.mScore);
        data.append("\t");
        data.append(this.mDetail);
        return data.toString();
    }

    private final int connectScoreCGI(String userId, String password) {
        String retStr;
        String impr;
        Object data = this.createSendData(userId, password);
        if (this.mIsImpressionEnabled && (impr = this.mImpressionArea.getText()).length() != 0) {
            if (!"\t".equals("" + ((String)data).charAt(((String)data).length() - 1))) {
                data = (String)data + "\t";
            }
            data = (String)data + impr;
        }
        if ((retStr = this.mConnectUtil.connectUrl(((String)data).toString())) == null) {
            return -3;
        }
        int ret = 0;
        try {
            ret = Integer.parseInt(retStr);
        }
        catch (Exception e) {
            return -3;
        }
        return ret;
    }

    private void sendScore(String userId, String password) {
        String title = this.mI18N.getString("title_send_score_result");
        int ans = this.connectScoreCGI(userId, password);
        if (ans <= 0) {
            title = SKMConnectUtil.getStateTitle(ans);
            this.mMessage = SKMConnectUtil.getStateMessage(ans);
        } else if (ans == 1) {
            this.mMessage = this.mI18N.getString("rankin_top");
        } else if (ans < 11) {
            this.mMessage = this.mI18N.getString("rankin_ten");
            this.mMessage = this.mMessage.replace("$rank", "" + ans);
        } else {
            this.mMessage = this.mI18N.getString("rankin");
            this.mMessage = this.mMessage.replace("$rank", "" + ans);
        }
        if (1 <= ans) {
            this.mRank = ans;
            this.mPrevScore = this.mScore + this.mDetail;
            this.mPrevTime = SKMTimer.getTime();
        }
        this.setTitle(title);
        this.mMainLabel.setText(this.mMessage);
        this.resizeFrame();
        SKMWindowFuncs.centering(this);
        this.mIsSending = false;
        this.mUidTf.requestFocus();
    }

    public boolean isFinished() {
        return this.mIsFinished;
    }

    private void resizeFrame() {
        this.remove(this.mMainLabelPanel);
        this.getContentPane().add((Component)this.mMainLabelPanel, "North");
        this.pack();
        SKMWindowFuncs.centering(this);
    }

    protected void showMessageOnLabel(String message) {
        this.mMainLabel.setText(message);
        this.resizeFrame();
    }

    protected boolean commandProc(String command) {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("register") || command.equals("delete_account")) {
            SKMRuntimeFuncs.openBrowser(this.mRegisterUserUrl);
            return;
        }
        if (command.equals("ranking")) {
            Object rankingUrl = new String(this.mRankingUrl);
            rankingUrl = ((String)rankingUrl).indexOf("?") == -1 ? (String)rankingUrl + "?" : (String)rankingUrl + "&";
            SKMRuntimeFuncs.openBrowser((String)rankingUrl + "rank=" + this.mRank);
            return;
        }
        if (command.equals("explain")) {
            JLabel explainLabel = new JLabel();
            explainLabel.setBackground(new Color(210, 210, 210));
            explainLabel.setFont(new Font("Monospaced", 0, 14));
            String explain = this.mI18N.getReplacedString("explain");
            explain = explain.replace("$max_name_length", "16");
            explain = explain.replace("$invalid_letters", SKMMineUtil.getInvalidLetters());
            explainLabel.setText(explain);
            JOptionPane.showMessageDialog(this, explainLabel, this.mI18N.getString("title_explain"), 1);
            return;
        }
        if (this.mIsSending) {
            return;
        }
        if (command.equals("finish")) {
            this.close();
            return;
        }
        if (this.commandProc(command)) {
            return;
        }
        long time = SKMTimer.getTime();
        if (this.mPrevScore != null && this.mPrevScore.equals(this.mScore + this.mDetail) && time - this.mPrevTime < 60000L) {
            this.mMainLabel.setText(SKMConnectUtil.getStateMessage(0));
            this.resizeFrame();
            return;
        }
        String uid = this.mUidTf.getText();
        char[] pwdChars = this.mPwdTf.getPassword();
        String pwd = pwdChars == null || pwdChars.length == 0 ? "" : new String(pwdChars);
        String impr = "";
        if (this.mIsImpressionEnabled) {
            impr = this.mImpressionArea.getText();
        }
        if (uid == null || uid.length() == 0) {
            this.mMainLabel.setText(this.mI18N.getString("error_no_codename"));
            this.resizeFrame();
            return;
        }
        if (SKMMineUtil.includesInvalidLetter(uid) || SKMMineUtil.includesInvalidLetter(pwd) || SKMMineUtil.includesInvalidLetter(impr)) {
            this.mMainLabel.setText(this.mI18N.getString("error_invalid_letter"));
            this.resizeFrame();
            return;
        }
        if (uid.indexOf("ttp://") != -1 || uid.indexOf("ttps://") != -1 || impr.indexOf("ttp://") != -1 || impr.indexOf("ttps://") != -1) {
            this.mMainLabel.setText(this.mI18N.getString("error_include_url"));
            this.resizeFrame();
            return;
        }
        int len = uid.length();
        boolean onlySpace = true;
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < len && i < 16; ++i) {
            char c = uid.charAt(i);
            if (c != ' ') {
                onlySpace = false;
            }
            tmp.append(c);
        }
        if (onlySpace) {
            this.mMainLabel.setText(this.mI18N.getString("error_space_name"));
            this.resizeFrame();
            return;
        }
        String userId = tmp.toString();
        if (16 < userId.length()) {
            this.mMainLabel.setText(this.mI18N.getString("error_too_long_name"));
            this.resizeFrame();
            return;
        }
        if (16 < pwd.length()) {
            this.mMainLabel.setText(this.mI18N.getString("error_too_long_password"));
            this.resizeFrame();
            return;
        }
        sUid = userId;
        sPwd = pwd;
        this.mRank = 0;
        this.setTitle(this.mI18N.getString("connecting"));
        this.mIsSending = true;
        new Thread(this){
            final /* synthetic */ ScoreFrame this$0;
            {
                ScoreFrame scoreFrame = this$0;
                Objects.requireNonNull(scoreFrame);
                this.this$0 = scoreFrame;
            }

            @Override
            public void run() {
                this.this$0.setUiEnabled(false);
                this.this$0.sendScore(sUid, sPwd);
                this.this$0.setUiEnabled(true);
            }
        }.start();
    }

    protected void addToUiList(Component c) {
        this.mUiList.add(c);
    }

    protected void setUiEnabled(boolean f) {
        for (int i = 0; i < this.mUiList.size(); ++i) {
            this.mUiList.get(i).setEnabled(f);
        }
    }

    public void open() {
        this.setVisible(true);
    }

    public void close() {
        this.mIsFinished = true;
        this.dispose();
        if (this.mHandler != null) {
            this.mHandler.finishScoreRegistration();
        }
    }
}

