/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.effect;

import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMRadialGradient;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.effect.Effect;

public class CircleEffect
extends Effect {
    private int mRadiusCoef;
    private int mRed;
    private int mGreen;
    private int mBlue;
    private float mCenterPosition;

    public CircleEffect(double x, double y, int radiusCoef) {
        super(x, y);
        this.mRadiusCoef = radiusCoef;
        this.mRed = 255;
        this.mGreen = 255;
        this.mBlue = 0;
        this.mLifeCount = 50;
    }

    public void setColor(SKMColor color) {
        this.mRed = color.getRed();
        this.mGreen = color.getGreen();
        this.mBlue = color.getBlue();
    }

    public void setCenterPosition(double position) {
        if (position < 0.0 || 1.0 <= position) {
            return;
        }
        this.mCenterPosition = (float)position;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        int alpha = SKMUtil.toInt(255 * (this.mLifeCount - this.mCount) / this.mLifeCount);
        if (0 < alpha) {
            int hr = 1 + this.mCount * this.mRadiusCoef / 2;
            SKMColor baseColor = new SKMColor(this.mRed, this.mGreen, this.mBlue, alpha);
            if (this.mCenterPosition == 0.0f) {
                g.setColor(baseColor);
                g.fillOval(this.mDrawX - hr, this.mDrawY - hr, 2 * hr, 2 * hr);
            } else {
                float[] positions = new float[]{0.0f, this.mCenterPosition, 1.0f};
                SKMColor transparentColor = new SKMColor(this.mRed, this.mGreen, this.mBlue, 0);
                SKMColor[] colors = new SKMColor[]{transparentColor, transparentColor, baseColor};
                SKMRadialGradient rg = new SKMRadialGradient((float)this.mX, (float)this.mY, (float)hr, positions, colors);
                g.setGradient(rg);
                g.fillOval(this.mDrawX - hr, this.mDrawY - hr, 2 * hr, 2 * hr);
                g.setGradient(null);
            }
        }
    }
}

