/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.effect;

import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.GameCharacter;

public class Effect {
    protected double mDoubleCount;
    protected double mDDoubleCount;
    protected double mRealX;
    protected double mRealY;
    protected double mSpeedX;
    protected double mSpeedY;
    protected int mX;
    protected int mY;
    protected int mDrawX;
    protected int mDrawY;
    protected int mCount;
    protected int mDxToPositionCharacter;
    protected int mDyToPositionCharacter;
    protected int mLifeCount;
    protected boolean mIsVisible;
    protected boolean mIsDead;
    protected boolean mIsKillWhenPositionCharacterDied;
    protected boolean mIsKillWhenPositionCharacterKilled;
    protected boolean mIsUseDoubleCount;
    protected GameCharacter mPositionCharacter;

    public Effect(double x, double y) {
        this.setXY(x, y);
        this.mIsVisible = true;
        this.mLifeCount = -1;
        this.mDDoubleCount = 1.0;
    }

    public void setX(double x) {
        this.mRealX = x;
        this.mX = (int)this.mRealX;
    }

    public void setY(double y) {
        this.mRealY = y;
        this.mY = (int)this.mRealY;
    }

    public void setXY(double x, double y) {
        this.mRealX = x;
        this.mRealY = y;
        this.mX = (int)this.mRealX;
        this.mY = (int)this.mRealY;
    }

    public int getX() {
        return this.mX;
    }

    public int getY() {
        return this.mY;
    }

    public double getRealX() {
        return this.mRealX;
    }

    public double getRealY() {
        return this.mRealY;
    }

    public void setSpeedX(double speedX) {
        this.mSpeedX = speedX;
    }

    public void setSpeedY(double speedY) {
        this.mSpeedY = speedY;
    }

    public void setSpeedXY(double speedX, double speedY) {
        this.mSpeedX = speedX;
        this.mSpeedY = speedY;
    }

    public void setSpeedByRadian(double rad, double speed) {
        this.mSpeedX = speed * Math.cos(rad);
        this.mSpeedY = speed * Math.sin(rad);
    }

    public double getSpeedX() {
        return this.mSpeedX;
    }

    public double getSpeedY() {
        return this.mSpeedY;
    }

    public void setVisible(boolean f) {
        this.mIsVisible = f;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public void setPositionCharacter(GameCharacter gc) {
        this.mPositionCharacter = gc;
        this.mDxToPositionCharacter = this.mX - gc.getX();
        this.mDyToPositionCharacter = this.mY - gc.getY();
    }

    public void setKillWhenPositionCharacterDied(boolean f) {
        this.mIsKillWhenPositionCharacterDied = f;
    }

    public void setKillWhenPositionCharacterKilled(boolean f) {
        this.mIsKillWhenPositionCharacterKilled = f;
    }

    public void setLifeCount(int lifeCount) {
        this.mLifeCount = lifeCount;
    }

    public void move() {
        this.mDoubleCount += this.mDDoubleCount;
        this.mCount = this.mIsUseDoubleCount ? SKMUtil.toInt(this.mDoubleCount) : ++this.mCount;
        if (this.mCount < 0) {
            this.mCount = 0;
            this.mDoubleCount = 0.0;
        }
        this.myMove();
        if (this.mPositionCharacter == null) {
            this.setXY(this.mRealX + this.mSpeedX, this.mRealY + this.mSpeedY);
        } else {
            this.setXY(this.mPositionCharacter.getX() + this.mDxToPositionCharacter, this.mPositionCharacter.getY() + this.mDyToPositionCharacter);
            if (this.mIsKillWhenPositionCharacterKilled) {
                if (this.mPositionCharacter.isDead()) {
                    this.kill();
                }
            } else if (this.mIsKillWhenPositionCharacterDied && this.mPositionCharacter.getEnergy() == 0) {
                this.kill();
            }
        }
        if (this.mLifeCount != -1 && (double)this.mLifeCount <= this.mDoubleCount) {
            this.kill();
        }
    }

    public void kill() {
        this.mIsDead = true;
    }

    public boolean isDead() {
        return this.mIsDead;
    }

    protected void myMove() {
    }

    public void paint(SKMGraphics g) {
        if (!this.mIsVisible) {
            return;
        }
        this.mDrawX = this.mX;
        this.mDrawY = this.mY;
        this.myPaint(g);
    }

    protected void myPaint(SKMGraphics g) {
    }

    public void cleanUp() {
    }
}

