/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.effect;

import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.effect.Effect;

public class FarBurstEffect
extends Effect {
    private double mRad;
    private double mDRad;
    private double mScale;
    private SKMColor mColor;

    public FarBurstEffect(double x, double y) {
        super(x, y);
        this.mLifeCount = 40;
        this.mScale = 1.0;
        this.mColor = SKMColor.WHITE;
    }

    public void setRad(double rad) {
        this.mRad = rad;
    }

    public void setDRad(double dRad) {
        this.mDRad = dRad;
    }

    public void setScale(double scale) {
        this.mScale = scale;
    }

    public void setColor(SKMColor color) {
        this.mColor = color;
    }

    @Override
    protected void myMove() {
        this.mRad += this.mDRad;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        int r;
        g.saveTransform();
        if (this.mScale != 1.0) {
            g.translate(this.mDrawX, this.mDrawY);
            g.scale(this.mScale);
            g.translate(-this.mDrawX, -this.mDrawY);
        }
        if (this.mRad != 0.0) {
            g.rotate(this.mRad, this.mDrawX, this.mDrawY);
        }
        g.setColor(this.mColor);
        int halfLife = this.mLifeCount / 2;
        int hw = halfLife + halfLife * this.mCount;
        int hh = this.mLifeCount / 5 - SKMUtil.toInt(this.mCount / 2);
        if (0 < hh) {
            int[][] diaXys = new int[][]{{-hw, 0, hw, 0}, {0, -hh, 0, hh}};
            int i = 0;
            while (i < diaXys[0].length) {
                int[] nArray = diaXys[0];
                int n = i;
                nArray[n] = nArray[n] + this.mDrawX;
                int[] nArray2 = diaXys[1];
                int n2 = i++;
                nArray2[n2] = nArray2[n2] + this.mDrawY;
            }
            g.fillPolygon(diaXys);
        }
        if (0 < (r = halfLife - this.mCount)) {
            g.fillOval(this.mDrawX - r, this.mDrawY - r, 2 * r, 2 * r);
        }
        g.restoreTransform();
    }
}

