/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.event;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMCheckBox;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMMap;
import jp.ne.sk_mine.util.andr_applet.SKMRadioButton;
import jp.ne.sk_mine.util.andr_applet.SKMSlider;
import jp.ne.sk_mine.util.andr_applet.SKMUI;
import jp.ne.sk_mine.util.andr_applet.game.GameView;

public class EventBase {
    private static boolean sIsUpdateButtonPositionsInSetPhase;
    private static boolean sIsUseBaseViewSize;
    protected boolean mIsInited;
    protected boolean mIsFinished;
    protected boolean mIsActive = true;
    protected boolean mIsToFinish;
    protected boolean mIsMousePressed;
    protected boolean mIsMouseReleased;
    protected boolean mIsMouseDragged;
    protected boolean mIsCheckHitUis;
    protected int mCount;
    protected int mPhase;
    protected int mNextPhase;
    protected int mSubPhase;
    protected int mNextSubPhase;
    protected int mDw;
    protected int mDh;
    protected int mMouseButton;
    protected int mMouseWheelRotation;
    protected double mMouseX;
    protected double mMouseY;
    protected double mMousePressedX;
    protected double mMousePressedY;
    protected double mMousePrevX;
    protected double mMousePrevY;
    protected String mId;
    protected SKMArray<SKMUI> mUis = new SKMArray();
    protected SKMArray<SKMUI> mVisibledUis = new SKMArray();
    protected SKMMap<Integer, EventBase> mPageMap = new SKMMap();
    protected GameView mGameManager = SKM.getManager();

    public static void setUpdateButtonPositionsInSetPhase(boolean f) {
        sIsUpdateButtonPositionsInSetPhase = f;
    }

    public static void setBaseViewSize(boolean f) {
        sIsUseBaseViewSize = f;
    }

    public EventBase() {
        this.mDw = this.mGameManager.getBaseDrawWidth();
        this.mDh = this.mGameManager.getBaseDrawHeight();
    }

    public void init() {
        this.mNextPhase = -1;
        this.mNextSubPhase = -1;
        this.myInit();
        this.mIsInited = true;
    }

    protected void myInit() {
    }

    public void setId(String id) {
        this.mId = id;
    }

    public String getId() {
        return this.mId;
    }

    public void setPhase(int phase) {
        this.mySetPhase(phase);
        this.mCount = 0;
        this.mSubPhase = 0;
        this.mNextPhase = -1;
        this.mNextSubPhase = -1;
        this.mPhase = phase;
        if (sIsUpdateButtonPositionsInSetPhase) {
            this.updateButtonPositions();
        }
    }

    protected void mySetPhase(int phase) {
    }

    protected void setNextPhase(int phase) {
        this.mNextPhase = phase;
    }

    public void setSubPhase(int subPhase) {
        this.mySetSubPhase(subPhase);
        this.mCount = 0;
        this.mSubPhase = subPhase;
        this.mNextSubPhase = -1;
        this.updateButtonPositions();
    }

    protected void mySetSubPhase(int subPhase) {
    }

    protected void setNextSubPhase(int subPhase) {
        this.mNextSubPhase = subPhase;
    }

    public void setActive(boolean f) {
        if (this.mIsActive == f) {
            return;
        }
        if (f) {
            for (int i = this.mUis.size() - 1; 0 <= i; --i) {
                SKMUI ui = this.mUis.get(i);
                if (!this.mVisibledUis.contains(ui)) continue;
                ui.setVisible(true);
            }
            this.mVisibledUis.clear();
            this.mCount = 0;
        } else {
            this.mVisibledUis.clear();
            for (int i = this.mUis.size() - 1; 0 <= i; --i) {
                SKMUI ui = this.mUis.get(i);
                if (ui.isVisible()) {
                    this.mVisibledUis.add(ui);
                }
                ui.setVisible(false);
            }
        }
        this.mIsActive = f;
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    public void addUi(SKMUI ui) {
        this.mGameManager.addUi(ui);
        this.mUis.add(ui);
    }

    public void removeUi(SKMUI ui) {
        this.mGameManager.removeUi(ui);
        this.mUis.remove(ui);
    }

    public void removeAllUis() {
        for (int i = this.mUis.size() - 1; 0 <= i; --i) {
            this.removeUi(this.mUis.get(i));
        }
    }

    public void addPage(int index, EventBase page) {
        page.setActive(false);
        this.mPageMap.put(index, page);
    }

    public void removePage(int index) {
        this.mPageMap.remove(index);
    }

    public void removeAllPages() {
        Object[] pageKeys = this.mPageMap.getKeys();
        for (int i = pageKeys.length - 1; 0 <= i; --i) {
            this.mPageMap.get((Integer)pageKeys[i]).finish();
        }
        this.mPageMap.clear();
    }

    public void deactiveAllPages() {
        Object[] pageKeys = this.mPageMap.getKeys();
        for (int i = pageKeys.length - 1; 0 <= i; --i) {
            EventBase event = this.mPageMap.get((Integer)pageKeys[i]);
            if (!event.isActive()) continue;
            event.setActive(false);
        }
    }

    public void switchActivePage(int index) {
        EventBase activePage = this.getActivePage();
        if (activePage != null) {
            activePage.setActive(false);
        }
        if (this.mPageMap.containsKey(index)) {
            this.mPageMap.get(index).setActive(true);
        }
    }

    public EventBase getActivePage() {
        Object[] pageKeys = this.mPageMap.getKeys();
        for (int i = pageKeys.length - 1; 0 <= i; --i) {
            int pageIndex = (Integer)pageKeys[i];
            EventBase event = this.mPageMap.get(pageIndex);
            if (!event.isActive()) continue;
            return event;
        }
        return null;
    }

    public void updateAllPageButtonPositions() {
        Object[] pageKeys = this.mPageMap.getKeys();
        for (int i = pageKeys.length - 1; 0 <= i; --i) {
            int pageIndex = (Integer)pageKeys[i];
            this.mPageMap.get(pageIndex).updateButtonPositions();
        }
    }

    public boolean mousePressed(double mx, double my, int button) {
        this.mIsMousePressed = true;
        this.mMouseX = this.mMousePrevX = mx;
        this.mMousePressedX = this.mMousePrevX;
        this.mMouseY = this.mMousePrevY = my;
        this.mMousePressedY = this.mMousePrevY;
        this.mMouseButton = button;
        if (this.mIsCheckHitUis) {
            if (this.isHitCheckBox(mx, my)) {
                return true;
            }
            if (this.isHitRadioButton(mx, my)) {
                return true;
            }
            if (this.isHitSlider(mx, my)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isHitCheckBox(double mx, double my) {
        for (int i = this.mUis.size() - 1; 0 <= i; --i) {
            SKMUI ui = this.mUis.get(i);
            if (!(ui instanceof SKMCheckBox) || !((SKMCheckBox)ui).isHit(mx, my)) continue;
            return true;
        }
        return false;
    }

    protected boolean isHitRadioButton(double mx, double my) {
        for (int i = this.mUis.size() - 1; 0 <= i; --i) {
            SKMUI ui = this.mUis.get(i);
            if (!(ui instanceof SKMRadioButton) || !((SKMRadioButton)ui).isHit(mx, my)) continue;
            return true;
        }
        return false;
    }

    protected boolean isHitSlider(double mx, double my) {
        for (int i = this.mUis.size() - 1; 0 <= i; --i) {
            SKMUI ui = this.mUis.get(i);
            if (!(ui instanceof SKMSlider) || !((SKMSlider)ui).isHit(mx, my)) continue;
            return true;
        }
        return false;
    }

    protected SKMUI checkHitUi(double mx, double my, SKMUI exceptedUi) {
        for (int i = this.mUis.size() - 1; 0 <= i; --i) {
            SKMUI ui = this.mUis.get(i);
            if (!ui.isHit(mx, my, false, true) || ui == exceptedUi) continue;
            return ui;
        }
        return null;
    }

    protected SKMUI checkHitUi(double mx, double my, SKMArray<SKMUI> exceptedUis) {
        for (int i = this.mUis.size() - 1; 0 <= i; --i) {
            SKMUI ui = this.mUis.get(i);
            if (!ui.isHit(mx, my, false, true) || exceptedUis.contains(ui)) continue;
            return ui;
        }
        return null;
    }

    public boolean mousePressedOnPage(int index, double mx, double my, int button) {
        EventBase page;
        if (this.mPageMap.containsKey(index) && (page = this.mPageMap.get(index)).isActive()) {
            return page.mousePressed(mx, my, button);
        }
        return false;
    }

    public boolean mouseReleased(double mx, double my, int button) {
        this.mIsMousePressed = false;
        this.mIsMouseReleased = true;
        this.mMouseX = mx;
        this.mMouseY = my;
        this.mMouseButton = button;
        if (this.mIsCheckHitUis) {
            this.isSliderReleased(mx, my);
        }
        return false;
    }

    protected boolean isSliderReleased(double mx, double my) {
        for (int i = this.mUis.size() - 1; 0 <= i; --i) {
            SKMUI ui = this.mUis.get(i);
            if (!(ui instanceof SKMSlider)) continue;
            SKMSlider slider = (SKMSlider)ui;
            if (slider.isPressed()) {
                slider.setPressed(false);
                continue;
            }
            if (!slider.isHitWholeSlider(mx, my)) continue;
            slider.setBarPosition(mx, my);
            return true;
        }
        return false;
    }

    public boolean mouseReleasedOnPage(int index, double mx, double my, int button) {
        EventBase page;
        if (this.mPageMap.containsKey(index) && (page = this.mPageMap.get(index)).isActive()) {
            return page.mouseReleased(mx, my, button);
        }
        return false;
    }

    public boolean mouseMoved(double mx, double my) {
        return false;
    }

    public boolean mouseMoved(double mx, double my, int button) {
        return false;
    }

    public boolean mouseDragged(double mx, double my) {
        this.mIsMouseDragged = true;
        this.mMousePrevX = this.mMouseX;
        this.mMousePrevY = this.mMouseY;
        this.mMouseX = mx;
        this.mMouseY = my;
        return this.mIsCheckHitUis && this.isSliderDragged(mx, my);
    }

    public boolean mouseDragged(double mx, double my, int button) {
        this.mIsMouseDragged = true;
        this.mMousePrevX = this.mMouseX;
        this.mMousePrevY = this.mMouseY;
        this.mMouseX = mx;
        this.mMouseY = my;
        this.mMouseButton = button;
        return this.mIsCheckHitUis && this.isSliderDragged(mx, my);
    }

    protected boolean isSliderDragged(double mx, double my) {
        for (int i = this.mUis.size() - 1; 0 <= i; --i) {
            SKMSlider slider;
            SKMUI ui = this.mUis.get(i);
            if (!(ui instanceof SKMSlider) || !(slider = (SKMSlider)ui).isPressed()) continue;
            slider.setBarPosition(mx, my);
            return true;
        }
        return false;
    }

    public boolean mouseDraggedOnPage(int index, double mx, double my) {
        EventBase page;
        if (this.mPageMap.containsKey(index) && (page = this.mPageMap.get(index)).isActive()) {
            return page.mouseDragged(mx, my);
        }
        return false;
    }

    public boolean mouseDraggedOnPage(int index, double mx, double my, int button) {
        EventBase page;
        if (this.mPageMap.containsKey(index) && (page = this.mPageMap.get(index)).isActive()) {
            return page.mouseDragged(mx, my, button);
        }
        return false;
    }

    public boolean mouseWheelMoved(int rotation) {
        this.mMouseWheelRotation = rotation;
        return false;
    }

    public boolean mouseWheelMovedOnPage(int index, int rotation) {
        EventBase page;
        if (this.mPageMap.containsKey(index) && (page = this.mPageMap.get(index)).isActive()) {
            return page.mouseWheelMoved(rotation);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, boolean isShift, boolean isCtrl, boolean isAlt) {
        return false;
    }

    public boolean keyReleased(int keyCode, boolean isShift, boolean isCtrl, boolean isAlt) {
        return false;
    }

    protected void inputProc() {
        if (this.mIsMouseDragged) {
            this.mIsMouseDragged = false;
            this.inputProcMouseDragged();
        } else if (this.mIsMousePressed) {
            this.mIsMousePressed = false;
            this.inputProcMousePressed();
        } else if (this.mIsMouseReleased) {
            this.mIsMouseReleased = false;
            this.inputProcMouseReleased();
        } else if (this.mMouseWheelRotation != 0) {
            this.inputProcMouseWheelMoved();
            this.mMouseWheelRotation = 0;
        }
    }

    protected void inputProcMousePressed() {
    }

    protected void inputProcMouseReleased() {
    }

    protected void inputProcMouseDragged() {
    }

    protected void inputProcMouseWheelMoved() {
    }

    public void run() {
        if (this.mIsToFinish) {
            this.mIsToFinish = false;
            this.finish();
            return;
        }
        if (this.mNextPhase != -1) {
            this.setPhase(this.mNextPhase);
            this.mNextPhase = -1;
        }
        if (this.mNextSubPhase != -1) {
            this.setSubPhase(this.mNextSubPhase);
            this.mNextSubPhase = -1;
        }
        this.myRun();
        ++this.mCount;
    }

    protected void myRun() {
    }

    protected void runPage(int index) {
        if (this.mPageMap.containsKey(index)) {
            this.mPageMap.get(index).run();
        }
    }

    public void paint(SKMGraphics g) {
        if (!this.mIsInited) {
            return;
        }
        this.myPaint(g);
    }

    protected void myPaint(SKMGraphics g) {
    }

    protected void paintPhaseChangeSettings(SKMGraphics g) {
        g.setColor(SKMColor.BLACK);
        g.fillRect(0, 0, this.mDw + 1, this.mDh + 1);
        g.setColor(SKMColor.WHITE);
        g.setFont(new SKMFont(20));
        g.drawCenteringString(SKM.getI18NCommon().getString("changing_settings"), this.mDw / 2, this.mDh / 2);
    }

    protected void paintPage(SKMGraphics g, int index) {
        if (this.mPageMap.containsKey(index)) {
            this.mPageMap.get(index).paint(g);
        }
    }

    public void resizeView(int width, int height) {
        if (sIsUseBaseViewSize) {
            this.mDw = this.mGameManager.getBaseDrawWidth();
            this.mDh = this.mGameManager.getBaseDrawHeight();
        } else {
            this.mDw = this.mGameManager.getDrawWidth();
            this.mDh = this.mGameManager.getDrawHeight();
        }
        Object[] pageKeys = this.mPageMap.getKeys();
        for (int i = pageKeys.length - 1; 0 <= i; --i) {
            this.mPageMap.get((Integer)pageKeys[i]).resizeView(width, height);
        }
        this.updateButtonPositions();
    }

    public void updateButtonPositions() {
        this.myUpdateButtonPositions();
        Object[] pageKeys = this.mPageMap.getKeys();
        for (int i = pageKeys.length - 1; 0 <= i; --i) {
            this.mPageMap.get((Integer)pageKeys[i]).updateButtonPositions();
        }
    }

    protected void myUpdateButtonPositions() {
    }

    public void finish() {
        this.removeAllUis();
        this.removeAllPages();
        this.mIsFinished = true;
    }

    public boolean isFinished() {
        return this.mIsFinished;
    }

    public void cleanUp() {
    }
}

