/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.event;

import java.util.ArrayList;
import java.util.List;
import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.game.event.EventBase;

public class EventManager {
    protected List<EventBase> mEvents = new ArrayList<EventBase>();

    public void setEvent(EventBase event) {
        if (this.mEvents.size() != 0) {
            this.mEvents.get(this.mEvents.size() - 1).setActive(false);
        }
        event.setActive(true);
        this.mEvents.add(event);
    }

    public EventBase getEvent() {
        return this.mEvents.size() == 0 ? null : this.mEvents.get(this.mEvents.size() - 1);
    }

    public boolean hasEvent() {
        return this.mEvents.size() != 0;
    }

    public boolean removeEvent(EventBase event) {
        for (int i = this.mEvents.size() - 1; 0 <= i; --i) {
            try {
                EventBase e = this.mEvents.get(i);
                if (e != event) continue;
                if (i == this.mEvents.size() - 1 && 0 < i) {
                    this.mEvents.get(i - 1).setActive(true);
                }
                event.setActive(false);
                this.mEvents.remove(i);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public int size() {
        return this.mEvents.size();
    }

    public boolean mousePressed(double mx, double my, int button) {
        if (this.mEvents.size() != 0) {
            try {
                if (this.mEvents.get(this.mEvents.size() - 1).mousePressed(mx, my, button)) {
                    return true;
                }
            }
            catch (Exception e) {
                SKM.getManager().logging(e);
            }
        }
        return false;
    }

    public boolean mouseReleased(double mx, double my, int button) {
        if (this.mEvents.size() != 0) {
            try {
                if (this.mEvents.get(this.mEvents.size() - 1).mouseReleased(mx, my, button)) {
                    return true;
                }
            }
            catch (Exception e) {
                SKM.getManager().logging(e);
            }
        }
        return false;
    }

    public boolean mouseMoved(double mx, double my) {
        if (this.mEvents.size() != 0) {
            try {
                if (this.mEvents.get(this.mEvents.size() - 1).mouseMoved(mx, my)) {
                    return true;
                }
            }
            catch (Exception e) {
                SKM.getManager().logging(e);
            }
        }
        return false;
    }

    public boolean mouseDragged(double mx, double my) {
        if (this.mEvents.size() != 0) {
            try {
                if (this.mEvents.get(this.mEvents.size() - 1).mouseDragged(mx, my)) {
                    return true;
                }
            }
            catch (Exception e) {
                SKM.getManager().logging(e);
            }
        }
        return false;
    }

    public boolean mouseDragged(double mx, double my, int button) {
        if (this.mEvents.size() != 0) {
            try {
                if (this.mEvents.get(this.mEvents.size() - 1).mouseDragged(mx, my, button)) {
                    return true;
                }
            }
            catch (Exception e) {
                SKM.getManager().logging(e);
            }
        }
        return false;
    }

    public boolean mouseWheelMoved(int rotation) {
        if (this.mEvents.size() != 0) {
            try {
                if (this.mEvents.get(this.mEvents.size() - 1).mouseWheelMoved(rotation)) {
                    return true;
                }
            }
            catch (Exception e) {
                SKM.getManager().logging(e);
            }
        }
        return false;
    }

    public boolean keyPressed(int keyCode, boolean isShift, boolean isCtrl, boolean isAlt) {
        return this.mEvents.size() != 0 && this.mEvents.get(this.mEvents.size() - 1).keyPressed(keyCode, isShift, isCtrl, isAlt);
    }

    public boolean keyReleased(int keyCode, boolean isShift, boolean isCtrl, boolean isAlt) {
        return this.mEvents.size() != 0 && this.mEvents.get(this.mEvents.size() - 1).keyReleased(keyCode, isShift, isCtrl, isAlt);
    }

    public void runEvent() {
        if (this.mEvents.size() != 0) {
            this.mEvents.get(this.mEvents.size() - 1).run();
        }
    }

    public void finish() {
        if (this.mEvents.size() != 0) {
            this.mEvents.get(this.mEvents.size() - 1).finish();
        }
    }

    public boolean isEventFinished() {
        for (int i = this.mEvents.size() - 1; 0 <= i; --i) {
            if (!this.mEvents.get(i).isFinished()) continue;
            return true;
        }
        return false;
    }

    public void removeFinishedEvents() {
        for (int i = this.mEvents.size() - 1; 0 <= i; --i) {
            if (!this.mEvents.get(i).isFinished()) continue;
            this.mEvents.remove(i);
        }
        if (this.mEvents.size() != 0) {
            this.mEvents.get(this.mEvents.size() - 1).setActive(true);
        }
    }

    public void paintEvent(SKMGraphics g) {
        if (this.mEvents.size() != 0) {
            this.mEvents.get(this.mEvents.size() - 1).paint(g);
        }
    }

    public void resizeView(int width, int height) {
        try {
            for (int i = this.mEvents.size() - 1; 0 <= i; --i) {
                this.mEvents.get(i).resizeView(width, height);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clear() {
        for (int i = this.mEvents.size() - 1; 0 <= i; --i) {
            if (this.mEvents.get(i).isFinished()) continue;
            this.mEvents.get(i).finish();
        }
        this.mEvents.clear();
    }
}

