/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.event;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMButton;
import jp.ne.sk_mine.util.andr_applet.SKMButtonGroup;
import jp.ne.sk_mine.util.andr_applet.SKMCheckBox;
import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMI18N;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMRadioButton;
import jp.ne.sk_mine.util.andr_applet.SKMUI;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.GameView;
import jp.ne.sk_mine.util.andr_applet.game.MyFrameButton;
import jp.ne.sk_mine.util.andr_applet.game.SaveLoadDialog;
import jp.ne.sk_mine.util.andr_applet.game.event.EventBase;

public class LangSettingPage
extends EventBase {
    protected final SKMColor mTitleColor = new SKMColor(230, 230, 230);
    protected boolean mIsSaveLoadEnabled;
    protected boolean mIsSeasonalEffectsSettingEnabled;
    protected boolean mIsPortrait;
    protected String mLang;
    protected MyFrameButton mSaveButton;
    protected MyFrameButton mLoadButton;
    protected SKMCheckBox mSoundCheck;
    protected SKMCheckBox mBgmCheck;
    protected SKMCheckBox mSeasonalEffectsDisabledCheck;
    protected SKMRadioButton[] mLangButtons;
    protected SaveLoadDialog mSaveLoadDialog;

    public LangSettingPage() {
        this(false);
    }

    public LangSettingPage(boolean isPortrait) {
        this.mIsPortrait = isPortrait;
        this.init();
    }

    @Override
    protected void myInit() {
        this.mIsSaveLoadEnabled = true;
        this.mLang = this.getLangFromSetting();
        SKMI18N i18nCommon = SKM.getI18NCommon();
        SKMFont menuFont = new SKMFont(14);
        this.mSaveButton = new MyFrameButton(i18nCommon.getString("save"), menuFont);
        this.mSaveButton.setVisible(false);
        this.addUi(this.mSaveButton);
        this.mLoadButton = new MyFrameButton(i18nCommon.getString("load"), menuFont);
        this.mLoadButton.setVisible(false);
        this.addUi(this.mLoadButton);
        SKMFont checkFont = new SKMFont(14);
        String baseImagePath = SKMImage.getBasePath();
        SKMImage.setBasePath("jp/ne/sk_mine/util/andr_applet/res/image/");
        SKMImage checkOnImage = new SKMImage("w_check_on.png");
        SKMImage checkOffImage = new SKMImage("w_check_off.png");
        SKMImage.setBasePath(baseImagePath);
        this.mSoundCheck = new SKMCheckBox(i18nCommon.getString("sound"), 0, 0, false, checkFont);
        this.mSoundCheck.setVisible(false);
        this.mSoundCheck.setTextColor(SKMColor.WHITE);
        this.mSoundCheck.setImages(checkOnImage, checkOffImage);
        this.mSoundCheck.setSelected(SKM.getManager().getSoundPlayer().isEnabled());
        this.mBgmCheck = new SKMCheckBox(i18nCommon.getString("bgm"), 0, 0, false, checkFont);
        this.mBgmCheck.setVisible(false);
        this.mBgmCheck.setTextColor(SKMColor.WHITE);
        this.mBgmCheck.setImages(checkOnImage, checkOffImage);
        this.mBgmCheck.setSelected(SKM.getManager().getBgmPlayer().isEnabled());
        this.mSeasonalEffectsDisabledCheck = new SKMCheckBox(i18nCommon.getString("disable_seasonal_effect"), 0, 0, false, checkFont);
        this.mSeasonalEffectsDisabledCheck.setVisible(false);
        this.mSeasonalEffectsDisabledCheck.setTextColor(SKMColor.WHITE);
        this.mSeasonalEffectsDisabledCheck.setImages(checkOnImage, checkOffImage);
        this.mSeasonalEffectsDisabledCheck.setSelected(SKM.getManager().isSeasonalEffectDisabled());
        this.addUi(this.mSoundCheck);
        this.addUi(this.mBgmCheck);
        this.addUi(this.mSeasonalEffectsDisabledCheck);
        SKMButtonGroup langButtonGroup = new SKMButtonGroup();
        String[] langs = SKM.getManager().getSupportedLangs();
        this.mLangButtons = new SKMRadioButton[langs.length];
        SKMFont langFont = new SKMFont(18);
        String lang = this.getLangFromSetting();
        for (int i = 0; i < langs.length; ++i) {
            this.mLangButtons[i] = new SKMRadioButton(i18nCommon.getString("lang_" + langs[i]), 0, 0, false, langFont);
            this.mLangButtons[i].setVisible(false);
            this.mLangButtons[i].setSelected(lang.equals(langs[i]));
            this.mLangButtons[i].setValue(langs[i]);
            this.mLangButtons[i].setColors(SKMColor.WHITE, SKMColor.GRAY);
            langButtonGroup.add(this.mLangButtons[i]);
            this.addUi(this.mLangButtons[i]);
        }
        SKMButton.setSameWidth(0, this.mLangButtons);
    }

    private final String getLangFromSetting() {
        return SKM.getI18NCommon().getString("lang");
    }

    public String getLang() {
        return this.mLang;
    }

    public void setSaveLoadEnabled(boolean f) {
        this.mIsSaveLoadEnabled = f;
        this.mSaveButton.setVisible(f);
        this.mLoadButton.setVisible(f);
    }

    public void setSeasonalEffectsSettingEnabled(boolean f) {
        this.mIsSeasonalEffectsSettingEnabled = f;
        this.mSeasonalEffectsDisabledCheck.setVisible(f);
    }

    @Override
    protected void myUpdateButtonPositions() {
        SKMGraphics g = SKM.getGraphics();
        int margin = 15;
        int numLangInRow = this.mIsPortrait ? 2 : 3;
        int buttonSpaceW = this.mLangButtons[0].getWidth() + 20;
        int langX = SKM.getManager().getBaseDrawWidth() / 2 - buttonSpaceW * (numLangInRow + 1) / 2;
        for (int i = 0; i < this.mLangButtons.length; ++i) {
            this.mLangButtons[i].setXY(langX + (1 + i % numLangInRow) * buttonSpaceW, 90 + 40 * SKMUtil.toInt(i / numLangInRow));
        }
        SKMFont categoryFont = new SKMFont(SKMFont.BOLD, 20);
        g.setFont(categoryFont);
        int settingX = 70;
        int checkGap = 40;
        int x = 70;
        int soundY = 90 + 40 * (2 + SKMUtil.toInt((this.mLangButtons.length - 1) / numLangInRow));
        this.mSoundCheck.setXY(x, soundY);
        this.mSoundCheck.setXY(x, soundY);
        this.mBgmCheck.setXY(x += this.mSoundCheck.getWidth() + 40, soundY);
        int settingY = soundY;
        if (this.mIsSeasonalEffectsSettingEnabled) {
            this.mSeasonalEffectsDisabledCheck.setXY(70, settingY += 55);
        }
        if (this.mIsSaveLoadEnabled) {
            this.mSaveButton.setXY(90, settingY += 110);
            this.mLoadButton.setXY(90 + this.mSaveButton.getWidth() + 30, this.mSaveButton.getY());
        }
    }

    @Override
    public void setActive(boolean f) {
        if (f) {
            this.mDw = SKM.getManager().getBaseDrawWidth();
            this.mDh = SKM.getManager().getBaseDrawHeight();
        }
        super.setActive(f);
        for (int i = this.mLangButtons.length - 1; 0 <= i; --i) {
            this.mLangButtons[i].setVisible(f);
        }
        this.mSeasonalEffectsDisabledCheck.setVisible(f && this.mIsSeasonalEffectsSettingEnabled);
        this.mSaveButton.setVisible(f && this.mIsSaveLoadEnabled);
        this.mLoadButton.setVisible(f && this.mIsSaveLoadEnabled);
        if (!this.mIsSaveLoadEnabled) {
            this.mVisibledUis.remove(this.mSaveButton);
            this.mVisibledUis.remove(this.mLoadButton);
        }
    }

    @Override
    public boolean mousePressed(double mx, double my, int button) {
        if (!this.isActive()) {
            return false;
        }
        GameView manager = SKM.getManager();
        if (this.mSoundCheck.isHit(mx, my)) {
            SKM.getSoundPlayer().setEnabled(this.mSoundCheck.isSelected());
            SKM.getManager().setSetting("isSoundEnabled", this.mSoundCheck.isSelected());
            if (!this.mSoundCheck.isSelected()) {
                manager.stopAllSounds();
            }
        } else if (this.mBgmCheck.isHit(mx, my)) {
            SKM.getBgmPlayer().setEnabled(this.mBgmCheck.isSelected());
            SKM.getManager().setSetting("isBgmEnabled", this.mBgmCheck.isSelected());
            if (this.mBgmCheck.isSelected()) {
                SKM.getBgmPlayer().play();
            } else {
                SKM.getBgmPlayer().pause();
            }
        } else if (this.mSeasonalEffectsDisabledCheck.isHit(mx, my)) {
            this.mGameManager.setSeasonalEffectDisabled(this.mSeasonalEffectsDisabledCheck.isSelected());
        } else if (this.mSaveButton.isHit(mx, my)) {
            new SaveLoadDialog(true, manager.getRegisterUserUrl()).setVisible(true);
        } else if (this.mLoadButton.isHit(mx, my)) {
            this.mSaveLoadDialog = new SaveLoadDialog(false, manager.getRegisterUserUrl());
            this.mSaveLoadDialog.setVisible(true);
        } else {
            for (int i = 0; i < this.mLangButtons.length; ++i) {
                if (!this.mLangButtons[i].isHit(mx, my)) continue;
                this.mLang = this.mLangButtons[i].getValue();
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected void myRun() {
        String loadData;
        if (this.mIsActive && this.mCount == 1) {
            for (int i = this.mUis.size() - 1; 0 <= i; --i) {
                ((SKMUI)this.mUis.get(i)).setVisible(true);
            }
            this.mSeasonalEffectsDisabledCheck.setVisible(this.mIsSeasonalEffectsSettingEnabled);
            this.mSaveButton.setVisible(this.mIsSaveLoadEnabled);
            this.mLoadButton.setVisible(this.mIsSaveLoadEnabled);
        }
        if (this.mSaveLoadDialog != null && (loadData = this.mSaveLoadDialog.getLoadedData()) != null) {
            SKM.getBgmPlayer().stop(true);
            SKM.getManager().applySettingDataString(loadData);
            SKM.getManager().reset();
        }
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        SKMI18N i18nCommon = SKM.getI18NCommon();
        g.setColor(SKMColor.BLACK);
        g.fillRect(0, 0, this.mDw + 1, this.mDh + 1);
        g.setFont(new SKMFont(SKMFont.BOLD, 28));
        g.setColor(this.mTitleColor);
        g.drawCenteringString(i18nCommon.getString("settings"), this.mDw / 2, 40);
        SKMFont categoryFont = new SKMFont(SKMFont.BOLD, 20);
        g.setColor(SKMColor.WHITE);
        g.setFont(categoryFont);
        String langTitle = i18nCommon.getString("language");
        int langX = this.mLangButtons[0].getX();
        int langTitleX = langX - g.stringWidth(langTitle) - 50;
        if (langTitleX < 10) {
            langTitleX = 10;
        }
        int settingX = 70;
        g.drawString(langTitle, langTitleX, 110);
        if (this.mIsSaveLoadEnabled) {
            g.setFont(new SKMFont(14));
            g.drawString(i18nCommon.getString("explanation_save_load"), 70, this.mSaveButton.getY() - 15);
        }
    }
}

