/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game.event;

import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;

class NameRow {
    private boolean mIsSelected;
    private int mX;
    private int mY;
    private int mOffsetX;
    private int mOffsetY;
    private int mWidth;
    private int mHeight;
    private String mText;
    private SKMColor mTextColor;
    private SKMFont mFont;

    public NameRow(String text, int x, int y, int width, int height) {
        this.mText = text;
        this.mX = x;
        this.mY = y;
        this.mWidth = width;
        this.mHeight = height;
        this.mTextColor = new SKMColor(230, 230, 230);
        this.mFont = new SKMFont(14);
    }

    public void setText(String text) {
        this.mText = text;
    }

    public String getText() {
        return this.mText;
    }

    public void setOffsetXY(int x, int y) {
        this.mOffsetX = x;
        this.mOffsetY = y;
    }

    public boolean isHit(double x, double y) {
        return (double)this.mX < (x -= (double)this.mOffsetX) && x < (double)(this.mX + this.mWidth) && (double)this.mY < (y -= (double)this.mOffsetY) && y < (double)(this.mY + this.mHeight);
    }

    public void setSelected(boolean f) {
        this.mIsSelected = f;
    }

    public void setTextColor(SKMColor color) {
        this.mTextColor = color;
    }

    public void setFont(SKMFont font) {
        this.mFont = font;
    }

    public void paint(SKMGraphics g) {
        g.saveTransform();
        g.translate(this.mOffsetX, this.mOffsetY);
        g.setFont(this.mFont);
        g.setColor(this.mTextColor);
        int textW = g.stringWidth(this.mText);
        g.drawCenteringString(this.mText, this.mX + 10 + textW / 2, this.mY + this.mHeight / 2);
        if (this.mIsSelected) {
            g.setColor(SKMColor.YELLOW);
            g.saveStroke();
            g.setStroke(2.0f);
            g.drawRect(this.mX + 3, this.mY + 3, this.mWidth - 5, this.mHeight - 5);
            g.restoreStroke();
        }
        g.restoreTransform();
    }
}

